/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.IContentManagerInputStreamProvider;
import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.internal.AsyncContentManagerSession;
import com.ibm.team.repository.client.internal.EncodingConvertingInputStream;
import com.ibm.team.repository.client.internal.FinishingParentProgressMonitor;
import com.ibm.team.repository.client.internal.SynchronousContentManagerSession;
import com.ibm.team.repository.client.internal.TeamPlatformObject;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.internal.property.RepositoryClientProperties;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.client.internal.util.MonitoredInputStream;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.service.IContentComparisonService;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.ITeamContentService;
import com.ibm.team.repository.common.transport.TeamContent;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.repository.common.utils.LineDelimiterUtil;
import com.ibm.team.repository.common.utils.LineDelimiterVerifier;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToCRLFInputStream;
import com.ibm.team.repository.common.utils.VerifyConvertToLFInputStream;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ContentManager
extends TeamPlatformObject
implements IContentManager {
    private static final Log log = LogFactory.getLog((String)"com.ibm.team.repository");
    private static int maxSimultaneousDownloads = 10;
    private final boolean useContentRest;
    private final ITeamContentService contentService;
    private final ITeamRestServiceClient contentRestService;
    private final IContentComparisonService comparisonService;
    private final LineDelimiter SERVER_PLATFORM_LINE_DELIMITER;

    ContentManager(TeamRepository repository, ITeamContentService contentService, ITeamRestServiceClient contentRestService) {
        super(repository);
        this.contentService = contentService;
        this.contentRestService = contentRestService;
        this.comparisonService = (IContentComparisonService)repository.getServiceInterface(IContentComparisonService.class);
        if (contentRestService != null) {
            this.useContentRest = RepositoryClientProperties.INSTANCE.getBooleanProperty("com.ibm.team.repository.client.internal.useContentRest", false);
            if (this.useContentRest && log.isInfoEnabled()) {
                log.info((Object)"ContentManager will use ContentRestService");
            }
        } else {
            this.useContentRest = false;
        }
        this.SERVER_PLATFORM_LINE_DELIMITER = LineDelimiter.LINE_DELIMITER_LF;
    }

    private ITeamContentService getContentService() {
        return this.contentService;
    }

    @Override
    public IContent storeContent(InputStream inStream, long length, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.storeContent(inStream, length, null, monitor);
    }

    @Override
    public IContent storeContent(InputStream inStream, long length, UUID predecessorId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (inStream == null) {
            throw new IllegalArgumentException();
        }
        return this.storeContent("text/plain", "us-ascii", LineDelimiter.LINE_DELIMITER_NONE, inStream, predecessorId, monitor);
    }

    @Override
    public IContent storeContent(String mediaType, String characterEncoding, InputStream inStream, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.storeContent(mediaType, characterEncoding, LineDelimiter.LINE_DELIMITER_NONE, inStream, null, monitor);
    }

    @Override
    public IContent storeContent(String mediaType, String characterEncoding, LineDelimiter lineDelimiter, InputStream inStream, UUID predecessorId, IProgressMonitor monitor) throws TeamRepositoryException {
        IContent result;
        if (inStream == null) {
            throw new IllegalArgumentException();
        }
        if (mediaType == null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw new IllegalArgumentException();
        }
        if (this.isTextType(mediaType) && (characterEncoding == null || characterEncoding.trim().equals(""))) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw new IllegalArgumentException("Character encoding must be supplied if media type is text");
        }
        if (lineDelimiter != LineDelimiter.LINE_DELIMITER_NONE && (characterEncoding == null || characterEncoding.trim().length() == 0)) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw new IllegalArgumentException("Character encoding must be supplied if line delimiters are present");
        }
        if (!this.validLineDelimiter(lineDelimiter)) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw new IllegalArgumentException();
        }
        LineDelimiter transmissionLineDelimiter = this.getTransmissionLineDelimiter(lineDelimiter);
        StreamLengthUtility slu = new StreamLengthUtility(inStream, characterEncoding, transmissionLineDelimiter, true);
        try {
            slu.run();
            InputStream in = slu.getInputStream();
            long length = slu.getStreamLength();
            result = this.internalStoreContent(mediaType, characterEncoding, lineDelimiter, in, transmissionLineDelimiter, length, predecessorId, slu.getContentHashCode(), monitor);
            ((Content)result).setLineDelimiterCount(slu.getLineDelimiterCount());
        }
        finally {
            slu.cleanup();
        }
        return result;
    }

    @Override
    public IContent storeContent(String mediaType, String characterEncoding, LineDelimiter lineDelimiter, IContentManagerInputStreamProvider streamProvider, UUID predecessorId, IProgressMonitor monitor) throws TeamRepositoryException {
        Content content;
        StreamLengthUtility slu;
        block27: {
            if (streamProvider == null) {
                throw new IllegalArgumentException();
            }
            if (mediaType == null) {
                throw new IllegalArgumentException();
            }
            if (this.isTextType(mediaType) && (characterEncoding == null || characterEncoding.trim().equals(""))) {
                throw new IllegalArgumentException("Character encoding must be supplied if media type is text");
            }
            if (lineDelimiter != LineDelimiter.LINE_DELIMITER_NONE && (characterEncoding == null || characterEncoding.trim().length() == 0)) {
                throw new IllegalArgumentException("Character encoding must be supplied if line delimiters are present");
            }
            if (!this.validLineDelimiter(lineDelimiter)) {
                throw new IllegalArgumentException();
            }
            LineDelimiter transmissionLineDelimiter = this.getTransmissionLineDelimiter(lineDelimiter);
            slu = null;
            InputStream in = streamProvider.getInputStream(1);
            try {
                InputStream toUpload;
                slu = new StreamLengthUtility(in, characterEncoding, transmissionLineDelimiter, false);
                slu.run();
                long length = slu.getStreamLength();
                HashCode hash = slu.getContentHashCode();
                long lineDelimiterCount = slu.getLineDelimiterCount();
                in.close();
                in = null;
                in = slu.getInputStream();
                if (in == null) {
                    in = streamProvider.getInputStream(2);
                }
                in = streamProvider.wrapInputStream(in);
                if (transmissionLineDelimiter == LineDelimiter.LINE_DELIMITER_NONE) {
                    toUpload = in;
                } else {
                    VerifyConvertToLFInputStream delimiterConverter;
                    block26: {
                        try {
                            if (transmissionLineDelimiter == LineDelimiter.LINE_DELIMITER_LF) {
                                delimiterConverter = new VerifyConvertToLFInputStream(in, characterEncoding);
                                break block26;
                            }
                            if (transmissionLineDelimiter == LineDelimiter.LINE_DELIMITER_CRLF) {
                                delimiterConverter = new VerifyConvertToCRLFInputStream(in, characterEncoding);
                                break block26;
                            }
                            if (transmissionLineDelimiter == LineDelimiter.LINE_DELIMITER_CR) {
                                delimiterConverter = new VerifyConvertToCRInputStream(in, characterEncoding);
                                break block26;
                            }
                            throw new IllegalStateException();
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new TeamRepositoryException((Object)this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.UnsupportedEncodingError"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
                        }
                    }
                    toUpload = new ReaderToInputStream((InputStreamReader)delimiterConverter);
                }
                Content result = (Content)this.internalStoreContent(mediaType, characterEncoding, lineDelimiter, toUpload, transmissionLineDelimiter, length, predecessorId, hash, monitor);
                in.close();
                in = null;
                slu.cleanup();
                slu = null;
                result.setLineDelimiterCount(lineDelimiterCount);
                content = result;
                if (in == null) break block27;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (slu != null) {
                        slu.cleanup();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Object)this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.PreprocessingIOError"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
                }
                catch (UnsupportedCharsetException e) {
                    throw new TeamRepositoryException((Object)this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.UnsupportedEncodingError"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
                }
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (slu != null) {
            slu.cleanup();
        }
        return content;
    }

    @Override
    public IContent storeText(String mediaType, String inputStreamCharacterEncoding, LineDelimiter lineDelimiter, InputStream inStream, UUID predecessorId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (inputStreamCharacterEncoding == null) {
            inputStreamCharacterEncoding = Charset.defaultCharset().name();
        }
        if (inStream == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        String outputEncoding = "UTF-8";
        EncodingConvertingInputStream converted = new EncodingConvertingInputStream(inStream, inputStreamCharacterEncoding, outputEncoding);
        return this.storeContent(mediaType, outputEncoding, lineDelimiter, converted, predecessorId, monitor);
    }

    private boolean isTextType(String mediaType) {
        return mediaType != null && mediaType.trim().toLowerCase(Locale.ROOT).startsWith("text");
    }

    private LineDelimiter getTransmissionLineDelimiter(LineDelimiter lineDelimiter) {
        if (lineDelimiter == LineDelimiter.LINE_DELIMITER_PLATFORM) {
            return this.SERVER_PLATFORM_LINE_DELIMITER;
        }
        return lineDelimiter;
    }

    private boolean validLineDelimiter(LineDelimiter lineDelimiter) {
        return lineDelimiter == LineDelimiter.LINE_DELIMITER_NONE || lineDelimiter == LineDelimiter.LINE_DELIMITER_LF || lineDelimiter == LineDelimiter.LINE_DELIMITER_CRLF || lineDelimiter == LineDelimiter.LINE_DELIMITER_CR || lineDelimiter == LineDelimiter.LINE_DELIMITER_PLATFORM;
    }

    @Override
    public IContent storeContent(String mediaType, String characterEncoding, InputStream inStream, long length, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.storeContent(mediaType, characterEncoding, inStream, length, null, monitor);
    }

    @Override
    public IContent storeContent(String mediaType, String characterEncoding, InputStream inStream, long length, UUID predecessorId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.storeContent(mediaType, characterEncoding, LineDelimiter.LINE_DELIMITER_NONE, inStream, predecessorId, monitor);
    }

    @Override
    public IContent storeContent(InputStream inStream, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.storeContent(inStream, null, monitor);
    }

    @Override
    public IContent storeContent(InputStream inStream, UUID predecessorId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (inStream == null) {
            throw new IllegalArgumentException();
        }
        return this.storeContent("text/plain", "us-ascii", LineDelimiter.LINE_DELIMITER_NONE, inStream, predecessorId, monitor);
    }

    private IContent internalStoreContent(String mediaType, String characterEncoding, LineDelimiter lineDelimiter, InputStream inStream, LineDelimiter inStreamLineDelimiter, long length, UUID predecessorId, HashCode contentHashCode, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.useContentRest) {
            return this.internalStoreContentRest(mediaType, characterEncoding, lineDelimiter, inStream, inStreamLineDelimiter, length, predecessorId, contentHashCode, monitor);
        }
        return this.internalStoreContentRpc(mediaType, characterEncoding, lineDelimiter, inStream, inStreamLineDelimiter, length, predecessorId, contentHashCode, monitor);
    }

    private IContent internalStoreContentRpc(String mediaType, String characterEncoding, LineDelimiter lineDelimiter, InputStream inStream, LineDelimiter inStreamLineDelimiter, long length, UUID predecessorId, HashCode contentHashCode, IProgressMonitor monitor) throws TeamRepositoryException {
        final Content content = RepositoryFactory.eINSTANCE.createContent();
        content.setContentType(mediaType);
        content.setCharacterEncoding(characterEncoding);
        content.setContentLength(length);
        content.setDeltaPredecessor(predecessorId);
        content.setLineDelimiter(lineDelimiter);
        UUID uuid = UUID.generate();
        content.setContentId(uuid);
        final HashComputingInputStream hashingInput = new HashComputingInputStream(inStream);
        MonitoredInputStream monitoredInStream = new MonitoredInputStream((InputStream)hashingInput, 1, length, monitor);
        SubProgressMonitor cancelationMonitor = null;
        if (monitor != null) {
            cancelationMonitor = new SubProgressMonitor(monitor, 0);
        }
        try {
            final TeamContent tcontent = new TeamContent().setMediaType(mediaType).setContentId(uuid).setPredecessorContentId(predecessorId).setLineDelimiter(inStreamLineDelimiter).setInputStream((InputStream)monitoredInStream).setCharacterEncoding(characterEncoding).setSize((int)length).setContentHashCode(contentHashCode);
            this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    try {
                        ContentManager.this.getContentService().put(tcontent);
                        content.setChecksum(hashingInput.getHash());
                        return null;
                    }
                    catch (IOException e) {
                        TeamRepositoryException tre = new TeamRepositoryException((Throwable)e);
                        tre.setOrigin((Object)ContentManager.this.teamRepository());
                        throw tre;
                    }
                }
            }, (IProgressMonitor)cancelationMonitor);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)monitoredInStream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)monitoredInStream).close();
        }
        catch (IOException iOException) {}
        return content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IContent internalStoreContentRest(String mediaType, String characterEncoding, LineDelimiter lineDelimiter, InputStream inStream, LineDelimiter inStreamLineDelimiter, final long length, UUID predecessorId, HashCode contentHashCode, IProgressMonitor monitor) throws TeamRepositoryException {
        Content content2;
        URI relUri;
        if (this.contentRestService == null) {
            throw new IllegalStateException("null contentRestService");
        }
        try {
            String queryParms = "hashcode=" + contentHashCode.getValue();
            if (predecessorId != null) {
                queryParms = String.valueOf(queryParms) + "&predecessor=" + predecessorId.getUuidValue();
            }
            if (inStreamLineDelimiter != LineDelimiter.LINE_DELIMITER_NONE) {
                queryParms = String.valueOf(queryParms) + "&linedelimiter=" + inStreamLineDelimiter.asQuery();
            }
            relUri = new URI(null, null, null, -1, "content", queryParms, null);
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.URISyntaxError"), (Object)e1.getMessage(), (Object[])new Object[0]));
        }
        final String contentType = characterEncoding != null && characterEncoding.length() != 0 ? String.format("%s;%s=%s", mediaType, "charset", characterEncoding) : mediaType;
        final MonitoredInputStream monitoredInStream = new MonitoredInputStream(inStream, 1, length, monitor);
        try {
            ITeamRestServiceClient.IRestClientConnection.Response response;
            final ITeamRestServiceClient.IRestClientConnection conn = this.contentRestService.getConnection(relUri);
            conn.addRequestHeader("Content-Type", contentType);
            conn.addRequestHeader("Content-Length", Long.toString(length));
            SubProgressMonitor cancellationMonitor = null;
            if (monitor != null) {
                cancellationMonitor = new SubProgressMonitor(monitor, 0);
            }
            if ((response = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ITeamRestServiceClient.IRestClientConnection.Response>(){

                @Override
                public ITeamRestServiceClient.IRestClientConnection.Response run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    return conn.doPost(monitoredInStream, length, contentType);
                }
            }, (IProgressMonitor)cancellationMonitor)).getStatusCode() != ITeamRestServiceClient.IRestClientConnection.Response.StatusCode.CREATED) {
                TeamRepositoryException tre = new TeamRepositoryException(Messages.getServerString("ContentManager.RESTServiceError"));
                tre.setOrigin((Object)this.teamRepository());
                throw tre;
            }
            String location = response.getResponseHeader("Location");
            String[] segments = location.split("/");
            UUID contentId = null;
            if (segments[segments.length - 2].equalsIgnoreCase("content")) {
                contentId = UUID.valueOf((String)segments[segments.length - 1]);
            }
            Content content = RepositoryFactory.eINSTANCE.createContent();
            content.setContentType(mediaType);
            content.setCharacterEncoding(characterEncoding);
            content.setContentLength(length);
            content.setDeltaPredecessor(predecessorId);
            content.setContentId(contentId);
            content.setChecksum(contentHashCode.getValue());
            content.setLineDelimiter(lineDelimiter);
            content2 = content;
        }
        catch (TeamServiceException e) {
            try {
                e.setOrigin((Object)this.teamRepository());
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)monitoredInStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)monitoredInStream).close();
            return content2;
        }
        catch (IOException iOException) {}
        return content2;
    }

    @Override
    public void retrieveContent(IContent content, OutputStream outStream, IProgressMonitor monitor) throws TeamRepositoryException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        if (outStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalRetrieveContent(content, outStream, monitor);
        }
        catch (Throwable throwable) {
            try {
                outStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            outStream.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public InputStream retrieveContentStream(IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        return this.internalRetrieveContentStream(content, monitor);
    }

    @Override
    public InputStream retrieveContentStream(IContent content, String alternativeEncoding, LineDelimiter alternativeDelimiter, IProgressMonitor monitor) throws TeamRepositoryException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        if (alternativeDelimiter != LineDelimiter.LINE_DELIMITER_NONE && (alternativeEncoding == null || alternativeEncoding.trim().length() == 0)) {
            throw new IllegalArgumentException("Character encoding must be supplied if line delimiters are present");
        }
        if (!this.validLineDelimiter(alternativeDelimiter)) {
            throw new IllegalArgumentException("Invalid line delimiter");
        }
        return this.internalRetrieveContentStream(content, alternativeEncoding, alternativeDelimiter, monitor);
    }

    private InputStream internalRetrieveContentStream(IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        InputStream inStream = this.useContentRest ? this.internalRetrieveContentStreamRest(content, monitor) : this.internalRetrieveContentStreamRpc(content, monitor);
        try {
            return this.getConversionStream(inStream, content.getCharacterEncoding(), content.getLineDelimiter());
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException((Object)this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.DelimiterConversionError"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
        }
        catch (UnsupportedCharsetException e) {
            throw new TeamRepositoryException((Object)this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.DelimiterConversionError"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
        }
    }

    private InputStream internalRetrieveContentStream(IContent content, String alternativeEncoding, LineDelimiter alternativeDelimiter, IProgressMonitor monitor) throws TeamRepositoryException {
        InputStream inStream = this.useContentRest ? this.internalRetrieveContentStreamRest(content, monitor) : this.internalRetrieveContentStreamRpc(content, monitor);
        if (alternativeDelimiter == LineDelimiter.LINE_DELIMITER_PLATFORM) {
            alternativeDelimiter = LineDelimiter.getPlatformDelimiter();
        }
        if (alternativeDelimiter == LineDelimiter.LINE_DELIMITER_NONE) {
            return inStream;
        }
        try {
            return new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)inStream, (String)alternativeEncoding, (LineDelimiter)alternativeDelimiter));
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Object)this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.DelimiterError"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
        }
    }

    private InputStream internalRetrieveContentStreamRpc(IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        String uuidstr;
        TeamContent tcontent;
        InputStream inStream;
        UUID contentId = content.getContentId();
        if (contentId == null) {
            throw new TeamRepositoryException((Object)this.teamRepository(), Messages.getServerString("ContentManager.InvalidContentId"));
        }
        SubProgressMonitor cancelationMonitor = null;
        FinishingParentProgressMonitor streamMonitor = null;
        if (monitor != null) {
            monitor.beginTask("", (int)content.getRawLength());
            cancelationMonitor = new SubProgressMonitor(monitor, 0);
            streamMonitor = new FinishingParentProgressMonitor(monitor, (int)content.getRawLength());
        }
        if ((inStream = (tcontent = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<TeamContent>(uuidstr = contentId.getUuidValue()){
            private final /* synthetic */ String val$uuidstr;
            {
                this.val$uuidstr = string;
            }

            @Override
            public TeamContent run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                try {
                    return ContentManager.this.getContentService().get(this.val$uuidstr);
                }
                catch (IOException e) {
                    TeamRepositoryException tre = new TeamRepositoryException((Throwable)e);
                    tre.setOrigin((Object)ContentManager.this.teamRepository());
                    throw tre;
                }
            }
        }, (IProgressMonitor)cancelationMonitor)).getInputStream()) == null) {
            throw new TeamRepositoryException((Object)this.teamRepository(), Messages.getServerString("ContentManager.ContentRetrievalError"));
        }
        inStream = new MonitoredInputStream(inStream, 1, tcontent.getSize(), (IProgressMonitor)streamMonitor);
        return inStream;
    }

    private InputStream getConversionStream(InputStream inStream, String encoding, LineDelimiter lineDelimiter) throws UnsupportedEncodingException {
        if (lineDelimiter == LineDelimiter.LINE_DELIMITER_PLATFORM && this.SERVER_PLATFORM_LINE_DELIMITER != LineDelimiter.getPlatformDelimiter()) {
            switch (LineDelimiter.getPlatformDelimiter()) {
                case LINE_DELIMITER_CRLF: {
                    return new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inStream, encoding));
                }
                case LINE_DELIMITER_CR: {
                    return new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inStream, encoding));
                }
                case LINE_DELIMITER_LF: {
                    return new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, encoding));
                }
            }
            return inStream;
        }
        return inStream;
    }

    private InputStream internalRetrieveContentStreamRest(IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        URI relUri;
        if (this.contentRestService == null) {
            throw new IllegalStateException("null contentRestService");
        }
        UUID contentId = content.getContentId();
        if (contentId == null) {
            throw new TeamRepositoryException((Object)this.teamRepository(), Messages.getServerString("ContentManager.InvalidContentId"));
        }
        try {
            relUri = new URI("content/" + contentId.getUuidValue());
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.URISyntaxError"), (Object)e1.getMessage(), (Object[])new Object[0]));
        }
        SubProgressMonitor cancellationMonitor = null;
        FinishingParentProgressMonitor streamMonitor = null;
        if (monitor != null) {
            monitor.beginTask("", (int)content.getRawLength());
            cancellationMonitor = new SubProgressMonitor(monitor, 0);
            streamMonitor = new FinishingParentProgressMonitor(monitor, (int)content.getRawLength());
        }
        try {
            final ITeamRestServiceClient.IRestClientConnection conn = this.contentRestService.getConnection(relUri);
            conn.addRequestHeader("Accept", content.getContentType());
            conn.addRequestHeader("Accept-Charset", content.getCharacterEncoding());
            ITeamRestServiceClient.IRestClientConnection.Response response = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ITeamRestServiceClient.IRestClientConnection.Response>(){

                @Override
                public ITeamRestServiceClient.IRestClientConnection.Response run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    return conn.doGet();
                }
            }, (IProgressMonitor)cancellationMonitor);
            if (response.getStatusCode() != ITeamRestServiceClient.IRestClientConnection.Response.StatusCode.OK) {
                TeamRepositoryException tre = new TeamRepositoryException(NLS.bind((String)Messages.getServerString("ContentManager.ContentServiceError"), (Object)"Content REST", (Object[])new Object[0]));
                tre.setOrigin((Object)this.teamRepository());
                tre.setData((Object)contentId);
                throw tre;
            }
            InputStream inStream = response.getResponseStream();
            if (inStream == null) {
                throw new TeamRepositoryException((Object)this.teamRepository(), Messages.getServerString("ContentManager.ContentRetrievalError"));
            }
            inStream = new MonitoredInputStream(inStream, 1, content.getRawLength(), (IProgressMonitor)streamMonitor);
            return inStream;
        }
        catch (TeamServiceException e) {
            e.setOrigin((Object)this.teamRepository());
            throw e;
        }
    }

    private void internalRetrieveContent(IContent content, OutputStream outStream, IProgressMonitor monitor) throws TeamRepositoryException {
        InputStream inStream = this.internalRetrieveContentStream(content, monitor);
        try {
            try {
                ContentManager.read(inStream, outStream);
            }
            catch (IOException e) {
                TeamRepositoryException tre = new TeamRepositoryException((Throwable)e);
                tre.setOrigin((Object)this.teamRepository());
                throw tre;
            }
        }
        catch (Throwable throwable) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inStream.close();
        }
        catch (IOException iOException) {}
    }

    public static void read(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[32000];
        int len = in.read(bytes);
        while (len > -1) {
            out.write(bytes, 0, len);
            len = in.read(bytes);
        }
    }

    @Override
    public boolean areContentBytesIdentical(IContent content1, IContent content2, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, 100);
        if (content1 == null || content2 == null) {
            throw new IllegalArgumentException();
        }
        UUID id1 = content1.getContentId();
        UUID id2 = content2.getContentId();
        if (id1 == null || id2 == null) {
            throw new IllegalArgumentException();
        }
        try {
            boolean result;
            monitor.worked(1);
            boolean bl = result = this.comparisonService.areContentBytesIdentical(id1, id2);
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IContentManagerSession createSession(int threads, String sessionName, long totalWork, IProgressMonitor monitor) {
        return this.createSession(threads, false, sessionName, totalWork, monitor);
    }

    @Override
    public IContentManagerSession createSession(int threads, boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        if (threads < 0) {
            throw new IllegalArgumentException("IContentManagerSession#createSession() must be given a non-negative thread count");
        }
        if (threads == 0) {
            return new SynchronousContentManagerSession(sessionName, (int)totalWork, this, monitor);
        }
        return new AsyncContentManagerSession(threads, allowFailures, sessionName, (int)totalWork, this, monitor);
    }

    @Override
    public IContentManagerSession createSession(String sessionName, boolean allowFailures, long totalWork, IProgressMonitor monitor) {
        return this.createSession(maxSimultaneousDownloads, allowFailures, sessionName, totalWork, monitor);
    }

    @Override
    public IContentManagerSession createSession(String sessionName, long totalWork, IProgressMonitor monitor) {
        return this.createSession(maxSimultaneousDownloads, false, sessionName, totalWork, monitor);
    }

    public static void setMaxSimultaneousDownloads(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Maximum number of threads must be zero or more.");
        }
        maxSimultaneousDownloads = count;
    }

    public static int getMaxSimultaneousDownloads() {
        return maxSimultaneousDownloads;
    }

    @Override
    public IContent storeContent(String contentType, String content, IProgressMonitor monitor) throws TeamRepositoryException {
        byte[] stringBytes;
        if (content == null) {
            throw new IllegalArgumentException("The content string must not be null");
        }
        try {
            stringBytes = content.getBytes(HttpUtil.CharsetEncoding.UTF8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.getServerString("ContentManager.StringEncodingError"), (Object)HttpUtil.CharsetEncoding.UTF8, (Object[])new Object[]{e}));
        }
        ByteArrayInputStream input = new ByteArrayInputStream(stringBytes);
        return this.storeContent(contentType, HttpUtil.CharsetEncoding.UTF8.toString(), LineDelimiter.LINE_DELIMITER_NONE, input, null, monitor);
    }

    @Override
    public IContent storeContent(String mediaType, String characterEncoding, LineDelimiter lineDelimiter, InputStream inStream, long length, UUID predecessorId, HashCode contentHashCode, IProgressMonitor monitor) throws TeamRepositoryException {
        if (inStream == null) {
            throw new IllegalArgumentException();
        }
        if (mediaType == null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw new IllegalArgumentException();
        }
        if (!this.validLineDelimiter(lineDelimiter)) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw new IllegalArgumentException();
        }
        if (this.isTextType(mediaType) && (characterEncoding == null || characterEncoding.trim().equals(""))) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw new IllegalArgumentException("Character encoding must be supplied if media type is text");
        }
        if (lineDelimiter != LineDelimiter.LINE_DELIMITER_NONE && (characterEncoding == null || characterEncoding.trim().length() == 0)) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw new IllegalArgumentException("Character encoding must be supplied if line delimiters are present");
        }
        if (contentHashCode == null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
            throw new IllegalArgumentException();
        }
        if (lineDelimiter == LineDelimiter.LINE_DELIMITER_NONE) {
            return this.internalStoreContent(mediaType, characterEncoding, lineDelimiter, inStream, LineDelimiter.LINE_DELIMITER_NONE, length, predecessorId, contentHashCode, monitor);
        }
        return this.storeContent(mediaType, characterEncoding, lineDelimiter, inStream, predecessorId, monitor);
    }

    @Override
    public IContent storeContent(String mediaType, String characterEncoding, InputStream inStream, UUID predecessorId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.storeContent(mediaType, characterEncoding, LineDelimiter.LINE_DELIMITER_NONE, inStream, predecessorId, monitor);
    }

    @Override
    public boolean convertDelimitersDuringRetrieval(IContent content) {
        return content.getLineDelimiter() == LineDelimiter.LINE_DELIMITER_PLATFORM && this.SERVER_PLATFORM_LINE_DELIMITER != LineDelimiter.getPlatformDelimiter();
    }

    private class StreamLengthUtility {
        private final InputStream input;
        private final LineDelimiterVerifier delimiterVerifier;
        private final LineDelimiter lineDelimiter;
        private InputStream newInput;
        private File tmpFile;
        private long length = -1L;
        private long lineDelimiterCount = 0L;
        private HashCode contentHashCode;
        private final boolean storeInTemp;

        public StreamLengthUtility(InputStream is, String encoding, LineDelimiter convertToLineDelimiter, boolean storeInTemp) throws TeamRepositoryException {
            this.storeInTemp = storeInTemp;
            this.lineDelimiter = convertToLineDelimiter;
            if (this.lineDelimiter == LineDelimiter.LINE_DELIMITER_NONE) {
                this.input = is;
                this.delimiterVerifier = null;
            } else {
                block8: {
                    try {
                        if (this.lineDelimiter == LineDelimiter.LINE_DELIMITER_PLATFORM) {
                            throw new IllegalArgumentException();
                        }
                        if (this.lineDelimiter == LineDelimiter.LINE_DELIMITER_LF) {
                            this.delimiterVerifier = new VerifyConvertToLFInputStream(is, encoding);
                            break block8;
                        }
                        if (this.lineDelimiter == LineDelimiter.LINE_DELIMITER_CRLF) {
                            this.delimiterVerifier = new VerifyConvertToCRLFInputStream(is, encoding);
                            break block8;
                        }
                        if (this.lineDelimiter == LineDelimiter.LINE_DELIMITER_CR) {
                            this.delimiterVerifier = new VerifyConvertToCRInputStream(is, encoding);
                            break block8;
                        }
                        throw new IllegalArgumentException();
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new TeamRepositoryException((Object)ContentManager.this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.UnsupportedEncodingError"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
                    }
                }
                this.input = new ReaderToInputStream((InputStreamReader)this.delimiterVerifier);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() throws TeamRepositoryException {
            content = new byte[32768];
            lengthSoFar = 0;
            r = 0;
            hashCalculator = new HashComputingInputStream(this.input);
            try {
                try {
                    block20: {
                        block19: {
                            while (lengthSoFar != content.length && r != -1) {
                                r = hashCalculator.read(content, lengthSoFar, content.length - lengthSoFar);
                                if (r == -1) continue;
                                lengthSoFar += r;
                            }
                            if (r != -1) break block19;
                            this.newInput = new ByteArrayInputStream(content, 0, lengthSoFar);
                            this.length = lengthSoFar;
                            break block20;
                        }
                        if (!this.storeInTemp) ** GOTO lbl44
                        this.tmpFile = File.createTempFile("blob", null);
                        out = new FileOutputStream(this.tmpFile);
                        bufOut = new BufferedOutputStream(out, 32000);
                        try {
                            bufOut.write(content, 0, content.length);
                            this.length = content.length;
                            numbytes = hashCalculator.read(content);
                            while (numbytes > -1) {
                                this.length += (long)numbytes;
                                bufOut.write(content, 0, numbytes);
                                numbytes = hashCalculator.read(content);
                            }
                        }
                        catch (Throwable var8_9) {
                            try {
                                bufOut.close();
                            }
                            catch (IOException v0) {}
                            throw var8_9;
                        }
                        try {
                            bufOut.close();
                        }
                        catch (IOException v1) {}
                        this.newInput = new BufferedInputStream(new FileInputStream(this.tmpFile));
                        break block20;
lbl-1000:
                        // 1 sources

                        {
                            lengthSoFar += r;
lbl44:
                            // 2 sources

                            ** while ((r = hashCalculator.read((byte[])content)) != -1)
                        }
lbl45:
                        // 1 sources

                        this.length = lengthSoFar;
                    }
                    if (this.delimiterVerifier != null) {
                        this.lineDelimiterCount = this.delimiterVerifier.getLineDelimiterCount();
                    }
                    this.contentHashCode = new HashCode(hashCalculator.getHash());
                }
                catch (IOException e) {
                    this.length = -1L;
                    throw new TeamRepositoryException((Object)ContentManager.this.teamRepository(), NLS.bind((String)Messages.getServerString("ContentManager.PreprocessingIOError"), (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
                }
            }
            catch (Throwable var9_10) {
                try {
                    this.input.close();
                }
                catch (IOException v2) {}
                throw var9_10;
            }
            try {
                this.input.close();
            }
            catch (IOException v3) {}
        }

        public long getStreamLength() throws TeamRepositoryException {
            if (this.length == -1L) {
                this.run();
            }
            return this.length;
        }

        public InputStream getInputStream() throws TeamRepositoryException {
            if (this.length == -1L) {
                this.run();
            }
            return this.newInput;
        }

        public long getLineDelimiterCount() throws TeamRepositoryException {
            if (this.length == -1L) {
                this.run();
            }
            return this.lineDelimiterCount;
        }

        public HashCode getContentHashCode() throws TeamRepositoryException {
            if (this.contentHashCode == null) {
                this.run();
            }
            return this.contentHashCode;
        }

        public void cleanup() {
            try {
                try {
                    if (this.newInput != null) {
                        this.newInput.close();
                    }
                }
                finally {
                    if (this.tmpFile != null) {
                        this.tmpFile.delete();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(NLS.bind((String)Messages.getServerString("ContentManager.FileCleanupError"), (Object)e.getMessage(), (Object[])new Object[0]), e);
            }
        }
    }
}

