/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command;

import com.urbancode.air.plugin.ant.com.urbancode.commons.fileutils.DirectoryFileFilter;
import com.urbancode.air.plugin.ant.com.urbancode.commons.fileutils.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String getArch() {
        String result = "";
        String arch = System.getProperty("os.arch").toLowerCase(Locale.US);
        result = arch.indexOf("amd64") > -1 || arch.indexOf("x64") > -1 || arch.indexOf("x86_64") > -1 ? "x64" : (arch.indexOf("x86") > -1 || arch.indexOf("386") > -1 || arch.indexOf("486") > -1 || arch.indexOf("586") > -1 || arch.indexOf("686") > -1 || arch.indexOf("pentium") > -1 ? "x86" : (arch.indexOf("ia64") > -1 || arch.indexOf("itanium") > -1 || arch.indexOf("ia-64") > -1 ? "ia64" : (arch.indexOf("ppc") > -1 || arch.indexOf("powerpc") > -1 ? "ppc" : (arch.indexOf("sparc") > -1 ? "sparc" : (arch.indexOf("parisc") > -1 || arch.indexOf("pa_risc") > -1 || arch.indexOf("pa-risc") > -1 ? "parisc" : (arch.indexOf("alpha") > -1 ? "alpha" : (arch.indexOf("mips") > -1 ? "mips" : (arch.indexOf("arm") > -1 ? "arm" : "unknown"))))))));
        return result;
    }

    public static String removeDuplicateWhitespace(String inputStr) {
        return inputStr.replaceAll("\\s+", " ");
    }

    public static List<File> sortFilesByLastModifiedDescending(File[] files) {
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                Long long1 = o1.lastModified();
                Long long2 = o2.lastModified();
                return long2.compareTo(long1);
            }
        };
        List<File> sortedFileList = Arrays.asList(files);
        Collections.sort(sortedFileList, comparator);
        return sortedFileList;
    }

    public static File[] directoryNameFilter(File dir, String match) {
        DirectoryFileFilter filter = DirectoryFileFilter.getFilter((File)dir);
        filter.addInclude(match);
        return FileUtils.getFilesRecursively((File)dir, (FileFilter)filter);
    }
}

