/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.Writer;

public class TeeWriter
extends Writer {
    protected final Writer[] out;

    public TeeWriter(Writer[] out) {
        if (out == null) {
            throw new IllegalArgumentException();
        }
        if (out.length == 0) {
            throw new IllegalArgumentException();
        }
        int i = out.length;
        while (i != 0) {
            if (out[--i] != null) continue;
            throw new IllegalArgumentException();
        }
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].write(b);
        }
    }

    @Override
    public void write(char[] b) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].write(b);
        }
    }

    @Override
    public void write(char[] b, int off, int len) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].write(b, off, len);
        }
    }

    @Override
    public void write(String str) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].write(str);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].write(str, off, len);
        }
    }

    @Override
    public Writer append(char c) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].append(c);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].append(csq);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].append(csq, start, end);
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        int i = this.out.length;
        while (i != 0) {
            this.out[--i].flush();
        }
    }

    @Override
    public void close() throws IOException {
        Exception firstException = null;
        int i = this.out.length;
        while (i != 0) {
            --i;
            try {
                this.out[i].close();
            }
            catch (Exception e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            if (firstException instanceof RuntimeException) {
                throw (RuntimeException)firstException;
            }
            throw (IOException)firstException;
        }
    }
}

