/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.server.xml;

import com.urbancode.air.i18n.TranslateUtil;
import com.urbancode.air.plugin.server.ext.PluginCommandPropertyUIType;
import com.urbancode.air.plugin.server.ext.PluginCommandType;
import com.urbancode.air.plugin.server.ext.PluginExtension;
import com.urbancode.air.plugin.server.ext.PluginType;
import com.urbancode.air.plugin.server.ur.ext.URCommandExtension;
import com.urbancode.air.plugin.server.ur.ext.URPluginCommandGroupProperty;
import com.urbancode.air.plugin.server.ur.ext.URPluginCommandPropertyExtension;
import com.urbancode.air.plugin.server.ur.ext.URPropertyGroupUIPropertyType;
import com.urbancode.air.plugin.server.xml.ServerPluginXMLContentHandler;
import com.urbancode.air.plugin_command.Command;
import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.scripted.ScriptedPropInfo;
import java.security.GeneralSecurityException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class URServerPluginXMLContentHandler
extends ServerPluginXMLContentHandler {
    public static final String PROPERTY_GROUP_ELEMENT = "property-group";
    public static final String TYPE_ELEMENT = "type";
    public static final String SPECIAL_TYPE = "specialType";
    public static final String PLUGIN_TYPE_ELEMENT = "plugin-type";
    public static final String SUB_TAG_ELEMENT = "sub-tag";
    public static final String HTTP_PROP_INFO_ELEMENT = "http-prop-info";
    public static final String SCRIPTED_PROP_INFO_ELEMENT = "scripted-prop-info";
    public static final String PROPERTY_GROUP_UI_ELEMENT = "property-group-ui";
    public static final String DEPENDS_ATTRIBUTE = "depends";
    public static final String UNLESS_ATTRIBUTE = "unless";
    public static final String OPTIONS_ATTRIBUTE = "options";
    public static final String TITLE_ATTRIBUTE = "title";
    public static final String PARENT_ATTRIBUTE = "parent";
    public static final String BASE_PATH_ATTRIBUTE = "basePath";
    public static final String VALUE_PATH_ATTRIBUTE = "valuePath";
    public static final String LABEL_PATH_ATTRIBUTE = "labelPath";
    public static final String USERNAME_ATTRIBUTE = "username";
    public static final String PASSWORD_ATTRIBUTE = "password";
    public static final String URL_ATTRIBUTE = "url";
    public static final String FORMAT_ATTRIBUTE = "dataFormat";
    public static final String DATA_SOURCE_TYPE_ATTRIBUTE = "dataSourceType";
    public static final String AUTHENTICATION_TYPE_ATTRIBUTE = "authType";
    public static final String SOURCE_ATTRIBUTE = "source";
    public static final String ARGUMENTS_ATTRIBUTE = "arguments";
    public static final String DISPLAYED_ATTRIBUTE = "displayed";
    public static final String EXTENDS_ATTRIBUTE = "extends";
    public static final String SUBSCRIBE_ATTRIBUTE = "subscribes";
    public static final String INTEGRATION = "Integration";
    URPluginCommandGroupProperty commandPropertyGroup = null;
    boolean groupHasProp = false;
    boolean hasType = false;
    boolean displayed = false;
    String types = null;
    String topics = null;
    String subTag = null;
    boolean hasSubTag = false;
    PluginType pluginType;
    protected String basePath = null;
    protected String username = null;
    protected String password = null;
    protected String dataFormat = null;
    protected String dataSourceType = null;
    protected String url = null;
    protected String valuePath = null;
    protected String authenticationType = null;
    protected String labelPath = null;
    protected String source = null;
    protected String arguments = null;
    protected String parent = null;
    protected String prerequisites = null;
    protected String unless = null;
    protected String options = null;

    public void startElement(String ns, String localName, String qName, Attributes attrs) throws SAXException {
        if (localName.equals(PROPERTY_GROUP_ELEMENT)) {
            this.handlePropertyGroupStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(TYPE_ELEMENT)) {
            this.handleTypeStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(PLUGIN_TYPE_ELEMENT)) {
            this.handlePluginTypeStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(HTTP_PROP_INFO_ELEMENT)) {
            this.handleHttpPropInfoStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else if (localName.equals(SCRIPTED_PROP_INFO_ELEMENT)) {
            this.handleScriptedPropInfoStart(attrs);
            this.tagNameStack.push(localName);
            this.tagText = new StringBuilder();
        } else {
            super.startElement(ns, localName, qName, attrs);
        }
    }

    public void endElement(String ns, String localName, String qName) throws SAXException {
        if (localName.equals(PROPERTY_GROUP_ELEMENT)) {
            this.handlePropertyGroupEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(TYPE_ELEMENT)) {
            this.handleTypeEnd();
            this.tagNameStack.pop();
        } else if (localName.equals("description")) {
            this.handleDescriptionEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(PLUGIN_TYPE_ELEMENT)) {
            this.handlePluginTypeEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(HTTP_PROP_INFO_ELEMENT)) {
            this.handleHttpPropInfoEnd();
            this.tagNameStack.pop();
        } else if (localName.equals(SCRIPTED_PROP_INFO_ELEMENT)) {
            this.handleScriptedPropInfoEnd();
            this.tagNameStack.pop();
        } else {
            super.endElement(ns, localName, qName);
        }
    }

    protected void handleHeaderEnd() throws SAXException {
        PluginExtension ext = null;
        if (PluginType.Connector.equals((Object)this.pluginType)) {
            ext = new PluginExtension(PluginType.Connector);
        } else if (PluginType.Task.equals((Object)this.pluginType)) {
            ext = new PluginExtension(PluginType.Task);
        }
        super.handleHeaderEnd();
        this.plugin.setExtension(ext);
    }

    protected void handlePropertyStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(new String[]{"properties", PROPERTY_GROUP_ELEMENT}, "property");
        String name = null;
        this.prerequisites = null;
        this.parent = null;
        this.unless = null;
        Boolean required = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals("name")) {
                name = attrValue;
                continue;
            }
            if (attrName.equals("required")) {
                required = Boolean.valueOf(attrValue);
                continue;
            }
            if (attrName.equals(PARENT_ATTRIBUTE)) {
                this.parent = attrValue;
                continue;
            }
            if (attrName.equals("required")) {
                required = Boolean.valueOf(attrValue);
                continue;
            }
            if (attrName.equals(DEPENDS_ATTRIBUTE)) {
                this.prerequisites = attrValue;
                continue;
            }
            if (attrName.equals(UNLESS_ATTRIBUTE)) {
                this.unless = attrValue;
                continue;
            }
            if (attrName.equals(OPTIONS_ATTRIBUTE)) {
                this.options = attrValue;
                continue;
            }
            throw new SAXException("Unknown attribute on property element " + attrName);
        }
        if (name == null) {
            throw new SAXException("name is a required attribute on property");
        }
        PluginCommandProperty prop = new PluginCommandProperty(name, required, null);
        this.curCommand.addPluginProp(prop);
        this.curProp = prop;
    }

    protected void handlePropertyUIStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("property", "property-ui");
        Object type = null;
        PluginCommandPropertyUIType propType = null;
        String label = null;
        String description = null;
        String placeholder = null;
        String defaultValue = null;
        Boolean hidden = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals("label")) {
                label = attrValue;
                continue;
            }
            if (attrName.equals("description")) {
                description = attrValue.replaceAll("\\s+", " ");
                continue;
            }
            if (attrName.equals("placeholder")) {
                placeholder = attrValue;
                continue;
            }
            if (attrName.equals("default-value")) {
                defaultValue = attrValue;
                continue;
            }
            if (attrName.equals("hidden")) {
                hidden = Boolean.valueOf(attrValue);
                continue;
            }
            if (attrName.equals(TYPE_ELEMENT)) {
                propType = PluginCommandPropertyUIType.valueOf(attrValue);
                continue;
            }
            throw new SAXException("Unknown attribute on property-ui : " + attrName);
        }
        if (label == null) {
            label = this.curProp.getName();
        }
        if (type == null && propType == null) {
            throw new SAXException("type is a required attribute on property-ui");
        }
        URPluginCommandPropertyExtension ext = new URPluginCommandPropertyExtension(propType, label, description, defaultValue, hidden);
        ext.setParent(this.parent);
        ext.setPrerequisites(this.prerequisites);
        ext.setUnless(this.unless);
        ext.setOptions(this.options);
        this.curProp.setExtension(ext);
        this.hasPropUi = true;
    }

    protected void handlePropertyEnd() throws SAXException {
        if (!this.hasPropUi) {
            throw new SAXException("All properties must have a property-ui. None found in property named " + this.curProp.getName() + " at location " + this.getTagStackPath());
        }
        this.hasPropUi = false;
        this.curProp = null;
    }

    private void handlePropertyGroupStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("properties", PROPERTY_GROUP_ELEMENT);
        String name = null;
        String description = null;
        String title = null;
        String depends = null;
        String unless = null;
        String options = null;
        URPropertyGroupUIPropertyType type = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals(TYPE_ELEMENT)) {
                type = URPropertyGroupUIPropertyType.valueOf(attrValue);
                continue;
            }
            if (attrName.equals("name")) {
                name = attrValue;
                continue;
            }
            if (attrName.equals("description")) {
                description = attrValue;
                continue;
            }
            if (attrName.equals(TITLE_ATTRIBUTE)) {
                title = attrValue;
                continue;
            }
            if (attrName.equals(DEPENDS_ATTRIBUTE)) {
                depends = attrValue;
                continue;
            }
            if (attrName.equals(UNLESS_ATTRIBUTE)) {
                unless = attrValue;
                continue;
            }
            if (attrName.equals(OPTIONS_ATTRIBUTE)) {
                unless = attrValue;
                continue;
            }
            throw new SAXException(TranslateUtil.i18n((String)"Unknown attribute on %1 : %2", (Object[])new Object[]{PROPERTY_GROUP_UI_ELEMENT, attrName}));
        }
        if (type == null) {
            throw new SAXException(TranslateUtil.i18n((String)"Attribute %1 is required on %2", (Object[])new Object[]{TYPE_ELEMENT, PROPERTY_GROUP_ELEMENT}));
        }
        if (name == null) {
            throw new SAXException(TranslateUtil.i18n((String)"Attribute %1 is required on %2", (Object[])new Object[]{"name", PROPERTY_GROUP_ELEMENT}));
        }
        if (title == null) {
            throw new SAXException(TranslateUtil.i18n((String)"Attribute %1 is required on %2", (Object[])new Object[]{TITLE_ATTRIBUTE, PROPERTY_GROUP_ELEMENT}));
        }
        if (description == null) {
            throw new SAXException(TranslateUtil.i18n((String)"Attribute %1 is required on %2", (Object[])new Object[]{"description", PROPERTY_GROUP_ELEMENT}));
        }
        this.commandPropertyGroup = new URPluginCommandGroupProperty(name, title, description, depends, unless, options, type);
    }

    private void handlePropertyGroupEnd() throws SAXException {
        if (this.curCommand.getExtension() == null) {
            URCommandExtension ext = new URCommandExtension(null, null);
            this.curCommand.setExtension(ext);
        }
        ((URCommandExtension)this.curCommand.getExtension()).addGroupProperty(this.commandPropertyGroup);
        this.commandPropertyGroup = null;
    }

    protected void handleHttpPropInfoStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("property", HTTP_PROP_INFO_ELEMENT);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals(BASE_PATH_ATTRIBUTE)) {
                this.basePath = attrValue;
                continue;
            }
            if (attrName.equals(USERNAME_ATTRIBUTE)) {
                this.username = attrValue;
                continue;
            }
            if (attrName.equals(PASSWORD_ATTRIBUTE)) {
                this.password = attrValue;
                continue;
            }
            if (attrName.equals(FORMAT_ATTRIBUTE)) {
                this.dataFormat = attrValue;
                continue;
            }
            if (attrName.equals(LABEL_PATH_ATTRIBUTE)) {
                this.labelPath = attrValue;
                continue;
            }
            if (attrName.equals(VALUE_PATH_ATTRIBUTE)) {
                this.valuePath = attrValue;
                continue;
            }
            if (attrName.equals(URL_ATTRIBUTE)) {
                this.url = attrValue;
                continue;
            }
            if (attrName.equals(AUTHENTICATION_TYPE_ATTRIBUTE)) {
                this.authenticationType = attrValue;
                continue;
            }
            throw new SAXException(TranslateUtil.i18n((String)"Unknown attribute %1 on %2", (Object[])new Object[]{attrName, HTTP_PROP_INFO_ELEMENT}));
        }
        if (this.url == null) {
            throw new SAXException(TranslateUtil.i18n((String)"%1 is a required attribute on %2", (Object[])new Object[]{URL_ATTRIBUTE, HTTP_PROP_INFO_ELEMENT}));
        }
        if (this.dataFormat == null) {
            throw new SAXException(TranslateUtil.i18n((String)"%1 is a required attribute on %2", (Object[])new Object[]{FORMAT_ATTRIBUTE, HTTP_PROP_INFO_ELEMENT}));
        }
        if (this.labelPath == null) {
            throw new SAXException(TranslateUtil.i18n((String)"%1 is a required attribute on %2", (Object[])new Object[]{LABEL_PATH_ATTRIBUTE, HTTP_PROP_INFO_ELEMENT}));
        }
        if (this.valuePath == null) {
            throw new SAXException(TranslateUtil.i18n((String)"%1 is a required attribute on %2", (Object[])new Object[]{VALUE_PATH_ATTRIBUTE, HTTP_PROP_INFO_ELEMENT}));
        }
    }

    protected void handleScriptedPropInfoStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("property", SCRIPTED_PROP_INFO_ELEMENT);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals(BASE_PATH_ATTRIBUTE)) {
                this.basePath = attrValue;
                continue;
            }
            if (attrName.equals(ARGUMENTS_ATTRIBUTE)) {
                this.arguments = attrValue;
                continue;
            }
            if (attrName.equals(SOURCE_ATTRIBUTE)) {
                this.source = attrValue;
                continue;
            }
            if (attrName.equals(PASSWORD_ATTRIBUTE)) {
                this.password = attrValue;
                continue;
            }
            if (attrName.equals(FORMAT_ATTRIBUTE)) {
                this.dataFormat = attrValue;
                continue;
            }
            if (attrName.equals(DATA_SOURCE_TYPE_ATTRIBUTE)) {
                this.dataSourceType = attrValue;
                continue;
            }
            if (attrName.equals(LABEL_PATH_ATTRIBUTE)) {
                this.labelPath = attrValue;
                continue;
            }
            if (attrName.equals(VALUE_PATH_ATTRIBUTE)) {
                this.valuePath = attrValue;
                continue;
            }
            throw new SAXException(TranslateUtil.i18n((String)"Unknown attribute %1 on %2", (Object[])new Object[]{attrName, SCRIPTED_PROP_INFO_ELEMENT}));
        }
        if (this.source == null) {
            throw new SAXException(TranslateUtil.i18n((String)"%1 is a required attribute on %2", (Object[])new Object[]{SOURCE_ATTRIBUTE, SCRIPTED_PROP_INFO_ELEMENT}));
        }
        if (this.dataSourceType == null) {
            throw new SAXException(TranslateUtil.i18n((String)"%1 is a required attribute on %2", (Object[])new Object[]{DATA_SOURCE_TYPE_ATTRIBUTE, SCRIPTED_PROP_INFO_ELEMENT}));
        }
    }

    protected void handleHttpPropInfoEnd() throws SAXException {
        if (this.curProp != null) {
            HttpPropInfo propInfo = new HttpPropInfo();
            propInfo.setBasePath(this.basePath);
            try {
                propInfo.setPassword(this.password);
            }
            catch (GeneralSecurityException e) {
                throw new SAXException(TranslateUtil.i18n((String)"Could not encrypt the password for propInfo %1 %2 %3", (Object[])new Object[]{this.url, this.dataFormat, e.getMessage()}));
            }
            propInfo.setUsername(this.username);
            propInfo.setFormatName(this.dataFormat);
            propInfo.setUrl(this.url);
            propInfo.setLabelPath(this.labelPath);
            propInfo.setValuePath(this.valuePath);
            if (this.authenticationType != null) {
                propInfo.setAuthenticationType(this.authenticationType);
            }
            ((URPluginCommandPropertyExtension)this.curProp.getExtension()).setHttpPropInfo(propInfo);
            this.username = null;
            this.dataFormat = null;
            this.url = null;
            this.labelPath = null;
            this.valuePath = null;
            this.basePath = null;
            this.password = null;
            this.authenticationType = null;
        }
    }

    protected void handleScriptedPropInfoEnd() throws SAXException {
        if (this.curProp != null) {
            ScriptedPropInfo propInfo = new ScriptedPropInfo();
            propInfo.setBasePath(this.basePath);
            if (this.dataFormat != null) {
                propInfo.setFormatName(this.dataFormat);
            }
            propInfo.setDataSourceType(this.dataSourceType);
            propInfo.setSource(this.source);
            propInfo.setArguments(this.arguments);
            propInfo.setLabelPath(this.labelPath);
            propInfo.setValuePath(this.valuePath);
            ((URPluginCommandPropertyExtension)this.curProp.getExtension()).setScriptedPropInfo(propInfo);
            this.dataFormat = null;
            this.dataSourceType = null;
            this.labelPath = null;
            this.valuePath = null;
            this.basePath = null;
            this.source = null;
            this.arguments = null;
        }
    }

    protected void handleDefaultValueEnd() throws SAXException {
        String parentElementName = (String)this.tagNameStack.get(this.tagNameStack.size() - 2);
        String defaultValue = this.tagText.toString().trim();
        if (!parentElementName.equals("property-ui")) {
            throw new SAXException("default-value not allowed in: " + parentElementName);
        }
        URPluginCommandPropertyExtension extension = (URPluginCommandPropertyExtension)this.curProp.getExtension();
        extension.setDefaultValue(defaultValue);
    }

    protected void handleTypeStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("step-type", TYPE_ELEMENT);
        if (this.hasType) {
            throw new SAXException(TranslateUtil.i18n((String)"%1 cannot have more than one %2", (Object[])new Object[]{"step-type", TYPE_ELEMENT}));
        }
    }

    protected void handleTypeEnd() throws SAXException {
        String val = this.tagText.toString();
        PluginCommandType type = PluginCommandType.valueOf(val);
        URCommandExtension ext = new URCommandExtension(type, null);
        this.curCommand.setExtension(ext);
        this.hasType = true;
    }

    protected void handleStepTypeStart(Attributes attrs) throws SAXException {
        String name = null;
        this.types = null;
        this.topics = null;
        this.displayed = false;
        this.checkParentElementType("plugin", "step-type");
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals("name")) {
                name = attrValue;
                continue;
            }
            if (attrName.equals(DISPLAYED_ATTRIBUTE)) {
                this.displayed = Boolean.parseBoolean(attrValue);
                continue;
            }
            if (attrName.equals(EXTENDS_ATTRIBUTE)) {
                this.types = attrValue;
                continue;
            }
            if (attrName.equals(SUBSCRIBE_ATTRIBUTE)) {
                this.topics = attrValue;
                continue;
            }
            throw new SAXException("Unknown attribute on step-type : " + attrName);
        }
        if (name == null) {
            throw new SAXException("name is a required attribute on step-type");
        }
        this.curCommand = new Command(name, "");
    }

    protected void handleStepTypeEnd() throws SAXException {
        if (this.curCommand.getExtension() == null) {
            URCommandExtension ext = new URCommandExtension(null, null);
            ext.setDisplayed(this.displayed);
            ext.setTypes(this.types);
            ext.setTopics(this.topics);
            this.curCommand.setExtension(ext);
        } else {
            ((URCommandExtension)this.curCommand.getExtension()).setDisplayed(this.displayed);
            ((URCommandExtension)this.curCommand.getExtension()).setTypes(this.types);
            ((URCommandExtension)this.curCommand.getExtension()).setTopics(this.topics);
        }
        this.hasType = false;
        if (!this.hasCommand) {
            throw new SAXException(TranslateUtil.i18n((String)"%1 has to have a %2", (Object[])new Object[]{"step-type", "command"}));
        }
        if (!this.hasPostProcessing) {
            throw new SAXException(TranslateUtil.i18n((String)"%1 has to have a %2", (Object[])new Object[]{"step-type", "post-processing"}));
        }
        this.hasPostProcessing = false;
        this.hasProperties = false;
        this.hasCommand = false;
        this.commands.add(this.curCommand);
        this.curCommand = null;
    }

    protected void handlePluginTypeStart(Attributes attrs) throws SAXException {
        this.checkParentElementType("header", PLUGIN_TYPE_ELEMENT);
    }

    protected void handlePluginTypeEnd() throws SAXException {
        String val = this.tagText.toString().trim();
        try {
            this.pluginType = PluginType.valueOf(val);
        }
        catch (Exception e) {
            throw new SAXException(TranslateUtil.i18n((String)"%s is not a valid plugin type", (Object[])new Object[]{val}));
        }
    }

    protected void handlePluginEnd() throws SAXException {
        if (!this.hasHeader) {
            throw new SAXException(TranslateUtil.i18n((String)"All plugins must have a header element!", (Object[])new Object[0]));
        }
        this.hasHeader = false;
        for (Command command : this.commands) {
            this.plugin.addCommand(command);
        }
        boolean atLeastOneStepIsDisplayable = false;
        for (Command cmd : this.plugin.getCommands()) {
            URCommandExtension ext;
            if (cmd.getExtension() == null || !(ext = (URCommandExtension)cmd.getExtension()).isDisplayed()) continue;
            atLeastOneStepIsDisplayable = true;
        }
        if (!atLeastOneStepIsDisplayable) {
            throw new SAXException(TranslateUtil.i18n((String)"A plugin must have at least one Step containing properties and the attribute displayed=true.", (Object[])new Object[0]));
        }
    }
}

