/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def.http;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.crypto.CryptStringUtil;
import com.urbancode.commons.util.logging.LogUtil;
import com.urbancode.oslc.OAuthLoginHelper;
import com.urbancode.oslc.OslcOAuthDefaultClient;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.wink.client.ClientResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestCallable
implements Callable<String> {
    private static final Logger log = Logger.getLogger(HttpRequestCallable.class);
    private static final String ACCEPT_JSON = "application/json";
    private static final String ACCEPT_XML = "application/xml";
    private HttpPropInfo info;

    public HttpRequestCallable(HttpPropInfo info) {
        this.info = info;
    }

    @Override
    public String call() throws Exception {
        String result = null;
        if (this.info.getHttpAuthenticationType() == HttpPropInfo.HttpAuthenticationType.BASIC) {
            result = this.callWithBasicAuthentication();
        } else if (this.info.getHttpAuthenticationType() == HttpPropInfo.HttpAuthenticationType.OAUTH) {
            result = this.callWithOAuth();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String callWithBasicAuthentication() throws Exception {
        String result = null;
        LogUtil.logDebug((Logger)log, (Object)("Retrieving data from " + this.info.getUrl() + " with username " + this.info.getUsername()));
        HttpClientBuilder builder = new HttpClientBuilder();
        if (this.info.getUsername() != null) {
            builder.setUsername(this.info.getUsername());
        }
        if (this.info.getPassword() != null) {
            builder.setPassword(CryptStringUtil.decrypt((String)this.info.getPassword()));
        }
        builder.setPreemptiveAuthentication(true);
        builder.setTrustAllCerts(true);
        URI uri = new URI(this.info.getUrl());
        HttpGet request = new HttpGet(uri);
        DefaultHttpClient client = builder.buildClient();
        if (this.info.getFormat() == HttpPropInfo.HttpDataFormat.JSON) {
            request.setHeader("Accept", ACCEPT_JSON);
        } else if (this.info.getFormat() == HttpPropInfo.HttpDataFormat.XML) {
            request.setHeader("Accept", ACCEPT_XML);
        }
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)request);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode < 200 || responseCode >= 300) {
                throw new TranslatableException("An problem occurred retrieving data from url: %s. Reason: %s", new Object[]{this.info.getUrl(), response.getStatusLine().getReasonPhrase()});
            }
            result = IO.readText((InputStream)response.getEntity().getContent());
            client.getConnectionManager().shutdown();
            LogUtil.logTrace((Logger)log, (Object)result);
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        return result;
    }

    public String callWithOAuth() throws Exception {
        String result = null;
        LogUtil.logDebug((Logger)log, (Object)("Retrieving data from " + this.info.getUrl() + " with username " + this.info.getUsername()));
        OslcOAuthDefaultClient oauthClient = new OAuthLoginHelper().oAuthLogin(this.info.getUrl(), this.info.getUsername(), CryptStringUtil.decrypt((String)this.info.getPassword()));
        String format = null;
        if (this.info.getFormat() == HttpPropInfo.HttpDataFormat.JSON) {
            format = ACCEPT_JSON;
        } else if (this.info.getFormat() == HttpPropInfo.HttpDataFormat.XML) {
            format = ACCEPT_XML;
        }
        ClientResponse response = oauthClient.getResource(this.info.getUrl(), format, "1.0");
        int responseCode = response.getStatusCode();
        if (responseCode < 200 || responseCode >= 300) {
            throw new TranslatableException("An problem occurred retrieving data from url: %s. Reason: %s", new Object[]{this.info.getUrl(), response.getMessage()});
        }
        result = IO.readText((InputStream)((InputStream)response.getEntity(InputStream.class)), (String)"UTF-8");
        LogUtil.logTrace((Logger)log, (Object)result);
        return result;
    }
}

