/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.ControllableSymbolicLinkImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLinkVersion;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.util.VersionedContentManagerByteArrayInputStreamPovider;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class JzRepoSymbolicLink
extends JzRepoControllableFolder {
    private static final String SLASH = String.valueOf('/');
    private static final String SLASH_OR_BACKSLASH_REGEXP = "[/\\\\]";
    public static final PropertyNameList.PropertyName<String> PN_ELEMENT_TARGET_ELEMENT_UNIVERSAL_SELECTOR = new PropertyNameList.PropertyName("com.ibm.team.interop", "Element.TargetElementUniversalSelector");
    public static final String SymbolicLinkPrefix = "<Symbolic Link>";
    public static final String CONTENT_TYPE_SYMLINK = "text/symblink";

    public JzRepoSymbolicLink(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableSymbolicLinkImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)ControllableSymbolicLink.LINK_TARGET)) {
            IVersionableHandle vh = this.lookupVersionableHandle(this.location().getPath(), feedback);
            return JzRepoSymbolicLinkVersion.getTarget(this.provider(), this.location(), vh, feedback);
        }
        if (propertyName.equals((Object)InteropUtilities.PN_SYMLINK_TARGET_IS_DIR)) {
            IVersionableHandle vh = this.lookupVersionableHandle(this.location().getPath(), feedback);
            IVersionable ver = JzRepoVersion.fetchCompleteState(this.provider(), vh, feedback);
            Boolean result = ver instanceof ISymbolicLink ? Boolean.valueOf(((ISymbolicLink)ver).isDirectoryLink()) : null;
            return result;
        }
        if (propertyName.equals(PN_ELEMENT_TARGET_ELEMENT_UNIVERSAL_SELECTOR)) {
            IVersionableHandle vh = this.lookupVersionableHandle(this.location().getPath(), feedback);
            IVersionable ver = JzRepoVersion.fetchCompleteState(this.provider(), vh, feedback);
            String index = propertyName.toString();
            Map userProperties = ver.getUserProperties();
            String result = (String)userProperties.get(index);
            return result;
        }
        if (propertyName.equals((Object)ControllableSymbolicLink.CHILD_MAP)) {
            HashMap result = new HashMap();
            return result;
        }
        if (propertyName.equals((Object)ControllableSymbolicLink.CHILD_LIST)) {
            ArrayList result = new ArrayList();
            return result;
        }
        if (propertyName.equals((Object)Resource.CREATION_DATE)) {
            IVersionableHandle vh = this.lookupVersionableHandle(this.location().getPath(), feedback);
            return JzRepoSymbolicLinkVersion.getCreationDate(this.provider(), vh, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public static String readSymbolicLinkTarget(WorkspaceProvider provider, JzLocation loc, OutputStream out, SrvcFeedback feedback) throws WvcmException {
        String content = out.toString();
        String path = null;
        if (!content.startsWith(SymbolicLinkPrefix)) {
            int end = content.length();
            if (end > 100) {
                content = String.valueOf(content.substring(0, 100)) + "...";
            }
            feedback.notifyWarning(NLS.bind((String)"Bad symlink at location: {0}, content: {1}", (Object)loc.string(), (Object[])new Object[]{content}));
            path = "bad_symlink_target_value";
        } else {
            path = content.substring(SymbolicLinkPrefix.length());
        }
        return path;
    }

    public static JzRepoResource doCreateSymbolicLink(JzProvider provider, JzLocation location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzLocation actualAddedItemLocation;
        boolean symbolicLinksSupported;
        PropValue propVal = updates.get(ControllableSymbolicLink.LINK_TARGET);
        if (propVal == null) {
            throw new WvcmException("LINK_TARGET must be set when creating a symbolic link", WvcmException.ReasonCode.FORBIDDEN);
        }
        String target = (String)propVal.get_value();
        Boolean isDirectory = null;
        propVal = updates.get(InteropUtilities.PN_SYMLINK_TARGET_IS_DIR);
        if (propVal != null) {
            isDirectory = (Boolean)propVal.get_value();
        }
        if (symbolicLinksSupported = "true".equalsIgnoreCase(provider.getSymlinksSupported())) {
            ISymbolicLink addMe = (ISymbolicLink)ISymbolicLink.ITEM_TYPE.createItem();
            addMe.setTarget(target);
            if (isDirectory != null) {
                addMe.setIsDirectoryLink(isDirectory.booleanValue());
            }
            addMe.setLinkTimestamp(new Date(System.currentTimeMillis()));
            actualAddedItemLocation = JzRepoControllableResource.doAddItemToParent(provider, location, (IVersionable)addMe, feedback);
        } else {
            IFileItem addMe = (IFileItem)IFileItem.ITEM_TYPE.createItem();
            String contentString = SymbolicLinkPrefix + target;
            byte[] contentByteArray = contentString.getBytes();
            try {
                IFileContent content = FileSystemCore.getContentManager((ITeamRepository)provider.getRepo()).storeContent("us-ascii", FileLineDelimiter.LINE_DELIMITER_NONE, (AbstractVersionedContentManagerInputStreamProvider)new VersionedContentManagerByteArrayInputStreamPovider(contentByteArray), null, JzProvider.getMonitor(feedback, 50));
                addMe.setContentType(CONTENT_TYPE_SYMLINK);
                addMe.setContent(content);
                addMe.setFileTimestamp(new Date(System.currentTimeMillis()));
                actualAddedItemLocation = JzRepoControllableResource.doAddItemToParent(provider, location, (IVersionable)addMe, feedback);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
        }
        JzRepoSymbolicLink result = new JzRepoSymbolicLink(provider, (Location)actualAddedItemLocation);
        updated.add(ControllableSymbolicLink.LINK_TARGET);
        return result;
    }
}

