/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client;

import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class ContextLock {
    private static final HashMap<UUID, LockInfo> locked = new HashMap();
    private static final Map<Thread, Integer> lockCount = new HashMap<Thread, Integer>();
    private static final ReentrantLock lock = new ReentrantLock();
    private final Map<UUID, ToLockInfo> contexts = new LinkedHashMap<UUID, ToLockInfo>();
    private static final int TYPE_NONE = 0;
    private static final int TYPE_SHARED = 1;
    private static final int TYPE_EXCLUSIVE = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExclusive(IContextHandle context) {
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            ToLockInfo info = this.contexts.get(context.getItemId());
            if (info == null) {
                info = new ToLockInfo();
                info.type = 2;
                this.contexts.put(context.getItemId(), info);
            } else {
                info.type |= 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShared(IContextHandle context) {
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            ToLockInfo info = this.contexts.get(context.getItemId());
            if (info == null) {
                info = new ToLockInfo();
                info.type = 1;
                this.contexts.put(context.getItemId(), info);
            } else {
                info.type |= 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExclusive(IContextHandle context, IComponentHandle component) {
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            ToLockInfo info = this.contexts.get(context.getItemId());
            if (info == null) {
                info = new ToLockInfo();
                info.componentLocks = new LinkedHashMap<UUID, Integer>();
                this.contexts.put(context.getItemId(), info);
                info.componentLocks.put(component.getItemId(), 2);
            } else if (info.componentLocks == null) {
                info.componentLocks = new LinkedHashMap<UUID, Integer>();
                info.componentLocks.put(component.getItemId(), 2);
            } else {
                Integer oldType = info.componentLocks.get(component.getItemId());
                info.componentLocks.put(component.getItemId(), oldType == null ? 2 : oldType | 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShared(IContextHandle context, IComponentHandle component) {
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            ToLockInfo info = this.contexts.get(context.getItemId());
            if (info == null) {
                info = new ToLockInfo();
                info.componentLocks = new LinkedHashMap<UUID, Integer>();
                this.contexts.put(context.getItemId(), info);
                info.componentLocks.put(component.getItemId(), 1);
            } else if (info.componentLocks == null) {
                info.componentLocks = new LinkedHashMap<UUID, Integer>();
                info.componentLocks.put(component.getItemId(), 1);
            } else {
                Integer oldType = info.componentLocks.get(component.getItemId());
                info.componentLocks.put(component.getItemId(), oldType == null ? 1 : oldType | 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExclusive(IContextHandle context) {
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            ToLockInfo info = this.contexts.get(context.getItemId());
            if (info == null) {
                return;
            }
            if (info.type == 2) {
                if (info.componentLocks == null) {
                    this.contexts.remove(context.getItemId());
                    return;
                }
                info.type = 0;
                return;
            }
            info.type &= 0xFFFFFFFD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShared(IContextHandle context) {
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            ToLockInfo info = this.contexts.get(context.getItemId());
            if (info == null) {
                return;
            }
            if (info.type == 1) {
                if (info.componentLocks == null) {
                    this.contexts.remove(context.getItemId());
                    return;
                }
                info.type = 0;
                return;
            }
            info.type &= 0xFFFFFFFE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExclusive(IContextHandle context, IComponentHandle component) {
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            ToLockInfo info = this.contexts.get(context.getItemId());
            if (info == null) {
                return;
            }
            if (info.componentLocks == null) {
                return;
            }
            Integer oldType = info.componentLocks.get(component.getItemId());
            if (oldType == null) {
                return;
            }
            if (oldType == 2) {
                info.componentLocks.remove(component.getItemId());
                if (info.componentLocks.isEmpty()) {
                    if (info.type == 0) {
                        this.contexts.remove(context.getItemId());
                        return;
                    }
                    info.componentLocks = null;
                }
                return;
            }
            info.componentLocks.put(component.getItemId(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShared(IContextHandle context, IComponentHandle component) {
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            ToLockInfo info = this.contexts.get(context.getItemId());
            if (info == null) {
                return;
            }
            if (info.componentLocks == null) {
                return;
            }
            Integer oldType = info.componentLocks.get(component.getItemId());
            if (oldType == null) {
                return;
            }
            if (oldType == 1) {
                info.componentLocks.remove(component.getItemId());
                if (info.componentLocks.isEmpty()) {
                    if (info.type == 0) {
                        this.contexts.remove(context.getItemId());
                        return;
                    }
                    info.componentLocks = null;
                }
                return;
            }
            info.componentLocks.put(component.getItemId(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            this.contexts.clear();
        }
    }

    /*
     * Exception decompiling
     */
    public void acquire(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForExclusive(UUID context, boolean canLock, Thread current, IProgressMonitor monitor) {
        LockInfo info = locked.get(context);
        if (info != null && info.writeOwner == current) {
            return false;
        }
        if (!canLock) {
            throw new IllegalStateException("Cannot expand lock list (" + this.getLockInfo(true) + ")");
        }
        if (info == null) {
            return false;
        }
        if (info.writeOwner != null || !info.readLocks.isEmpty() || !info.componentLocks.isEmpty()) {
            try {
                LockInfo lockInfo = info;
                synchronized (lockInfo) {
                    lock.unlock();
                    ++info.waiterCount;
                    try {
                        do {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            try {
                                info.wait(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                        } while (info.writeOwner != null || !info.readLocks.isEmpty() || !info.componentLocks.isEmpty());
                    }
                    finally {
                        --info.waiterCount;
                    }
                }
            }
            catch (Throwable throwable) {
                lock.lock();
                info = locked.get(context);
                if (info != null && info.writeOwner == null && info.readLocks.isEmpty() && info.componentLocks.isEmpty()) {
                    LockInfo lockInfo = info;
                    synchronized (lockInfo) {
                        if (info.waiterCount == 0) {
                            locked.remove(context);
                        }
                    }
                }
                throw throwable;
            }
            lock.lock();
            info = locked.get(context);
            if (info != null && info.writeOwner == null && info.readLocks.isEmpty() && info.componentLocks.isEmpty()) {
                LockInfo lockInfo = info;
                synchronized (lockInfo) {
                    if (info.waiterCount == 0) {
                        locked.remove(context);
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForShared(UUID context, boolean canLock, Thread current, IProgressMonitor monitor) {
        int numWrites;
        LockInfo info = locked.get(context);
        if (info != null && (info.writeOwner == current || info.readLocks.containsKey(current))) {
            return false;
        }
        if (!canLock) {
            throw new IllegalStateException("Cannot expand lock list (" + this.getLockInfo(true) + ")");
        }
        if (info == null) {
            return false;
        }
        Integer numWritesO = info.numComponentWriteLocksPerThread.get(current);
        int n = numWrites = numWritesO == null ? 0 : numWritesO;
        if (info.writeOwner != null || info.totalComponentWriteLocks != numWrites) {
            try {
                LockInfo lockInfo = info;
                synchronized (lockInfo) {
                    lock.unlock();
                    ++info.waiterCount;
                    try {
                        do {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            try {
                                info.wait(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                        } while (info.writeOwner != null || info.totalComponentWriteLocks != numWrites);
                    }
                    finally {
                        --info.waiterCount;
                    }
                }
            }
            catch (Throwable throwable) {
                lock.lock();
                info = locked.get(context);
                if (info != null && info.writeOwner == null && info.readLocks.isEmpty() && info.componentLocks.isEmpty()) {
                    LockInfo lockInfo = info;
                    synchronized (lockInfo) {
                        if (info.waiterCount == 0) {
                            locked.remove(context);
                        }
                    }
                }
                throw throwable;
            }
            lock.lock();
            info = locked.get(context);
            if (info != null && info.writeOwner == null && info.readLocks.isEmpty() && info.componentLocks.isEmpty()) {
                LockInfo lockInfo = info;
                synchronized (lockInfo) {
                    if (info.waiterCount == 0) {
                        locked.remove(context);
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForExclusive(UUID context, UUID component, boolean canLock, Thread current, IProgressMonitor monitor) {
        LockInfo info = locked.get(context);
        if (info != null && info.writeOwner == current) {
            return false;
        }
        if (info == null) {
            if (canLock) return false;
            throw new IllegalStateException("Cannot expand lock list (" + this.getLockInfo(true) + ")");
        }
        ComponentLockInfo ci = info.componentLocks.get(component);
        if (ci != null && ci.writeOwner == current) {
            return false;
        }
        if (!canLock) {
            throw new IllegalStateException("Cannot expand lock list (" + this.getLockInfo(true) + ")");
        }
        if (info.writeOwner == null && info.readLocks.isEmpty()) {
            if (ci == null) return false;
            if (ci.writeOwner == null) {
                if (ci.readLocks.isEmpty()) return false;
            }
        }
        try {
            LockInfo lockInfo = info;
            synchronized (lockInfo) {
                lock.unlock();
                ++info.waiterCount;
                try {
                    do {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        try {
                            info.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ci = info.componentLocks.get(component);
                    } while (info.writeOwner != null || !info.readLocks.isEmpty() || ci != null && (ci.writeOwner != null || !ci.readLocks.isEmpty()));
                }
                finally {
                    --info.waiterCount;
                }
            }
        }
        catch (Throwable throwable) {
            lock.lock();
            info = locked.get(context);
            if (info == null) throw throwable;
            if (info.writeOwner != null) throw throwable;
            if (!info.readLocks.isEmpty()) throw throwable;
            if (!info.componentLocks.isEmpty()) throw throwable;
            LockInfo lockInfo = info;
            synchronized (lockInfo) {
                if (info.waiterCount != 0) throw throwable;
                locked.remove(context);
                throw throwable;
            }
        }
        lock.lock();
        info = locked.get(context);
        if (info == null) return true;
        if (info.writeOwner != null) return true;
        if (!info.readLocks.isEmpty()) return true;
        if (!info.componentLocks.isEmpty()) return true;
        LockInfo lockInfo = info;
        synchronized (lockInfo) {
            if (info.waiterCount != 0) return true;
            locked.remove(context);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForShared(UUID context, UUID component, boolean canLock, Thread current, IProgressMonitor monitor) {
        LockInfo info = locked.get(context);
        if (info != null) {
            if (info.writeOwner == current) return false;
            if (info.readLocks.containsKey(current)) {
                return false;
            }
        }
        if (info == null) {
            if (canLock) return false;
            throw new IllegalStateException("Cannot expand lock list (" + this.getLockInfo(true) + ")");
        }
        ComponentLockInfo ci = info.componentLocks.get(component);
        if (ci != null) {
            if (ci.writeOwner == current) return false;
            if (ci.readLocks.containsKey(current)) {
                return false;
            }
        }
        if (!canLock) {
            throw new IllegalStateException("Cannot expand lock list (" + this.getLockInfo(true) + ")");
        }
        if (info.writeOwner == null) {
            if (ci == null) return false;
            if (ci.writeOwner == null) return false;
        }
        try {
            LockInfo lockInfo = info;
            synchronized (lockInfo) {
                lock.unlock();
                ++info.waiterCount;
                try {
                    do {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        try {
                            info.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ci = info.componentLocks.get(component);
                    } while (info.writeOwner != null || ci != null && ci.writeOwner != null);
                }
                finally {
                    --info.waiterCount;
                }
            }
        }
        catch (Throwable throwable) {
            lock.lock();
            info = locked.get(context);
            if (info == null) throw throwable;
            if (info.writeOwner != null) throw throwable;
            if (!info.readLocks.isEmpty()) throw throwable;
            if (!info.componentLocks.isEmpty()) throw throwable;
            LockInfo lockInfo = info;
            synchronized (lockInfo) {
                if (info.waiterCount != 0) throw throwable;
                locked.remove(context);
                throw throwable;
            }
        }
        lock.lock();
        info = locked.get(context);
        if (info == null) return true;
        if (info.writeOwner != null) return true;
        if (!info.readLocks.isEmpty()) return true;
        if (!info.componentLocks.isEmpty()) return true;
        LockInfo lockInfo = info;
        synchronized (lockInfo) {
            if (info.waiterCount != 0) return true;
            locked.remove(context);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Thread current = Thread.currentThread();
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            if (this.contexts.isEmpty()) {
                return;
            }
            lock.lock();
            try {
                for (Map.Entry<UUID, ToLockInfo> e : this.contexts.entrySet()) {
                    UUID id = e.getKey();
                    ToLockInfo info = e.getValue();
                    LockInfo lInfo = locked.get(id);
                    if (lInfo == null) {
                        throw new IllegalStateException("Not holding any locks for context " + id + "(" + this.getLockInfo(false) + ")");
                    }
                    if ((info.type & 2) != 0 && lInfo.writeOwner != current) {
                        throw new IllegalStateException("Not holding exclusive lock for context " + id + "(" + this.getLockInfo(false) + ")");
                    }
                    if ((info.type & 1) != 0 && !lInfo.readLocks.containsKey(current)) {
                        throw new IllegalStateException("Not holding shared lock for context " + id + "(" + this.getLockInfo(false) + ")");
                    }
                    if (info.componentLocks == null) continue;
                    for (Map.Entry<UUID, Integer> en : info.componentLocks.entrySet()) {
                        UUID cmpId = en.getKey();
                        int lockType = en.getValue();
                        ComponentLockInfo cmpInfo = lInfo.componentLocks.get(cmpId);
                        if (cmpInfo == null) {
                            throw new IllegalStateException("Not holding any locks for context " + id + " component " + cmpId + "(" + this.getLockInfo(false) + ")");
                        }
                        if ((lockType & 2) != 0 && cmpInfo.writeOwner != current) {
                            throw new IllegalStateException("Not holding exclusive lock for context " + id + " component " + cmpId + "(" + this.getLockInfo(false) + ")");
                        }
                        if ((lockType & 1) == 0 || cmpInfo.readLocks.containsKey(current)) continue;
                        throw new IllegalStateException("Not holding shared lock for context " + id + " component " + cmpId + "(" + this.getLockInfo(false) + ")");
                    }
                }
                int numUnloked = 0;
                for (Map.Entry<UUID, ToLockInfo> e : this.contexts.entrySet()) {
                    UUID id = e.getKey();
                    ToLockInfo info = e.getValue();
                    LockInfo lInfo = locked.get(id);
                    boolean doNotify = false;
                    LockInfo lockInfo = lInfo;
                    synchronized (lockInfo) {
                        if ((info.type & 2) != 0) {
                            --lInfo.writeLockCount;
                            if (lInfo.writeLockCount == 0) {
                                lInfo.writeOwner = null;
                                doNotify = true;
                            }
                            ++numUnloked;
                        }
                        if ((info.type & 1) != 0) {
                            int oldValue = lInfo.readLocks.get(current);
                            if (oldValue == 1) {
                                lInfo.readLocks.remove(current);
                                if (lInfo.readLocks.isEmpty() && lInfo.writeOwner == null) {
                                    doNotify = true;
                                }
                            } else {
                                lInfo.readLocks.put(current, oldValue - 1);
                            }
                            ++numUnloked;
                        }
                        if (info.componentLocks != null) {
                            int cmpWriteUnlocks = 0;
                            for (Map.Entry<UUID, Integer> en : info.componentLocks.entrySet()) {
                                UUID cmpId = en.getKey();
                                int lockType = en.getValue();
                                ComponentLockInfo cmpInfo = lInfo.componentLocks.get(cmpId);
                                if ((lockType & 2) != 0) {
                                    --cmpInfo.writeLockCount;
                                    if (cmpInfo.writeLockCount == 0) {
                                        cmpInfo.writeOwner = null;
                                        if (cmpInfo.readLocks.isEmpty()) {
                                            lInfo.componentLocks.remove(cmpId);
                                        }
                                        if (lInfo.writeOwner == null) {
                                            doNotify = true;
                                        }
                                    }
                                    ++numUnloked;
                                    ++cmpWriteUnlocks;
                                }
                                if ((lockType & 1) == 0) continue;
                                int oldValue = cmpInfo.readLocks.get(current);
                                if (oldValue == 1) {
                                    cmpInfo.readLocks.remove(current);
                                    if (cmpInfo.readLocks.isEmpty() && cmpInfo.writeOwner == null) {
                                        lInfo.componentLocks.remove(cmpId);
                                        if (lInfo.readLocks.isEmpty() && lInfo.writeOwner == null) {
                                            doNotify = true;
                                        }
                                    }
                                } else {
                                    cmpInfo.readLocks.put(current, oldValue - 1);
                                }
                                ++numUnloked;
                            }
                            if (cmpWriteUnlocks != 0) {
                                lInfo.totalComponentWriteLocks -= cmpWriteUnlocks;
                                int oldValue = lInfo.numComponentWriteLocksPerThread.get(current);
                                if (oldValue == cmpWriteUnlocks) {
                                    lInfo.numComponentWriteLocksPerThread.remove(current);
                                } else {
                                    lInfo.numComponentWriteLocksPerThread.put(current, oldValue - cmpWriteUnlocks);
                                }
                            }
                        }
                        if (doNotify) {
                            if (lInfo.waiterCount == 0) {
                                if (lInfo.writeOwner == null && lInfo.readLocks.isEmpty() && lInfo.componentLocks.isEmpty()) {
                                    locked.remove(id);
                                }
                            } else {
                                lInfo.notifyAll();
                            }
                        }
                    }
                }
                int oldCount = lockCount.get(current);
                if (oldCount == numUnloked) {
                    lockCount.remove(current);
                } else {
                    lockCount.put(current, oldCount - numUnloked);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLocked() {
        Thread current = Thread.currentThread();
        Map<UUID, ToLockInfo> map = this.contexts;
        synchronized (map) {
            if (this.contexts.isEmpty()) {
                return true;
            }
            lock.lock();
            try {
                for (Map.Entry<UUID, ToLockInfo> e : this.contexts.entrySet()) {
                    UUID id = e.getKey();
                    ToLockInfo info = e.getValue();
                    LockInfo lInfo = locked.get(id);
                    if (lInfo == null || (info.type & 2) != 0 && lInfo.writeOwner != current || (info.type & 1) != 0 && !lInfo.readLocks.containsKey(current) && lInfo.writeOwner != current) {
                        return false;
                    }
                    if (info.componentLocks == null) continue;
                    for (Map.Entry<UUID, Integer> en : info.componentLocks.entrySet()) {
                        UUID cmpId = en.getKey();
                        int lockType = en.getValue();
                        if ((lockType & 2) != 0) {
                            lockType = 2;
                        }
                        ComponentLockInfo cmpInfo = lInfo.componentLocks.get(cmpId);
                        boolean locked = false;
                        if (cmpInfo != null) {
                            if (lockType == 2 && cmpInfo.writeOwner == current) {
                                locked = true;
                            }
                            if (lockType == 1 && (cmpInfo.readLocks.containsKey(current) || cmpInfo.writeOwner == current)) {
                                locked = true;
                            }
                        }
                        if (lockType == 2 && lInfo.writeOwner == current) {
                            locked = true;
                        }
                        if (lockType == 1 && (lInfo.readLocks.containsKey(current) || lInfo.writeOwner == current)) {
                            locked = true;
                        }
                        if (locked) continue;
                        return false;
                    }
                }
            }
            finally {
                lock.unlock();
            }
            return true;
        }
    }

    private String getLockInfo(boolean isLocking) {
        Object info;
        UUID wsId;
        Thread current = Thread.currentThread();
        StringBuilder b = new StringBuilder();
        b.append("locked: ");
        boolean first = true;
        for (Map.Entry<UUID, LockInfo> entry : locked.entrySet()) {
            Integer cnt;
            wsId = entry.getKey();
            info = entry.getValue();
            if (((LockInfo)info).writeOwner == current) {
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append('(');
                b.append(Integer.toString(((LockInfo)info).writeLockCount));
                b.append("w) ");
                b.append(wsId.getUuidValue());
            }
            if ((cnt = ((LockInfo)info).readLocks.get(current)) != null) {
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append('(');
                b.append(cnt.toString());
                b.append("r) ");
                b.append(wsId.getUuidValue());
            }
            for (Map.Entry<UUID, ComponentLockInfo> ce : ((LockInfo)info).componentLocks.entrySet()) {
                UUID cmpId = ce.getKey();
                ComponentLockInfo cInfo = ce.getValue();
                if (cInfo.writeOwner == current) {
                    if (!first) {
                        b.append(", ");
                    } else {
                        first = false;
                    }
                    b.append('(');
                    b.append(Integer.toString(cInfo.writeLockCount));
                    b.append("w) ");
                    b.append(wsId.getUuidValue());
                    b.append(", ");
                    b.append(cmpId.getUuidValue());
                }
                if ((cnt = cInfo.readLocks.get(current)) == null) continue;
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append('(');
                b.append(cnt.toString());
                b.append("r) ");
                b.append(wsId.getUuidValue());
                b.append(", ");
                b.append(cmpId.getUuidValue());
            }
        }
        if (isLocking) {
            b.append(", locking: ");
        } else {
            b.append(", unlocking: ");
        }
        first = true;
        for (Map.Entry<UUID, Object> entry : this.contexts.entrySet()) {
            wsId = entry.getKey();
            info = (ToLockInfo)entry.getValue();
            if (((ToLockInfo)info).type != 0) {
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append('(');
                b.append(Integer.toString(((ToLockInfo)info).type));
                b.append(") ");
                b.append(wsId.getUuidValue());
            }
            if (((ToLockInfo)info).componentLocks == null) continue;
            for (Map.Entry<UUID, Integer> ce : ((ToLockInfo)info).componentLocks.entrySet()) {
                UUID cmpId = ce.getKey();
                Integer type = ce.getValue();
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append('(');
                b.append(type.toString());
                b.append(") ");
                b.append(wsId.getUuidValue());
                b.append(", ");
                b.append(cmpId.getUuidValue());
            }
        }
        return b.toString();
    }

    public static String internalDumpLockInfo() {
        StringBuilder b;
        ThreadCheck.checkLongOpsAllowed();
        lock.lock();
        try {
            Integer cnt;
            Thread t;
            b = new StringBuilder();
            b.append("Locks held: ");
            boolean first = true;
            HashMap<Thread, Integer> realLockCount = new HashMap<Thread, Integer>();
            for (Map.Entry<UUID, LockInfo> entry : locked.entrySet()) {
                UUID id = entry.getKey();
                LockInfo info = entry.getValue();
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append("context: ");
                b.append(id.getUuidValue());
                Thread t2 = info.writeOwner;
                if (t2 != null) {
                    b.append("\n write owner: ");
                    b.append(Long.toString(t2.getId()));
                    b.append(':');
                    b.append(t2.getName());
                    b.append(" (");
                    b.append(info.writeLockCount);
                    b.append(')');
                    Integer old = (Integer)realLockCount.get(t2);
                    if (old == null) {
                        realLockCount.put(t2, info.writeLockCount);
                    } else {
                        realLockCount.put(t2, old + info.writeLockCount);
                    }
                } else if (info.writeLockCount != 0) {
                    b.append("\n write locks: ");
                    b.append(Integer.toString(info.writeLockCount));
                }
                b.append("\n readers:");
                for (Map.Entry<Thread, Integer> re : info.readLocks.entrySet()) {
                    t2 = re.getKey();
                    Integer n = re.getValue();
                    b.append("\n  ");
                    b.append(Long.toString(t2.getId()));
                    b.append(':');
                    b.append(t2.getName());
                    b.append(" (");
                    b.append(n.toString());
                    b.append(')');
                    Integer old = (Integer)realLockCount.get(t2);
                    if (old == null) {
                        realLockCount.put(t2, n);
                        continue;
                    }
                    realLockCount.put(t2, old + n);
                }
                int totalComponentWriteLocks = 0;
                HashMap<Thread, Integer> cmpLocks = new HashMap<Thread, Integer>();
                for (Map.Entry<UUID, ComponentLockInfo> entry2 : info.componentLocks.entrySet()) {
                    UUID cmpId = entry2.getKey();
                    ComponentLockInfo cInfo = entry2.getValue();
                    b.append("\n   component ");
                    b.append(cmpId.getUuidValue());
                    t2 = cInfo.writeOwner;
                    if (t2 != null) {
                        b.append("\n    write owner: ");
                        b.append(Long.toString(t2.getId()));
                        b.append(':');
                        b.append(t2.getName());
                        b.append(" (");
                        b.append(cInfo.writeLockCount);
                        b.append(')');
                        Integer v = (Integer)cmpLocks.get(t2);
                        if (v == null) {
                            cmpLocks.put(t2, cInfo.writeLockCount);
                        } else {
                            cmpLocks.put(t2, cInfo.writeLockCount + v);
                        }
                        Integer old = (Integer)realLockCount.get(t2);
                        if (old == null) {
                            realLockCount.put(t2, cInfo.writeLockCount);
                        } else {
                            realLockCount.put(t2, old + cInfo.writeLockCount);
                        }
                    } else if (cInfo.writeLockCount != 0) {
                        b.append("\n    write locks: ");
                        b.append(Integer.toString(cInfo.writeLockCount));
                    }
                    totalComponentWriteLocks += cInfo.writeLockCount;
                    b.append("\n    readers:");
                    for (Map.Entry<Thread, Integer> re : cInfo.readLocks.entrySet()) {
                        t2 = re.getKey();
                        Integer n = re.getValue();
                        b.append("\n     ");
                        b.append(Long.toString(t2.getId()));
                        b.append(':');
                        b.append(t2.getName());
                        b.append(" (");
                        b.append(n.toString());
                        b.append(')');
                        Integer old = (Integer)realLockCount.get(t2);
                        if (old == null) {
                            realLockCount.put(t2, n);
                            continue;
                        }
                        realLockCount.put(t2, old + n);
                    }
                }
                if (info.totalComponentWriteLocks != totalComponentWriteLocks) {
                    b.append("\n Total component write locks is ");
                    b.append(Integer.toString(totalComponentWriteLocks));
                    b.append(" but the stored value is ");
                    b.append(Integer.toString(info.totalComponentWriteLocks));
                }
                for (Map.Entry<Object, Object> entry3 : info.numComponentWriteLocksPerThread.entrySet()) {
                    t2 = (Thread)entry3.getKey();
                    Integer n = (Integer)entry3.getValue();
                    Integer r = (Integer)cmpLocks.remove(t2);
                    if (r == null) {
                        r = 0;
                    }
                    if (n.equals(r) && n != 0) continue;
                    b.append("\n Real number of component write locks for ");
                    b.append(Long.toString(t2.getId()));
                    b.append(':');
                    b.append(t2.getName());
                    b.append(" is ");
                    b.append(r == null ? Integer.toString(0) : r.toString());
                    b.append(" but stored value is ");
                    b.append(n.toString());
                }
                for (Map.Entry<Object, Object> entry4 : cmpLocks.entrySet()) {
                    t2 = (Thread)entry4.getKey();
                    Integer r = (Integer)entry4.getValue();
                    b.append("\n Stored value of component write locks for ");
                    b.append(Long.toString(t2.getId()));
                    b.append(':');
                    b.append(t2.getName());
                    b.append(" is 0 but real value is ");
                    b.append(r.toString());
                }
                b.append("\n ");
                b.append(Integer.toString(info.waiterCount));
                b.append(" waiting threads");
            }
            for (Map.Entry<Object, Object> entry : lockCount.entrySet()) {
                t = (Thread)entry.getKey();
                cnt = (Integer)entry.getValue();
                Integer rCnt = (Integer)realLockCount.remove(t);
                if (cnt != 0 && cnt.equals(rCnt)) continue;
                b.append("\nReal number of locks for ");
                b.append(Long.toString(t.getId()));
                b.append(':');
                b.append(t.getName());
                b.append(": is ");
                b.append(rCnt == null ? Integer.toString(0) : rCnt.toString());
                b.append(" but stored value is ");
                b.append(cnt.toString());
            }
            for (Map.Entry<Object, Object> entry : realLockCount.entrySet()) {
                t = (Thread)entry.getKey();
                cnt = (Integer)entry.getValue();
                b.append("\nStored value for number of locks for ");
                b.append(Long.toString(t.getId()));
                b.append(':');
                b.append(t.getName());
                b.append(": is 0 but real value is ");
                b.append(cnt.toString());
            }
        }
        finally {
            lock.unlock();
        }
        return b.toString();
    }

    private static class ComponentLockInfo {
        Thread writeOwner;
        int writeLockCount;
        Map<Thread, Integer> readLocks = new HashMap<Thread, Integer>();

        private ComponentLockInfo() {
        }
    }

    private static class LockInfo {
        Map<UUID, ComponentLockInfo> componentLocks = new HashMap<UUID, ComponentLockInfo>();
        Map<Thread, Integer> readLocks = new HashMap<Thread, Integer>();
        Map<Thread, Integer> numComponentWriteLocksPerThread = new HashMap<Thread, Integer>();
        Thread writeOwner;
        int writeLockCount;
        int totalComponentWriteLocks;
        int waiterCount;

        private LockInfo() {
        }
    }

    private static class ToLockInfo {
        int type;
        Map<UUID, Integer> componentLocks;

        private ToLockInfo() {
        }
    }
}

