/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.scm.common.internal.dto2.PagedFetchDescriptor;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import org.eclipse.osgi.util.NLS;

public interface IPagedFetchDescriptor {
    public static final int MAX_PAGE_SIZE = 2048;
    public static final IPagedFetchDescriptorFactory FACTORY = new IPagedFetchDescriptorFactory(){

        @Override
        public IPagedFetchDescriptor maxEntries(int maxEntries) {
            if (maxEntries > 2048) {
                throw new IllegalArgumentException(NLS.bind((String)"The most entries that can be fetched in a page is {0}", (Object)2048));
            }
            if (maxEntries <= 0) {
                throw new IllegalArgumentException("maxEntries must be greater than 0.");
            }
            PagedFetchDescriptor desc = ScmDto2Factory.eINSTANCE.createPagedFetchDescriptor();
            desc.setMaxToFetch(maxEntries);
            desc.setPageToFetch(0);
            return desc;
        }
    };

    public static interface IPagedFetchDescriptorFactory {
        public IPagedFetchDescriptor maxEntries(int var1);
    }
}

