/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.attributeValueProviders.AttributeValueProviderRegistry;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ICondition;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ProviderContext;
import com.ibm.team.workitem.common.internal.util.AttributesAdvisorHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class RequiredAttributesByConditionAdvisor
implements IOperationAdvisor {
    public static final String ADVISOR_ID = "com.ibm.team.workitem.advisor.requiredAttributes";
    public static final String REQUIRED_ATTRIBUTES = "requiredAttributes";

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        ISaveParameter saveParameter;
        IAuditable auditable;
        Object data = operation.getOperationData();
        if (data instanceof ISaveParameter && (auditable = (saveParameter = (ISaveParameter)data).getNewState()) instanceof IWorkItem) {
            IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            IWorkItem workItem = (IWorkItem)auditable;
            TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
            this.checkWorkItem(workItem, workItemCommon, saveParameter, advisorConfiguration, collector, userTimeZone, monitor);
        }
    }

    public static List<String> getRequiredAttributes(IWorkItem workItem, IWorkItemCommon workItemCommon, String workflowAction, IProcessConfigurationElement advisorConfiguration, boolean ignoreScriptBasedAttributeAdvisors, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<String> attributes = new ArrayList<String>();
        for (AttributesAdvisorHelper.AttributeAdvisorConfiguration cfg : AttributesAdvisorHelper.getConfiguration(REQUIRED_ATTRIBUTES, workItem.getProjectArea(), workItemCommon, advisorConfiguration, monitor)) {
            ICondition filter;
            IConfiguration providerConfiguration = cfg.getConfiguration(new ProviderContext(workflowAction));
            if (ignoreScriptBasedAttributeAdvisors && providerConfiguration.getScriptClass() != null || !(filter = AttributeValueProviderRegistry.getInstance().getCondition(providerConfiguration)).matches(workItem, workItemCommon, providerConfiguration, monitor)) continue;
            attributes.addAll(cfg.getAttributeIdentifiers());
        }
        return attributes;
    }

    private void checkWorkItem(IWorkItem workItem, IWorkItemCommon workItemCommon, ISaveParameter saveParameter, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, TimeZone userTimeZone, IProgressMonitor monitor) throws TeamRepositoryException {
        List<String> attributes = RequiredAttributesByConditionAdvisor.getRequiredAttributes(workItem, workItemCommon, saveParameter.getWorkflowAction(), advisorConfiguration, false, monitor);
        for (String attributeId : attributes) {
            IAttribute attribute = workItemCommon.findAttribute(workItem.getProjectArea(), attributeId, monitor);
            if (attribute == null || !workItem.isAttributeSet(attribute)) continue;
            Object nullValue = attribute.getNullValue(workItemCommon.getAuditableCommon(), monitor);
            Object value = AttributesAdvisorHelper.getValue(workItem, attribute);
            if (!AttributesAdvisorHelper.equals(value, nullValue)) continue;
            IAdvisorInfo info = collector.createProblemInfo(this.getSummary(attribute), this.getDescription(workItem, attribute, userTimeZone), ADVISOR_ID);
            info.setProblemObject((Object)workItem.getItemHandle());
            info.setData(AttributesAdvisorHelper.createData(workItem, attribute, REQUIRED_ATTRIBUTES));
            collector.addInfo((IReportInfo)info);
        }
    }

    private String getSummary(IAttribute attribute) {
        return NLS.bind((String)Messages.getString("RequiredAttributesByConditionAdvisor.ATTRIBUTE_NOT_SET_SUMMARY"), (Object)attribute.getDisplayName(), (Object[])new Object[0]);
    }

    private String getDescription(IWorkItem workItem, IAttribute attribute, TimeZone userTimeZone) {
        return NLS.bind((String)Messages.getString("RequiredAttributesByConditionAdvisor.ATTRIBUTE_NOT_SET_DESCRIPTION"), (Object)attribute.getDisplayName(), (Object[])new Object[]{WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone)});
    }
}

