/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.api.common.providers.Literal;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.Identifier;
import java.net.MalformedURLException;
import java.net.URL;

public class ValueSetLiteral
implements ILiteral {
    private IProjectAreaHandle fProjectArea;
    private String fIdentifier = null;
    private String fName = null;
    private URL fIconUrl = null;

    public ValueSetLiteral(IProjectAreaHandle projectArea) {
        this.fProjectArea = projectArea;
    }

    public ValueSetLiteral(IProjectAreaHandle projectArea, String identifier, String name, URL iconUrl) {
        this.fProjectArea = projectArea;
        this.fIdentifier = identifier;
        this.fName = name;
        this.fIconUrl = iconUrl;
    }

    public ValueSetLiteral(IProjectAreaHandle projectArea, Literal literal) {
        this.fProjectArea = projectArea;
        this.fIdentifier = literal.identifier;
        this.fName = literal.name;
        if (literal.iconUrl != null) {
            try {
                this.fIconUrl = new URL(literal.iconUrl);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setIdentifier(String identifier) {
        this.fIdentifier = identifier;
    }

    public void setIconUrl(String iconUrl) throws MalformedURLException {
        this.fIconUrl = new URL(iconUrl);
    }

    public void setIconUrl(URL iconUrl) {
        this.fIconUrl = iconUrl;
    }

    @Override
    public int compareTo(ILiteral o) {
        return this.fIdentifier.compareTo(o.getIdentifier2().getStringIdentifier());
    }

    @Override
    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    @Override
    public Identifier<? extends ILiteral> getIdentifier2() {
        return Identifier.create(ILiteral.class, this.fIdentifier);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public URL getIconURL() {
        return this.fIconUrl;
    }
}

