/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.internal.expression.AbstractQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.Messages;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class AttachmentQueryAttributeFactory
implements IQueryableAttributeFactory {
    private static final String CONTENT_LENGTH_IDENTIFIER_PROPERTY = RepositoryPackage.eINSTANCE.getContent_ContentLength().getName();
    private static final String CONTENT_TYPE_IDENTIFIER_PROPERTY = RepositoryPackage.eINSTANCE.getContent_ContentType().getName();
    private static QueryableAttributeDescriptor[] ATTACHMENT_DESCRIPTOR_ATTRIBUTES = new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(IAttachment.ID_PROPERTY, Messages.getString("AttachmentQueryAttributeFactory.ATTACHMENT_ID"), "integer"), new QueryableAttributeDescriptor(IAttachment.NAME_PROPERTY, Messages.getString("AttachmentQueryAttributeFactory.ATTACHMENT_NAME"), "smallString"), new QueryableAttributeDescriptor(IAttachment.CONTENT_PROPERTY, Messages.getString("AttachmentQueryAttributeFactory.ATTACHMENT_CONTENT"), "content"), new QueryableAttributeDescriptor(IAttachment.CREATION_DATE_PROPERTY, Messages.getString("AttachmentQueryAttributeFactory.ATTACHMENT_CREATION_DATE"), "timestamp"), new QueryableAttributeDescriptor(IAttachment.CREATOR_PROPERTY, Messages.getString("AttachmentQueryAttributeFactory.ATTACHMENT_CREATED_BY"), "contributor")};
    private static QueryableAttributeDescriptor[] CONTENT_ATTRIBUTES = new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(CONTENT_LENGTH_IDENTIFIER_PROPERTY, Messages.getString("AttachmentQueryAttributeFactory.CONTENT_LENGTH"), "fileSize"), new QueryableAttributeDescriptor(CONTENT_TYPE_IDENTIFIER_PROPERTY, Messages.getString("AttachmentQueryAttributeFactory.CONTENT_TYPE"), "smallString")};
    private static Map<String, QueryableAttributeDescriptor[]> fgDescriptorMap = new HashMap<String, QueryableAttributeDescriptor[]>();

    static {
        fgDescriptorMap.put("content", CONTENT_ATTRIBUTES);
    }

    @Override
    public IQueryableAttribute findAttribute(IProjectAreaHandle projectArea, String attributeIdentifier, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryableAttribute queryAttribute = null;
        String[] path = QueryableAttributePath.createPath(attributeIdentifier);
        String rootAttribute = path[0];
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = ATTACHMENT_DESCRIPTOR_ATTRIBUTES;
        int n = ATTACHMENT_DESCRIPTOR_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            if (descriptor.getIdentifier().equals(rootAttribute)) {
                queryAttribute = this.createQueryAttribute(descriptor, auditableCommon, monitor);
                this.createChildAttributes(projectArea, queryAttribute, auditableCommon, monitor);
                if (path.length > 1) {
                    return QueryableAttributePath.getAttribute(queryAttribute, QueryableAttributePath.removeFirstSegment(path));
                }
                return queryAttribute;
            }
            ++n2;
        }
        return null;
    }

    public List findAllAttributes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<QueryableAttribute> attributes = new ArrayList<QueryableAttribute>();
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = ATTACHMENT_DESCRIPTOR_ATTRIBUTES;
        int n = ATTACHMENT_DESCRIPTOR_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            QueryableAttribute queryAttribute = this.createQueryAttribute(descriptor, auditableCommon, monitor);
            this.createChildAttributes(projectArea, queryAttribute, auditableCommon, monitor);
            attributes.add(queryAttribute);
            ++n2;
        }
        return attributes;
    }

    private void createChildAttributes(IProjectAreaHandle projectArea, AbstractQueryableAttribute parent, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (parent == null || parent.getAttributeType() == null) {
            return;
        }
        ArrayList<IQueryableAttribute> children = new ArrayList<IQueryableAttribute>();
        QueryableAttributeDescriptor[] descriptors = fgDescriptorMap.get(parent.getAttributeType());
        if (descriptors != null) {
            QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
                QueryableAttribute childAttribute = this.createQueryAttribute(descriptor, auditableCommon, monitor);
                this.createChildAttributes(projectArea, childAttribute, auditableCommon, monitor);
                children.add(childAttribute);
                ++n2;
            }
        }
        parent.setChildAttributes(children);
    }

    private QueryableAttribute createQueryAttribute(QueryableAttributeDescriptor descriptor, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryableAttribute attribute = new QueryableAttribute(descriptor);
        if (attribute.hasNullValue()) {
            AttributeType type = AttributeTypes.getAttributeType(attribute.getAttributeType());
            attribute.setNullValue(type.getNullValue(auditableCommon, monitor));
        }
        return attribute;
    }

    public ItemProfile<IAttachment> computeProfile(List<IQueryableAttribute> attributes) {
        ArrayList<String> attributeIds = new ArrayList<String>(attributes.size());
        for (IQueryableAttribute attribute : attributes) {
            attributeIds.add(attribute.getIdentifier());
        }
        return IAttachment.SMALL_PROFILE.createExtension(attributeIds);
    }

    @Override
    public List<String> getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet set) {
        return Arrays.asList(IAttachment.ID_PROPERTY, IAttachment.NAME_PROPERTY);
    }
}

