/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.utl;

import com.ibm.team.workitem.common.internal.oslc.utl.XMLParseException;
import com.ibm.team.workitem.common.internal.oslc.utl.XMLPath;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class XMLParserUtil {
    private final Map<String, Method> fHandlerMap = new HashMap<String, Method>();
    private final SAXHandler fSAXHandler = new SAXHandler();
    private final Object fHandler;

    public XMLParserUtil(Object handler) {
        Method[] methods;
        Method[] methodArray = methods = handler.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            XMLPath annotation = method.getAnnotation(XMLPath.class);
            if (annotation != null) {
                this.fHandlerMap.put(annotation.value(), method);
            }
            ++n2;
        }
        this.fHandler = handler;
    }

    public void parse(URL url) throws XMLParseException {
        try {
            XMLReader xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xmlReader.setContentHandler(this.fSAXHandler);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.fSAXHandler);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xmlReader.parse(url.toString());
        }
        catch (SAXException x) {
            Throwable throwable = x.getException();
            if (throwable instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)throwable).getTargetException();
            }
            throw new XMLParseException(throwable != null ? throwable : x);
        }
        catch (ParserConfigurationException x) {
            throw new XMLParseException(x);
        }
        catch (FactoryConfigurationError x) {
            throw new XMLParseException(x);
        }
        catch (IOException x) {
            throw new XMLParseException(x);
        }
    }

    private class SAXHandler
    extends DefaultHandler2 {
        private IPath fCurrentPath = new Path("/");
        private Stack<Object> fContextStack = new Stack();
        private StringBuilder fStringBuilder = new StringBuilder();
        private Attributes fCurrentAttributes;

        private SAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.handlePendingCharacters();
            IPath path = this.fCurrentPath.append(localName);
            Method method = (Method)XMLParserUtil.this.fHandlerMap.get(path.toString());
            Object context = null;
            if (method != null) {
                try {
                    if (method.getParameterTypes().length == 2) {
                        Object parentContext = this.fContextStack.peek();
                        context = method.invoke(XMLParserUtil.this.fHandler, attributes, parentContext);
                    } else {
                        context = method.invoke(XMLParserUtil.this.fHandler, attributes);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new SAXException(e);
                }
                catch (InvocationTargetException e) {
                    throw new SAXException(e);
                }
            }
            if (context == null && !this.fContextStack.isEmpty()) {
                context = this.fContextStack.peek();
            }
            this.fCurrentPath = path;
            this.fCurrentAttributes = attributes;
            this.fContextStack.push(context);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.handlePendingCharacters();
            this.fContextStack.pop();
            this.fCurrentPath = this.fCurrentPath.removeLastSegments(1);
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            this.fStringBuilder.append(chars, start, length);
        }

        private void handlePendingCharacters() throws SAXException {
            if (this.fStringBuilder.length() > 0) {
                Method method = (Method)XMLParserUtil.this.fHandlerMap.get(String.valueOf(this.fCurrentPath.toString()) + "#content");
                if (method != null) {
                    try {
                        if (method.getParameterTypes().length == 3) {
                            Object parentContext = this.fContextStack.peek();
                            method.invoke(XMLParserUtil.this.fHandler, this.fCurrentAttributes, this.fStringBuilder.toString(), parentContext);
                        } else {
                            method.invoke(XMLParserUtil.this.fHandler, this.fCurrentAttributes, this.fStringBuilder.toString());
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new SAXException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new SAXException(e);
                    }
                }
                this.fStringBuilder = new StringBuilder();
            }
        }
    }
}

