/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.common.IQueryCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.IInternalQueryCommon;
import com.ibm.team.workitem.common.internal.IQueryRepositoryService;
import com.ibm.team.workitem.common.internal.ServiceRunnable;
import com.ibm.team.workitem.common.internal.expression.ASTExpression;
import com.ibm.team.workitem.common.internal.query.Messages;
import com.ibm.team.workitem.common.internal.query.QueryDescriptor;
import com.ibm.team.workitem.common.internal.query.QueryResultIterator;
import com.ibm.team.workitem.common.internal.query.ResolvingQueryResultIterator;
import com.ibm.team.workitem.common.internal.query.presentations.QueryEditorPresentation;
import com.ibm.team.workitem.common.internal.query.presentations.QueryEditorPresentationManager;
import com.ibm.team.workitem.common.internal.query.rcp.dto.ResultPage;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.search.QueryRequest;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.internal.util.PermissionContext;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IGroupCount;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IQueryType;
import com.ibm.team.workitem.common.query.IResolvedResult;
import com.ibm.team.workitem.common.query.IResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public abstract class QueryCommon
implements IQueryCommon,
IInternalQueryCommon {
    public static final long SCORE_FACTOR = 100000L;
    private ICommonServiceContext fServiceContext;
    private QueryEditorPresentationManager fQueryEditorPresentationManager;

    public static String serializeQueryRequest(QueryRequest queryRequest) throws IOException {
        XMIResourceImpl resource = new XMIResourceImpl();
        resource.setEncoding("UTF-8");
        queryRequest.addToResource((Resource)resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        resource.save((OutputStream)out, null);
        return out.toString("UTF-8");
    }

    public QueryCommon(ICommonServiceContext serviceContext) {
        this.fServiceContext = serviceContext;
    }

    @Override
    public QueryEditorPresentation findConfiguration(final IProjectAreaHandle projectArea, final IQueryType type, final IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fQueryEditorPresentationManager == null) {
            this.fQueryEditorPresentationManager = new QueryEditorPresentationManager(this.getAuditableCommon());
        }
        return this.fServiceContext.callCancelableService(new ServiceRunnable<QueryEditorPresentation>(){

            @Override
            public QueryEditorPresentation run() throws TeamRepositoryException {
                return QueryCommon.this.fQueryEditorPresentationManager.getConfiguration(projectArea, type, monitor);
            }
        }, monitor);
    }

    @Override
    public IQueryResult<IResult> getQueryResults(IQueryDescriptor query) {
        return new QueryResultIterator(this, query);
    }

    @Override
    public IQueryResult<IResult> getExpressionResults(IProjectAreaHandle projectArea, Expression expression) {
        IQueryDescriptor descriptor = this.createQuery(projectArea, "com.ibm.team.workitem.workItemType", "", expression);
        return this.getQueryResults(descriptor);
    }

    @Override
    public <T extends IAuditable> IQueryResult<IResolvedResult<T>> getResolvedQueryResults(IQueryDescriptor query, ItemProfile<T> profile) {
        IQueryResult<IResult> queryResult = this.getQueryResults(query);
        return new ResolvingQueryResultIterator<T>(this, queryResult, profile);
    }

    @Override
    public <T extends IAuditable> IQueryResult<IResolvedResult<T>> getResolvedExpressionResults(IProjectAreaHandle projectArea, Expression expression, ItemProfile<T> profile) {
        IQueryDescriptor descriptor = this.createQuery(projectArea, "com.ibm.team.workitem.workItemType", "", expression);
        return this.getResolvedQueryResults(descriptor, profile);
    }

    @Override
    public int countQueryResults(final IQueryDescriptor query, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<Integer>(){

            @Override
            public Integer run() throws TeamRepositoryException {
                Expression expression = query.getResolvedExpression();
                ASTExpression astExpression = QueryUtils.getASTExpression(expression);
                if (astExpression != null) {
                    ASTExpression countExpression = astExpression.createCountStatement();
                    QueryIterator result = QueryCommon.this.getAuditableCommon().getDataQueryIterator((IDataQuery)countExpression.getQuery(), countExpression.getParameters().toArray(), null, QueryIterator.ReadMode.UNCOMMITTED);
                    try {
                        Integer n = (Integer)result.next(null);
                        return n;
                    }
                    finally {
                        result.close();
                    }
                }
                return QueryCommon.this.getQueryRepositoryService().count(query);
            }
        }, monitor);
    }

    @Override
    public int countExpressionResults(IProjectAreaHandle projectArea, Expression expression, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryDescriptor descriptor = this.createQuery(projectArea, "com.ibm.team.workitem.workItemType", "", expression);
        return this.countQueryResults(descriptor, monitor);
    }

    ResultPage fetchQueryResults(final IQueryDescriptor query, final int startIndex, final int pageSize, final int limit, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<ResultPage>(){

            @Override
            public ResultPage run() throws TeamRepositoryException {
                return QueryCommon.this.getQueryRepositoryService().fetchQueryResults(query, startIndex, pageSize, limit);
            }
        }, monitor);
    }

    ResultPage fetchMore(final UUID token, final int startIndex, final int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<ResultPage>(){

            @Override
            public ResultPage run() throws TeamRepositoryException {
                return QueryCommon.this.getQueryRepositoryService().fetchMore(token, startIndex, pageSize);
            }
        }, monitor);
    }

    ResultPage fetchQueryResults(final ASTExpression astExpression, final int startIndex, final int pageSize, final int limit, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<ResultPage>(){

            @Override
            public ResultPage run() throws TeamRepositoryException {
                return QueryCommon.this.getQueryRepositoryService().fetchASTResults((IItemQuery)astExpression.getQuery(), astExpression.getParameters().toArray(), startIndex, pageSize, limit, astExpression.getContextIds());
            }
        }, monitor);
    }

    @Override
    public List<IQueryDescriptor> findSharedQueries(final IProjectAreaHandle projectAreaHandle, final List<? extends IAuditableHandle> sharingTargetList, final String type, final ItemProfile<IQueryDescriptor> profile, final IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<List<IQueryDescriptor>>(){

            @Override
            public List<IQueryDescriptor> run() throws TeamRepositoryException {
                IAuditableHandle[] sharingTargets = sharingTargetList.toArray(new IAuditableHandle[sharingTargetList.size()]);
                IItemQueryPage page = QueryCommon.this.getQueryRepositoryService().findSharedQueries(projectAreaHandle, sharingTargets, type);
                return QueryCommon.this.resolveResults(page, profile, monitor);
            }
        }, monitor);
    }

    @Override
    public List<IQueryDescriptor> findQuickPlannerSharedQueries(final IProjectAreaHandle projectAreaHandle, final List<? extends IAuditableHandle> sharingTargetList, final String type, final ItemProfile<IQueryDescriptor> profile, final IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<List<IQueryDescriptor>>(){

            @Override
            public List<IQueryDescriptor> run() throws TeamRepositoryException {
                IAuditableHandle[] sharingTargets = sharingTargetList.toArray(new IAuditableHandle[sharingTargetList.size()]);
                IItemQueryPage page = QueryCommon.this.getQueryRepositoryService().findQuickPlannerSharedQueries(projectAreaHandle, sharingTargets, type);
                return QueryCommon.this.resolveResults(page, profile, monitor);
            }
        }, monitor);
    }

    public List<ITeamAreaHandle> findTeamAreasWithSharedQueries(final IProjectAreaHandle projectAreaHandle, final List<? extends IAuditableHandle> sharingTargetList, final String type, ItemProfile<ITeamArea> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<List<ITeamAreaHandle>>(){

            @Override
            public List<ITeamAreaHandle> run() throws TeamRepositoryException {
                IAuditableHandle[] sharingTargets = sharingTargetList.toArray(new IAuditableHandle[sharingTargetList.size()]);
                return Arrays.asList(QueryCommon.this.getQueryRepositoryService().findTeamAreasWithSharedQueries(projectAreaHandle, sharingTargets, type));
            }
        }, monitor);
    }

    @Override
    public List<IQueryDescriptor> findPersonalQueries(final IProjectAreaHandle projectAreaHandle, final IContributorHandle creator, final String type, final ItemProfile<IQueryDescriptor> profile, final IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<List<IQueryDescriptor>>(){

            @Override
            public List<IQueryDescriptor> run() throws TeamRepositoryException {
                IItemQueryPage page = QueryCommon.this.getQueryRepositoryService().findPersonalQueries(projectAreaHandle, creator, type);
                return QueryCommon.this.resolveResults(page, profile, monitor);
            }
        }, monitor);
    }

    @Override
    public List<IQueryDescriptor> findQuickPlannerPersonalQueries(final IProjectAreaHandle projectAreaHandle, final IContributorHandle creator, final String type, final ItemProfile<IQueryDescriptor> profile, final IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<List<IQueryDescriptor>>(){

            @Override
            public List<IQueryDescriptor> run() throws TeamRepositoryException {
                IItemQueryPage page = QueryCommon.this.getQueryRepositoryService().findQuickPlannerPersonalQueries(projectAreaHandle, creator, type);
                return QueryCommon.this.resolveResults(page, profile, monitor);
            }
        }, monitor);
    }

    @Override
    public IQueryDescriptor save(final IQueryDescriptor descriptorWorkingCopy, final IProgressMonitor monitor) throws TeamRepositoryException {
        descriptorWorkingCopy.setExpression(descriptorWorkingCopy.getExpression());
        final IQueryDescriptor[] result = new IQueryDescriptor[1];
        final ProcessRunnable runnable = new ProcessRunnable(){

            public IOperationReport run(IProgressMonitor operationMonitor) throws TeamRepositoryException {
                IItemsResponse response = QueryCommon.this.getQueryRepositoryService().save(descriptorWorkingCopy);
                result[0] = (IQueryDescriptor)response.getFirstClientItem();
                return response.getOperationReport();
            }
        };
        return this.fServiceContext.callCancelableService(new ServiceRunnable<IQueryDescriptor>(){

            @Override
            public IQueryDescriptor run() throws TeamRepositoryException {
                QueryCommon.this.executeProcessRunnable(runnable, Messages.getString("QueryCommon.SAVE_QUERY_PROCESS_RUNNABLE_NAME"), monitor);
                return result[0];
            }
        }, monitor);
    }

    @Override
    public IOperationReport delete(final IQueryDescriptorHandle queryDescriptorHandle, final IProgressMonitor monitor) throws TeamRepositoryException {
        final ProcessRunnable runnable = new ProcessRunnable(){

            public IOperationReport run(IProgressMonitor operationMonitor) throws TeamRepositoryException {
                return QueryCommon.this.getQueryRepositoryService().delete(queryDescriptorHandle);
            }
        };
        return this.fServiceContext.callCancelableService(new ServiceRunnable<IOperationReport>(){

            @Override
            public IOperationReport run() throws TeamRepositoryException {
                return QueryCommon.this.executeProcessRunnable(runnable, Messages.getString("QueryCommon.DELETE_QUERY_PROCESS_RUNNABLE_NAME"), monitor);
            }
        }, monitor);
    }

    @Override
    public List<IGroupCount> getGroupCounts(IProjectAreaHandle projectArea, Expression expression, String attributeIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryDescriptor queryDescriptor = this.createQuery(projectArea, "com.ibm.team.workitem.workItemType", "", expression);
        return this.getQueryGroupCounts(queryDescriptor, attributeIdentifier, monitor);
    }

    @Override
    public List<IGroupCount> getQueryGroupCounts(final IQueryDescriptor queryDescriptor, final String attributeIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fServiceContext.callCancelableService(new ServiceRunnable<List<IGroupCount>>(){

            @Override
            public List<IGroupCount> run() throws TeamRepositoryException {
                IGroupCount[] counts = QueryCommon.this.getQueryRepositoryService().fetchGroupCounts(queryDescriptor, attributeIdentifier);
                return Arrays.asList(counts);
            }
        }, monitor);
    }

    @Override
    public IQueryDescriptor createQuery(IProjectAreaHandle projectArea, String queryType, String name, Expression expression) {
        QueryDescriptor query = (QueryDescriptor)this.getAuditableCommon().createAuditable(IQueryDescriptor.ITEM_TYPE);
        query.setProjectArea(projectArea);
        query.setQueryType(queryType);
        query.setName(name);
        query.setExpression(expression);
        query.setCreator(this.getAuditableCommon().getUser());
        query.setDescription("");
        query.setModified(new Timestamp(System.currentTimeMillis()));
        query.setModifiedBy(this.getAuditableCommon().getUser());
        query.setTags("");
        query.setId("");
        PermissionContext.setDefault((IItem)query);
        return query;
    }

    protected ICommonServiceContext getServiceContext() {
        return this.fServiceContext;
    }

    protected abstract IOperationReport executeProcessRunnable(ProcessRunnable var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected abstract <T> T getService(Class<T> var1);

    protected <T extends IAuditable> List<T> resolveAuditables(List<? extends IAuditableHandle> handles, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return CollectionUtils.removeNulls(this.getAuditableCommon().resolveAuditables(handles, profile, monitor));
    }

    protected void notifyExecutionDone(Object query, int total) {
    }

    protected <T extends IAuditable> IQueryResult<IResolvedResult<T>> getResolvedTokenResults(UUID token, ItemProfile<T> profile) {
        QueryResultIterator queryResult = new QueryResultIterator(this, token);
        return new ResolvingQueryResultIterator<T>(this, queryResult, profile);
    }

    private <T extends IAuditable> List<T> resolveResults(IItemQueryPage page, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        LinkedList handles = new LinkedList();
        while (true) {
            handles.addAll(page.getItemHandles());
            if (!page.hasNext()) break;
            page = (IItemQueryPage)this.getQueryService().fetchPage(page.getToken(), page.getNextStartPosition(), Integer.MAX_VALUE);
        }
        return this.resolveAuditables(handles, profile, monitor);
    }

    private IQueryService getQueryService() {
        return this.getService(IQueryService.class);
    }

    protected IQueryRepositoryService getQueryRepositoryService() {
        return this.getService(IQueryRepositoryService.class);
    }
}

