/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.impl;

import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.ParameterVariableContext;
import com.ibm.team.workitem.common.internal.expression.ExpressionSerializerFactory;
import com.ibm.team.workitem.common.internal.expression.IExpressionSerializer;
import com.ibm.team.workitem.common.internal.query.impl.Associations;
import com.ibm.team.workitem.common.internal.query.impl.DefaultSerializationContext;
import com.ibm.team.workitem.common.internal.query.impl.ParameterVariableResolver;
import com.ibm.team.workitem.common.internal.query.impl.QueryDescriptorImpl;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.query.IAssociations;
import com.ibm.team.workitem.common.query.UnboundQueryParameterException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class QueryDescriptorCustomImpl
extends QueryDescriptorImpl {
    private Expression fExpression;
    private Associations fAssociations;
    private ParameterVariableContext fParameterVariableContext;

    @Override
    public void reset() {
        this.fExpression = null;
    }

    @Override
    public Expression getExpression() throws SerializationException {
        if (this.getInternalExpression() == null) {
            return null;
        }
        if (this.fExpression == null) {
            IExpressionSerializer serializer = ExpressionSerializerFactory.getSerializer(this.getSerializationVersion());
            this.fExpression = serializer.deserialize(this.getInternalExpression(), new DefaultSerializationContext(this));
        }
        return this.fExpression;
    }

    @Override
    public void setExpression(Expression newExpression) throws SerializationException {
        this.fExpression = newExpression;
        if (this.fExpression != null) {
            IExpressionSerializer serializer = ExpressionSerializerFactory.getSerializer("XML");
            String serialized = serializer.serialize(this.fExpression);
            Assert.isNotNull((Object)serialized);
            if (!serialized.equals(this.getInternalExpression())) {
                this.setInternalExpression(serialized);
            }
            if (!"XML".equals(this.getSerializationVersion())) {
                this.setSerializationVersion("XML");
            }
        } else {
            this.setInternalExpression(null);
        }
        this.setInternalHasParameters(!this.getParameterVariables().isEmpty());
    }

    @Override
    public IAssociations getAssociations() {
        if (this.fAssociations == null) {
            this.fAssociations = new Associations(this.getInternalAssociations());
        }
        return this.fAssociations;
    }

    @Override
    public boolean isShared() {
        return !this.getInternalAssociations().isEmpty();
    }

    @Override
    public void setParameterValues(ParameterVariableContext context) {
        this.fParameterVariableContext = context;
    }

    @Override
    public ParameterVariableContext getParameterValues() {
        return this.fParameterVariableContext;
    }

    @Override
    public boolean hasParameterVariables() {
        return this.isInternalHasParameters();
    }

    @Override
    public Map<String, VariableAttributeExpression> getParameterVariables() {
        HashMap<String, VariableAttributeExpression> result = new HashMap<String, VariableAttributeExpression>();
        Expression expression = this.getExpression();
        List<Object> variables = expression != null ? QueryUtils.getParameterVariables(expression) : Collections.emptyList();
        for (VariableAttributeExpression variableAttributeExpression : variables) {
            IAttributeVariable<?> curVar = variableAttributeExpression.getVariable();
            result.put(curVar.getName(), variableAttributeExpression);
        }
        return result;
    }

    @Override
    public Expression getResolvedExpression() throws UnboundQueryParameterException {
        Expression result = this.getExpression().copy();
        ParameterVariableResolver resolver = new ParameterVariableResolver(this.fParameterVariableContext);
        result.accept(resolver);
        Collection<IAttributeVariable<?>> unresolvedVariables = resolver.getUnresolvedVariables();
        if (unresolvedVariables.isEmpty()) {
            return result;
        }
        throw new UnboundQueryParameterException(unresolvedVariables);
    }
}

