/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ShareableMetadataUtil {
    public static MetadataAbstraction getMetadataFor(IShareable s, IProgressMonitor prog) throws FileSystemException {
        FileItemInfo info = ((Shareable)s).getFileItemInfo(prog);
        if (info == null) {
            return null;
        }
        return new MetadataAbstraction(info.getContentType(), info.getLineDelimiter());
    }

    public static final class MetadataAbstraction {
        private final String mimeType;
        private final FileLineDelimiter lineDelimiter;

        public String getMimeType() {
            return this.mimeType;
        }

        public FileLineDelimiter getLineDelimiter() {
            return this.lineDelimiter;
        }

        public MetadataAbstraction(String m, FileLineDelimiter d) {
            this.mimeType = m;
            this.lineDelimiter = d;
        }
    }
}

