/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.content;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.VersionedContentDeleted;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class DeletedContent {
    private DeletedContent() {
    }

    public static InputStream getDeletedContentInputStream(String encoding) {
        ByteArrayInputStream in = new ByteArrayInputStream(DeletedContent.getDeletedContentSubstitution(encoding));
        return in;
    }

    public static boolean isRootCauseDeletedContent(Throwable e) {
        int digParanoiaCount = 0;
        Throwable cause = e;
        while (cause instanceof TeamRepositoryException && digParanoiaCount < 50) {
            if (cause instanceof VersionedContentDeleted) {
                return true;
            }
            cause = cause.getCause();
            ++digParanoiaCount;
        }
        return false;
    }

    public static byte[] getDeletedContentSubstitution(String encoding) {
        if (encoding == null || encoding.equals("") || !Charset.isSupported(encoding)) {
            return Messages.PERMENTLY_DELETED_CONTENT.getBytes();
        }
        try {
            return Messages.PERMENTLY_DELETED_CONTENT.getBytes(encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return Messages.PERMENTLY_DELETED_CONTENT.getBytes();
        }
    }
}

