/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreProvider;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.utils.LRUCache;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class LoadFilterIgnoreProvider
extends IgnoreProvider
implements IIgnoreProvider,
IIgnoreProvider.IIgnoreTester,
ICopyFileAreaListener {
    private boolean shouldInvalidateCache = true;
    private final LRUCache<ILocation, LoadFilterIgnoreRule> filters = new LRUCache(100);
    private LoadFilterIgnoreRule lastFilter;

    public LoadFilterIgnoreProvider() {
        SharingManager sm = SharingManager.getInstance();
        sm.addListener(this);
    }

    @Override
    public IIgnoreProvider.IIgnoreTester getTester(IShareable shareable) {
        return this;
    }

    @Override
    public void flushInAbsenceOfEvents(Collection<IShareable> roots, IProgressMonitor progress) throws FileSystemException {
    }

    @Override
    protected void syncChangeTrackerForEvent(IShareable ignoreRoot, IIgnoreEvent event, SubMonitor monitor) throws FileSystemException {
    }

    @Override
    protected IgnoreProvider createCopyInternal(Collection<IIgnoreManager.ICopyParameter> params, IIgnoreManager ignoreManager, IProgressMonitor progress) {
        return new LoadFilterIgnoreProvider();
    }

    @Override
    public boolean shouldInvalidateCache(IShareable shareable) {
        LRUCache<ILocation, LoadFilterIgnoreRule> lRUCache = this.filters;
        synchronized (lRUCache) {
            boolean bl;
            try {
                bl = this.shouldInvalidateCache;
                this.shouldInvalidateCache = false;
            }
            catch (Throwable throwable) {
                this.shouldInvalidateCache = false;
                throw throwable;
            }
            return bl;
        }
    }

    @Override
    public boolean shouldBeIgnored(IShareable toCheck, IRelativeLocation path, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        LoadFilterIgnoreRule filter = this.getFilterFor(toCheck, (IProgressMonitor)progress.newChild(1));
        if (filter == null) {
            return false;
        }
        return filter.shouldBeIgnored(toCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadFilterIgnoreRule getFilterFor(IShareable toCheck, IProgressMonitor monitor) {
        block17: {
            try {
                LoadFilterIgnoreRule filter;
                LoadFilterIgnoreProvider loadFilterIgnoreProvider = this;
                synchronized (loadFilterIgnoreProvider) {
                    if (this.lastFilter != null && this.lastFilter.isEffectiveBelow(toCheck)) {
                        return this.lastFilter;
                    }
                    this.lastFilter = null;
                }
                IShare share = toCheck.getShare(monitor);
                if (share == null) break block17;
                ILocation shareLocation = share.getShareable().getFullPath();
                Object object = this.filters;
                synchronized (object) {
                    filter = this.filters.get(shareLocation);
                }
                if (filter == null) {
                    LoadFilter lf = LoadFilter.getFilter(share.getSharingDescriptor());
                    filter = new LoadFilterIgnoreRule(share.getShareable(), lf);
                    LRUCache<ILocation, LoadFilterIgnoreRule> lRUCache = this.filters;
                    synchronized (lRUCache) {
                        this.filters.put(shareLocation, filter);
                    }
                }
                object = this;
                synchronized (object) {
                    this.lastFilter = filter;
                }
                return filter;
            }
            catch (FileSystemException e) {
                LoggingHelper.log("com.ibm.team.filesystem.client", e);
            }
            catch (IOException e) {
                TeamRepositoryException tre = new TeamRepositoryException((Throwable)e);
                tre.fillInStackTrace();
                LoggingHelper.log("com.ibm.team.filesystem.client", tre);
            }
        }
        return new LoadFilterIgnoreRule(toCheck, null);
    }

    @Override
    public void done() {
    }

    @Override
    public List findIgnoreReasons(IShareable shareable, IRelativeLocation path, IProgressMonitor monitor) {
        if (this.shouldBeIgnored(shareable, path, monitor)) {
            LoadFilterIgnoreRule filter = this.getFilterFor(shareable, monitor);
            return Collections.singletonList(filter);
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void change(ICopyFileAreaEvent[] events) {
        LRUCache<ILocation, LoadFilterIgnoreRule> lRUCache = this.filters;
        synchronized (lRUCache) {
            this.shouldInvalidateCache = true;
            this.filters.flush();
            this.lastFilter = null;
        }
    }

    private class LoadFilterIgnoreRule
    implements IIgnoreProvider.IIgnoreRule {
        private final ILoadFilter filter;
        private final IShareable root;

        public LoadFilterIgnoreRule(IShareable share, ILoadFilter filter) {
            this.root = share;
            this.filter = filter;
        }

        @Override
        public boolean shouldBeIgnored(IShareable shareable) {
            if (this.filter == null) {
                return false;
            }
            IRelativeLocation relativeLocation = shareable.getFullPath().getLocationRelativeTo(this.root.getFullPath());
            int i = 0;
            while (i < relativeLocation.segmentCount()) {
                if (!this.filter.include(relativeLocation.segment(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean isEffectiveBelow(IShareable shareable) {
            return this.root.getFullPath().isPrefixOf(shareable.getFullPath());
        }

        @Override
        public List<IShareable> getEffectiveFrom(IProgressMonitor monitor) {
            return Collections.singletonList(this.root);
        }

        @Override
        public IIgnoreProvider getProvider() {
            return LoadFilterIgnoreProvider.this;
        }

        @Override
        public String getShortDescription() {
            return NLS.bind((String)Messages.LoadFilterIgnoreProvider_0, (Object)this.root.getFullPath().toOSString());
        }
    }
}

