/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.EmptyNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.BaselineContext;
import com.ibm.team.filesystem.client.internal.namespace.impl.ContextNameUtil;
import com.ibm.team.filesystem.client.internal.snapshot.ContextSnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BaselineSnapshot
extends ContextSnapshot {
    private IBaselineConnection connection;

    private BaselineSnapshot(IBaselineConnection connection) {
        this.connection = connection;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.connection.teamRepository();
    }

    @Override
    public String getName() {
        return ContextNameUtil.getContextName(this.connection);
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.connection.getContextHandle();
    }

    @Override
    public ItemNamespace getNamespaceFor(ItemId<IComponent> component, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component.equals((Object)ItemUtil.getComponent((IComponentHandle)this.connection.getComponent()))) {
            return BaselineNamespace.create(this.connection.teamRepository(), this.connection.getBaseline());
        }
        return EmptyNamespace.create(this.connection.teamRepository(), component);
    }

    @Override
    public Map<ItemId<IComponent>, IItemContext> getContexts(IProgressMonitor monitor) throws TeamRepositoryException {
        return Collections.singletonMap(ConnectionUtil.getComponent(this.connection), new BaselineContext(this.connection));
    }

    @Override
    public Set<ItemNamespace> getNamespaces(IProgressMonitor monitor) throws TeamRepositoryException {
        return Collections.singleton(BaselineNamespace.create(this.connection));
    }

    public static ISnapshot create(ItemLocator<IBaseline> id, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)id.getRepository());
        return new BaselineSnapshot(mgr.getBaselineConnection((IBaselineHandle)id.toHandle(), (IProgressMonitor)progress.newChild(100)));
    }
}

