/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.dbprofiler;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.dbprofiler.DbProfile;
import com.urbancode.commons.util.dbprofiler.DbProfileCounter;
import com.urbancode.commons.util.dbprofiler.ProfilingConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

@BridgeMethodsAdded
public class ProfilingDataSource
implements DataSource {
    private static final Logger log = Logger.getLogger(ProfilingDataSource.class);
    private DataSource delegate;

    public static void startProfiling() {
        DbProfileCounter.startProfiling();
    }

    public static DbProfile stopProfiling() {
        return DbProfileCounter.stopProfiling();
    }

    public void setDelegate(DataSource delegate) {
        this.delegate = delegate;
    }

    public Connection getConnection() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("getConnection()");
        }
        return new ProfilingConnection(this.delegate.getConnection());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("getConnection(String,String)");
        }
        return new ProfilingConnection(this.delegate.getConnection(username, password));
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }
}

