/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.util.JazzLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class JavaCoreUtil {
    private static final String NLS_maxNumberReached = "JavaCoreUtil.maxNumberReached";
    private static final String NLS_tooLittleTimeBetweenCores = "JavaCoreUtil.tooLittleTimeBetweenCores";
    private static final String NLS_generatingJavaCore = "JavaCoreUtil.generatingJavaCore";
    private static final String NLS_failedToProduceJavaCore = "JavaCoreUtil.failedToProduceJavaCore";
    private static final String NLS_javaCoreInProcess = "JavaCoreUtil.javaCoreInProcess";
    private static final Lock lock = new ReentrantLock();
    private static final JazzLog log = JazzLog.getLog(JavaCoreUtil.class);
    private static final Map<String, JavaCoreTracker> trackers = new HashMap<String, JavaCoreTracker>();

    public static void generateJavaCore(String trackerName, int maxNumberOfCores, long minTimeBetweenCores) {
        if (!lock.tryLock()) {
            log.infoMsg(NLS_javaCoreInProcess, new Object[0]);
            return;
        }
        try {
            if (!trackers.containsKey(trackerName)) {
                trackers.put(trackerName, new JavaCoreTracker());
            }
            JavaCoreTracker t = trackers.get(trackerName);
            if (t.coreCount >= maxNumberOfCores) {
                JavaCoreUtil.logMsg(NLS_maxNumberReached, trackerName, t.coreCount + 1, maxNumberOfCores);
                return;
            }
            long timeSinceLastCore = System.currentTimeMillis() - t.lastCoreTime;
            if (timeSinceLastCore < minTimeBetweenCores) {
                JavaCoreUtil.logMsg(NLS_tooLittleTimeBetweenCores, trackerName, timeSinceLastCore, minTimeBetweenCores);
                return;
            }
            try {
                JavaCoreUtil.logMsg(NLS_generatingJavaCore, trackerName);
                Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
                Method dumpMethod = dumpClass.getMethod("JavaDump", new Class[0]);
                dumpMethod.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                log.warnMsg(NLS_failedToProduceJavaCore, e, new Object[0]);
            }
            ++t.coreCount;
            t.lastCoreTime = System.currentTimeMillis();
        }
        finally {
            lock.unlock();
        }
    }

    private static void logMsg(String messageKey, Object ... args) {
        log.logConsoleMsg(messageKey, args);
        log.infoMsg(messageKey, args);
    }

    private static class JavaCoreTracker {
        long lastCoreTime = 0L;
        int coreCount = 0;

        private JavaCoreTracker() {
        }
    }
}

