/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.services.event;

import java.io.Serializable;
import java.util.Date;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Event
implements Serializable {
    private static final long serialVersionUID = -7545319711974518918L;
    public static final String TYPE_PROPERTY_NAME = "event_type_name";
    private JSONObject properties;
    private final Object source;
    private final Date timestamp;

    public Event() {
        this.properties = new JSONObject();
        this.source = null;
        this.timestamp = new Date();
    }

    public Event(JSONObject properties) {
        this.properties = properties;
        this.source = null;
        this.timestamp = new Date();
        if (!this.properties.has(TYPE_PROPERTY_NAME)) {
            try {
                this.properties.put(TYPE_PROPERTY_NAME, (Object)this.getClass().getCanonicalName());
            }
            catch (JSONException e) {
                throw new RuntimeException("This should never happen", e);
            }
        }
    }

    public Event(Object source) {
        this.properties = new JSONObject();
        this.source = source;
        this.timestamp = new Date();
    }

    public Event(Object source, String type) throws Exception {
        this.properties = new JSONObject();
        this.properties.append(TYPE_PROPERTY_NAME, (Object)type);
        this.source = source;
        this.timestamp = new Date();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        String type;
        try {
            type = this.properties.getString(TYPE_PROPERTY_NAME);
        }
        catch (JSONException e) {
            type = this.getClass().getCanonicalName();
        }
        return type;
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    protected void setProperties(JSONObject properties) {
        this.properties = properties;
    }

    public String getString(String key) {
        String result = null;
        if (this.properties.has(key)) {
            try {
                result = this.properties.getString(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("This should never happen", e);
            }
        }
        return result;
    }

    public Integer getInteger(String key) {
        Integer result = null;
        if (this.properties.has(key)) {
            try {
                result = this.properties.getInt(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("This should never happen", e);
            }
        }
        return result;
    }

    public Long getLong(String key) {
        Long result = null;
        if (this.properties.has(key)) {
            try {
                result = this.properties.getLong(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("This should never happen", e);
            }
        }
        return result;
    }

    public Double getDouble(String key) {
        Double result = null;
        if (this.properties.has(key)) {
            try {
                result = this.properties.getDouble(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("This should never happen", e);
            }
        }
        return result;
    }

    public Boolean getBoolean(String key) {
        Boolean result = null;
        if (this.properties.has(key)) {
            try {
                result = this.properties.getBoolean(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("This should never happen", e);
            }
        }
        return result;
    }

    public Object getObject(String key) {
        Object result = null;
        if (this.properties.has(key)) {
            try {
                result = this.properties.get(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("This should never happen", e);
            }
        }
        return result;
    }

    public JSONObject getJsonObject(String key) {
        JSONObject result = null;
        if (this.properties.has(key)) {
            try {
                result = this.properties.getJSONObject(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("This should never happen", e);
            }
        }
        return result;
    }

    public JSONArray getJsonArray(String key) {
        JSONArray result = null;
        if (this.properties.has(key)) {
            try {
                result = this.properties.getJSONArray(key);
            }
            catch (JSONException e) {
                throw new RuntimeException("This should never happen", e);
            }
        }
        return result;
    }

    public boolean hasProperty(String key) {
        return this.properties.has(key);
    }

    public Object getSource() {
        return this.source;
    }

    public String toString() {
        return this.getType();
    }
}

