/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryModelField;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.internal.util.SafeSimpleDataFormat;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IDateTimeField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import java.util.Date;

public class DateTimeField
extends AbstractQueryModelField
implements IDateTimeField {
    public DateTimeField(IQueryPath aModel, String aName) {
        this.name(aName);
        this.parent(aModel);
    }

    @Override
    public ElementType getFieldType() {
        return ElementType.DATE_TIME_LITERAL;
    }

    @Override
    public IPredicate _in(IDateTime[] dateTimes) {
        this.checkInPredicateValueArray(dateTimes);
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(field);
        IDateTime[] iDateTimeArray = dateTimes;
        int n = dateTimes.length;
        int n2 = 0;
        while (n2 < n) {
            IDateTime dateTime = iDateTimeArray[n2];
            this.checkInPredicateNullValue(dateTime);
            FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(dateTime);
            inList.getValues().add((Object)filterElement);
            ++n2;
        }
        return inList;
    }

    @Override
    public IPredicate _in(Date[] dates) {
        this.checkInPredicateValueArray(dates);
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(field);
        Date[] dateArray = dates;
        int n = dates.length;
        int n2 = 0;
        while (n2 < n) {
            Date date = dateArray[n2];
            Literal literal = QueryastFactory.eINSTANCE.createLiteral();
            literal.setKind(ElementType.DATE_TIME_LITERAL);
            literal.setStringValue(SafeSimpleDataFormat.DATE_FORMATS.get(0).format(date));
            inList.getValues().add((Object)literal);
            ++n2;
        }
        return inList;
    }

    @Override
    public IPredicate _eq(Date dateToCompare) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, dateToCompare);
    }

    @Override
    public IPredicate _eq(IDateTime dateTime) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, dateTime);
    }

    @Override
    public IPredicate _gt(Date dateToCompare) {
        return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, dateToCompare);
    }

    @Override
    public IPredicate _gt(IDateTime dateTime) {
        return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, dateTime);
    }

    @Override
    public IPredicate _gtOrEq(Date dateToCompare) {
        return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, dateToCompare);
    }

    @Override
    public IPredicate _gtOrEq(IDateTime dateTime) {
        return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, dateTime);
    }

    @Override
    public IPredicate _lt(Date dateToCompare) {
        return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, dateToCompare);
    }

    @Override
    public IPredicate _lt(IDateTime dateTime) {
        return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, dateTime);
    }

    @Override
    public IPredicate _ltOrEq(Date dateToCompare) {
        return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, dateToCompare);
    }

    @Override
    public IPredicate _ltOrEq(IDateTime dateTime) {
        return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, dateTime);
    }

    @Override
    public IPredicate _notEq(Date dateToCompare) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, dateToCompare);
    }

    @Override
    public IPredicate _notEq(IDateTime dateTime) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, dateTime);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, Date dateToCompare) {
        FeaturePath lhsField = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)lhsField, dateToCompare);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, IDateTime dateTime) {
        FeaturePath lhsField = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)lhsField, dateTime);
    }
}

