/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.IHelperType;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.IVirtualType;
import com.ibm.team.repository.common.internal.util.ComponentElementDescriptor;
import com.ibm.team.repository.common.internal.util.IComponentElementDescriptor;
import com.ibm.team.repository.common.internal.util.IComponentRegistry;
import com.ibm.team.repository.common.internal.util.IModelElementDescriptor;
import com.ibm.team.repository.common.internal.util.IServiceElementDescriptor;
import com.ibm.team.repository.common.internal.util.InternalTeamPlatform;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.HelperType;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.VirtualType;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class ComponentRegistry
extends ExtensionRegistryReader<IComponentElementDescriptor>
implements IComponentRegistry {
    private static final String ATTRIBUTE_IS_NOT_UNIQUE_ERROR = "The %s bundle's plugin.xml file contains a <%s> element with the %s attribute value %s that is not unique.";
    private static final String NO_VERSION = "";
    public static final String REPOSITORY_COMPONENT_ID = "com.ibm.team.repository";
    public static final IComponentRegistry INSTANCE = new ComponentRegistry();
    private Map<String, IComponentElementDescriptor> idToComponentElementDescriptorMap;
    private Map<String, Log> idToLogMap;
    private Set<String> localModelUriSet;
    private Set<String> remoteModelUriSet;
    private Map<String, IComponentElementDescriptor> modelUriToComponentElementDescriptorMap;
    private Map<String, IComponentElementDescriptor> dtoModelUriToComponentElementDescriptorMap;
    private Map<String, IComponentElementDescriptor> serviceUriToComponentElementDescriptorMap;
    private volatile IItemType[] allItemTypesCache;
    private Object allItemTypesCacheInitializerLock;
    private volatile Map<IItemType, IItemType.READ_ACCESS_POLICY> allItemTypesWithReadAccessInfoCache;
    private Object allItemTypesWithReadAccessInfoCacheInitializerLock;
    private volatile IVirtualType[] allVirtualTypesCache;
    private Object allVirtualTypesCacheLock;
    private volatile Set<IItemType> allCommonConfigurationTypesCache;
    private Object allCommonConfigurationTypesCacheInitializerLock;
    private ReadWriteLock lock;
    public static final String TEAM_PACKAGE_ANNOTATION = "teamPackage";
    private static final String TEAM_CLASS_ANNOTATION = "teamClass";
    private static final String READ_ACCESS_POLICY_ANNOTATION = "readAccessPolicy";
    private static final String USE_READ_ACCESS_POLICY_OF_PACKAGE = "USE_READ_ACCESS_POLICY_OF_PACKAGE";
    private static final String ALLOWS_COMMON_CONFIGURATION_ITEMS_ANNOTATION = "allowsCommonConfigurationItems";

    private ComponentRegistry() {
        super("com.ibm.team.repository.common", "components");
    }

    private void clearAllMaps() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            this.clearIdToComponentElementDescriptorMap();
            this.clearNamespaceUriToComponentElementDescriptorMap();
            this.clearServiceUriToComponentElementDescriptorMap();
        }
        finally {
            writeLock.unlock();
        }
    }

    private void clearIdToComponentElementDescriptorMap() {
        Map<String, IComponentElementDescriptor> map = this.getIdToComponentElementDescriptorMap();
        map.clear();
    }

    private void clearNamespaceUriToComponentElementDescriptorMap() {
        Map<String, IComponentElementDescriptor> map = this.getModelUriToComponentElementDescriptorMap();
        map.clear();
    }

    private void clearServiceUriToComponentElementDescriptorMap() {
        Map<String, IComponentElementDescriptor> map = this.getServiceUriToComponentElementDescriptorMap();
        map.clear();
    }

    public static ComponentRegistry getNewComponentRegistry() {
        return new ComponentRegistry();
    }

    @Override
    public IHelperType[] getAllHelperTypes() {
        IHelperType[] result = this.getAllHelperTypes(false);
        return result;
    }

    @Override
    public IHelperType[] getAllHelperTypes(boolean includeAbstractTypes) {
        this.checkStarted();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            RepositoryPackage repositoryPackage = this.getRepositoryPackage();
            EClass helper = repositoryPackage.getHelper();
            Set<String> set = this.getAllModelURIs();
            int size = set.size();
            ArrayList<HelperType> allHelperTypes = new ArrayList<HelperType>(size);
            for (String modelUri : set) {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(modelUri);
                if (ePackage == null) continue;
                TreeIterator iterator = ePackage.eAllContents();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (eObject instanceof EClass) {
                        EClass eClass = (EClass)eObject;
                        if ((includeAbstractTypes || !eClass.isAbstract()) && helper.isSuperTypeOf(eClass)) {
                            HelperType helperType = ItemUtil.helperTypeFor(eClass);
                            allHelperTypes.add(helperType);
                        }
                    }
                    if (eObject instanceof EPackage) continue;
                    iterator.prune();
                }
            }
            int count = allHelperTypes.size();
            IHelperType[] result = new IHelperType[count];
            allHelperTypes.toArray(result);
            IHelperType[] iHelperTypeArray = result;
            return iHelperTypeArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IItemType[] getAllItemTypes() {
        IItemType[] allItemTypes = this.allItemTypesCache;
        if (allItemTypes == null) {
            Object object = this.allItemTypesCacheInitializerLock;
            synchronized (object) {
                if (this.allItemTypesCache == null) {
                    this.allItemTypesCache = this.getItemTypes(false, this.getAllModelURIs());
                }
                allItemTypes = this.allItemTypesCache;
            }
        }
        return allItemTypes;
    }

    @Override
    public IItemType[] getAllItemTypes(boolean includeAbstractTypes) {
        IItemType[] allItemTypes = this.getItemTypes(includeAbstractTypes, this.getAllModelURIs());
        return allItemTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVirtualType[] getAllVirtualTypes() {
        IVirtualType[] allVirtualTypes = this.allVirtualTypesCache;
        if (allVirtualTypes == null) {
            Object object = this.allVirtualTypesCacheLock;
            synchronized (object) {
                if (this.allVirtualTypesCache == null) {
                    this.allVirtualTypesCache = this.getAllVirtualTypes(false);
                }
                allVirtualTypes = this.allVirtualTypesCache;
            }
        }
        return allVirtualTypes;
    }

    @Override
    public IVirtualType[] getAllVirtualTypes(boolean includeAbstractTypes) {
        return this.getVirtualTypes(includeAbstractTypes);
    }

    @Override
    public IVirtualType getVirtualType(String name, String namespace) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace must not be null");
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(namespace);
        if (ePackage == null) {
            return null;
        }
        EClassifier classifier = ePackage.getEClassifier(name);
        if (!(classifier instanceof EClass)) {
            return null;
        }
        EClass eClass = (EClass)classifier;
        RepositoryPackage repositoryPackage = this.getRepositoryPackage();
        if (eClass == repositoryPackage.getVirtual() || !repositoryPackage.getVirtual().isSuperTypeOf(eClass)) {
            return null;
        }
        VirtualType virtualType = ItemUtil.virtualTypeFor(name, namespace);
        return virtualType;
    }

    @Override
    public Set<String> getAllModelURIs() {
        HashSet<String> result;
        this.checkStarted();
        Set<String> locModelUriSet = this.getLocalModelUriSet();
        Set<String> rmtModelUriSet = this.getRemoteModelUriSet();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            int size = locModelUriSet.size() + rmtModelUriSet.size();
            result = new HashSet<String>(size);
            result.addAll(locModelUriSet);
            result.addAll(rmtModelUriSet);
        }
        finally {
            readLock.unlock();
        }
        return result;
    }

    @Override
    public IComponentElementDescriptor getComponentDescriptor(IConfigurationElement element) {
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        this.checkStarted();
        IComponentElementDescriptor descriptor = (IComponentElementDescriptor)this.getDescriptor(element);
        return descriptor;
    }

    @Override
    public IComponentElementDescriptor getComponentDescriptor(IType type) {
        if (type == null) {
            throw new IllegalArgumentException("itemType must not be null");
        }
        this.checkStarted();
        String modelUri = type.getNamespaceURI();
        IComponentElementDescriptor descriptor = this.getComponentDescriptorForModelUri(modelUri);
        return descriptor;
    }

    @Override
    public IComponentElementDescriptor getComponentDescriptorForId(String id) {
        IComponentElementDescriptor descriptor;
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.checkStarted();
        Map<String, IComponentElementDescriptor> map = this.getIdToComponentElementDescriptorMap();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            descriptor = map.get(id);
        }
        finally {
            readLock.unlock();
        }
        if (descriptor == null) {
            String message = String.format("Failed to find IComponentElementDescriptor for id %s", id);
            throw new IllegalArgumentException(message);
        }
        return descriptor;
    }

    @Override
    public IComponentElementDescriptor getComponentDescriptorForModelUri(String uri) {
        IComponentElementDescriptor descriptor;
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        this.checkStarted();
        Map<String, IComponentElementDescriptor> map = this.getModelUriToComponentElementDescriptorMap();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            descriptor = map.get(uri);
        }
        finally {
            readLock.unlock();
        }
        if (descriptor == null) {
            String message = String.format("Failed to find IComponentElementDescriptor for URI %s", uri);
            throw new IllegalArgumentException(message);
        }
        return descriptor;
    }

    @Override
    public IComponentElementDescriptor getComponentDescriptorForDtoModelUri(String uri) {
        IComponentElementDescriptor descriptor;
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        this.checkStarted();
        Map<String, IComponentElementDescriptor> map = this.getDtoModelUriToComponentElementDescriptorMap();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            descriptor = map.get(uri);
        }
        finally {
            readLock.unlock();
        }
        return descriptor;
    }

    @Override
    public IComponentElementDescriptor getComponentDescriptorForServiceUri(String serviceUri) {
        IComponentElementDescriptor descriptor;
        if (serviceUri == null) {
            throw new IllegalArgumentException("serviceUri must not be null");
        }
        this.checkStarted();
        Map<String, IComponentElementDescriptor> map = this.getServiceUriToComponentElementDescriptorMap();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            descriptor = map.get(serviceUri);
        }
        finally {
            readLock.unlock();
        }
        return descriptor;
    }

    @Override
    public List<IComponentElementDescriptor> getComponentDescriptors() {
        ArrayList<IComponentElementDescriptor> descriptors;
        this.checkStarted();
        Map<String, IComponentElementDescriptor> map = this.getIdToComponentElementDescriptorMap();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            Collection<IComponentElementDescriptor> values = map.values();
            int size = values.size();
            descriptors = new ArrayList<IComponentElementDescriptor>(size);
            descriptors.addAll(values);
        }
        finally {
            readLock.unlock();
        }
        return descriptors;
    }

    @Override
    public String getComponentId(IType type) {
        IComponentElementDescriptor descriptor = this.getComponentDescriptor(type);
        String id = this.getId(descriptor);
        return id;
    }

    @Override
    public String getComponentId(String namespaceUri) {
        IComponentElementDescriptor descriptor = this.getComponentDescriptorForModelUri(namespaceUri);
        String id = this.getId(descriptor);
        return id;
    }

    @Override
    public IItemType.READ_ACCESS_POLICY getReadAccessPolicyForType(IType type) {
        IItemType.READ_ACCESS_POLICY readAccessPolicy = this.getAllItemTypesWithReadAccessInfoCache().get(type);
        if (readAccessPolicy != null) {
            return readAccessPolicy;
        }
        String pattern = "Cannot find read access policy for type {0}";
        String message = NLS.bind(pattern, type.getName(), new Object[0]);
        throw new IllegalStateException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<IItemType, IItemType.READ_ACCESS_POLICY> getAllItemTypesWithReadAccessInfoCache() {
        Map<IItemType, IItemType.READ_ACCESS_POLICY> allItemTypesWithReadAccessInfo = this.allItemTypesWithReadAccessInfoCache;
        if (allItemTypesWithReadAccessInfo == null) {
            Object object = this.allItemTypesWithReadAccessInfoCacheInitializerLock;
            synchronized (object) {
                if (this.allItemTypesWithReadAccessInfoCache == null) {
                    this.allItemTypesWithReadAccessInfoCache = this.computeReadAccessPolicyInfo(this.getAllModelURIs());
                }
                allItemTypesWithReadAccessInfo = this.allItemTypesWithReadAccessInfoCache;
            }
        }
        return allItemTypesWithReadAccessInfo;
    }

    @Override
    public boolean isUsingPublicReadAccessPolicy(IType type) {
        IItemType.READ_ACCESS_POLICY readAccessPolicy = this.getReadAccessPolicyForType(type);
        return readAccessPolicy.equals((Object)IItemType.READ_ACCESS_POLICY.PUBLIC);
    }

    @Override
    public boolean isUsingProtectedReadAccessPolicy(IType type) {
        IItemType.READ_ACCESS_POLICY readAccessPolicy = this.getReadAccessPolicyForType(type);
        return readAccessPolicy.equals((Object)IItemType.READ_ACCESS_POLICY.PROTECTED);
    }

    @Override
    public boolean isUsingApplicationManagedReadAccessPolicy(IType type) {
        IItemType.READ_ACCESS_POLICY readAccessPolicy = this.getReadAccessPolicyForType(type);
        return readAccessPolicy.equals((Object)IItemType.READ_ACCESS_POLICY.APPLICATION_MANAGED);
    }

    @Override
    public boolean isUsingInternalReadAccessPolicy(IType type) {
        IItemType.READ_ACCESS_POLICY readAccessPolicy = this.getReadAccessPolicyForType(type);
        return readAccessPolicy.equals((Object)IItemType.READ_ACCESS_POLICY.INTERNAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IItemType> getAllCommonConfigurationTypesCache() {
        if (this.allCommonConfigurationTypesCache == null) {
            Object object = this.allCommonConfigurationTypesCacheInitializerLock;
            synchronized (object) {
                if (this.allCommonConfigurationTypesCache == null) {
                    this.allCommonConfigurationTypesCache = new HashSet<IItemType>();
                    EClass itemClass = this.getRepositoryPackage().getItem();
                    for (String modelURI : this.getAllModelURIs()) {
                        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(modelURI);
                        if (ePackage == null) continue;
                        TreeIterator packageContentsIterator = ePackage.eAllContents();
                        while (packageContentsIterator.hasNext()) {
                            String allowsCommon;
                            EAnnotation annotation;
                            EClass eClass;
                            EObject eObject = (EObject)packageContentsIterator.next();
                            if (!(eObject instanceof EClass) || !itemClass.isSuperTypeOf(eClass = (EClass)eObject) || (annotation = eClass.getEAnnotation(TEAM_CLASS_ANNOTATION)) == null || (allowsCommon = (String)annotation.getDetails().get((Object)ALLOWS_COMMON_CONFIGURATION_ITEMS_ANNOTATION)) == null || !allowsCommon.equalsIgnoreCase("true")) continue;
                            ItemType itemType = ItemUtil.itemTypeFor(eClass);
                            this.allCommonConfigurationTypesCache.add(itemType);
                        }
                    }
                }
            }
        }
        return this.allCommonConfigurationTypesCache;
    }

    @Override
    public boolean isStoreableInCommonConfiguration(IType type) {
        return this.getAllCommonConfigurationTypesCache().contains(type);
    }

    @Override
    public IHelperType getHelperType(String name, String modelUri) {
        EClass eClass;
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (modelUri == null) {
            throw new IllegalArgumentException("modelUri must not be null");
        }
        Set<String> set = this.getAllModelURIs();
        boolean exists = set.contains(modelUri);
        if (!exists) {
            return null;
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(modelUri);
        if (ePackage == null) {
            return null;
        }
        EClassifier classifier = ePackage.getEClassifier(name);
        if (!(classifier instanceof EClass)) {
            return null;
        }
        RepositoryPackage repositoryPackage = this.getRepositoryPackage();
        EClass helper = repositoryPackage.getHelper();
        if (!helper.isSuperTypeOf(eClass = (EClass)classifier)) {
            return null;
        }
        HelperType helperType = ItemUtil.helperTypeFor(name, modelUri);
        return helperType;
    }

    private String getId(IComponentElementDescriptor descriptor) {
        String id = descriptor == null ? null : descriptor.getIdAttribute();
        return id;
    }

    private Map<String, IComponentElementDescriptor> getIdToComponentElementDescriptorMap() {
        return this.idToComponentElementDescriptorMap;
    }

    private Map getIdToLogMap() {
        return this.idToLogMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidModelURI(String modelURI) {
        Set<String> locModelUriSet = this.getLocalModelUriSet();
        Set<String> rmtModelUriSet = this.getRemoteModelUriSet();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            if (locModelUriSet.contains(modelURI)) {
                return true;
            }
            if (!rmtModelUriSet.contains(modelURI)) return false;
            return true;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public IItemType getItemType(String name, String modelUri) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (modelUri == null) {
            throw new IllegalArgumentException("modelUri must not be null");
        }
        boolean exists = this.isValidModelURI(modelUri);
        if (!exists) {
            return null;
        }
        return IItemType.IRegistry.INSTANCE.getItemType(name, modelUri);
    }

    @Override
    protected void checkStarted() {
        super.checkStarted();
        if (!InternalTeamPlatform.getDefault().isStarted()) {
            throw new IllegalStateException("TeamPlatform must be started.");
        }
    }

    private IItemType[] getItemTypes(boolean includeAbstractTypes, Set<String> set) {
        this.checkStarted();
        RepositoryPackage repositoryPackage = this.getRepositoryPackage();
        EClass auditable = repositoryPackage.getAuditable();
        EClass versionable = repositoryPackage.getUnmanagedItem();
        EClass simpleItem = repositoryPackage.getSimpleItem();
        EClass configurationAwareAuditable = repositoryPackage.getConfigurationAwareAuditable();
        EClass configurationAwareSimpleItem = repositoryPackage.getConfigurationAwareSimpleItem();
        EClass item = repositoryPackage.getItem();
        int size = set.size();
        ArrayList<ItemType> allItemTypes = new ArrayList<ItemType>(size);
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            for (String modelUri : set) {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(modelUri);
                if (ePackage == null) continue;
                TreeIterator iterator = ePackage.eAllContents();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (eObject instanceof EClass) {
                        EClass eClass = (EClass)eObject;
                        if (eClass == auditable || eClass == simpleItem || eClass == versionable || eClass == configurationAwareAuditable || eClass == configurationAwareSimpleItem) continue;
                        if (item.isSuperTypeOf(eClass)) {
                            ItemType itemType = ItemUtil.itemTypeFor(eClass);
                            if (includeAbstractTypes || !eClass.isAbstract()) {
                                allItemTypes.add(itemType);
                            }
                        }
                    }
                    if (eObject instanceof EPackage) continue;
                    iterator.prune();
                }
            }
            int count = allItemTypes.size();
            IItemType[] result = new IItemType[count];
            allItemTypes.toArray(result);
            IItemType[] iItemTypeArray = result;
            return iItemTypeArray;
        }
        finally {
            readLock.unlock();
        }
    }

    private Map<IItemType, IItemType.READ_ACCESS_POLICY> computeReadAccessPolicyInfo(Set<String> set) {
        this.checkStarted();
        RepositoryPackage repositoryPackage = this.getRepositoryPackage();
        EClass auditable = repositoryPackage.getAuditable();
        EClass versionable = repositoryPackage.getUnmanagedItem();
        EClass simpleItem = repositoryPackage.getSimpleItem();
        EClass item = repositoryPackage.getItem();
        int size = set.size();
        HashMap<IItemType, IItemType.READ_ACCESS_POLICY> result = new HashMap<IItemType, IItemType.READ_ACCESS_POLICY>(size * 2 + 1);
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            for (String modelUri : set) {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(modelUri);
                if (ePackage == null) continue;
                IItemType.READ_ACCESS_POLICY packageReadAccessPolicy = this.getReadAccessPolicyForPackage(ePackage);
                TreeIterator iterator = ePackage.eAllContents();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (eObject instanceof EClass) {
                        EClass eClass = (EClass)eObject;
                        if (eClass == auditable || eClass == simpleItem || eClass == versionable) continue;
                        if (item.isSuperTypeOf(eClass)) {
                            ItemType itemType = ItemUtil.itemTypeFor(eClass);
                            IItemType.READ_ACCESS_POLICY readAccessPolicy = this.getReadAccessPolicyForType(eClass, packageReadAccessPolicy);
                            result.put(itemType, readAccessPolicy);
                        }
                    }
                    if (eObject instanceof EPackage) continue;
                    iterator.prune();
                }
            }
            HashMap<IItemType, IItemType.READ_ACCESS_POLICY> hashMap = result;
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    private IItemType.READ_ACCESS_POLICY getReadAccessPolicyForPackage(EPackage ePackage) {
        EAnnotation annotation = ePackage.getEAnnotation(TEAM_PACKAGE_ANNOTATION);
        if (annotation == null) {
            return IItemType.READ_ACCESS_POLICY.PROTECTED;
        }
        String readAccessPolicy = (String)annotation.getDetails().get((Object)READ_ACCESS_POLICY_ANNOTATION);
        if (readAccessPolicy == null) {
            return IItemType.READ_ACCESS_POLICY.PROTECTED;
        }
        readAccessPolicy = readAccessPolicy.trim();
        return this.getReadAccessPolicy(readAccessPolicy);
    }

    private IItemType.READ_ACCESS_POLICY getReadAccessPolicyForType(EClass eClass, IItemType.READ_ACCESS_POLICY packageReadAccessPolicy) {
        EAnnotation annotation = eClass.getEAnnotation(TEAM_CLASS_ANNOTATION);
        if (annotation == null) {
            return packageReadAccessPolicy;
        }
        String readAccessPolicy = (String)annotation.getDetails().get((Object)READ_ACCESS_POLICY_ANNOTATION);
        if (readAccessPolicy == null) {
            return packageReadAccessPolicy;
        }
        if ((readAccessPolicy = readAccessPolicy.trim()).equals(USE_READ_ACCESS_POLICY_OF_PACKAGE)) {
            return packageReadAccessPolicy;
        }
        return this.getReadAccessPolicy(readAccessPolicy);
    }

    private IItemType.READ_ACCESS_POLICY getReadAccessPolicy(String readAccessPolicy) {
        if (readAccessPolicy.equals("PUBLIC")) {
            return IItemType.READ_ACCESS_POLICY.PUBLIC;
        }
        if (readAccessPolicy.equals("PROTECTED")) {
            return IItemType.READ_ACCESS_POLICY.PROTECTED;
        }
        if (readAccessPolicy.equals("APPLICATION_MANAGED")) {
            return IItemType.READ_ACCESS_POLICY.APPLICATION_MANAGED;
        }
        if (readAccessPolicy.equals("INTERNAL")) {
            return IItemType.READ_ACCESS_POLICY.INTERNAL;
        }
        return IItemType.READ_ACCESS_POLICY.PROTECTED;
    }

    @Override
    public IItemType[] getLocalItemTypes() {
        Set<String> set = this.getLocalModelUriSet();
        IItemType[] result = this.getItemTypes(false, set);
        return result;
    }

    private IVirtualType[] getVirtualTypes(boolean includeAbstractTypes) {
        String[] keyArray;
        this.checkStarted();
        RepositoryPackage repositoryPackage = this.getRepositoryPackage();
        EClass virtual = repositoryPackage.getVirtual();
        ArrayList<VirtualType> allVirtualTypes = new ArrayList<VirtualType>(59);
        String[] stringArray = keyArray = EPackage.Registry.INSTANCE.keySet().toArray(new String[0]);
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            EPackage ePackage = this.resolvePackage(key, EPackage.Registry.INSTANCE.get((Object)key));
            if (ePackage != null) {
                TreeIterator iterator = ePackage.eAllContents();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (eObject instanceof EClass) {
                        EClass eClass = (EClass)eObject;
                        if ((includeAbstractTypes || !eClass.isAbstract()) && eClass != virtual && virtual.isSuperTypeOf(eClass)) {
                            VirtualType virtualType = ItemUtil.virtualTypeFor(eClass);
                            allVirtualTypes.add(virtualType);
                        }
                    }
                    if (eObject instanceof EPackage) continue;
                    iterator.prune();
                }
            }
            ++n2;
        }
        int count = allVirtualTypes.size();
        IVirtualType[] result = new IVirtualType[count];
        allVirtualTypes.toArray(result);
        return result;
    }

    private EPackage resolvePackage(String key, Object obj) {
        Log LOG = this.getLog(REPOSITORY_COMPONENT_ID);
        if (key == null || obj == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Attempt to resolve EPackage with null uri or package reference");
            }
            return null;
        }
        EPackage ePackage = null;
        if (obj instanceof EPackage) {
            ePackage = (EPackage)obj;
        } else if (obj instanceof EPackage.Descriptor) {
            try {
                ePackage = ((EPackage.Descriptor)obj).getEPackage();
            }
            catch (Exception e) {
                LOG.warn((Object)String.format("Exception thrown when resolving package descriptor for package \"%s\": %s", obj.toString(), e.getMessage()));
                return null;
            }
            if (ePackage == null) {
                LOG.warn((Object)String.format("Package descriptor \"%s\" references unrecognized package", obj.toString()));
                return null;
            }
        } else {
            LOG.warn((Object)String.format("Unexpected type found in EPackage.Registry: \"%s\"", obj.getClass().getName()));
            return null;
        }
        return ePackage;
    }

    private Set<String> getLocalModelUriSet() {
        return this.localModelUriSet;
    }

    private Lock getReadLock() {
        return this.lock.readLock();
    }

    private Lock getWriteLock() {
        return this.lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Log getLog(String id) {
        Map map;
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.checkStarted();
        Map map2 = map = this.getIdToLogMap();
        synchronized (map2) {
            Log log = (Log)map.get(id);
            if (log == null) {
                log = LogFactory.getLog((String)id);
                map.put(id, log);
            }
            return log;
        }
    }

    private Map<String, IComponentElementDescriptor> getModelUriToComponentElementDescriptorMap() {
        return this.modelUriToComponentElementDescriptorMap;
    }

    private Map<String, IComponentElementDescriptor> getDtoModelUriToComponentElementDescriptorMap() {
        return this.dtoModelUriToComponentElementDescriptorMap;
    }

    @Override
    public String getModelVersion(String modelUri) {
        if (modelUri == null) {
            throw new IllegalArgumentException("modelUri must not be null");
        }
        this.checkStarted();
        IComponentElementDescriptor descriptor = INSTANCE.getComponentDescriptorForModelUri(modelUri);
        IModelElementDescriptor modelElementDescriptor = descriptor.getModelElementDescriptor();
        String version = modelElementDescriptor.getVersionAttribute();
        return version;
    }

    private Set<String> getRemoteModelUriSet() {
        return this.remoteModelUriSet;
    }

    private RepositoryPackage getRepositoryPackage() {
        return RepositoryPackage.eINSTANCE;
    }

    private Map<String, IComponentElementDescriptor> getServiceUriToComponentElementDescriptorMap() {
        return this.serviceUriToComponentElementDescriptorMap;
    }

    @Override
    public String getServiceVersion(String serviceUri) {
        if (serviceUri == null) {
            throw new IllegalArgumentException("serviceUri must not be null");
        }
        IComponentElementDescriptor descriptor = this.getComponentDescriptorForServiceUri(serviceUri);
        if (descriptor == null) {
            return NO_VERSION;
        }
        IServiceElementDescriptor serviceElementDescriptor = descriptor.getServiceElementDescriptor(serviceUri);
        if (serviceElementDescriptor == null) {
            return NO_VERSION;
        }
        String version = serviceElementDescriptor.getVersionAttribute();
        return version;
    }

    @Override
    protected IComponentElementDescriptor handleExtensionAdded(IConfigurationElement element) {
        ComponentElementDescriptor descriptor = null;
        descriptor = new ComponentElementDescriptor(element);
        Map<String, IComponentElementDescriptor> idToComponentElementDescriptor = this.getIdToComponentElementDescriptorMap();
        Map<String, IComponentElementDescriptor> modelUriToComponentElementDescriptor = this.getModelUriToComponentElementDescriptorMap();
        Map<String, IComponentElementDescriptor> dtoModelUriToComponentElementDescriptor = this.getDtoModelUriToComponentElementDescriptorMap();
        Map<String, IComponentElementDescriptor> serviceUriToComponentElementDescriptor = this.getServiceUriToComponentElementDescriptorMap();
        String id = descriptor.getIdAttribute();
        IModelElementDescriptor modelElementDescriptor = descriptor.getModelElementDescriptor();
        List<IModelElementDescriptor> dtoModelElementDescriptors = descriptor.getDtoModelElementDescriptors();
        List<IServiceElementDescriptor> serviceElementDescriptors = descriptor.getServiceElementDescriptors();
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            try {
                boolean exists = idToComponentElementDescriptor.containsKey(id);
                if (exists) {
                    String bundleSymbolicName = descriptor.getBundleSymbolicName();
                    String message = String.format(ATTRIBUTE_IS_NOT_UNIQUE_ERROR, bundleSymbolicName, "component", "id", id);
                    throw new IllegalArgumentException(message);
                }
                this.flushCachedTypes();
                idToComponentElementDescriptor.put(id, descriptor);
                if (modelElementDescriptor != null) {
                    String modelUri = modelElementDescriptor.getUriAttribute();
                    exists = modelUriToComponentElementDescriptor.containsKey(modelUri);
                    if (exists) {
                        String bundleSymbolicName = descriptor.getBundleSymbolicName();
                        String message = String.format(ATTRIBUTE_IS_NOT_UNIQUE_ERROR, bundleSymbolicName, "model", "uri", modelUri);
                        throw new IllegalArgumentException(message);
                    }
                    modelUriToComponentElementDescriptor.put(modelUri, descriptor);
                    Set<String> localModelUris = this.getLocalModelUriSet();
                    exists = localModelUris.contains(modelUri);
                    if (exists) {
                        String bundleSymbolicName = descriptor.getBundleSymbolicName();
                        String message = String.format(ATTRIBUTE_IS_NOT_UNIQUE_ERROR, bundleSymbolicName, "model", "uri", modelUri);
                        throw new IllegalArgumentException(message);
                    }
                    localModelUris.add(modelUri);
                }
                for (IModelElementDescriptor dtoModelElementDescriptor : dtoModelElementDescriptors) {
                    String dtoModelUri = dtoModelElementDescriptor.getUriAttribute();
                    exists = dtoModelUriToComponentElementDescriptor.containsKey(dtoModelUri);
                    if (exists) {
                        String bundleSymbolicName = descriptor.getBundleSymbolicName();
                        String message = String.format(ATTRIBUTE_IS_NOT_UNIQUE_ERROR, bundleSymbolicName, "dtoModel", "uri", dtoModelUri);
                        throw new IllegalArgumentException(message);
                    }
                    dtoModelUriToComponentElementDescriptor.put(dtoModelUri, descriptor);
                }
                for (IServiceElementDescriptor serviceElementDescriptor : serviceElementDescriptors) {
                    String serviceUri = serviceElementDescriptor.getUriAttribute();
                    exists = serviceUriToComponentElementDescriptor.containsKey(serviceUri);
                    if (exists) {
                        String bundleSymbolicName = descriptor.getBundleSymbolicName();
                        String message = String.format(ATTRIBUTE_IS_NOT_UNIQUE_ERROR, bundleSymbolicName, "service", "uri", serviceUri);
                        throw new IllegalArgumentException(message);
                    }
                    serviceUriToComponentElementDescriptor.put(serviceUri, descriptor);
                }
            }
            catch (IllegalArgumentException exception) {
                String message = exception.getMessage();
                this.logError(message);
                writeLock.unlock();
            }
        }
        finally {
            writeLock.unlock();
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCachedTypes() {
        Object object = this.allItemTypesCacheInitializerLock;
        synchronized (object) {
            this.allItemTypesCache = null;
        }
        object = this.allItemTypesWithReadAccessInfoCacheInitializerLock;
        synchronized (object) {
            this.allItemTypesWithReadAccessInfoCache = null;
        }
        object = this.allVirtualTypesCacheLock;
        synchronized (object) {
            this.allVirtualTypesCache = null;
        }
    }

    @Override
    protected void handleExtensionRemoved(IConfigurationElement element, IComponentElementDescriptor descriptor) {
        Map<String, IComponentElementDescriptor> idToComponentElementDescriptor = this.getIdToComponentElementDescriptorMap();
        Map<String, IComponentElementDescriptor> namespaceUriToComponentElementDescriptorMap = this.getModelUriToComponentElementDescriptorMap();
        Map<String, IComponentElementDescriptor> dtoModelUriToComponentElementDescriptor = this.getDtoModelUriToComponentElementDescriptorMap();
        Map<String, IComponentElementDescriptor> serviceUriToComponentElementDescriptor = this.getServiceUriToComponentElementDescriptorMap();
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            String id = descriptor.getIdAttribute();
            idToComponentElementDescriptor.remove(id);
            IModelElementDescriptor modelElementDescriptor = descriptor.getModelElementDescriptor();
            if (modelElementDescriptor != null) {
                String modelUri = modelElementDescriptor.getUriAttribute();
                Set<String> localModelUris = this.getLocalModelUriSet();
                localModelUris.remove(modelUri);
                namespaceUriToComponentElementDescriptorMap.remove(modelUri);
            }
            List<IModelElementDescriptor> dtoModelElementDescriptors = descriptor.getDtoModelElementDescriptors();
            for (IModelElementDescriptor dtoModelElementDescriptor : dtoModelElementDescriptors) {
                String uri = dtoModelElementDescriptor.getUriAttribute();
                dtoModelUriToComponentElementDescriptor.remove(uri);
            }
            List<IServiceElementDescriptor> serviceDescriptors = descriptor.getServiceElementDescriptors();
            for (IServiceElementDescriptor serviceDescriptor : serviceDescriptors) {
                String uri = serviceDescriptor.getUriAttribute();
                serviceUriToComponentElementDescriptor.remove(uri);
            }
            this.flushCachedTypes();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    protected void handleStopped() {
        this.clearAllMaps();
    }

    @Override
    protected void initialize() {
        this.initializeLocks();
        this.setIdToComponentElementDescriptorMap(new HashMap<String, IComponentElementDescriptor>(this.estimateHashedCollectionSize(75)));
        this.setIdToLogMap(new HashMap(this.estimateHashedCollectionSize(75)));
        this.setLocalModelUriSet(new HashSet<String>(this.estimateHashedCollectionSize(75)));
        this.setRemoteModelUriSet(new HashSet<String>(this.estimateHashedCollectionSize(75)));
        this.setModelUriToComponentElementDescriptorMap(new HashMap<String, IComponentElementDescriptor>(this.estimateHashedCollectionSize(75)));
        this.setDtoModelUriToComponentElementDescriptorMap(new HashMap<String, IComponentElementDescriptor>(this.estimateHashedCollectionSize(150)));
        this.setServiceUriToComponentElementDescriptorMap(new HashMap<String, IComponentElementDescriptor>(this.estimateHashedCollectionSize(275)));
    }

    private void initializeLocks() {
        this.lock = new ReentrantReadWriteLock();
        this.allItemTypesCacheInitializerLock = new Object();
        this.allItemTypesWithReadAccessInfoCacheInitializerLock = new Object();
        this.allVirtualTypesCacheLock = new Object();
        this.allCommonConfigurationTypesCacheInitializerLock = new Object();
    }

    @Override
    public boolean isComponent(String id) {
        boolean exists;
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.checkStarted();
        Map<String, IComponentElementDescriptor> map = this.getIdToComponentElementDescriptorMap();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            exists = map.containsKey(id);
        }
        finally {
            readLock.unlock();
        }
        return exists;
    }

    @Override
    public boolean isValidComponent(String modelUri) {
        boolean exists;
        if (modelUri == null) {
            throw new IllegalArgumentException("model URI must not be null");
        }
        this.checkStarted();
        Map<String, IComponentElementDescriptor> map = this.getModelUriToComponentElementDescriptorMap();
        Lock readLock = this.getReadLock();
        readLock.lock();
        try {
            exists = map.containsKey(modelUri);
        }
        finally {
            readLock.unlock();
        }
        return exists;
    }

    @Override
    public void registerRemoteModel(String name, String description, String version, String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        this.checkStarted();
        Set<String> set = this.getRemoteModelUriSet();
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            set.add(uri);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void setIdToComponentElementDescriptorMap(Map<String, IComponentElementDescriptor> idToComponentElementDescriptorMap) {
        this.idToComponentElementDescriptorMap = idToComponentElementDescriptorMap;
    }

    private void setIdToLogMap(Map idToLogMap) {
        this.idToLogMap = idToLogMap;
    }

    private void setLocalModelUriSet(Set<String> localModelUriSet) {
        this.localModelUriSet = localModelUriSet;
    }

    private void setModelUriToComponentElementDescriptorMap(Map<String, IComponentElementDescriptor> namespaceUriToComponentElementDescriptorMap) {
        this.modelUriToComponentElementDescriptorMap = namespaceUriToComponentElementDescriptorMap;
    }

    private void setDtoModelUriToComponentElementDescriptorMap(Map<String, IComponentElementDescriptor> namespaceUriToComponentElementDescriptorMap) {
        this.dtoModelUriToComponentElementDescriptorMap = namespaceUriToComponentElementDescriptorMap;
    }

    private void setRemoteModelUriSet(Set<String> remoteModelUriSet) {
        this.remoteModelUriSet = remoteModelUriSet;
    }

    private void setServiceUriToComponentElementDescriptorMap(Map<String, IComponentElementDescriptor> serviceUriToComponentElementDescriptorMap) {
        this.serviceUriToComponentElementDescriptorMap = serviceUriToComponentElementDescriptorMap;
    }
}

