/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class DateUtils {
    private static final SimpleDateFormat _ISO8601DateFormat;
    private static final SimpleDateFormat _RFC822DateFormat;
    private static final SimpleDateFormat _RFC3339DateFormat;
    private static final SimpleTimeZone _gmtTimeZone;
    private static final SimpleDateFormat _ISO8601DateFormatInternal;
    private static final SimpleDateFormat _RFC822DateFormatInternal;
    private static final SimpleDateFormat _RFC3339DateFormatInternal;
    private static final SimpleDateFormat _RFC3339DateNoMillisFormatInternal;
    private static final SimpleTimeZone _gmtTimeZoneInternal;
    private static final NumberFormat _millisecondFormatter;

    static {
        _gmtTimeZone = new SimpleTimeZone(0, "GMT");
        _gmtTimeZoneInternal = new SimpleTimeZone(0, "GMT");
        _ISO8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        _ISO8601DateFormat.setTimeZone(_gmtTimeZoneInternal);
        _RFC822DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        _RFC822DateFormat.setTimeZone(_gmtTimeZoneInternal);
        _RFC3339DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
        _RFC3339DateFormat.setTimeZone(_gmtTimeZoneInternal);
        _ISO8601DateFormatInternal = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        _ISO8601DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        _RFC822DateFormatInternal = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        _RFC822DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        _RFC3339DateNoMillisFormatInternal = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        _RFC3339DateNoMillisFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        _RFC3339DateFormatInternal = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
        _RFC3339DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        _millisecondFormatter = new MillisecondFormatter(_RFC3339DateFormatInternal.toPattern().indexOf(83) - 2);
        _millisecondFormatter.setParseIntegerOnly(true);
        _RFC3339DateFormatInternal.setNumberFormat(_millisecondFormatter);
        _RFC3339DateFormat.setNumberFormat(_millisecondFormatter);
    }

    public static synchronized String formatTimeISO8601(Date time) {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        _ISO8601DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        return _ISO8601DateFormatInternal.format(time);
    }

    public static synchronized Timestamp parseTimeISO8601(String time) throws ParseException {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        return new Timestamp(_ISO8601DateFormatInternal.parse(time).getTime());
    }

    public static synchronized String formatTimeRFC822(Date time) {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        _RFC822DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        return _RFC822DateFormatInternal.format(time);
    }

    public static synchronized Timestamp parseTimeRFC822(String time) throws ParseException {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        return new Timestamp(_RFC822DateFormatInternal.parse(time).getTime());
    }

    public static synchronized String formatTimeRFC3339(Date time) {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        _RFC3339DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        return _RFC3339DateFormatInternal.format(time);
    }

    public static synchronized Timestamp parseTimeRFC3339(String time) throws ParseException {
        if (time == null) {
            throw new IllegalArgumentException("time must not be null");
        }
        try {
            return new Timestamp(_RFC3339DateFormatInternal.parse(time).getTime());
        }
        catch (ParseException e) {
            try {
                return new Timestamp(_RFC3339DateNoMillisFormatInternal.parse(time).getTime());
            }
            catch (ParseException parseException) {
                throw e;
            }
        }
    }

    public static SimpleDateFormat getISO8601DateFormat() {
        return _ISO8601DateFormat;
    }

    public static SimpleDateFormat getRFC822DateFormat() {
        return _RFC822DateFormat;
    }

    public static SimpleDateFormat getRFC3339DateFormat() {
        return _RFC3339DateFormat;
    }

    public static SimpleTimeZone getGMTTimeZone() {
        return _gmtTimeZone;
    }

    private static class MillisecondFormatter
    extends DecimalFormat {
        private static final long serialVersionUID = -1177752105211688479L;
        final int index;

        public MillisecondFormatter(int index) {
            this.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
            this.index = index;
        }

        @Override
        public Number parse(String text, ParsePosition pos) {
            int currIndex = pos.getIndex();
            Number parsedNumber = super.parse(text, pos);
            if (currIndex != this.index) {
                return parsedNumber;
            }
            int digitCount = pos.getIndex() - currIndex;
            switch (digitCount) {
                case 1: {
                    return (long)(parsedNumber.intValue() * 100);
                }
                case 2: {
                    return (long)(parsedNumber.intValue() * 10);
                }
                case 3: {
                    return parsedNumber;
                }
            }
            return Math.round((double)parsedNumber.intValue() * Math.pow(10.0, 3 - digitCount));
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

