/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContentCache {
    private static final int CACHE_SIZE = 100;
    private Map fCache = null;
    private List fLRU = null;

    ContentCache() {
        this.initializeCache(100);
    }

    public synchronized String get(IContent content) {
        UUID contentId = content.getContentId();
        String value = (String)this.fCache.get(contentId);
        if (value == null) {
            return null;
        }
        this.fLRU.remove(contentId);
        this.fLRU.add(this.fLRU.size(), contentId);
        return value;
    }

    public synchronized void put(IContent content, String value) {
        UUID contentId = content.getContentId();
        Object result = this.fCache.get(contentId);
        if (result != null) {
            this.fCache.put(contentId, value);
            this.fLRU.remove(contentId);
            this.fLRU.add(this.fLRU.size(), contentId);
            return;
        }
        if (this.fCache.size() == 100) {
            UUID toBeRemoved = (UUID)this.fLRU.remove(0);
            this.fCache.remove(toBeRemoved);
        }
        this.fLRU.add(this.fLRU.size(), contentId);
        this.fCache.put(contentId, value);
    }

    private void initializeCache(int newCacheSize) {
        int cacheSize = newCacheSize * 4 / 3 + 1;
        this.fCache = new HashMap(cacheSize);
        this.fLRU = new ArrayList(newCacheSize);
    }
}

