/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IProjectLinkListWorkingCopy;
import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.process.common.IProjectLinkHandle;
import com.ibm.team.process.internal.client.InternalProcessClient;
import com.ibm.team.process.internal.client.workingcopies.ExecUtil;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.PropertyWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.UpdateRequest;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.process.internal.common.links.LinkTypes;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectLinkListWorkingCopy
extends PropertyWorkingCopy
implements IProjectLinkListWorkingCopy {
    private final ITeamRepository fCachedTeamRepository;
    private List fWorkingCopy = new ArrayList();
    private List fExistingLinks = new ArrayList();
    private List fAddedLinks = new ArrayList();
    private List fRemovedLinks = new ArrayList();
    private IStatus fBackLinkSaveStatus;
    private List fSubStatus;
    private IDocument fName;
    private String fProjectAreaName;
    private List<SourceProjectInfo> fSourceProjectInfoList = new ArrayList<SourceProjectInfo>();

    public ProjectLinkListWorkingCopy(ITeamRepository teamRepository, IDocument name) {
        this.fCachedTeamRepository = teamRepository;
        this.fName = name;
    }

    @Override
    public List getLinks() {
        return this.fWorkingCopy;
    }

    @Override
    public void dispose() {
        this.fWorkingCopy = null;
        super.dispose();
    }

    @Override
    public synchronized boolean isDisposed() {
        return this.fWorkingCopy == null;
    }

    public void asyncUpdate(final IProjectArea projectArea, final int flags, IUpdateContext context, IProgressMonitor monitor) {
        if (this.isDisposed()) {
            return;
        }
        this.fProjectAreaName = projectArea.getName();
        this.fBackLinkSaveStatus = null;
        this.fSubStatus = new ArrayList();
        UpdateRequest request = new UpdateRequest(Messages.getString("ProjectLinkListWorkingCopy.0")){

            @Override
            public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                if (ProjectLinkListWorkingCopy.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                monitor.beginTask(this.getName(), 1000);
                try {
                    final ArrayList<IProjectLink> links = new ArrayList<IProjectLink>();
                    IProjectLinkHandle[] projectAreaLinks = projectArea.getProjectLinks();
                    IItemManager manager = ProjectLinkListWorkingCopy.this.fCachedTeamRepository.itemManager();
                    List additions = manager.fetchCompleteItems(Arrays.asList(projectAreaLinks), flags, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    for (IProjectLink projectLink : additions) {
                        if (projectLink == null) continue;
                        links.add(projectLink);
                    }
                    if (ProjectLinkListWorkingCopy.this.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!ProjectLinkListWorkingCopy.this.isDisposed()) {
                                List oldLinks = null;
                                ArrayList newLinks = null;
                                oldLinks = ProjectLinkListWorkingCopy.this.fWorkingCopy;
                                newLinks = new ArrayList(links);
                                ProjectLinkListWorkingCopy.this.fWorkingCopy = newLinks;
                                ProjectLinkListWorkingCopy.this.fExistingLinks = new ArrayList(ProjectLinkListWorkingCopy.this.fWorkingCopy);
                                ProjectLinkListWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(ProjectLinkListWorkingCopy.this, "linkList.change", oldLinks, newLinks));
                            }
                        }
                    };
                    if (context != null) {
                        context.execute(runnable);
                    } else {
                        runnable.run();
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException x) {
                    if (ProjectLinkListWorkingCopy.this.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    Status status = new Status(4, "com.ibm.team.process.client", 0, this.getName(), (Throwable)x);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        ExecUtil.asyncExec(request, context, monitor);
    }

    @Override
    public synchronized void removeLinks(IProjectLinkHandle[] links) {
        if (!this.isDisposed()) {
            ArrayList<IProjectLinkHandle> linksRemoved = new ArrayList<IProjectLinkHandle>();
            ArrayList<IProjectLinkHandle> linksToRemove = new ArrayList<IProjectLinkHandle>();
            linksToRemove.addAll(Arrays.asList(links));
            Iterator e = this.fWorkingCopy.iterator();
            while (e.hasNext()) {
                IProjectLinkHandle link = (IProjectLinkHandle)e.next();
                if (!this.hasLink(linksToRemove, link)) continue;
                e.remove();
                if (this.hasLink(this.fAddedLinks, link)) {
                    this.fAddedLinks.remove(link);
                } else {
                    this.fRemovedLinks.add(link);
                }
                linksRemoved.add(link);
            }
            if (!linksRemoved.isEmpty()) {
                this.setDirty(!this.fAddedLinks.isEmpty() || !this.fRemovedLinks.isEmpty(), true);
                this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "linkList.delete", linksRemoved.toArray(), null));
            }
        }
    }

    @Override
    public synchronized void addLinks(IProjectLinkHandle[] links) {
        if (!this.isDisposed()) {
            ArrayList<IProjectLinkHandle> newLinks = new ArrayList<IProjectLinkHandle>();
            int i = 0;
            while (i < links.length) {
                IProjectLinkHandle link = links[i];
                if (!this.hasLink(this.fWorkingCopy, link)) {
                    this.fWorkingCopy.add(link);
                    IProjectLinkHandle removedLink = this.resolveLink(this.fRemovedLinks, link);
                    if (removedLink != null) {
                        this.fRemovedLinks.remove(removedLink);
                    } else if (this.resolveLink(this.fExistingLinks, link) == null) {
                        this.fAddedLinks.add(link);
                    }
                    newLinks.add(link);
                }
                ++i;
            }
            if (!newLinks.isEmpty()) {
                this.setDirty(!this.fAddedLinks.isEmpty() || !this.fRemovedLinks.isEmpty(), true);
                this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "linkList.add", null, newLinks.toArray()));
            }
        }
    }

    private boolean hasLink(List linkList, IProjectLinkHandle linkHandle) {
        return this.resolveLink(linkList, linkHandle) != null;
    }

    public IProjectLinkHandle resolveLink(IProjectLinkHandle linkHandle) {
        return this.resolveLink(this.fWorkingCopy, linkHandle);
    }

    private IProjectLinkHandle resolveLink(List linkList, IProjectLinkHandle linkHandle) {
        for (IProjectLinkHandle existingLinkHandle : linkList) {
            if (existingLinkHandle instanceof IProjectLink && linkHandle instanceof IProjectLink) {
                IProjectLink existingLink = (IProjectLink)existingLinkHandle;
                IProjectLink link = (IProjectLink)linkHandle;
                if (existingLink.getLinkType().equals(link.getLinkType()) && existingLink.getTargetServicesUrl().equals(link.getTargetServicesUrl()) && existingLink.getTargetUrl().equals(link.getTargetUrl())) {
                    return existingLink;
                }
            }
            if (!existingLinkHandle.sameItemId((IItemHandle)linkHandle)) continue;
            return existingLinkHandle;
        }
        return null;
    }

    public void syncSave(IProjectArea mutableProjectArea, List itemsToSave, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fBackLinkSaveStatus = null;
        this.fSubStatus = new ArrayList();
        mutableProjectArea.setProjectLinks(this.fWorkingCopy.toArray(new IProjectLinkHandle[this.fWorkingCopy.size()]));
        if (!this.fAddedLinks.isEmpty()) {
            for (IProjectLink projectAreaLink : this.fAddedLinks) {
                projectAreaLink.setProjectArea((IProjectAreaHandle)mutableProjectArea);
            }
            itemsToSave.addAll(this.fAddedLinks);
        }
    }

    protected void syncSaveBackLinks(IProjectArea projectArea, IProgressMonitor monitor) {
        this.fBackLinkSaveStatus = null;
        this.fSubStatus = new ArrayList();
        monitor.beginTask(Messages.getString("ProjectLinkListWorkingCopy.8"), 1000);
        if (this.fAddedLinks.isEmpty()) {
            monitor.worked(500);
        } else {
            try {
                this.createBackLinks((ProjectArea)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            catch (TeamRepositoryException e) {
                this.fBackLinkSaveStatus = new MultiStatus("com.ibm.team.process.client", 2, this.fSubStatus.toArray(new IStatus[this.fSubStatus.size()]), Messages.getString("ProjectLinkListWorkingCopy.9"), (Throwable)e);
            }
        }
        if (this.fRemovedLinks.isEmpty()) {
            monitor.worked(500);
        } else {
            try {
                this.deleteBackLinks((ProjectArea)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            catch (TeamRepositoryException e) {
                this.fBackLinkSaveStatus = new MultiStatus("com.ibm.team.process.client", 2, this.fSubStatus.toArray(new IStatus[this.fSubStatus.size()]), Messages.getString("ProjectLinkListWorkingCopy.10"), (Throwable)e);
            }
        }
        this.fAddedLinks = new ArrayList();
        this.fRemovedLinks = new ArrayList();
        this.fExistingLinks = new ArrayList(this.fWorkingCopy);
    }

    private void createBackLinks(ProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        MultiStatus creating = new MultiStatus("com.ibm.team.process.client", 1, Messages.getString("ProjectLinkListWorkingCopy.14"), null);
        this.fSubStatus.add(creating);
        monitor.beginTask(Messages.getString("ProjectLinkListWorkingCopy.2"), 1000 * this.fAddedLinks.size());
        for (IProjectLink projectAreaLink : this.fAddedLinks) {
            Status backLinkStatus = new Status(1, "com.ibm.team.process.client", NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.15"), (Object)LinkTypes.getPeerLinkType((String)projectAreaLink.getLinkType()), (Object)projectAreaLink.getLabel()), null);
            creating.add((IStatus)backLinkStatus);
            this.postBackLink(projectAreaLink, (IProjectArea)projectArea, creating, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
    }

    private void deleteBackLinks(ProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        MultiStatus deleting = new MultiStatus("com.ibm.team.process.client", 1, Messages.getString("ProjectLinkListWorkingCopy.1"), null);
        this.fSubStatus.add(deleting);
        monitor.beginTask(Messages.getString("ProjectLinkListWorkingCopy.3"), 1000 * this.fRemovedLinks.size());
        final ITeamRawRestServiceClient rawRestServiceClient = this.fCachedTeamRepository.getRawRestServiceClient();
        String backLinkTargetUrl = this.getBackLinkTargetUrl((IProjectArea)projectArea);
        Iterator iterator = this.fRemovedLinks.iterator();
        while (iterator.hasNext()) {
            IProjectLink projectAreaLink = (IProjectLink)iterator.next();
            final String targetConsumerRegistryUrl = projectAreaLink.getTargetConsumerRegistryUrl();
            if (targetConsumerRegistryUrl != null && targetConsumerRegistryUrl.trim().length() > 0) {
                final String linkType = LinkTypes.getPeerLinkType((String)projectAreaLink.getLinkType());
                Status backLinkStatus = new Status(1, "com.ibm.team.process.client", NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.21"), (Object)linkType, (Object)targetConsumerRegistryUrl), null);
                deleting.add((IStatus)backLinkStatus);
                final String deleteBackLinkUrl = String.valueOf(targetConsumerRegistryUrl) + "?type=" + linkType + "&resource=" + backLinkTargetUrl;
                IClientLibraryContext.IServiceRunnable block = new IClientLibraryContext.IServiceRunnable(){

                    public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                        ITeamRawRestServiceClient.IRawRestClientConnection connection = null;
                        try {
                            URI url = new URI(deleteBackLinkUrl);
                            connection = rawRestServiceClient.getConnection(url);
                            return connection.doDelete();
                        }
                        catch (URISyntaxException e1) {
                            throw new TeamRepositoryException(e1.getMessage(), (Throwable)e1);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            throw new TeamRepositoryException(NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.22"), (Object)linkType, (Object)targetConsumerRegistryUrl));
                        }
                    }
                };
                ITeamRawRestServiceClient.IRawRestClientConnection.Response response = (ITeamRawRestServiceClient.IRawRestClientConnection.Response)((IClientLibraryContext)this.fCachedTeamRepository).callCancelableService(block, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                String failureMessage = Messages.getString("ProjectLinkListWorkingCopy.4");
                this.handleResponse(response, failureMessage);
                deleting.add((IStatus)new Status(1, "com.ibm.team.process.client", NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.23"), (Object)linkType, (Object)targetConsumerRegistryUrl)));
            }
            iterator.remove();
        }
    }

    private void handleResponse(ITeamRawRestServiceClient.IRawRestClientConnection.Response response, String failureMessage) throws TeamRepositoryException {
        if (response.getStatusCode() != 200 && response.getStatusCode() != 201 && response.getStatusCode() != 202) {
            throw new TeamRepositoryException(failureMessage);
        }
    }

    private String getBackLinkTargetUrl(IProjectArea area) {
        return String.valueOf(this.fCachedTeamRepository.getRepositoryURI()) + "process/project-areas/" + area.getItemId().getUuidValue();
    }

    private void postBackLink(final IProjectLink projectAreaLink, final IProjectArea projectArea, MultiStatus creating, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        final String backLinkConsumerRegistryUrl = projectAreaLink.getTargetConsumerRegistryUrl();
        if (backLinkConsumerRegistryUrl == null || backLinkConsumerRegistryUrl.length() == 0) {
            Status status = new Status(1, "com.ibm.team.process.client", Messages.getString("ProjectLinkListWorkingCopy.16"));
            creating.add((IStatus)status);
            return;
        }
        String peerLinkType = LinkTypes.getPeerLinkType((String)projectAreaLink.getLinkType());
        String servicesUrlString = null;
        String consumerRegistry = null;
        for (SourceProjectInfo sourceProjectInfo : this.fSourceProjectInfoList) {
            if (sourceProjectInfo.fTagName == null || !sourceProjectInfo.fTagName.equals(LinkTypes.getTagNameForLinkType((String)peerLinkType))) continue;
            servicesUrlString = sourceProjectInfo.fServiceUrl;
            consumerRegistry = sourceProjectInfo.fConsumerRegistryUrl;
        }
        if (servicesUrlString == null) {
            creating.add((IStatus)new Status(2, "com.ibm.team.process.client", NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.13"), (Object)peerLinkType)));
            return;
        }
        final String finalServicesUrlString = servicesUrlString;
        final String finalConsumerRegistry = consumerRegistry;
        final String failureMessage = NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.7"), (Object)peerLinkType, (Object)backLinkConsumerRegistryUrl);
        creating.add((IStatus)new Status(1, "com.ibm.team.process.client", NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.19"), (Object)peerLinkType, (Object)backLinkConsumerRegistryUrl)));
        IClientLibraryContext.IServiceRunnable block = new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ITeamRawRestServiceClient.IRawRestClientConnection connection = null;
                try {
                    URI url = new URI(backLinkConsumerRegistryUrl);
                    connection = ProjectLinkListWorkingCopy.this.fCachedTeamRepository.getRawRestServiceClient().getConnection(url);
                    String projectAreaBackLinkPostData = ProjectLinkListWorkingCopy.this.getProjectAreaBackLinkPostData(projectAreaLink, projectArea, finalServicesUrlString, finalConsumerRegistry);
                    byte[] data = projectAreaBackLinkPostData.getBytes("UTF-8");
                    ByteArrayInputStream content = new ByteArrayInputStream(data);
                    ITeamRawRestServiceClient.IRawRestClientConnection.Response resp = connection.doPost((InputStream)content, (long)data.length, "application/xml;charset=UTF-8");
                    return resp;
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (TeamRepositoryException e) {
                    throw new TeamRepositoryException(failureMessage, (Throwable)e);
                }
            }
        };
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = (ITeamRawRestServiceClient.IRawRestClientConnection.Response)((IClientLibraryContext)this.fCachedTeamRepository).callCancelableService(block, monitor);
        this.handleResponse(response, failureMessage);
        creating.add((IStatus)new Status(1, "com.ibm.team.process.client", NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.20"), (Object)peerLinkType, (Object)backLinkConsumerRegistryUrl)));
    }

    public Document readRootServicesXml(String rootServicesXmlUrl, IProgressMonitor monitor) throws TeamRepositoryException {
        String failureMessage = NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.5"), (Object)rootServicesXmlUrl);
        IClientLibraryContext.IServiceRunnable block = this.rawRestDoGetBlock(rootServicesXmlUrl, failureMessage);
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = (ITeamRawRestServiceClient.IRawRestClientConnection.Response)((IClientLibraryContext)this.fCachedTeamRepository).callCancelableService(block, monitor);
        this.handleResponse(response, failureMessage);
        String rootServicesXml = this.readResponse(response);
        return this.constructDocument(rootServicesXml);
    }

    public Document readRootServicesXml(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.readRootServicesXml(this.getRootServicesXmlURI(), monitor);
    }

    public Document readFriendsXML(NodeList descriptionNodeChildren, IProgressMonitor monitor) throws TeamRepositoryException {
        Node friendsNode = this.getNode(descriptionNodeChildren, "friends", "http://jazz.net/xmlns/prod/jazz/discovery/1.0/");
        Node friendsResourceNode = this.getAttributeNode(friendsNode, "resource", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        String friendsResourceURLString = friendsResourceNode.getTextContent();
        String failureMessage = NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.24"), (Object)friendsResourceURLString);
        IClientLibraryContext.IServiceRunnable block = this.rawRestDoGetBlock(friendsResourceURLString, failureMessage);
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = (ITeamRawRestServiceClient.IRawRestClientConnection.Response)((IClientLibraryContext)this.fCachedTeamRepository).callCancelableService(block, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
        this.handleResponse(response, failureMessage);
        String friendsListingXml = this.readResponse(response);
        return this.constructDocument(friendsListingXml);
    }

    private String getRootServicesXmlURI() {
        String rootServicesXml;
        String property = System.getProperty("testdiscovery");
        if (property != null && property.equals("true")) {
            rootServicesXml = "processexample/rootservices.xml";
        } else {
            String repositoryURI = this.fCachedTeamRepository.getRepositoryURI();
            rootServicesXml = String.valueOf(repositoryURI) + "rootservices";
        }
        return rootServicesXml;
    }

    public String getFrontingServerRootServicesResource(IProgressMonitor monitor, NodeList descriptionNodeChildren) throws TeamRepositoryException {
        Document friendsListingXmlDocument = this.readFriendsXML(descriptionNodeChildren, monitor);
        NodeList children = friendsListingXmlDocument.getChildNodes();
        Node rdfNode = this.getNode(children, "RDF", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        List<Node> allFriends = this.getNodes(rdfNode.getChildNodes(), "Friend", "http://jazz.net/xmlns/prod/jazz/discovery/1.0/");
        String frontingServerRootServicesResource = null;
        for (Node friend : allFriends) {
            NodeList friendChildren = friend.getChildNodes();
            Node specialNode = this.getNode(friendChildren, "internal", "http://jazz.net/xmlns/prod/jazz/jfs/1.0/");
            if (specialNode == null || !"true".equals(specialNode.getTextContent())) continue;
            Node rootServicesNode = this.getNode(friendChildren, "rootServices", "http://jazz.net/xmlns/prod/jazz/discovery/1.0/");
            Node rootServicesResourceNode = this.getAttributeNode(rootServicesNode, "resource", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            frontingServerRootServicesResource = rootServicesResourceNode.getTextContent();
            break;
        }
        return frontingServerRootServicesResource;
    }

    private IClientLibraryContext.IServiceRunnable rawRestDoGetBlock(final String resourceUrlString, final String failureMessage) {
        IClientLibraryContext.IServiceRunnable block = new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                ITeamRawRestServiceClient.IRawRestClientConnection connection = null;
                try {
                    URI url = new URI(resourceUrlString);
                    connection = ProjectLinkListWorkingCopy.this.fCachedTeamRepository.getRawRestServiceClient().getConnection(url);
                    return connection.doGet();
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (TeamRepositoryException e) {
                    throw new TeamRepositoryException(failureMessage, (Throwable)e);
                }
            }
        };
        return block;
    }

    public String readResponse(ITeamRawRestServiceClient.IRawRestClientConnection.Response response) throws TeamRepositoryException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(8192);
            InputStream stream = response.getResponseStream();
            byte[] bytes = new byte[8192];
            try {
                int ch = stream.read(bytes);
                while (ch != -1) {
                    buffer.write(bytes, 0, ch);
                    ch = stream.read(bytes);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            return buffer.toString("UTF-8");
        }
        catch (IOException e) {
            throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public Document constructDocument(String xmlDocumentContent) throws TeamRepositoryException {
        Document xmlDocument = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlDocumentContent.getBytes("UTF-8"));
            xmlDocument = docBuilder.parse(bais);
        }
        catch (IllegalArgumentException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (DOMException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (ParserConfigurationException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (SAXException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (IOException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        return xmlDocument;
    }

    public Node getNode(NodeList nodes, String baseName, String namespaceURI) {
        Node matchingNode = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String nodeLocalName = node.getLocalName();
            String nodeNamespaceURI = node.getNamespaceURI();
            if (baseName.equals(nodeLocalName) && namespaceURI.equals(nodeNamespaceURI)) {
                matchingNode = node;
                break;
            }
            ++i;
        }
        return matchingNode;
    }

    public List<Node> getNodes(NodeList nodes, String baseName, String namespaceURI) {
        ArrayList<Node> matchingNodes = new ArrayList<Node>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String nodeLocalName = node.getLocalName();
            String nodeNamespaceURI = node.getNamespaceURI();
            if (baseName.equals(nodeLocalName) && namespaceURI.equals(nodeNamespaceURI)) {
                matchingNodes.add(node);
            }
            ++i;
        }
        return matchingNodes;
    }

    public Node getAttributeNode(Node node, String localName, String namespace) {
        NamedNodeMap attributes = node.getAttributes();
        return attributes.getNamedItemNS(namespace, localName);
    }

    public String getAttributeValue(Node node, String localName, String namespace) {
        Node attrNode = this.getAttributeNode(node, localName, namespace);
        if (attrNode != null) {
            return attrNode.getTextContent();
        }
        return null;
    }

    private String getProjectAreaBackLinkPostData(IProjectLink projectAreaLink, IProjectArea projectArea, String servicesUrl, String consumerRegistryUrl) throws TeamRepositoryException {
        String label = this.toXmlEncoded(projectArea.getName());
        String linkType = LinkTypes.getPeerLinkType((String)projectAreaLink.getLinkType());
        String backLinkTargetUrl = this.getBackLinkTargetUrl(projectArea);
        return this.getPostData(linkType, label, backLinkTargetUrl, servicesUrl, consumerRegistryUrl);
    }

    public String toXmlEncoded(String plainText) {
        String xmlText = plainText;
        xmlText = xmlText.replace("&", "&amp;");
        xmlText = xmlText.replace("\"", "&quot;");
        xmlText = xmlText.replace("<", "&lt;");
        xmlText = xmlText.replace(">", "&gt;");
        return xmlText;
    }

    private String getPostData(String linkType, String label, String targetUrl, String servicesUrl, String consumerRegistryUrl) {
        String postData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<jp:link \nxmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\nxmlns:jp=\"http://jazz.net/xmlns/prod/jazz/process/1.0/\"\nxmlns:dc=\"http://purl.org/dc/terms/\"\nxmlns:oslc=\"http://open-services.net/xmlns/discovery/1.0/\">\n<jp:link-type>" + linkType + "</jp:link-type>\n" + "<oslc:ServiceProvider>\n" + "<dc:title>" + label + "</dc:title>\n" + "<oslc:details rdf:resource=\"" + targetUrl + "\"/>\n" + "<oslc:services rdf:resource=\"" + servicesUrl + "\"/>\n";
        if (consumerRegistryUrl != null) {
            postData = String.valueOf(postData) + "<jp:consumerRegistry rdf:resource=\"" + consumerRegistryUrl + "\"/>\n";
        }
        postData = String.valueOf(postData) + "</oslc:ServiceProvider>\n</jp:link>";
        return postData;
    }

    @Override
    public IStatus getBackLinkSaveStatus() {
        return this.fBackLinkSaveStatus;
    }

    public String getProjectAreaName() {
        return this.fName.get();
    }

    public String getOriginalProjectAreaName() {
        return this.fProjectAreaName;
    }

    public void setOriginalProjectAreaName(String name) {
        this.fProjectAreaName = name;
    }

    public ServiceProviderCatalogEntry parseServiceProviderCatalogV2Entry(Node serviceProviderCatalogNode) throws TeamRepositoryException {
        Node domainNode = this.getNode(serviceProviderCatalogNode.getChildNodes(), "domain", "http://open-services.net/ns/core#");
        if (domainNode == null) {
            throw new TeamRepositoryException(Messages.getString("ProjectLinkListWorkingCopy.25"));
        }
        Node domainResourceAttributNode = this.getAttributeNode(domainNode, "resource", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        if (domainResourceAttributNode == null) {
            throw new TeamRepositoryException(Messages.getString("ProjectLinkListWorkingCopy.26"));
        }
        String domain = domainResourceAttributNode.getTextContent();
        Node aboutAttributNode = this.getAttributeNode(serviceProviderCatalogNode, "about", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        if (aboutAttributNode == null) {
            throw new TeamRepositoryException(Messages.getString("ProjectLinkListWorkingCopy.28"));
        }
        String about = aboutAttributNode.getTextContent();
        return new ServiceProviderCatalogEntry("ServiceProviderCatalog", domain, about);
    }

    public ServiceProviderCatalogEntry getMappedPreCoreEntry(ServiceProviderCatalogEntry v2Entry) throws TeamRepositoryException {
        String mappedTagName = LinkTypes.getMappedPreCoreTagName((String)v2Entry.getNameSpace());
        String mappedNamespace = LinkTypes.getMappedPreCoreNamespace((String)v2Entry.getNameSpace());
        if (mappedTagName == null || mappedNamespace == null) {
            InternalProcessClient.log(new TeamRepositoryException(NLS.bind((String)Messages.getString("ProjectLinkListWorkingCopy.27"), (Object)v2Entry.getNameSpace())));
            return null;
        }
        return new ServiceProviderCatalogEntry(mappedTagName, mappedNamespace, v2Entry.getResourceUrl());
    }

    public List<ServiceProviderCatalogEntry> getPreCoreServicesProviderCatalogEntries(NodeList descriptionNodeChildren) throws TeamRepositoryException {
        ArrayList<ServiceProviderCatalogEntry> catalogEnties = new ArrayList<ServiceProviderCatalogEntry>();
        String[] tagNames = LinkTypes.PROVIDERS;
        String[] namesSpaces = LinkTypes.PROVIDER_NAMESPACES;
        int i = 0;
        while (i < tagNames.length) {
            String tagName = tagNames[i];
            String namespace = namesSpaces[i];
            Node serviceProviderCatalog = this.getNode(descriptionNodeChildren, tagName, namespace);
            if (serviceProviderCatalog != null) {
                Node serviceProviderResourceNode = this.getAttributeNode(serviceProviderCatalog, "resource", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                String serviceProviderResource = serviceProviderResourceNode.getTextContent();
                catalogEnties.add(new ServiceProviderCatalogEntry(tagName, namespace, serviceProviderResource));
            }
            ++i;
        }
        return catalogEnties;
    }

    public List<ServiceProviderCatalogEntry> getCoreServicesProviderCatalogEntries(NodeList descriptionNodeChildren) throws TeamRepositoryException {
        ArrayList<ServiceProviderCatalogEntry> catalogEnties = new ArrayList<ServiceProviderCatalogEntry>();
        List<Node> catalogNodes = this.getNodes(descriptionNodeChildren, "oslcCatalogs", "http://jazz.net/xmlns/prod/jazz/discovery/1.0/");
        if (catalogNodes != null && catalogNodes.size() > 0) {
            for (Node oslcCatalog : catalogNodes) {
                List<Node> innerServiceProviderCatalogs = this.getNodes(oslcCatalog.getChildNodes(), "ServiceProviderCatalog", "http://open-services.net/ns/core#");
                for (Node innerServiceProviderCatalogNode : innerServiceProviderCatalogs) {
                    ServiceProviderCatalogEntry entry = this.getMappedPreCoreEntry(this.parseServiceProviderCatalogV2Entry(innerServiceProviderCatalogNode));
                    if (entry == null) continue;
                    catalogEnties.add(entry);
                }
            }
        }
        return catalogEnties;
    }

    public List<ServiceProviderCatalogEntry> getAllUniqueServicesProviderCatalogEntries(NodeList descriptionNodeChildren) throws TeamRepositoryException {
        List<ServiceProviderCatalogEntry> catalogEnties = new ArrayList<ServiceProviderCatalogEntry>();
        catalogEnties.addAll(this.getCoreServicesProviderCatalogEntries(descriptionNodeChildren));
        catalogEnties = this.removeDuplicatedEntries(catalogEnties);
        List<ServiceProviderCatalogEntry> preCoreEntries = this.getPreCoreServicesProviderCatalogEntries(descriptionNodeChildren);
        for (ServiceProviderCatalogEntry entry : preCoreEntries) {
            if (this.isDuplicatedServiceCatalogEntry(entry, catalogEnties)) continue;
            catalogEnties.add(entry);
        }
        return catalogEnties;
    }

    public boolean isDuplicatedServiceCatalogEntry(ServiceProviderCatalogEntry entry, List<ServiceProviderCatalogEntry> existedEnties) {
        for (ServiceProviderCatalogEntry existedEntry : existedEnties) {
            if (!entry.getTagName().equals(existedEntry.getTagName())) continue;
            return true;
        }
        return false;
    }

    private List<ServiceProviderCatalogEntry> removeDuplicatedEntries(List<ServiceProviderCatalogEntry> catalogEnties) {
        ArrayList<ServiceProviderCatalogEntry> existedCatalogs = new ArrayList<ServiceProviderCatalogEntry>();
        for (ServiceProviderCatalogEntry entry : catalogEnties) {
            if (this.isDuplicatedServiceCatalogEntry(entry, existedCatalogs)) continue;
            existedCatalogs.add(entry);
        }
        return existedCatalogs;
    }

    public void addSourceProjectInfo(String serviceUrl, String consumerRegistryUrl, String tagName) {
        boolean isDuplicated = false;
        if (tagName == null || serviceUrl == null) {
            return;
        }
        for (SourceProjectInfo existingSourceProjectInfo : this.fSourceProjectInfoList) {
            if (!tagName.equals(existingSourceProjectInfo.fTagName)) continue;
            isDuplicated = true;
            break;
        }
        if (!isDuplicated) {
            this.fSourceProjectInfoList.add(new SourceProjectInfo(serviceUrl, consumerRegistryUrl, tagName));
        }
    }

    public class ServiceProviderCatalogEntry {
        private String tagName;
        private String nameSpace;
        private String resourceUrl;

        private ServiceProviderCatalogEntry(String tagName, String nameSpace, String resourceUrl) {
            this.tagName = tagName;
            this.nameSpace = nameSpace;
            this.resourceUrl = resourceUrl;
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getNameSpace() {
            return this.nameSpace;
        }

        public String getResourceUrl() {
            return this.resourceUrl;
        }
    }

    public class SourceProjectInfo {
        private String fServiceUrl;
        private String fConsumerRegistryUrl;
        private String fTagName;

        public SourceProjectInfo(String serviceUrl, String consumerRegistryUrl, String tagName) {
            this.fServiceUrl = serviceUrl;
            this.fConsumerRegistryUrl = consumerRegistryUrl;
            this.fTagName = tagName;
        }
    }
}

