/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.ant.com.urbancode.commons.xml.marshall;

import com.urbancode.air.plugin.ant.com.urbancode.commons.xml.DOMUtils;
import com.urbancode.air.plugin.ant.com.urbancode.commons.xml.marshall.MarshallingContext;
import com.urbancode.air.plugin.ant.com.urbancode.commons.xml.marshall.MarshallingRuntimeException;
import com.urbancode.air.plugin.ant.com.urbancode.commons.xml.marshall.XmlMarshallerBase;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MarshallingEngine {
    private Map name2marshaller = new HashMap();

    protected MarshallingEngine() {
    }

    public void registerMarshaller(XmlMarshallerBase marshaller) {
        this.name2marshaller.put(marshaller.getName(), marshaller);
    }

    public void unmarshall(InputStream inStream, MarshallingContext context) throws MarshallingRuntimeException {
        if (inStream != null) {
            try {
                Document doc = DOMUtils.loadDocument(inStream);
                Element rootElement = doc.getDocumentElement();
                this.unmarshall(rootElement, context);
            }
            catch (Exception e) {
                throw new MarshallingRuntimeException(e);
            }
        }
    }

    public void unmarshall(Element element, MarshallingContext context) throws MarshallingRuntimeException {
        XmlMarshallerBase marshaller = this.getMarshaller(element);
        if (marshaller == null) {
            throw new IllegalStateException("Marshaller not registered for element: " + element.getTagName());
        }
        context.setEngine(this);
        marshaller.unmarshall(element, context);
    }

    public void unmarshallChildElements(Element element, MarshallingContext context) throws MarshallingRuntimeException {
        NodeList childNodeList = element.getChildNodes();
        Node childNode = null;
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            childNode = childNodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            this.unmarshall((Element)childNode, context);
        }
    }

    public XmlMarshallerBase getMarshaller(Element element) {
        XmlMarshallerBase result = (XmlMarshallerBase)this.name2marshaller.get(element.getTagName());
        return result;
    }
}

