/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.HttpUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.impl.auth.SPNegoScheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class AdaptedSPNegoScheme
extends SPNegoScheme {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String NEGOTIATE = ": Negotiate ";

    public AdaptedSPNegoScheme() {
    }

    public AdaptedSPNegoScheme(boolean stripPort) {
        super(stripPort);
    }

    protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer) throws GSSException {
        byte[] token = input;
        if (token == null) {
            token = new byte[]{};
        }
        GSSManager manager = this.getManager();
        GSSName serverName = manager.createName("HTTP@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
        GSSContext gssContext = manager.createContext(serverName.canonicalize(oid), oid, null, Integer.MAX_VALUE);
        gssContext.requestMutualAuth(true);
        gssContext.requestCredDeleg(true);
        return gssContext.initSecContext(token, 0, token.length);
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        Header oldHeader = super.authenticate(credentials, request, context);
        String oldHeaderStr = oldHeader.toString();
        String startOfAuthenticationHeader = this.isProxy() ? "Proxy-Authorization: Negotiate " : "Authorization: Negotiate ";
        String oldTokenStr = oldHeaderStr.substring(startOfAuthenticationHeader.length()).trim();
        byte[] bytesInPlatform = oldTokenStr.getBytes();
        String newTokenstr = new String(bytesInPlatform, HttpUtil.CharsetEncoding.UTF8.toCharset());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Corrected response to use '" + newTokenstr + "'"));
        }
        CharArrayBuffer newBuffer = new CharArrayBuffer(32);
        newBuffer.append(startOfAuthenticationHeader);
        newBuffer.append(newTokenstr);
        return new BufferedHeader(newBuffer);
    }
}

