/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import java.net.Socket;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class SSLUtils {
    private static final Log _log = LogFactory.getLog(SSLUtils.class);
    public static final String VALIDATE_CERTS_PROP = "com.ibm.team.clm.ssl.validateCertificates";
    public static final String USE_SECURE_TRUST_MANAGER_PROP = "com.ibm.team.clm.ssl.useSecureTrustManager";
    public static final String USE_SECURE_HOSTNAME_VERIFIER_PROP = "com.ibm.team.clm.ssl.useSecureHostnameVerifier";
    public static final String CLIENT_SSL_PROTOCOL_PROPERTY = "com.ibm.team.repository.transport.client.protocol";
    private static final TrustingTrustManager trustingTM = new TrustingTrustManager();
    public static final List<String> DEFAULT_PROTOCOLS = Arrays.asList("SSL_TLS", "TLS", "SSL");

    public static boolean isValidateCertificates() {
        String p = System.getProperty(VALIDATE_CERTS_PROP, "false");
        return Boolean.parseBoolean(p);
    }

    public static boolean isUseSecureTrustManager() {
        String p = System.getProperty(USE_SECURE_TRUST_MANAGER_PROP);
        return p == null ? SSLUtils.isValidateCertificates() : Boolean.parseBoolean(p);
    }

    public static boolean isUseSecureHostnameVerifier() {
        String p = System.getProperty(USE_SECURE_HOSTNAME_VERIFIER_PROP);
        return p == null ? SSLUtils.isValidateCertificates() : Boolean.parseBoolean(p);
    }

    public static SSLSocketFactory createSocketFactory() {
        return new SSLSocketFactory(SSLUtils.createSSLContext(SSLUtils.getDefaultTrustManager()), SSLUtils.getDefaultX509HostnameVerifier());
    }

    public static SSLContext createSSLContext() {
        return SSLUtils.createSSLContext(SSLUtils.getSSLProtocols(null), null, (TrustManager)SSLUtils.getDefaultTrustManager());
    }

    public static SSLContext createSSLContext(TrustManager trustManager) {
        return SSLUtils.createSSLContext(SSLUtils.getSSLProtocols(null), null, trustManager);
    }

    public static SSLContext createSSLContext(List<String> protocols, KeyManager[] keyManagers, TrustManager trustManager) {
        SSLUtils.logDebug("SSL Algorithm Priority: " + protocols);
        SSLContext context = null;
        for (String protocol : SSLUtils.getSSLProtocols(protocols)) {
            context = SSLUtils.createSSLContext(protocol, keyManagers, trustManager);
            if (context != null) {
                return context;
            }
            SSLUtils.logDebug(MessageFormat.format("Failed to create {0} context", protocol));
        }
        SSLUtils.logDebug("No acceptable encryption algorithm found");
        throw new RuntimeException("No acceptable encryption algorithm found");
    }

    public static SSLContext createSSLContext(KeyManager[] keyManagers, TrustManager trustManager) {
        return SSLUtils.createSSLContext(null, keyManagers, trustManager);
    }

    public static SSLContext createSSLContext(String protocol, KeyManager[] keyManagers, TrustManager trustManager) {
        SSLContext context;
        SSLUtils.logDebug(MessageFormat.format("Creating {0} context", protocol));
        try {
            TrustManager[] trustManagerArray;
            context = SSLContext.getInstance(protocol);
            if (trustManager == null) {
                trustManagerArray = null;
            } else {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = trustManager;
            }
            context.init(keyManagers, trustManagerArray, null);
            Socket s = context.getSocketFactory().createSocket();
            s.close();
        }
        catch (Throwable t) {
            SSLUtils.logDebug(t.getMessage(), t);
            return null;
        }
        return context;
    }

    public static List<String> getSSLProtocols(List<String> protocols) {
        if (protocols == null) {
            String protocol = System.getProperty(CLIENT_SSL_PROTOCOL_PROPERTY);
            if (protocol != null) {
                return Arrays.asList(protocol);
            }
            return DEFAULT_PROTOCOLS;
        }
        return protocols;
    }

    public static X509TrustManager getDefaultTrustManager() {
        return SSLUtils.isUseSecureTrustManager() ? SSLUtils.getSecureTrustManager() : SSLUtils.getTrustingTrustManager();
    }

    public static X509TrustManager getTrustingTrustManager() {
        return trustingTM;
    }

    public static X509TrustManager getSecureTrustManager() {
        return null;
    }

    public static X509HostnameVerifier getDefaultX509HostnameVerifier() {
        return SSLUtils.isUseSecureHostnameVerifier() ? SSLUtils.getSecureX509HostNameverifier() : SSLUtils.getTrustingX509HostnameVerifier();
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return SSLUtils.getDefaultX509HostnameVerifier();
    }

    public static X509HostnameVerifier getTrustingX509HostnameVerifier() {
        return SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
    }

    public static X509HostnameVerifier getSecureX509HostNameverifier() {
        return SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
    }

    private static void logDebug(String message) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)message);
        }
    }

    private static void logDebug(String message, Throwable t) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)message, t);
        }
    }

    private static class TrustingTrustManager
    implements X509TrustManager {
        private static final X509Certificate[] emptyArray = new X509Certificate[0];

        private TrustingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return emptyArray;
        }
    }
}

