/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate.types;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{1};
    }

    public Class<UUID> returnedClass() {
        return UUID.class;
    }

    public boolean equals(Object a, Object b) throws HibernateException {
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode(Object o) throws HibernateException {
        return o.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        UUID uuid = null;
        String s = rs.getString(names[0]);
        if (s != null) {
            uuid = UUID.fromString(s);
        }
        return uuid;
    }

    public void nullSafeSet(PreparedStatement stmt, Object value, int index) throws HibernateException, SQLException {
        if (value != null) {
            if (!(value instanceof UUID)) {
                throw new HibernateException("Unable to assign UUID to column[" + index + "].");
            }
            stmt.setString(index, ((UUID)value).toString());
        } else {
            stmt.setNull(index, this.sqlTypes()[0]);
        }
    }

    public Object deepCopy(Object uuid) throws HibernateException {
        return uuid;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object obj) throws HibernateException {
        return (UUID)obj;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

