/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet_def;

import com.urbancode.air.property.PropertyConfiguration;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryRegistry;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroup;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.xml.DOMUtils;
import com.urbancode.commons.xml.DocumentBuilderFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hibernate.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PropSheetDefLoader {
    private File inputFile;

    public PropSheetDefLoader(File inputFile) {
        if (inputFile == null) {
            throw new NullPointerException("Input File cannont be null!");
        }
        this.inputFile = inputFile;
    }

    public PropSheetDef load(PropSheetGroup propSheetGroup, Element rootElement) {
        if (!rootElement.getTagName().equals("property-def-group")) {
            throw new RuntimeException("Not a property-def-group xml!");
        }
        String name = rootElement.getAttribute("name");
        PropSheetDef result = propSheetGroup.getPropSheetDef(name);
        if (result != null) {
            List<PropDef> removals = result.getDirectPropDefList();
            for (Element propDefElement : DOMUtils.getChildElementList((Element)rootElement, (String)"property")) {
                PropDef propDef = this.readPropertyDefintion(propDefElement, result);
                String propName = propDef.getName();
                PropDef existingPropDef = result.getPropDef(propName);
                if (existingPropDef == null) {
                    result.addPropDef(propDef);
                    continue;
                }
                removals.remove(existingPropDef);
                existingPropDef.setDescription(propDef.getDescription());
                existingPropDef.setPlaceholder(propDef.getPlaceholder());
                existingPropDef.setDefaultValue(propDef.getDefaultValue());
                existingPropDef.setLabel(propDef.getLabel());
                existingPropDef.setPattern(propDef.getPattern());
                existingPropDef.setHidden(propDef.isHidden());
                existingPropDef.setRequired(propDef.isRequired());
                existingPropDef.setType(propDef.getType());
                existingPropDef.removeAllAllowedValues();
                for (PropDefAllowedValue val : propDef.getAllowedValues()) {
                    existingPropDef.addAllowedValue(val.getValue(), val.getLabel());
                }
            }
            for (PropDef remove : removals) {
                result.removePropDef(remove);
            }
        } else {
            result = PropSheetDefFactoryRegistry.getFactory().createPropSheetDef(propSheetGroup, name);
            this.getSession().save((Object)result);
            for (Element propDefElement : DOMUtils.getChildElementList((Element)rootElement, (String)"property")) {
                PropDef propDef = this.readPropertyDefintion(propDefElement, result);
                result.addPropDef(propDef);
            }
            this.getSession().save((Object)result);
        }
        return result;
    }

    public PropDef readPropertyDefintion(Element eprop, PropSheetDef group) {
        Element uiElement = DOMUtils.getFirstChild((Element)eprop, (String)"property-ui");
        String pType = uiElement.getAttribute("type");
        pType = pType.equals("checkBox") ? "checkbox" : (pType.equals("textAreaBox") ? "textarea" : pType.substring(0, pType.length() - "Box".length()));
        boolean pRequired = Boolean.valueOf(eprop.getAttribute("required"));
        String pName = eprop.getAttribute("name");
        String pDescription = uiElement.getAttribute("description");
        String pPlaceholder = uiElement.getAttribute("placeholder");
        String pLabel = StringUtil.trimToNull((String)uiElement.getAttribute("label"));
        String pPattern = StringUtil.trimToNull((String)uiElement.getAttribute("pattern"));
        String pDefaultValue = StringUtil.trimToNull((String)uiElement.getAttribute("default-value"));
        boolean pHidden = Boolean.valueOf(uiElement.getAttribute("hidden"));
        PropDef.PropDefType pDefType = PropDef.PropDefType.valueOf(pType.toUpperCase(Locale.US).replace("-", "_"));
        PropDef prop = new PropDef(group, pName);
        prop.setType(pDefType);
        prop.setDescription(pDescription);
        prop.setPlaceholder(pPlaceholder);
        prop.setLabel(pLabel);
        prop.setPattern(pPattern);
        prop.setDefaultValue(pDefaultValue);
        prop.setRequired(pRequired);
        prop.setHidden(pHidden);
        if (pRequired && pHidden) {
            throw new RuntimeException("Properties can not be both required and hidden (property " + pName + ")");
        }
        if (pDefType.hasAllowedValues()) {
            for (Element valueElem : DOMUtils.getChildElementList((Element)eprop, (String)"value")) {
                String value = DOMUtils.getChildText((Element)valueElem);
                String label = StringUtil.trimToNull((String)valueElem.getAttribute("label"));
                prop.addAllowedValue(value, label);
            }
        }
        return prop;
    }

    public Element getRootElement() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(this.inputFile);
        Element rootElement = doc.getDocumentElement();
        return rootElement;
    }

    private Session getSession() {
        PropertyConfiguration config = PropertyConfiguration.getInstance();
        return config.getSessionLookup().getSession();
    }
}

