/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.web.rest;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.PropertyConfiguration;
import com.urbancode.air.property.lookup.PropSheetHelpersLookup;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.http.HttpPropInfoHelper;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactory;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryRegistry;
import com.urbancode.air.property.web.param.PropSheetDefParam;
import com.urbancode.air.property.web.rest.PropDefResource;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.webext.util.AbstractResource;
import com.urbancode.commons.webext.util.JSONOutputType;
import com.urbancode.commons.webext.util.JSONUtilities;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.hibernate.FlushMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="propSheetDef")
public class PropSheetDefResource
extends AbstractResource<PropSheetDef> {
    private static PropSheetDefResource instance = new PropSheetDefResource();

    public static PropSheetDefResource getInstance() {
        return instance;
    }

    protected JSONObject getBasicJSON(PropSheetDef propSheetDef) throws Exception {
        JSONObject result = new JSONObject();
        result.put("id", (Object)propSheetDef.getId());
        result.put("name", (Object)propSheetDef.getName());
        result.put("description", (Object)propSheetDef.getDescription());
        if (propSheetDef.isVersioned()) {
            result.put("path", (Object)propSheetDef.getPersistenceData().getPath());
            result.put("version", propSheetDef.getPersistenceData().getRelativeVersion());
            result.put("versionCount", propSheetDef.getPersistenceData().getVersionCount());
            result.put("commit", propSheetDef.getPersistenceData().getCommit());
            result.put("resolveHttpValuesUrl", (Object)("property/propSheetDef/" + URLEncoder.encode(propSheetDef.getPersistenceData().getPath().replace('/', '&'), "UTF-8") + ".-1/resolveHttpValues"));
            result.put("versioned", true);
        } else {
            result.put("versioned", false);
            result.put("resolveHttpValuesUrl", (Object)("property/propSheetDef/" + propSheetDef.getId() + "/resolveHttpValues"));
        }
        return result;
    }

    @PUT
    @Produces(value={"application/json"})
    public JSONObject createPropSheetDef(String input) throws Exception {
        PropSheetDefFactory factory = PropSheetDefFactoryRegistry.getFactory();
        PropSheetDef propSheetDef = factory.createPropSheetDef(null, null);
        JSONObject submittedJson = new JSONObject(input);
        this.setValuesFromJSON(propSheetDef, submittedJson);
        return this.toJSON((Object)propSheetDef, new JSONOutputType[]{JSONOutputType.BASIC});
    }

    @GET
    @Path(value="{propSheetDef}")
    @Produces(value={"application/json"})
    public JSONObject getPropSheetDef(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam) throws Exception {
        PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
        return this.toJSON((Object)propSheetDef, new JSONOutputType[]{JSONOutputType.ALL});
    }

    @PUT
    @Path(value="{propSheetDef}")
    @Produces(value={"application/json"})
    public JSONObject updatePropSheetDef(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam, String input) throws Exception {
        PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
        JSONObject submittedJson = new JSONObject(input);
        this.setValuesFromJSON(propSheetDef, submittedJson);
        return this.toJSON((Object)propSheetDef, new JSONOutputType[0]);
    }

    public void setValuesFromJSON(PropSheetDef propSheetDef, JSONObject submittedJson) throws Exception {
        String name = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"name");
        String description = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"description");
        propSheetDef.setName(name);
        propSheetDef.setDescription(description);
    }

    @PUT
    @Path(value="{propSheetDef}/propDefs")
    @Produces(value={"application/json"})
    public JSONObject createPropDef(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam, String input) throws Exception {
        JSONObject submittedJson = new JSONObject(input);
        PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
        String name = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"name");
        name = name.trim();
        PropDef propDef = new PropDef(propSheetDef, name);
        propSheetDef.addPropDef(propDef);
        PropDefResource.getInstance().setValuesFromJSON(propDef, submittedJson);
        return PropDefResource.getInstance().toJSON(propDef, new JSONOutputType[0]);
    }

    @GET
    @Path(value="{propSheetDef}/resolveHttpValues")
    @Produces(value={"application/json"})
    public JSONArray testDefaultHttpValues(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam, @QueryParam(value="label") String labelFilter, @HeaderParam(value="Range") String range, @Context HttpServletResponse response, @QueryParam(value="httpUrl") String httpUrl, @QueryParam(value="httpUsername") String httpUsername, @QueryParam(value="httpFormat") String httpFormat, @QueryParam(value="httpBasePath") String httpBasePath, @QueryParam(value="httpValuePath") String httpValuePath, @QueryParam(value="httpLabelPath") String httpLabelPath, @QueryParam(value="httpPassword") String httpPassword, @QueryParam(value="propDefName") String propDefName) throws Exception {
        PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
        PropDef propDef = propSheetDef.getPropDef(propDefName);
        return this.testValues(propDef, labelFilter, range, response, httpUrl, httpUsername, httpFormat, httpBasePath, httpValuePath, httpLabelPath, httpPassword);
    }

    @GET
    @Path(value="noPropSheet/resolveHttpValues")
    @Produces(value={"application/json"})
    public JSONArray testDefaultHttpValuesNoPropSheet(@QueryParam(value="label") String labelFilter, @HeaderParam(value="Range") String range, @Context HttpServletResponse response, @QueryParam(value="httpUrl") String httpUrl, @QueryParam(value="httpUsername") String httpUsername, @QueryParam(value="httpFormat") String httpFormat, @QueryParam(value="httpBasePath") String httpBasePath, @QueryParam(value="httpValuePath") String httpValuePath, @QueryParam(value="httpLabelPath") String httpLabelPath, @QueryParam(value="httpPassword") String httpPassword) throws Exception {
        return this.testValues(null, labelFilter, range, response, httpUrl, httpUsername, httpFormat, httpBasePath, httpValuePath, httpLabelPath, httpPassword);
    }

    public JSONArray testValues(PropDef propDef, String labelFilter, String range, HttpServletResponse response, String httpUrl, String httpUsername, String httpFormat, String httpBasePath, String httpValuePath, String httpLabelPath, String httpPassword) throws Exception {
        HttpPropInfo info = new HttpPropInfo();
        info.setUrl(httpUrl);
        info.setUsername(httpUsername);
        info.setFormatName(httpFormat);
        info.setBasePath(httpBasePath);
        info.setValuePath(httpValuePath);
        info.setLabelPath(httpLabelPath);
        if (propDef != null && httpPassword.equals("****")) {
            info.setPassword(propDef.getHttpPropInfo().getPassword());
        } else {
            info.setPassword(httpPassword);
        }
        HttpPropInfoHelper helper = PropSheetHelpersLookup.getHttpPropInfoHelper();
        List<PropDefAllowedValue> allowedValues = helper.getAllowedValues(info);
        this.filterHttpValues(allowedValues, labelFilter, range, response);
        JSONArray result = new PropDefResource().getAllowedValuesJson(allowedValues);
        return result;
    }

    @GET
    @Path(value="{propSheetDef}/resolveHttpValues/{propDefName}")
    @Produces(value={"application/json"})
    public JSONArray resolveHttpValues(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam, @PathParam(value="propDefName") String propDefName, @QueryParam(value="label") String labelFilter, @HeaderParam(value="Range") String range, @Context HttpServletResponse response) throws Exception {
        PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
        PropDef propDef = propSheetDef.getPropDef(propDefName);
        JSONArray result = new JSONArray();
        if (propDef.getType().isHttpBased()) {
            List<PropDefAllowedValue> allowedValues = propDef.getHttpPropInfo().getAllowedValues();
            this.filterHttpValues(allowedValues, labelFilter, range, response);
            result = new PropDefResource().getAllowedValuesJson(allowedValues);
        }
        return result;
    }

    private void filterHttpValues(List<PropDefAllowedValue> allowedValues, String labelFilter, String range, HttpServletResponse response) {
        Pattern pattern;
        Matcher matcher;
        if (!StringUtil.isEmpty((String)labelFilter)) {
            String namePatternRegex = labelFilter.replace("?", ".?").replace("*", ".*").replace("\\", "\\\\?");
            ListIterator<PropDefAllowedValue> it = allowedValues.listIterator();
            while (it.hasNext()) {
                PropDefAllowedValue allowedValue = it.next();
                if (allowedValue.getLabel().matches(namePatternRegex)) continue;
                it.remove();
            }
        }
        if (!StringUtil.isEmpty((String)range) && (matcher = (pattern = Pattern.compile("items=(\\d*)-(\\d*)")).matcher(range)).find()) {
            int startIndex = Integer.valueOf(matcher.group(1));
            int endIndex = Integer.valueOf(matcher.group(2)) + 1;
            int total = allowedValues.size();
            if (endIndex > allowedValues.size()) {
                endIndex = allowedValues.size();
            }
            if (startIndex >= endIndex) {
                allowedValues.clear();
            } else {
                ArrayList<PropDefAllowedValue> sublist = new ArrayList<PropDefAllowedValue>(allowedValues.subList(startIndex, endIndex));
                allowedValues.retainAll(sublist);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(startIndex).append('-').append(endIndex - 1).append('/').append(total);
            response.addHeader("Content-Range", sb.toString());
        }
    }

    @GET
    @Path(value="{propSheetDef}/resolveHttpValues/{propDefName}/{propValue}")
    @Produces(value={"application/json"})
    public JSONObject resolveSingleHttpValue(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam, @PathParam(value="propDefName") String propDefName, @PathParam(value="propValue") String propValue) throws Exception {
        PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
        PropDef propDef = propSheetDef.getPropDef(propDefName);
        JSONObject result = null;
        if (propDef.getType().isHttpBased()) {
            List<PropDefAllowedValue> allowedValues = propDef.getHttpPropInfo().getAllowedValues();
            PropDefAllowedValue singleValue = null;
            for (PropDefAllowedValue allowedValue : allowedValues) {
                if (!allowedValue.getValue().equals(propValue)) continue;
                singleValue = allowedValue;
                break;
            }
            if (singleValue != null) {
                result = new PropDefResource().getAllowedValueJson(singleValue);
            }
        }
        return result;
    }

    @GET
    @Path(value="{propSheetDef}/propDefs")
    @Produces(value={"application/json"})
    public JSONArray getPropSheetDefPropDefs(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam) throws Exception {
        PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
        return this.getPropDefs(propSheetDef);
    }

    public JSONArray getPropDefs(PropSheetDef propSheetDef, JSONOutputType ... outputTypes) throws Exception {
        JSONArray result = new JSONArray();
        List<PropDef> directPropDefList = propSheetDef.getDirectPropDefList();
        for (PropDef propDef : propSheetDef.getPropDefList()) {
            if (propDef.isHidden()) continue;
            JSONObject propDefJson = PropDefResource.getInstance().toJSON(propDef, outputTypes);
            propDefJson.put("inherited", !directPropDefList.contains(propDef));
            result.put((Object)propDefJson);
        }
        return result;
    }

    public JSONArray getPropDefs(PropSheetDef propSheetDef) throws Exception {
        return this.getPropDefs(propSheetDef, JSONOutputType.BASIC);
    }

    public JSONArray getUnsafePropDefs(PropSheetDef propSheetDef) throws Exception {
        JSONArray result = new JSONArray();
        List<PropDef> directPropDefList = propSheetDef.getDirectPropDefList();
        for (PropDef propDef : propSheetDef.getPropDefList()) {
            if (propDef.isHidden()) continue;
            JSONObject propDefJson = PropDefResource.getInstance().getUnsafeJSON(propDef);
            propDefJson.put("inherited", !directPropDefList.contains(propDef));
            result.put((Object)propDefJson);
        }
        return result;
    }

    @PUT
    @Path(value="{propSheetDef}/propDefs/{propDefName}")
    @Produces(value={"application/json"})
    public JSONObject updatePropDef(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam, @PathParam(value="propDefName") String propDefName, String input) throws Exception {
        JSONObject submittedJson = new JSONObject(input);
        PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
        PropDef propDef = propSheetDef.getPropDef(propDefName);
        if (propDef == null) {
            throw new TranslatableException("No property definition named '%s' was found to update.", new Object[]{propDefName});
        }
        PropDefResource.getInstance().setValuesFromJSON(propDef, submittedJson);
        return PropDefResource.getInstance().toJSON(propDef, new JSONOutputType[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{propSheetDef}/propDefs/{propDefName}")
    public void deletePropDef(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam, @PathParam(value="propDefName") String propDefName) throws Exception {
        FlushMode currentMode = this.getFlushMode();
        try {
            this.setFlushMode(FlushMode.COMMIT);
            this.flush();
            PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
            PropDef propDef = propSheetDef.getPropDef(propDefName);
            if (propDef == null) {
                throw new TranslatableException("No PropDef found by that name on this PropSheetDef.", new Object[0]);
            }
            propSheetDef.removePropDef(propDef);
        }
        finally {
            this.setFlushMode(currentMode);
        }
    }

    @PUT
    @Path(value="{propSheetDef}/propDefs/update/{deleteExtraProps}")
    @Produces(value={"application/json"})
    public JSONArray updatePropDefs(@PathParam(value="propSheetDef") PropSheetDefParam propSheetDefParam, @PathParam(value="deleteExtraProps") Boolean deleteExtraProps, String input) throws Exception {
        JSONArray propDefs = new JSONArray(input);
        PropSheetDef propSheetDef = (PropSheetDef)((Object)propSheetDefParam.getValue());
        List<PropDef> currentPropDefs = propSheetDef.getPropDefList();
        if (deleteExtraProps.booleanValue()) {
            for (PropDef currentProp : currentPropDefs) {
                boolean found = false;
                for (int index = 0; index < propDefs.length() && !found; ++index) {
                    JSONObject entry = propDefs.getJSONObject(index);
                    String name = JSONUtilities.getStringFromJsonObject((JSONObject)entry, (String)"name");
                    if (!name.equals(currentProp.getName())) continue;
                    found = true;
                }
                if (found) continue;
                propSheetDef.removePropDef(currentProp);
            }
        }
        for (int index = 0; index < propDefs.length(); ++index) {
            PropDef.PropDefType propDefType = PropDef.PropDefType.TEXT;
            JSONObject entry = (JSONObject)propDefs.get(index);
            String propDefName = JSONUtilities.getStringFromJsonObject((JSONObject)entry, (String)"name");
            String propDefTypeString = JSONUtilities.getStringFromJsonObject((JSONObject)entry, (String)"type");
            if (!StringUtil.isEmpty((String)propDefTypeString)) {
                propDefType = PropDef.PropDefType.valueOf(propDefTypeString);
            }
            String propDefValue = JSONUtilities.getStringFromJsonObject((JSONObject)entry, (String)"value");
            Boolean propDefRequired = JSONUtilities.getBooleanFromJsonObject((JSONObject)entry, (String)"required");
            String propDefDescription = JSONUtilities.getStringFromJsonObject((JSONObject)entry, (String)"description");
            String propDefLabel = JSONUtilities.getStringFromJsonObject((JSONObject)entry, (String)"label");
            String propDefPattern = JSONUtilities.getStringFromJsonObject((JSONObject)entry, (String)"pattern");
            PropDef propDef = propSheetDef.getPropDef(propDefName);
            if (StringUtil.isEmpty((String)propDefLabel)) {
                propDefLabel = propDefName;
            }
            if (propDef == null) {
                propDef = propSheetDef.createPropDef(propDefType, propDefName);
            }
            if (propDefType != null) {
                propDef.setType(propDefType);
            }
            if (propDefPattern != null) {
                try {
                    Pattern.compile(propDefPattern);
                }
                catch (Exception e) {
                    throw new RuntimeException("The regular expression submitted was not valid. Please submit a valid regular expression.");
                }
                propDef.setPattern(propDefPattern);
            }
            if (propDefValue != null) {
                propDef.setDefaultValue(propDefValue);
            }
            if (propDefRequired != null) {
                propDef.setRequired(propDefRequired);
            }
            if (propDefDescription != null) {
                propDef.setDescription(propDefDescription);
            }
            if (propDefLabel == null) continue;
            propDef.setLabel(propDefLabel);
        }
        return this.getPropDefs(propSheetDef);
    }

    private PropertyConfiguration getPropertyConfiguration() {
        return PropertyConfiguration.getInstance();
    }

    private FlushMode getFlushMode() {
        return this.getPropertyConfiguration().getSessionLookup().getSession().getFlushMode();
    }

    private void flush() {
        this.getPropertyConfiguration().getSessionLookup().getSession().flush();
    }

    private void setFlushMode(FlushMode mode) {
        this.getPropertyConfiguration().getSessionLookup().getSession().setFlushMode(mode);
    }
}

