/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.cli;

import com.urbancode.air.plugin_command.runtime.AutomationPluginRunnable;
import com.urbancode.air.plugin_command.runtime.AutomationPluginRuntime;
import com.urbancode.air.plugin_command.runtime.FetcherLocal;
import com.urbancode.air.plugin_command.runtime.StepExecutionInfo;
import com.urbancode.air.plugin_command.xml.AutomationPluginRuntimeMarshallEngine;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class PluginCommandRuntimeCli {
    private String[] args;
    private transient Options options = new Options();
    private Properties outputProperties = null;

    public static void main(String[] args) throws Exception {
        PluginCommandRuntimeCli cli = new PluginCommandRuntimeCli(args);
        cli.run();
    }

    public PluginCommandRuntimeCli(String[] args) {
        this.options.addOption("p", "pluginId", true, "The full id of the plugin to execute.");
        this.options.addOption("v", "pluginVersion", true, "The version of the plugin to execute.");
        this.options.addOption("s", "stepname", true, "The name of the step to execute.");
        this.options.addOption("ip", "inputPropFile", true, "The location of the input property file.");
        this.options.addOption("ep", "envPropFile", true, "The location of the environment property file.");
        this.options.addOption("op", "outputPropFile", true, "The location of the ouptput property file.");
        this.options.addOption("w", "workingDirectory", true, "The location of the working directory.");
        this.options.addOption("ol", "outputLogFile", true, "The location of the output log file.");
        this.options.addOption("el", "errorLogFile", true, "The location of the error log file.");
        this.options.addOption("h", "help", false, "Display the help message.");
        this.options.addOption("c", "pluginCache", true, "The plugin cache directory.");
        this.options.addOption("z", "pluginZip", true, "The plugin zip file.");
        this.args = args;
    }

    public void run() throws Exception {
        AutomationPluginRuntime runtime;
        File zipFile;
        File storageDir;
        CommandLine line;
        PosixParser parser = new PosixParser();
        try {
            line = parser.parse(this.options, this.args);
            if (line.hasOption("h")) {
                this.printHelpAndExit(this.options, 0);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.checkRequiredOption(line, "p");
        this.checkRequiredOption(line, "v");
        this.checkRequiredOption(line, "s");
        this.checkRequiredOption(line, "ip");
        this.checkRequiredOption(line, "ep");
        this.checkRequiredOption(line, "ol");
        this.checkRequiredOption(line, "el");
        String version = line.getOptionValue('v');
        if (!line.hasOption("z") && !line.hasOption("c")) {
            System.out.println("Either a plugin cache directory or plugin zip file must be specified!");
            this.printHelpAndExit(this.options, 1);
        }
        String pluginId = line.getOptionValue("p");
        if (line.hasOption("c")) {
            storageDir = new File(line.getOptionValue("c"));
        } else {
            try {
                storageDir = File.createTempFile("pluginCacheDir-", "dir");
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create temp pluginCacheDir. Please specify a pluginCache on the commandline!", e);
            }
            storageDir.delete();
        }
        storageDir.mkdirs();
        if (line.hasOption("z") && (zipFile = new File(line.getOptionValue("z"))).isFile() && zipFile.canRead()) {
            String resultName = pluginId + "_" + version + ".zip";
            File newLocation = new File(storageDir, resultName);
            System.out.println("Copying file : " + zipFile.getAbsolutePath() + " to : " + newLocation.getAbsolutePath());
            IO.copy((File)zipFile, (File)newLocation);
        }
        FetcherLocal fetcher = new FetcherLocal(storageDir);
        AutomationPluginRuntimeMarshallEngine xmlEngine = AutomationPluginRuntimeMarshallEngine.getInstance();
        try {
            runtime = new AutomationPluginRuntime(fetcher, xmlEngine);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create PluginCommandRuntime!", e);
        }
        Long pluginVersion = Long.parseLong(line.getOptionValue("v"));
        String stepName = line.getOptionValue("s");
        File inputPropFile = new File(line.getOptionValue("ip"));
        File envPropFile = new File(line.getOptionValue("ep"));
        File outputPropFile = new File(line.getOptionValue("op"));
        File workingDirectory = new File(line.getOptionValue("w"));
        File outputLogFile = new File(line.getOptionValue("ol"));
        File errorLogFile = new File(line.getOptionValue("el"));
        Properties inputProps = this.loadProperties(inputPropFile);
        Properties envProps = this.loadProperties(envPropFile);
        AutomationPluginRunnable runner = runtime.getPluginRunner();
        runner = runner.withPluginId(pluginId).withInputProperties(inputProps).withEnvironmentProperties(envProps).withInputPropFile(inputPropFile).withEnvPropFile(envPropFile).withPluginVersion(pluginVersion).withCommandName(stepName).withOutputPropFile(outputPropFile).withWorkingDirectory(workingDirectory).withOutputLog(outputLogFile).withErrorLogFile(errorLogFile).withSecureValues(new HashSet<String>()).withPropertyNamesToKeepEnvVarsIn(new HashSet<String>()).withImpersonationToken(null).withStepExecutionInfo(new StepExecutionInfo(UUID.randomUUID())).withPostProcessingScript(null);
        runner.run();
        this.outputProperties = runner.getOutputProperties();
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File file) throws IOException {
        Properties result = new Properties();
        FileInputStream is = new FileInputStream(file);
        try {
            result.load(is);
        }
        finally {
            IO.close((InputStream)is);
        }
        return result;
    }

    private void checkRequiredOption(CommandLine line, String option) {
        if (!line.hasOption(option)) {
            System.out.println("Option '--" + this.options.getOption(option).getLongOpt() + "' is required!");
            System.out.println();
            this.printHelpAndExit(this.options, 1);
        }
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("PluginCommandRuntimeCli", options);
        System.exit(exitCode);
    }
}

