/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.properties;

import com.urbancode.air.plugin_command.properties.PropertyValueScope;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PropertyResolver {
    private static final String tokenPatternString = "[$][{]((?:[^\\\\}]++|\\\\[}]|\\\\(?![}]))*)[}]";
    private static final Pattern tokenPattern = Pattern.compile("[$][{]((?:[^\\\\}]++|\\\\[}]|\\\\(?![}]))*)[}]", 40);
    private final PropertyValueScope propertyProvider;

    public PropertyResolver(PropertyValueScope propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public String resolve(String s) {
        String result = s;
        Matcher matcher = tokenPattern.matcher("");
        HashSet<String> history = new HashSet<String>();
        try {
            while (result != null && history.add(result) && history.size() < 100) {
                matcher.reset(result);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String scriptPart = matcher.group();
                    String value = this.resolveScript(scriptPart);
                    if (value == null) {
                        value = scriptPart;
                    }
                    matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
                }
                matcher.appendTail(sb);
                result = sb.toString();
            }
        }
        catch (StackOverflowError e) {
            throw new RuntimeException("Stack overflow matching during parameter resolution");
        }
        return result;
    }

    protected String resolveScript(String s) {
        Matcher matcher;
        String propName;
        String result = s;
        if (s != null && s.startsWith("${") && s.endsWith("}") && StringUtils.equals((String)(result = this.getProperty(propName = this.getPropertyNameFromExpression(s).replaceAll("\\\\[}]", "}"))), (String)s) && (matcher = tokenPattern.matcher(result)).find() && (matcher.group(1).startsWith("p?") || matcher.group(1).startsWith("property?"))) {
            result = "";
        }
        return result;
    }

    protected String getProperty(String propName) {
        String result = null;
        if (propName != null && (propName = propName.trim()).length() != 0 && (result = this.propertyProvider.get(propName)) == null && propName.startsWith("env/")) {
            propName = propName.substring(4);
            result = this.propertyProvider.get(propName);
        }
        return result;
    }

    protected String getPropertyNameFromExpression(String expression) {
        String dividerString = expression.contains(":") ? ":" : "{";
        String result = expression.substring(expression.indexOf(dividerString) + 1, expression.length() - 1);
        return result;
    }
}

