/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.common.advice;

import com.ibm.team.process.common.IBehaviorConfiguration;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.advice.IOperationConfigurationInfo;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AdvisableOperation {
    private String fOperationId;
    private Object fOperationData;
    private IProcessArea fProcessArea;
    private IDevelopmentLine fLine;
    private IOperationConfigurationInfo fInfo;
    private String[] fReportData;

    public AdvisableOperation(String operationId, Object operationData, IProcessArea processArea) {
        this(operationId, operationData, processArea, null);
    }

    public AdvisableOperation(String operationId, Object operationData, IProcessArea processArea, IDevelopmentLine line) {
        this.fOperationId = operationId;
        this.fOperationData = operationData;
        this.fProcessArea = processArea;
        this.fLine = line;
    }

    public abstract IOperationReport run(IBehaviorConfiguration var1, IProgressMonitor var2) throws TeamRepositoryException;

    public boolean canReRun() {
        return false;
    }

    public IOperationReport reRun(IBehaviorConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    public IOperationReport advise(IBehaviorConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    public String[] getActions() throws TeamRepositoryException {
        return new String[0];
    }

    public IProcessArea getProcessArea() {
        return this.fProcessArea;
    }

    public IProcessArea[] getSecondaryProcessAreas() {
        return new IProcessArea[0];
    }

    public String[] getSecondaryActions(IProcessArea secondaryArea) throws TeamRepositoryException {
        return new String[0];
    }

    public IDevelopmentLine getSecondaryDevelopmentLine(IProcessArea secondaryArea) {
        return null;
    }

    public IDevelopmentLine getDevelopmentLine() {
        return this.fLine;
    }

    public Object getOperationData() {
        return this.fOperationData;
    }

    public String getOperationIdentifier() {
        return this.fOperationId;
    }

    public boolean shouldThrowPermissionDeniedException() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AdvisableOperation) {
            AdvisableOperation other = (AdvisableOperation)obj;
            Object otherData = other.getOperationData();
            Object data = this.getOperationData();
            return other.getOperationIdentifier().equals(this.getOperationIdentifier()) && otherData == data || otherData != null && data != null && otherData.equals(data);
        }
        return false;
    }

    public int hashCode() {
        Object data = this.getOperationData();
        return this.getOperationIdentifier().hashCode() ^ (data == null ? 0 : data.hashCode());
    }

    public IOperationConfigurationInfo getOperationConfigurationInfo() {
        return this.fInfo;
    }

    public void setOperationConfigurationInfo(IOperationConfigurationInfo info) {
        this.fInfo = info;
    }

    public void setDevelopmentLine(IDevelopmentLine line) {
        this.fLine = line;
    }

    public void setReportData(String[] reportData) {
        this.fReportData = reportData;
    }

    public String[] getReportData() {
        return this.fReportData;
    }
}

