/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.rest.representations;

import com.ibm.team.process.internal.common.rest.representations.IRepresentationContentTypeHandler;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class RepresentationContentTypeHandlerRegistry {
    private static Registry registry = null;
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRepresentationContentTypeHandler getHandler(String contentType) {
        Object object = lock;
        synchronized (object) {
            if (registry == null) {
                registry = new Registry();
                registry.start();
            }
        }
        for (IRepresentationContentTypeHandler handler : registry.handlers.values()) {
            if (!handler.handles(contentType)) continue;
            return handler;
        }
        return null;
    }

    private static class Registry
    extends ExtensionRegistryReader<String> {
        public static final String BUNDLE_ID = "com.ibm.team.process.common";
        private static final String EXTENSION_POINT_ID = "processRepresentationHandlers";
        private static final String HANDLER_ELEMENT_NAME = "handler";
        private static final String HANDLER_CLASS = "handlerClass";
        private final Map<String, IRepresentationContentTypeHandler> handlers = new HashMap<String, IRepresentationContentTypeHandler>();

        protected Registry() {
            super(BUNDLE_ID, EXTENSION_POINT_ID);
        }

        protected String handleExtensionAdded(IConfigurationElement element) {
            if (element.getName().equals(HANDLER_ELEMENT_NAME)) {
                try {
                    String name = element.getAttribute(HANDLER_CLASS);
                    IRepresentationContentTypeHandler handler = (IRepresentationContentTypeHandler)element.createExecutableExtension(HANDLER_CLASS);
                    this.handlers.put(name, handler);
                    return name;
                }
                catch (CoreException coreException) {
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return null;
        }

        protected void handleExtensionRemoved(IConfigurationElement element, String name) {
            if (element.getName().equals(HANDLER_ELEMENT_NAME)) {
                this.handlers.remove(name);
            }
        }
    }
}

