/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.common.IProcessContainer;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;

public class ProcessModelCache {
    private volatile LinkedList<ModelCacheEntry> fEntries = new LinkedList();
    private final int fMaxSize;
    private final int fPromoteThreshold;

    public ProcessModelCache(int size) {
        this.fMaxSize = size;
        this.fPromoteThreshold = (int)((float)size * 0.2f);
    }

    public AbstractModel get(IProcessContainer container, IContent content, IDevelopmentLine line, CurrentIterationInfo[] iterationInfos) {
        LinkedList<ModelCacheEntry> entries = this.fEntries;
        int i = 1;
        for (ModelCacheEntry entry : entries) {
            if (container.sameItemId((IItemHandle)entry.containerHandle)) {
                AbstractModel model = entry.model.get();
                if (model != null && this.isUpToDate(entry, content, line, iterationInfos)) {
                    if (i > this.fPromoteThreshold) {
                        this.promoteEntry(entry);
                    }
                    return model;
                }
                this.removeEntry(entry);
                break;
            }
            ++i;
        }
        return null;
    }

    private boolean isUpToDate(ModelCacheEntry entry, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos) {
        if (content.getContentId().equals((Object)entry.contentId)) {
            return (line == null || line.sameItemId((IItemHandle)entry.line)) && (currentIterationInfos == null || this.equalIterationInfos(currentIterationInfos, entry.currentIterationInfos));
        }
        return false;
    }

    private boolean equalIterationInfos(CurrentIterationInfo[] iterationInfosA, CurrentIterationInfo[] iterationInfosB) {
        if (iterationInfosB != null && iterationInfosA.length == iterationInfosB.length) {
            int i = 0;
            while (i < iterationInfosA.length) {
                if (!this.equalIterationInfo(iterationInfosA[i], iterationInfosB[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean equalIterationInfo(CurrentIterationInfo infoA, CurrentIterationInfo infoB) {
        if (infoA.getIteration().sameItemId((IItemHandle)infoB.getIteration())) {
            IIterationType typeA = infoA.getIterationType();
            IIterationType typeB = infoB.getIterationType();
            return typeA == null && typeB == null || typeA != null && typeA.sameItemId((IItemHandle)typeB) || typeB != null && typeB.sameItemId((IItemHandle)typeA);
        }
        return false;
    }

    private synchronized void promoteEntry(ModelCacheEntry entry) {
        LinkedList<ModelCacheEntry> entries = new LinkedList<ModelCacheEntry>(this.fEntries);
        entries.remove(entry);
        entries.add(0, entry);
        this.fEntries = entries;
    }

    private synchronized void removeEntry(ModelCacheEntry entry) {
        LinkedList<ModelCacheEntry> entries = new LinkedList<ModelCacheEntry>(this.fEntries);
        entries.remove(entry);
        this.fEntries = entries;
    }

    public synchronized void put(IProcessContainer container, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, AbstractModel model) {
        if (this.fMaxSize < 1) {
            return;
        }
        LinkedList<ModelCacheEntry> entries = new LinkedList<ModelCacheEntry>(this.fEntries);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            ModelCacheEntry entry = (ModelCacheEntry)iterator.next();
            if (entry == null || !container.sameItemId((IItemHandle)entry.containerHandle)) continue;
            iterator.remove();
            break;
        }
        ModelCacheEntry entry = new ModelCacheEntry();
        entry.containerHandle = (IProcessContainerHandle)container.getItemHandle();
        entry.model = new SoftReference<AbstractModel>(model);
        entry.contentId = content.getContentId();
        entry.line = line;
        entry.currentIterationInfos = currentIterationInfos;
        entries.addFirst(entry);
        if (entries.size() > this.fMaxSize) {
            entries.removeLast();
        }
        this.fEntries = entries;
    }

    private class ModelCacheEntry {
        public IProcessContainerHandle containerHandle;
        public SoftReference<AbstractModel> model;
        public UUID contentId;
        public IDevelopmentLine line;
        public CurrentIterationInfo[] currentIterationInfos;

        private ModelCacheEntry() {
        }
    }
}

