/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLUtil {
    private XMLUtil() {
    }

    public static Document constructDocument(String xmlDocumentContent) throws TeamRepositoryException {
        Document xmlDocument = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xmlDocumentContent));
            xmlDocument = docBuilder.parse(is);
        }
        catch (IllegalArgumentException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (DOMException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (ParserConfigurationException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (SAXException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (IOException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        return xmlDocument;
    }

    public static String asXMLString(XMLMemento memento) {
        return XMLUtil.asXMLString(memento, "\n");
    }

    public static String asXMLString(XMLMemento memento, String delimiter) {
        try {
            String platformDelimiter;
            String xml = AbstractModel.serializeDocument(memento.getDocument());
            int i = xml.indexOf("<?xml");
            int j = xml.indexOf("<", i + 5);
            if (j >= 0) {
                xml = xml.substring(j);
            }
            if (delimiter != null && (platformDelimiter = System.getProperty("line.separator")) != null && !platformDelimiter.equals(delimiter)) {
                xml = xml.replace(platformDelimiter, delimiter);
            }
            return xml;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Document getXmlDocument(InputStream inputStream) throws TeamRepositoryException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        docBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            return docBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (SAXException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
        catch (IOException exception) {
            throw new TeamRepositoryException((Throwable)exception);
        }
    }

    public static NodeList getNodes(Document document, String xpathExpression) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(xpathExpression);
        return (NodeList)expr.evaluate(document, XPathConstants.NODESET);
    }

    public static Element getElement(NodeList nodes, String localName, String namespaceURI) {
        int len = nodes.getLength();
        int i = 0;
        while (i < len) {
            Node node = nodes.item(i);
            if (node instanceof Element && localName.equals(node.getLocalName()) && namespaceURI.equals(node.getNamespaceURI())) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    public static Element getElement(NodeList nodes, String name) {
        int len = nodes.getLength();
        int i = 0;
        while (i < len) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getNodeName().equals(name)) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    public static String unescapeXML(String xmlText) {
        if (xmlText == null) {
            return xmlText;
        }
        String plainText = xmlText;
        plainText = plainText.replace("&amp;", "&");
        plainText = plainText.replace("&quot;", "\"");
        plainText = plainText.replace("&lt;", "<");
        plainText = plainText.replace("&gt;", ">");
        plainText = plainText.replace("&#10;", "\n");
        plainText = plainText.replace("&#13;", "\r");
        plainText = plainText.replace("&#039;", "'");
        return plainText;
    }

    public static String filterInvalidXMLCharacters(String xmlText) {
        if (xmlText == null) {
            return null;
        }
        int len = xmlText.length();
        int cp = 0;
        int ch = 0;
        StringBuilder stringBuilder = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            ch = xmlText.charAt(i);
            boolean surrogate = false;
            if (Character.isHighSurrogate((char)ch) && i + 1 < len && Character.isLowSurrogate(xmlText.charAt(i + 1))) {
                surrogate = true;
                cp = xmlText.codePointAt(i++);
            } else {
                cp = ch;
            }
            if (!DataValue.XMLChar.isInvalid((int)cp)) {
                stringBuilder.append((char)ch);
                if (surrogate) {
                    stringBuilder.append(xmlText.charAt(i));
                }
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public static Transformer getXMLTransformer() throws TransformerConfigurationException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            transFactory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return transformer;
    }

    public static XMLReader getXMLReader() {
        try {
            SAXParserFactory nsParserFactory = SAXParserFactory.newInstance();
            nsParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            nsParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            nsParserFactory.setNamespaceAware(true);
            return nsParserFactory.newSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return null;
    }

    public static String normalizeXML(String xml) throws UnsupportedEncodingException, TransformerException {
        Transformer transformer = XMLUtil.getXMLTransformer();
        XMLReader xmlReader = XMLUtil.getXMLReader();
        WhitespaceFilter filter = new WhitespaceFilter(xmlReader);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        transformer.transform(new SAXSource(filter, new InputSource(new StringReader(xml))), new StreamResult(new OutputStreamWriter((OutputStream)outputStream, "UTF-8")));
        return outputStream.toString("UTF8");
    }

    private static class WhitespaceFilter
    extends XMLFilterImpl {
        public WhitespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String string = new String(ch, start, length).trim();
            if (string.length() > 0) {
                super.characters(ch, start, length);
            }
        }
    }
}

