/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.internal.client.workingcopies.ExecUtil;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.StringWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.UpdateRequest;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DevelopmentLineWorkingCopy
extends StringWorkingCopy {
    private ITeamArea fTeamArea;
    private IProjectArea fProjectArea;
    private IProjectArea fUncommittedProjectArea;
    private boolean fInherited;
    private IDevelopmentLine fDevelopmentLine;

    public DevelopmentLineWorkingCopy(ITeamArea teamArea) {
        this.fTeamArea = teamArea;
    }

    @Override
    public void dispose() {
        this.fTeamArea = null;
        super.dispose();
    }

    public void syncSave(List processItemsToSaveCollector, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processService = (IProcessItemService)((ITeamRepository)this.fTeamArea.getOrigin()).getClientLibrary(IProcessItemService.class);
        this.fUncommittedProjectArea = (IProjectArea)processService.getMutableCopy((IProcessItem)this.fProjectArea);
        ITeamAreaHierarchy hierarchy = this.fUncommittedProjectArea.getTeamAreaHierarchy();
        IDevelopmentLineHandle currentLine = hierarchy.getRawDevelopmentLine((ITeamAreaHandle)this.fTeamArea);
        if (currentLine != null && currentLine.sameItemId((IItemHandle)this.fDevelopmentLine)) {
            return;
        }
        hierarchy.setDevelopmentLine((ITeamAreaHandle)this.fTeamArea, (IDevelopmentLineHandle)this.fDevelopmentLine);
        processItemsToSaveCollector.add(this.fUncommittedProjectArea);
    }

    @Override
    protected void updateUnderlyingPropertyState() {
        this.fProjectArea = this.fUncommittedProjectArea;
        this.fUncommittedProjectArea = null;
    }

    public ITeamArea getTeamArea() {
        return this.fTeamArea;
    }

    public void asyncUpdate(final int flags, IUpdateContext context, IProgressMonitor monitor) {
        if (this.isDisposed()) {
            return;
        }
        UpdateRequest request = new UpdateRequest(Messages.getString("DevelopmentLineWorkingCopy.0")){

            @Override
            public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                if (DevelopmentLineWorkingCopy.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                monitor.beginTask("", 1000);
                try {
                    IDevelopmentLine developmentLine;
                    ITeamRepository repo = (ITeamRepository)DevelopmentLineWorkingCopy.this.fTeamArea.getOrigin();
                    IItemManager itemManager = repo.itemManager();
                    IProjectAreaHandle projectAreaHandle = DevelopmentLineWorkingCopy.this.fTeamArea.getProjectArea();
                    DevelopmentLineWorkingCopy.this.fProjectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                    ITeamAreaHierarchy hierarchy = DevelopmentLineWorkingCopy.this.fProjectArea.getTeamAreaHierarchy();
                    ITeamAreaHandle parentTeamAreaHandle = hierarchy.getParent((ITeamAreaHandle)DevelopmentLineWorkingCopy.this.fTeamArea.getItemHandle());
                    DevelopmentLineWorkingCopy.this.fInherited = parentTeamAreaHandle != null;
                    IDevelopmentLineHandle developmentLineHandle = hierarchy.getRawDevelopmentLine((ITeamAreaHandle)DevelopmentLineWorkingCopy.this.fTeamArea);
                    if (developmentLineHandle != null) {
                        developmentLine = (IDevelopmentLine)itemManager.fetchCompleteItem((IItemHandle)developmentLineHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                    } else {
                        developmentLine = null;
                        monitor.worked(500);
                    }
                    String label = DevelopmentLineWorkingCopy.this.getLabel(developmentLine);
                    String developmentLineName = DevelopmentLineWorkingCopy.this.fInherited ? NLS.bind((String)Messages.getString("DevelopmentLineWorkingCopy.3"), (Object)label) : label;
                    final String finalLineName = developmentLineName;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!DevelopmentLineWorkingCopy.this.isDisposed()) {
                                DevelopmentLineWorkingCopy.this.fDevelopmentLine = developmentLine;
                                DevelopmentLineWorkingCopy.this.updateDocumentContent(finalLineName);
                            }
                        }
                    };
                    if (context == null) {
                        runnable.run();
                    } else {
                        context.execute(runnable);
                    }
                    DevelopmentLineWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(DevelopmentLineWorkingCopy.this, "developmentLine", null, null));
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException e) {
                    if (DevelopmentLineWorkingCopy.this.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    Status status = new Status(4, "com.ibm.team.process.client", 0, this.getName(), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        ExecUtil.asyncExec(request, context, monitor);
    }

    void setDevelopmentLine(IDevelopmentLine developmentLine) {
        this.fDevelopmentLine = developmentLine;
        this.getDocument().set(this.getLabel(developmentLine));
    }

    IDevelopmentLine getDevelopmentLine() {
        return this.fDevelopmentLine;
    }

    private String getLabel(IDevelopmentLine developmentLine) {
        if (developmentLine == null) {
            return Messages.getString("DevelopmentLineWorkingCopy.5");
        }
        String name = developmentLine.getName();
        return name != null && name.trim().length() > 0 ? name : developmentLine.getId();
    }

    public boolean isInherited() {
        return this.fInherited;
    }
}

