/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.CommitLock;
import com.urbancode.air.vc.Session;
import com.urbancode.air.vc.VCConfiguration;
import com.urbancode.air.vc.VCHelperRegistry;
import com.urbancode.air.vc.metadata.RecordMetadataService;
import com.urbancode.persistence.hibernate.TxManager;
import java.io.Serializable;
import org.hibernate.LockOptions;
import org.hibernate.SQLQuery;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;

public class Repository {
    private TxManager txManager;
    private VCHelperRegistry helperRegistry;
    private VCConfiguration configuration;
    private ThreadLocal<Session> sessions = new ThreadLocal();
    private Thread metadataThread;
    private RecordMetadataService recordMetadataService;

    @Deprecated
    public Repository(TxManager txManager, VCHelperRegistry helperRegistry) {
        this(txManager, helperRegistry, null);
    }

    public Repository(TxManager txManager, VCHelperRegistry helperRegistry, VCConfiguration configuration) {
        this.txManager = txManager;
        this.helperRegistry = helperRegistry;
        if (configuration == null) {
            configuration = new VCConfiguration();
        }
        this.configuration = configuration;
        this.recordMetadataService = new RecordMetadataService(this);
        this.metadataThread = new Thread((Runnable)this.recordMetadataService, "RecordMetadataService");
        this.metadataThread.setDaemon(true);
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public long acquireLock(String name) {
        long start = System.currentTimeMillis();
        this.txManager.getSession().get(CommitLock.class, (Serializable)((Object)name), LockOptions.UPGRADE);
        long duration = System.currentTimeMillis() - start;
        return duration;
    }

    public long getCurrentCommit() {
        SQLQuery query = this.txManager.getSession().createSQLQuery("select max(id) as id from vc_commit");
        query.addScalar("id", (Type)new LongType());
        long result = 0L;
        Object queryResult = query.uniqueResult();
        if (queryResult != null) {
            result = (Long)queryResult;
        }
        return result;
    }

    public VCHelperRegistry getHelperRegistry() {
        return this.helperRegistry;
    }

    public Session createSession() {
        if (this.getSession() != null) {
            throw new UnsupportedOperationException("Can't create a session while one is already open for this thread.");
        }
        int maxSessionSize = 0;
        if (this.configuration != null) {
            maxSessionSize = this.configuration.getMaxSessionSize();
        }
        Session session = new Session(this, maxSessionSize);
        this.sessions.set(session);
        return session;
    }

    public Session getSession() {
        return this.sessions.get();
    }

    public void unbindSession() {
        this.sessions.set(null);
    }

    public VCConfiguration getConfiguration() {
        return this.configuration;
    }

    public void shutdown() {
        this.recordMetadataService.shutdown();
    }

    public void start() {
        this.recordMetadataService.runPreStartMetadataGenerators();
        this.metadataThread.start();
    }

    public void awaitShutdown() {
        this.shutdown();
        try {
            this.metadataThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

