/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc.metadata;

import com.urbancode.air.vc.LatestVersionEntry;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.PersistentReader;
import com.urbancode.air.vc.PersistentRecord;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.metadata.PreStartRecordMetadataGenerator;
import com.urbancode.air.vc.metadata.RecordMetadata;
import com.urbancode.air.vc.metadata.RecordMetadataGenerator;
import com.urbancode.air.vc.metadata.RecordMetadataGeneratorState;
import com.urbancode.persistence.hibernate.TxManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordMetadataService
implements Runnable {
    public static final long THROTTLE_TIME = Long.getLong("com.urbancode.air.vc.metadata.record_metadata_service.throttle_time", 250L);
    private static Logger log = Logger.getLogger(RecordMetadataService.class);
    private Repository repository;
    private final Object repositorySynchronizer = new Object();
    private boolean shutdown = false;

    public RecordMetadataService(Repository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final TxManager txman = this.repository.getTxManager();
        this.initializeGeneratorState();
        while (true) {
            Object object = this.repositorySynchronizer;
            synchronized (object) {
                try {
                    this.repositorySynchronizer.wait(THROTTLE_TIME);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (this.shutdown) {
                    return;
                }
            }
            final UUID lockedGeneratorStateId = this.acquireGeneratorStateLock();
            txman.forceBegin();
            try {
                if (lockedGeneratorStateId == null) {
                    if (!this.getIncompleteMetadataGenerators().isEmpty()) continue;
                    log.info((Object)"All versioned metadata generators have been processed.");
                    break;
                }
                txman.queueFinallyWork(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        txman.forceBegin();
                        try {
                            RecordMetadataGeneratorState generatorState = RecordMetadataService.this.getGeneratorState(lockedGeneratorStateId);
                            generatorState.setLocked(false);
                            txman.commit();
                        }
                        finally {
                            txman.forceEnd();
                        }
                    }
                });
                RecordMetadataGeneratorState generatorState = this.getGeneratorState(lockedGeneratorStateId);
                this.processGenerator(generatorState);
                txman.commit();
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                txman.forceEnd();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeGeneratorState() {
        TxManager txman = this.repository.getTxManager();
        txman.forceBegin();
        try {
            long currentCommit = this.repository.getCurrentCommit();
            HashMap<String, RecordMetadataGeneratorState> generatorStateMap = new HashMap<String, RecordMetadataGeneratorState>();
            for (RecordMetadataGeneratorState state : this.getAllMetadataGeneratorState()) {
                generatorStateMap.put(state.getMetadataGeneratorName(), state);
            }
            for (RecordMetadataGenerator generator : this.repository.getConfiguration().getMetadataGenerators()) {
                String generatorName = generator.getClass().getName();
                RecordMetadataGeneratorState generatorState = (RecordMetadataGeneratorState)generatorStateMap.get(generatorName);
                if (generatorState == null) {
                    generatorState = new RecordMetadataGeneratorState(generator, currentCommit);
                    txman.getSession().save((Object)generatorState);
                    generatorStateMap.put(generatorName, generatorState);
                    log.info((Object)("Processing metadata for new generator: " + generator.getGeneratorDisplayName()));
                    continue;
                }
                if (generatorState.getMetadataGeneratorVersion() == generator.getGeneratorVersion()) continue;
                generatorState.setNewestScannedCommit(0L);
                generatorState.setScanEndCommit(currentCommit);
                generatorState.setMetadataGeneratorVersion(generator);
                log.info((Object)("Upgrading metadata for generator: " + generator.getGeneratorDisplayName()));
            }
            txman.commit();
        }
        finally {
            txman.forceEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPreStartMetadataGenerators() {
        log.info((Object)"Running prestart metadata generators. Do not turn off server while this is running.");
        final TxManager txman = this.repository.getTxManager();
        this.initializeGeneratorState();
        while (!this.shutdown) {
            log.trace((Object)"acquiring lock");
            final UUID generatorStateLock = this.acquirePreStartGeneratorStateLock();
            log.trace((Object)"lock acquired");
            txman.forceBegin();
            try {
                if (generatorStateLock == null) {
                    if (!this.allPreStartGeneratorsComplete()) continue;
                    log.trace((Object)"All pre start versioned metadata generators have been processed.");
                    break;
                }
                txman.queueFinallyWork(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        txman.forceBegin();
                        try {
                            log.trace((Object)"unlocking");
                            RecordMetadataGeneratorState generatorState = RecordMetadataService.this.getGeneratorState(generatorStateLock);
                            generatorState.setLocked(false);
                            txman.commit();
                        }
                        finally {
                            txman.forceEnd();
                        }
                    }
                });
                log.trace((Object)"getting generator state");
                RecordMetadataGeneratorState generatorState = this.getGeneratorState(generatorStateLock);
                log.trace((Object)"processing generator");
                this.processPreStartGenerator(generatorState);
                txman.commit();
            }
            finally {
                txman.forceEnd();
            }
        }
        log.info((Object)"Prestart metadata generators complete.");
    }

    private boolean allPreStartGeneratorsComplete() {
        List<RecordMetadataGeneratorState> incompleteGenStates = this.getIncompleteMetadataGenerators();
        Set<String> preStartGeneratorNames = this.getPrestartMetadataGeneratorNames();
        for (RecordMetadataGeneratorState genState : incompleteGenStates) {
            if (!preStartGeneratorNames.contains(genState.getMetadataGeneratorName())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID acquirePreStartGeneratorStateLock() {
        UUID result = null;
        Set<String> preStartGeneratorNames = this.getPrestartMetadataGeneratorNames();
        TxManager txman = this.repository.getTxManager();
        txman.forceBegin();
        try {
            Disjunction containsPreStartGeneratorName = Restrictions.disjunction();
            for (String name : preStartGeneratorNames) {
                containsPreStartGeneratorName.add((Criterion)Restrictions.eq((String)"metadataGeneratorName", (Object)name));
            }
            result = this.acquireLockForGenerator(containsPreStartGeneratorName);
        }
        finally {
            txman.forceEnd();
        }
        return result;
    }

    private Set<String> getPrestartMetadataGeneratorNames() {
        HashSet<String> preStartGeneratorNames = new HashSet<String>();
        for (RecordMetadataGenerator recordMetadataGenerator : this.repository.getConfiguration().getPreStartMetadataGenerators()) {
            preStartGeneratorNames.add(recordMetadataGenerator.getClass().getName());
        }
        return preStartGeneratorNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID acquireGeneratorStateLock() {
        UUID result = null;
        TxManager txman = this.repository.getTxManager();
        txman.forceBegin();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Acquire Unupgraded version start ");
            }
            result = this.acquireLockForGenerator(null);
        }
        finally {
            txman.forceEnd();
        }
        return result;
    }

    private UUID acquireLockForGenerator(Disjunction validGenerators) {
        UUID result = null;
        TxManager txman = this.repository.getTxManager();
        Criteria crit = txman.getSession().createCriteria(RecordMetadataGeneratorState.class);
        crit.add((Criterion)Restrictions.eq((String)"locked", (Object)false));
        crit.add((Criterion)Restrictions.neProperty((String)"scanEndCommit", (String)"newestScannedCommit"));
        if (validGenerators != null) {
            crit.add((Criterion)validGenerators);
        }
        crit.setMaxResults(1);
        RecordMetadataGeneratorState generatorState = (RecordMetadataGeneratorState)crit.uniqueResult();
        if (generatorState != null) {
            RecordMetadataGeneratorState genState;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Acquire Unupgraded Lock - Acquire ROW LOCK for " + generatorState.getId()));
            }
            if (!(genState = this.getGeneratorState(generatorState.getId())).isLocked().booleanValue()) {
                genState.setLocked(true);
                result = genState.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Acquire Unupgraded Lock - set locked true for " + genState.getId()));
                }
            } else {
                log.debug((Object)"Lock currently held");
            }
        }
        txman.commit();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Acquired Unupgraded Lock - Finish ");
            if (result != null) {
                log.debug((Object)("Acquired Unupgraded Lock - ROW LOCK Released for " + result));
            }
        }
        return result;
    }

    protected void processGenerator(RecordMetadataGeneratorState generatorState) {
        TxManager txman = this.repository.getTxManager();
        Session session = txman.getSession();
        PersistentReader reader = new PersistentReader(this.repository);
        this.repository.getConfiguration().setAdminSecurity();
        long newestScannedCommit = generatorState.getNewestScannedCommit();
        long totalScanEndCommit = generatorState.getScanEndCommit();
        RecordMetadataGenerator generator = this.getMetadataGenerator(generatorState);
        if (generator == null) {
            generatorState.setNewestScannedCommit(totalScanEndCommit);
        } else {
            long thisScanStartCommit = newestScannedCommit + 1L;
            long thisScanEndCommit = thisScanStartCommit + 999L;
            if (thisScanStartCommit > totalScanEndCommit) {
                thisScanStartCommit = totalScanEndCommit;
            }
            if (thisScanEndCommit > totalScanEndCommit) {
                thisScanEndCommit = totalScanEndCommit;
            }
            this.deleteExistingMetadata(thisScanStartCommit, thisScanEndCommit, generator, "GenericRecordMetadata");
            Set<PersistentRecord> persistentRecords = this.getPersistentsForGenerator(generator, thisScanStartCommit, thisScanEndCommit);
            for (PersistentRecord record : persistentRecords) {
                try {
                    Persistent persistent = reader.restore(record, true);
                    Collection<RecordMetadata> metadata = generator.generateMetadata(record, persistent);
                    if (metadata == null) continue;
                    for (RecordMetadata metadatum : metadata) {
                        session.save((Object)metadatum);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to handle record " + record.getPath() + "#" + record.getCommit(), e);
                }
            }
            generatorState.setNewestScannedCommit(thisScanEndCommit);
        }
    }

    protected void processPreStartGenerator(RecordMetadataGeneratorState generatorState) {
        TxManager txman = this.repository.getTxManager();
        Session session = txman.getSession();
        PersistentReader reader = new PersistentReader(this.repository);
        this.repository.getConfiguration().setAdminSecurity();
        long newestScannedCommit = generatorState.getNewestScannedCommit();
        long totalScanEndCommit = generatorState.getScanEndCommit();
        PreStartRecordMetadataGenerator generator = this.getPreStartMetadataGenerator(generatorState);
        if (generator == null) {
            generatorState.setNewestScannedCommit(totalScanEndCommit);
        } else {
            long thisScanStartCommit = newestScannedCommit + 1L;
            long thisScanEndCommit = thisScanStartCommit + 999L;
            thisScanStartCommit = Math.min(thisScanStartCommit, totalScanEndCommit);
            thisScanEndCommit = Math.min(thisScanEndCommit, totalScanEndCommit);
            log.trace((Object)"deleting existing metadata");
            this.deleteExistingMetadata(thisScanStartCommit, thisScanEndCommit, null, generator.getMetadataTableName());
            log.trace((Object)"getting persistents");
            Set<PersistentRecord> persistentRecords = this.getPersistentsForPreStartGenerator(generator, thisScanStartCommit, thisScanEndCommit);
            for (PersistentRecord record : persistentRecords) {
                try {
                    Persistent persistent = reader.restore(record, true);
                    Collection<RecordMetadata> metadata = generator.generateMetadata(record, persistent, true);
                    if (metadata == null) continue;
                    for (RecordMetadata metadatum : metadata) {
                        session.save((Object)metadatum);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to handle record " + record.getPath() + "#" + record.getCommit(), e);
                }
            }
            generatorState.setNewestScannedCommit(thisScanEndCommit);
        }
    }

    private RecordMetadataGenerator getMetadataGenerator(RecordMetadataGeneratorState generatorState) {
        RecordMetadataGenerator result = null;
        String generatorName = generatorState.getMetadataGeneratorName();
        for (RecordMetadataGenerator generator : this.repository.getConfiguration().getMetadataGenerators()) {
            if (!generatorName.equals(generator.getClass().getName())) continue;
            result = generator;
        }
        return result;
    }

    private PreStartRecordMetadataGenerator getPreStartMetadataGenerator(RecordMetadataGeneratorState generatorState) {
        PreStartRecordMetadataGenerator result = null;
        String generatorName = generatorState.getMetadataGeneratorName();
        for (PreStartRecordMetadataGenerator generator : this.repository.getConfiguration().getPreStartMetadataGenerators()) {
            if (!generatorName.equals(generator.getClass().getName())) continue;
            result = generator;
        }
        return result;
    }

    private Set<PersistentRecord> getPersistentsForGenerator(RecordMetadataGenerator metadataGenerator, long startCommit, long endCommit) {
        HashSet<PersistentRecord> result = new HashSet<PersistentRecord>();
        TxManager txman = this.repository.getTxManager();
        Criteria criteria = txman.getSession().createCriteria(PersistentRecord.class);
        criteria.add((Criterion)Restrictions.ge((String)"commit.id", (Object)startCommit));
        criteria.add((Criterion)Restrictions.le((String)"commit.id", (Object)endCommit));
        Collection<RecordMetadataGenerator.GeneratorFilter> filters = metadataGenerator.getFilters();
        if (filters != null && !filters.isEmpty()) {
            Disjunction disjunction = Restrictions.disjunction();
            for (RecordMetadataGenerator.GeneratorFilter filter : filters) {
                String fieldName = null;
                if (filter.getField() == RecordMetadataGenerator.GeneratorFilterField.DIRECTORY) {
                    fieldName = "directory";
                } else if (filter.getField() == RecordMetadataGenerator.GeneratorFilterField.PATH) {
                    fieldName = "path";
                }
                if (filter.getComparison() == RecordMetadataGenerator.GeneratorFilterComparison.EQ) {
                    disjunction.add((Criterion)Restrictions.eq((String)fieldName, (Object)filter.getValue()));
                    continue;
                }
                if (filter.getComparison() != RecordMetadataGenerator.GeneratorFilterComparison.LIKE) continue;
                disjunction.add((Criterion)Restrictions.like((String)fieldName, (Object)filter.getValue()));
            }
            criteria.add((Criterion)disjunction);
        }
        criteria.setFetchSize(1000);
        for (Object rawResult : criteria.list()) {
            result.add((PersistentRecord)rawResult);
        }
        return result;
    }

    private Set<PersistentRecord> getPersistentsForPreStartGenerator(RecordMetadataGenerator metadataGenerator, long startCommit, long endCommit) {
        HashSet<PersistentRecord> result = new HashSet<PersistentRecord>();
        TxManager txman = this.repository.getTxManager();
        Criteria criteria = txman.getSession().createCriteria(LatestVersionEntry.class);
        criteria.add((Criterion)Restrictions.ge((String)"commit", (Object)startCommit));
        criteria.add((Criterion)Restrictions.le((String)"commit", (Object)endCommit));
        criteria.add((Criterion)Restrictions.eq((String)"deleted", (Object)false));
        Collection<RecordMetadataGenerator.GeneratorFilter> filters = metadataGenerator.getFilters();
        if (filters != null && !filters.isEmpty()) {
            Disjunction disjunction = Restrictions.disjunction();
            for (RecordMetadataGenerator.GeneratorFilter filter : filters) {
                String fieldName = null;
                if (filter.getField() == RecordMetadataGenerator.GeneratorFilterField.DIRECTORY) {
                    fieldName = "directory";
                } else if (filter.getField() == RecordMetadataGenerator.GeneratorFilterField.PATH) {
                    fieldName = "path";
                }
                if (filter.getComparison() == RecordMetadataGenerator.GeneratorFilterComparison.EQ) {
                    disjunction.add((Criterion)Restrictions.eq((String)fieldName, (Object)filter.getValue()));
                    continue;
                }
                if (filter.getComparison() != RecordMetadataGenerator.GeneratorFilterComparison.LIKE) continue;
                disjunction.add((Criterion)Restrictions.like((String)fieldName, (Object)filter.getValue()));
            }
            criteria.add((Criterion)disjunction);
        }
        criteria.setFetchSize(1000);
        criteria.setProjection((Projection)Projections.property((String)"record"));
        for (Object rawResult : criteria.list()) {
            result.add((PersistentRecord)rawResult);
        }
        return result;
    }

    private void deleteExistingMetadata(Long startCommit, Long endCommit, RecordMetadataGenerator metadataGenerator, String tableName) {
        TxManager txman = this.repository.getTxManager();
        String queryString = "delete from " + tableName + " " + "where recordCommit >= :startCommit " + "and recordCommit <= :endCommit ";
        if (metadataGenerator != null) {
            queryString = queryString + "and metadataGeneratorName = :generatorName";
        }
        Query deleteQuery = txman.getSession().createQuery(queryString);
        deleteQuery.setParameter("startCommit", (Object)startCommit);
        deleteQuery.setParameter("endCommit", (Object)endCommit);
        if (metadataGenerator != null) {
            deleteQuery.setParameter("generatorName", (Object)metadataGenerator.getClass().getName());
        }
        deleteQuery.executeUpdate();
    }

    public List<RecordMetadataGeneratorState> getIncompleteMetadataGenerators() {
        TxManager txman = this.repository.getTxManager();
        Criteria crit = txman.getSession().createCriteria(RecordMetadataGeneratorState.class);
        crit.add((Criterion)Restrictions.neProperty((String)"scanEndCommit", (String)"newestScannedCommit"));
        return crit.list();
    }

    public List<RecordMetadataGeneratorState> getAllMetadataGeneratorState() {
        TxManager txman = this.repository.getTxManager();
        Criteria crit = txman.getSession().createCriteria(RecordMetadataGeneratorState.class);
        return crit.list();
    }

    private RecordMetadataGeneratorState getGeneratorState(UUID id) {
        TxManager txman = this.repository.getTxManager();
        Session session = txman.getSession();
        return (RecordMetadataGeneratorState)session.get(RecordMetadataGeneratorState.class, (Serializable)id, LockOptions.UPGRADE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.repositorySynchronizer;
        synchronized (object) {
            this.shutdown = true;
            this.repositorySynchronizer.notifyAll();
        }
    }
}

