/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class RequiredApprovalsAdvisor
implements IOperationAdvisor {
    public static final String APPROVAL_STATE = "approvalState";
    public static final String APPROVAL_TYPE = "approvalType";
    public static final String WORK_ITEM_TYPE = "workItemType";
    public static final String STATE_ID = "stateId";
    public static final String APPROVAL = "approval";
    public static final String OPTIONS = "options";
    public static final String ONLY_IF_PRESENT = "onlyIfPresent";
    public static final String ID = "com.ibm.team.workitem.advisor.requiredApprovals";

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object data = operation.getOperationData();
        if (data instanceof ISaveParameter) {
            ISaveParameter saveParameter = (ISaveParameter)data;
            this.addProblems(advisorConfiguration, saveParameter, collector, monitor);
        }
    }

    private void addProblems(IProcessConfigurationElement advisorConfiguration, ISaveParameter saveParameter, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditable auditable = saveParameter.getNewState();
        if (auditable instanceof IWorkItem) {
            IWorkItem workItem;
            IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            IWorkItemType workItemType = workItemCommon.findWorkItemType((workItem = (IWorkItem)auditable).getProjectArea(), workItem.getWorkItemType(), monitor);
            if (workItemType == null) {
                return;
            }
            String stateId = RequiredApprovalsAdvisor.findTargetStateId(workItem, saveParameter.getWorkflowAction(), workItemCommon, monitor);
            if (stateId == null) {
                return;
            }
            IProcessConfigurationElement[] configurationElements = advisorConfiguration.getChildren();
            HashMap approvalTypes = null;
            boolean onlyIfPresent = false;
            LocalizationContext lc = LocalizationContext.createProjectAreaContext(auditableCommon, workItem.getProjectArea(), monitor);
            int i = 0;
            while (i < configurationElements.length) {
                IProcessConfigurationElement configurationElement = configurationElements[i];
                if (APPROVAL.equals(configurationElement.getName())) {
                    if (stateId.equals(configurationElement.getAttribute(STATE_ID)) && workItemType.getIdentifier().equals(configurationElement.getAttribute(WORK_ITEM_TYPE))) {
                        String approvalType;
                        HashSet<String> approvalStates;
                        if (approvalTypes == null) {
                            approvalTypes = new HashMap();
                        }
                        if ((approvalStates = (HashSet)approvalTypes.get(approvalType = configurationElement.getAttribute(APPROVAL_TYPE))) == null) {
                            approvalStates = new HashSet<String>();
                            approvalTypes.put(approvalType, approvalStates);
                        }
                        String approvalState = configurationElement.getAttribute(APPROVAL_STATE);
                        approvalStates.add(approvalState);
                    }
                } else if (OPTIONS.equals(configurationElement.getName())) {
                    onlyIfPresent = Boolean.valueOf(configurationElement.getAttribute(ONLY_IF_PRESENT));
                }
                ++i;
            }
            if (approvalTypes != null) {
                HashSet<String> presentApprovalTypes = new HashSet<String>();
                List<IApprovalDescriptor> descriptors = workItem.getApprovals().getDescriptors();
                for (IApprovalDescriptor d : descriptors) {
                    HashSet approvalStates = (HashSet)approvalTypes.get(d.getTypeIdentifier());
                    if (approvalStates != null && approvalStates.contains(d.getCumulativeStateIdentifier())) {
                        approvalTypes.remove(d.getTypeIdentifier());
                    }
                    presentApprovalTypes.add(d.getTypeIdentifier());
                }
                if (!approvalTypes.isEmpty()) {
                    TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
                    Set typeNames = approvalTypes.keySet();
                    for (String approvalType : typeNames) {
                        if (onlyIfPresent && !presentApprovalTypes.contains(approvalType)) continue;
                        HashSet approvalStates = (HashSet)approvalTypes.get(approvalType);
                        IAdvisorInfo info = collector.createProblemInfo(this.getSummary(approvalType, lc), this.getDescription(workItem, approvalType, approvalStates, userTimeZone, lc), ID);
                        info.setProblemObject((Object)workItem.getItemHandle());
                        collector.addInfo((IReportInfo)info);
                    }
                }
            }
        }
    }

    public static String findTargetStateId(IWorkItem workItem, String actionId, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        Identifier<IState> state = workItem.getState2();
        IWorkflowInfo wfInfo = ((WorkItemCommon)workItemCommon).findWorkflowInfo(workItem, monitor);
        if (state == null && actionId == null && wfInfo != null) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
        }
        if (wfInfo != null && state != null && !Arrays.asList(wfInfo.getAllStateIds()).contains(state)) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
        }
        if (actionId != null && wfInfo != null && (state = wfInfo.getActionResultState(Identifier.create(IWorkflowAction.class, actionId))) == null) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
            if (actionId != null) {
                state = wfInfo.getActionResultState(Identifier.create(IWorkflowAction.class, actionId));
            }
        }
        if (state != null) {
            String stateId = state.getStringIdentifier();
            try {
                Integer.parseInt(stateId);
                stateId = "s" + stateId;
            }
            catch (NumberFormatException numberFormatException) {}
            return stateId;
        }
        return null;
    }

    private String getSummary(String approvalType, LocalizationContext lc) {
        IApprovalType type = WorkItemApprovals.getType(approvalType);
        String typeName = null;
        if (type != null) {
            typeName = type.getDisplayName(lc);
        }
        if (typeName == null) {
            typeName = approvalType;
        }
        return NLS.bind((String)Messages.getString("RequiredApprovalsAdvisor.APPROVAL_NOT_PRESENT_SUMMARY"), (Object)typeName, (Object[])new Object[0]);
    }

    private String getDescription(IWorkItem workItem, String approvalType, HashSet<String> approvalStates, TimeZone userTimeZone, LocalizationContext lc) {
        IApprovalType type = WorkItemApprovals.getType(approvalType);
        String typeName = null;
        if (type != null) {
            typeName = type.getDisplayName(lc);
        }
        if (typeName == null) {
            typeName = approvalType;
        }
        String states = null;
        for (String approvalState : approvalStates) {
            IApprovalState state = WorkItemApprovals.getState(approvalState);
            String stateName = state != null ? state.getDisplayName(lc) : approvalState;
            stateName = NLS.bind((String)Messages.getString("RequiredApprovalsAdvisor.APPROVAL_QUOTE"), (Object)stateName, (Object[])new Object[0]);
            states = states == null ? stateName : NLS.bind((String)Messages.getString("RequiredApprovalsAdvisor.APPROVAL_MULTIPLE"), (Object)states, (Object[])new Object[]{stateName});
        }
        String format = approvalStates.size() > 1 ? Messages.getString("RequiredApprovalsAdvisor.APPROVAL_NOT_PRESENT_PLURAL_DESCRIPTION") : Messages.getString("RequiredApprovalsAdvisor.APPROVAL_NOT_PRESENT_DESCRIPTION");
        return NLS.bind((String)format, (Object)WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone), (Object[])new Object[]{typeName, states});
    }
}

