/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.internal.expression.Messages;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class QueryDescriptorQueryAttributeFactory
implements IQueryableAttributeFactory {
    private static QueryableAttributeDescriptor[] QUERY_DESCRIPTOR_ATTRIBUTES = new QueryableAttributeDescriptor[]{new QueryableAttributeDescriptor(IQueryDescriptor.NAME_PROPERTY, Messages.getString("QueryDescriptorQueryAttributeFactory.QUERY_NAME"), "smallString"), new QueryableAttributeDescriptor(IQueryDescriptor.CREATOR_PROPERTY, Messages.getString("QueryDescriptorQueryAttributeFactory.QUERY_CREATED_BY"), "contributor"), new QueryableAttributeDescriptor(IQueryDescriptor.TYPE_PROPERTY, Messages.getString("QueryDescriptorQueryAttributeFactory.QUERY_TYPE"), "smallString"), new QueryableAttributeDescriptor(IQueryDescriptor.TAGS_PROPERTY, Messages.getString("QueryDescriptorQueryAttributeFactory.QUERY_TAGS"), "smallString"), new QueryableAttributeDescriptor(IQueryDescriptor.PROJECTAREA_PROPERTY, Messages.getString("QueryDescriptorQueryAttributeFactory.QUERY_PROJECT_AREA"), "projectArea"), new QueryableAttributeDescriptor(IQueryDescriptor.ID_PROPERTY, Messages.getString("QueryDescriptorQueryAttributeFactory.QUERY_ID"), "smallString")};

    @Override
    public IQueryableAttribute findAttribute(IProjectAreaHandle projectArea, String attributeIdentifier, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = QUERY_DESCRIPTOR_ATTRIBUTES;
        int n = QUERY_DESCRIPTOR_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            if (descriptor.getIdentifier().equals(attributeIdentifier)) {
                return new QueryableAttribute(descriptor);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public List<IQueryableAttribute> findAllAttributes(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>();
        QueryableAttributeDescriptor[] queryableAttributeDescriptorArray = QUERY_DESCRIPTOR_ATTRIBUTES;
        int n = QUERY_DESCRIPTOR_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            QueryableAttributeDescriptor descriptor = queryableAttributeDescriptorArray[n2];
            attributes.add(new QueryableAttribute(descriptor));
            ++n2;
        }
        return attributes;
    }

    public ItemProfile<IQueryDescriptor> computeProfile(List<IQueryableAttribute> attributes) {
        ArrayList<String> attributeIds = new ArrayList<String>(attributes.size());
        for (IQueryableAttribute attribute : attributes) {
            attributeIds.add(attribute.getIdentifier());
        }
        return IQueryDescriptor.SMALL_PROFILE.createExtension(attributeIds);
    }

    @Override
    public List<String> getDefaultAttributeSet(IQueryableAttributeFactory.AttributeSet set) {
        return Arrays.asList(IQueryDescriptor.NAME_PROPERTY, IQueryDescriptor.CREATOR_PROPERTY);
    }
}

