/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.workitem.common.internal.query.IExportDescriptor;
import com.ibm.team.workitem.common.internal.query.util.Messages;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExportLocations {
    public static final String URL_PARAM_COLUMNS = "col";
    public static final String URL_PARAM_EXPORTER = "exporter";
    public static final String URL_PARAM_VALUE_ID = "id";
    public static final String URL_PARAM_SORT_ID = "sortId";
    public static final String URL_PARAM_SORT_ORDER = "sortOrder";
    public static final String URL_PARAM_LINK_STYLE = "_linkStyle";
    public static final String URL_PARAM_LINK_STYLE_ABSOLUTE = "absolute";
    public static final String URL_PARAM_FIELD_DELIMITER = "fieldDelimiter";
    public static final String URL_PARAM_QUOTE_STRINGS = "quoteStrings";
    public static final String URL_PARAM_HEADERS_INCLUDED = "headersIncluded";
    public static final String URL_PARAM_ENCODING = "encoding";

    public static Location createExportLocation(IQueryDescriptorHandle handle, IExportDescriptor exportDescriptor, Map<String, List<String>> queryParams, String repoUrl) {
        return ExportLocations.createExportLocation(handle, exportDescriptor.getContentType(), queryParams, repoUrl);
    }

    public static Location createExportLocation(IQueryDescriptorHandle handle, ExportType exportType, Map<String, List<String>> queryParams, String repoUrl) {
        return ExportLocations.createExportLocation(handle, exportType.toString(), queryParams, repoUrl);
    }

    private static Location createExportLocation(IQueryDescriptorHandle handle, String mediaType, Map<String, List<String>> queryParams, String repoUrl) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("_mediaType", Collections.singletonList(mediaType));
        if (queryParams != null) {
            parameters.putAll(queryParams);
        }
        String queryString = ExportLocations.createQueryString(parameters);
        return Location.itemLocation((IItemHandle)handle, (String)repoUrl, (String)queryString, null);
    }

    public static String createQueryString(Map<String, List<String>> parameters) {
        if (parameters == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<String> keyIterator = parameters.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            List<String> values = parameters.get(key);
            if (values == null) continue;
            Iterator<String> valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                buffer.append(key);
                buffer.append("=");
                buffer.append(valueIterator.next());
                if (!keyIterator.hasNext() && !valueIterator.hasNext()) continue;
                buffer.append("&");
            }
        }
        return buffer.toString();
    }

    public static enum ExportType {
        CSV("text/csv"),
        HTML("text/html");

        private final String fId;

        private ExportType(String id) {
            this.fId = id;
        }

        public String toString() {
            return this.fId;
        }
    }

    public static enum FileEncoding {
        UTF8(Messages.getString("FILE_ENCODING_UTF-8"), "UTF-8", false, new byte[]{-17, -69, -65}),
        UTF16LE(Messages.getString("FILE_ENCODING_UTF-16LE"), "UTF-16LE", true, new byte[]{-1, -2});

        private final String fLabel;
        private final String fCharsetName;
        private final byte[] fBOM;
        private boolean fBOMEnabled;

        private FileEncoding(String label, String charsetName, boolean BOMEnabled, byte[] BOM2) {
            this.fLabel = label;
            this.fCharsetName = charsetName;
            this.fBOM = BOM2;
            this.fBOMEnabled = BOMEnabled;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getCharsetName() {
            return this.fCharsetName;
        }

        public byte[] getBOM() {
            return this.fBOM;
        }

        public boolean isBOMEnabled() {
            return this.fBOMEnabled;
        }
    }
}

