/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.links.common.internal.registry.LinkTypeRegistry;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.workitem.common.internal.template.Messages;
import com.ibm.team.workitem.common.internal.template.xml.IllegalFormatException;
import com.ibm.team.workitem.common.internal.template.xml.XMLTemplateParser;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.template.IWorkItemTemplate;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WorkItemTemplateCheck {
    private static final IStatus STATUS_OK = new Status(0, "com.ibm.team.workitem.common", Messages.getString("WorkItemTemplateCheck.STATUS_OK_VALID_TEMPLATE"));
    private static final IStatus STATUS_ERROR = new Status(4, "com.ibm.team.workitem.common", Messages.getString("WorkItemTemplateCheck.STATUS_ERROR_INVALID_TEMPLATE"));
    private static final IStatus STATUS_WARNING = new Status(2, "com.ibm.team.workitem.common", Messages.getString("WorkItemTemplateCheck.STATUS_WARN_REFERENCES_IN_TEMPLATE"));
    private static final IStatus STATUS_URI_LINKS_WARNING = new Status(2, "com.ibm.team.workitem.common", Messages.getString("WorkItemTemplateCheck.STATUS_WARN_URI_REFERENCES_IN_TEMPLATE"));
    private static final Set<String> ALLOWED_TEMPLATE_URI_LINKS = new HashSet<String>(Arrays.asList(WorkItemEndPoints.RELATED_ARTIFACT.getLinkType().getLinkTypeId(), WorkItemEndPoints.MENTIONS.getLinkType().getLinkTypeId(), WorkItemEndPoints.ATTACHMENT.getLinkType().getLinkTypeId()));
    private static volatile Pattern fgInvalidTemplateLinksPattern;
    private static final Object fgLock;

    static {
        fgLock = new Object();
    }

    public static IStatus isValid(IWorkItemTemplateHandle template) {
        return template != null && WorkItemTemplateCheck.isValidString(template.getId()) && WorkItemTemplateCheck.isValidString(template.getName()) ? STATUS_OK : STATUS_ERROR;
    }

    public static IStatus isValid(IWorkItemTemplate template) {
        IStatus handleStatus = WorkItemTemplateCheck.isValid((IWorkItemTemplateHandle)template);
        if (handleStatus.getSeverity() == 0) {
            return WorkItemTemplateCheck.isValid(template.getContent());
        }
        return handleStatus;
    }

    public static IStatus isValid(String templateContent) {
        if (!WorkItemTemplateCheck.isValidSpecification(templateContent) || !WorkItemTemplateCheck.isValidXml(templateContent)) {
            return STATUS_ERROR;
        }
        if (WorkItemTemplateCheck.containsItemReferences(templateContent)) {
            return STATUS_WARNING;
        }
        if (WorkItemTemplateCheck.isInvalidTemplate(templateContent)) {
            return STATUS_URI_LINKS_WARNING;
        }
        return STATUS_OK;
    }

    public static IStatus isValid(String id, String name, String path) {
        return WorkItemTemplateCheck.isValidString(id) && WorkItemTemplateCheck.isValidString(name) && WorkItemTemplateCheck.isValidString(path) ? STATUS_OK : STATUS_ERROR;
    }

    public static boolean isInvalidTemplate(String templateContent) {
        return WorkItemTemplateCheck.getInvalidTemplateLinksPattern().matcher(templateContent).find();
    }

    public static boolean isValidForTemplate(IEndPointDescriptor end) {
        return end != null && (end.isItemReference() || ALLOWED_TEMPLATE_URI_LINKS.contains(end.getLinkType().getLinkTypeId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pattern getInvalidTemplateLinksPattern() {
        if (fgInvalidTemplateLinksPattern == null) {
            Object object = fgLock;
            synchronized (object) {
                if (fgInvalidTemplateLinksPattern == null) {
                    HashSet<String> all = new HashSet<String>();
                    for (Object entry : LinkTypeRegistry.INSTANCE.allEntries()) {
                        ILinkType linkType = (ILinkType)entry;
                        if (WorkItemTemplateCheck.isValidForTemplate(linkType.getTargetEndPointDescriptor())) continue;
                        all.add(Pattern.quote(linkType.getLinkTypeId()));
                    }
                    String regex = CollectionUtils.join(all, "|");
                    fgInvalidTemplateLinksPattern = Pattern.compile(regex);
                }
            }
        }
        return fgInvalidTemplateLinksPattern;
    }

    private static boolean isValidSpecification(String templateContent) {
        return WorkItemTemplateCheck.isValidString(templateContent) && templateContent.indexOf("<rtc_cm:WorkItemTemplate") > -1 && templateContent.indexOf("</rtc_cm:WorkItemTemplate>") > -1 && templateContent.indexOf("<rtc_cm:workItems>") > -1 && templateContent.indexOf("</rtc_cm:workItems>") > -1;
    }

    private static boolean containsItemReferences(String templateContent) {
        return templateContent.split("rdf:resource=\\\"[^>]*_[\\w-]{22}").length > 1;
    }

    private static boolean isValidString(String string) {
        return string != null && string.length() > 0;
    }

    private static boolean isValidXml(String content) {
        try {
            XMLTemplateParser.parseTemplateXml(content);
        }
        catch (IllegalFormatException illegalFormatException) {
            return false;
        }
        return true;
    }
}

