/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseItemHandleQueryModel;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.internal.model.query.BaseWorkItemQueryModel;
import com.ibm.team.workitem.common.internal.util.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class WorkItemDataIntegrity {
    private IAuditableCommon fAuditableCommon;

    public WorkItemDataIntegrity(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
    }

    public IStatus verify(IProgressMonitor monitor) throws TeamRepositoryException {
        MultiStatus status = new MultiStatus("com.ibm.team.workitem.common", 0, Messages.getString("WorkItemDataIntegrity.NAME"), null);
        BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        status.add(this.verify(model, (BaseItemHandleQueryModel)model.projectArea(), "WorkItem.projectArea", "ProjectArea", monitor));
        status.add(this.verify(model, (BaseItemHandleQueryModel)model.category(), "WorkItem.category", "Category", monitor));
        status.add(this.verify(model, (BaseItemHandleQueryModel)model.target(), "WorkItem.target", "Iteration", monitor));
        status.add(this.verify(model, (BaseItemHandleQueryModel)model.foundIn(), "WorkItem.foundIn", "Deliverable", monitor));
        return status;
    }

    private IStatus verify(BaseWorkItemQueryModel.WorkItemQueryModel model, BaseItemHandleQueryModel property, String propertyName, String typeName, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryIterator<UUID> missingIter = this.danglingReferences(model, property);
        int limit = 10;
        try {
            if (missingIter.hasNext(monitor)) {
                ArrayList<UUID> first10Missing = new ArrayList<UUID>();
                int size = 0;
                while (missingIter.hasNext(monitor)) {
                    UUID missing = missingIter.next(monitor);
                    if (size < limit) {
                        first10Missing.add(missing);
                    }
                    ++size;
                }
                StringBuilder builder = new StringBuilder();
                builder.append(NLS.bind((String)Messages.getString("WorkItemDataIntegrity.DANGLING_REFERENCES"), (Object)propertyName, (Object[])new Object[]{size, typeName}));
                builder.append('\n');
                for (UUID missing : first10Missing) {
                    QueryIterator<IDataRow> affectedItems = this.affectedItems(model, property, missing);
                    int count = 0;
                    String workItems = "";
                    try {
                        int j = 0;
                        while (j < limit && affectedItems.hasNext(monitor)) {
                            IDataRow row = affectedItems.next(monitor);
                            String tmp = NLS.bind((String)Messages.getString("WorkItemDataIntegrity.REFERENCE"), (Object)row.getUUID(0).getUuidValue(), (Object[])new Object[]{row.getInt(1)});
                            workItems = j == 0 ? tmp : NLS.bind((String)Messages.getString("WorkItemDataIntegrity.REFERENCE_LIST"), (Object)workItems, (Object[])new Object[]{tmp});
                            ++count;
                            ++j;
                        }
                        boolean hasMore = affectedItems.hasNext(monitor);
                        while (affectedItems.hasNext(monitor)) {
                            affectedItems.next(monitor);
                            ++count;
                        }
                        if (hasMore) {
                            builder.append(NLS.bind((String)Messages.getString("WorkItemDataIntegrity.DANGLING_REFERENCE_CONTINUED"), (Object)typeName, (Object[])new Object[]{missing.getUuidValue(), count}));
                        } else {
                            builder.append(NLS.bind((String)Messages.getString("WorkItemDataIntegrity.DANGLING_REFERENCE"), (Object)typeName, (Object[])new Object[]{missing.getUuidValue(), count, workItems}));
                        }
                        builder.append('\n');
                    }
                    finally {
                        affectedItems.close();
                    }
                }
                if (missingIter.hasNext(monitor)) {
                    builder.append(Messages.getString("WorkItemDataIntegrity.CONTINUED"));
                }
                Status status = new Status(4, "com.ibm.team.workitem.common", builder.toString().trim());
                return status;
            }
        }
        finally {
            missingIter.close();
        }
        return new Status(0, "com.ibm.team.workitem.common", NLS.bind((String)Messages.getString("WorkItemDataIntegrity.NO_DANGLING_REFERENCES"), (Object)propertyName, (Object[])new Object[0]));
    }

    private QueryIterator<UUID> danglingReferences(BaseWorkItemQueryModel.WorkItemQueryModel model, BaseItemHandleQueryModel property) {
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        query.filter(((ISingleItemQueryModel)property)._isNull()._not()._and(((ISingleItemQueryModel)property)._isMissing()));
        query.select((ISelectionElement)property.itemId());
        query.distinct();
        return this.fAuditableCommon.getDataQueryIterator(query, null, null, null);
    }

    private QueryIterator<IDataRow> affectedItems(BaseWorkItemQueryModel.WorkItemQueryModel model, BaseItemHandleQueryModel property, UUID uuid) {
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        query.filter(property.itemId()._eq((IUUID)query.newUUIDArg()));
        query.select((ISelectionElement)model.itemId(), (ISelectionElement)model.id());
        return this.fAuditableCommon.getDataRowQueryIterator(query, new Object[]{uuid}, null, null);
    }
}

