/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.ContextLock;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IHistoricBaselineIterator;
import com.ibm.team.scm.client.internal.BaselinesInHistoryIterator;
import com.ibm.team.scm.client.internal.ChangeHistoryEvent;
import com.ibm.team.scm.client.internal.ClientChangeHistoryProxy;
import com.ibm.team.scm.client.internal.ClientComponentInfo;
import com.ibm.team.scm.client.internal.ClientCurrentComponentInfo;
import com.ibm.team.scm.client.internal.ClientPastComponentInfo;
import com.ibm.team.scm.client.internal.ConfigurationUpdateEvent;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.ConnectionBasedClientConfigurationProxy;
import com.ibm.team.scm.client.internal.FlowTable;
import com.ibm.team.scm.client.internal.MergedBaselineHistoryIterator;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.PatchUpdateEvent;
import com.ibm.team.scm.client.internal.RemoteRepoDescriptorUtils;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.WorkspaceConnection;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.FlowFlags;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.InvalidAuthenticationTokenException;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IChangeSetFlowReport;
import com.ibm.team.scm.common.dto.IComponentOpDescriptor;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ComponentHandle;
import com.ibm.team.scm.common.internal.ConfigUtil;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.FlowEntry;
import com.ibm.team.scm.common.internal.HistoricBasis;
import com.ibm.team.scm.common.internal.IScmQueryService;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.team.scm.common.internal.dto.BaselinesInHistoryResult;
import com.ibm.team.scm.common.internal.dto.MergedBaselineResult;
import com.ibm.team.scm.common.internal.dto.PastComponent;
import com.ibm.team.scm.common.internal.dto.RemoteRepoDescriptor;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.ServiceHistoryProvider;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshParameter;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceUpdateReportResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class FlowNodeConnection
extends Connection
implements IFlowNodeConnection {
    protected final Object lock = new Object();
    protected final IWorkspaceHandle workspaceHandle;
    protected final Workspace workspace;
    protected SyncTime vTime;
    protected Map<UUID, ClientCurrentComponentInfo> cachedComponents = Collections.EMPTY_MAP;
    protected Map<UUID, IComponentHandle> inaccessibleComponents = Collections.EMPTY_MAP;
    protected IFlowTable flowTable = new FlowTable();
    private final IFlowNodeConnection.IComponentOpFactory componentOpFactory = new ComponentOpFactory();
    public static final Log log = LogFactory.getLog(FlowNodeConnection.class);

    protected WorkspaceRefreshParameter getDeltaParameter() {
        WorkspaceRefreshParameter parm = ScmDtoFactory.eINSTANCE.createWorkspaceRefreshParameter();
        parm.setContributorState(this.workspaceManager.getRefreshParameter());
        return parm;
    }

    FlowNodeConnection(WorkspaceManager workspaceManager, WorkspaceRefreshResult refreshResult) throws TeamRepositoryException {
        super(workspaceManager);
        if (refreshResult == null) {
            throw new IllegalArgumentException();
        }
        List updates = this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(refreshResult.getWorkspace()));
        Workspace ws = (Workspace)updates.get(0);
        this.vTime = new SyncTime(ws.getTime() - 1L);
        this.workspaceHandle = (IWorkspaceHandle)ItemUtil.createItemHandle((ItemType)((ItemType)IWorkspace.ITEM_TYPE), (UUID)refreshResult.getWorkspaceItemId(), (UUID)ws.getStateId());
        this.workspace = ws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validate() throws ItemNotFoundException {
        Workspace workspace = this.workspace;
        WeakReference<WorkspaceConnection> ref = null;
        Object object = this.workspaceManager.lock;
        synchronized (object) {
            ref = this.workspaceManager.knownWorkspaceConnections.get(workspace.getItemId());
        }
        if (ref == null) {
            String msg = NLS.bind((String)Messages.FlowNodeConnection_0, (Object[])new Object[]{workspace.getName(), workspace.getItemId()}, (Object[])new Object[0]);
            ItemNotFoundException e = new ItemNotFoundException(msg);
            throw e;
        }
        WorkspaceConnection wc = (WorkspaceConnection)ref.get();
        if (wc != this) {
            ItemNotFoundException e;
            if (wc != null) {
                String msg = NLS.bind((String)Messages.FlowNodeConnection_1, (Object[])new Object[]{workspace.getName(), workspace.getItemId()}, (Object[])new Object[0]);
                e = new ItemNotFoundException(msg);
                log.error((Object)e.getMessage(), (Throwable)e);
            } else {
                String msg = NLS.bind((String)Messages.FlowNodeConnection_2, (Object[])new Object[]{workspace.getName(), workspace.getItemId()}, (Object[])new Object[0]);
                e = new ItemNotFoundException(msg);
            }
            throw e;
        }
    }

    protected abstract void refresh(IProgressMonitor var1) throws TeamRepositoryException;

    protected abstract void refresh(boolean var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract void refresh(WorkspaceRefreshResult var1, WorkspaceRefreshParameter var2, boolean var3, IProgressMonitor var4) throws TeamRepositoryException;

    protected abstract void refreshWorkspace(Workspace var1);

    protected abstract void refreshComponentHierarchyCache(IUpdateReport var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IWorkspaceHandle getWorkspaceHandle() {
        return this.workspaceHandle;
    }

    protected boolean ownerLoggedIn() {
        if (!this.workspaceManager.teamRepository().loggedIn()) {
            return false;
        }
        return this.workspaceManager.teamRepository().loggedInContributor().sameItemId((IItemHandle)this.getOwner());
    }

    @Override
    public IWorkspace getResolvedWorkspace() {
        return this.workspace;
    }

    @Override
    public IAuditableHandle getOwner() {
        return this.workspace.getOwner();
    }

    @Override
    public String getDescription() {
        return this.workspace.getDescription();
    }

    @Override
    public String getExclusiveFileLockPatterns() {
        String patternString;
        if (!this.isStream()) {
            return null;
        }
        Map properties = this.workspace.getProperties();
        if (properties.containsKey("exclusiveFileLockPattern") && (patternString = (String)properties.get("exclusiveFileLockPattern")) != null) {
            return patternString;
        }
        return "";
    }

    @Override
    public boolean isStream() {
        return this.workspace.isStream();
    }

    @Override
    public String getName() {
        return this.workspace.getName();
    }

    @Override
    public void setName(String name, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setName(name, null, monitor);
    }

    public static int compareTimes(long cachedTime, long newTime) {
        long diff = cachedTime - newTime;
        if (diff == 0L) {
            return 0;
        }
        if (diff < 0L) {
            return -1;
        }
        return 1;
    }

    public void setName(String name, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            try {
                FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " setName() begins");
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                IWorkspaceHandle handle = this.getWorkspaceHandle();
                Workspace workspace = (Workspace)service.setWorkspaceName(handle, name, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                this.refreshWorkspace(workspace);
                FlowNodeConnection.log("Workspace " + workspace.getItemId().getUuidValue() + " setName() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void setDescription(String description, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setDescription(description, null, monitor);
    }

    public void setDescription(String description, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            try {
                FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " setDescription() begins");
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                IWorkspaceHandle handle = this.getWorkspaceHandle();
                Workspace workspace = (Workspace)service.setWorkspaceDescription(handle, description, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                this.refreshWorkspace(workspace);
                FlowNodeConnection.log("Workspace " + workspace.getItemId().getUuidValue() + " setDescription() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void setExclusiveFileLockPatterns(String patterns, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setExclusiveFileLockPatterns(patterns, null, monitor);
    }

    public void setExclusiveFileLockPatterns(String patterns, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isStream() || patterns == null) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            try {
                FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " setExclusiveFileLockPatterns() begins");
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                IWorkspaceHandle handle = this.getWorkspaceHandle();
                Workspace workspace = (Workspace)service.setWorkspaceProperty(handle, "exclusiveFileLockPattern", patterns, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                this.refreshWorkspace(workspace);
                FlowNodeConnection.log("Workspace " + workspace.getItemId().getUuidValue() + " setExclusiveFileLockPatterns() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void setOwner(IAuditableHandle owner, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setOwner(owner, null, monitor);
    }

    public void setOwner(IAuditableHandle owner, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        if (this.isStream() && !(owner instanceof IProcessAreaHandle)) {
            throw new IllegalArgumentException();
        }
        if (!this.isStream() && !(owner instanceof IContributorHandle)) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            try {
                FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " setOwner() begins");
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                IWorkspaceHandle handle = this.getWorkspaceHandle();
                Workspace result = (Workspace)service.setWorkspaceOwner(handle, owner, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                this.refreshWorkspace(result);
                FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " setOwner() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IProcessAreaHandle getProcessArea(IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableHandle ownerHandle = this.getOwner();
        if (ownerHandle instanceof IProcessAreaHandle) {
            IProcessArea area = (IProcessArea)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)ownerHandle, 0, monitor);
            return area.getProjectArea();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISyncTime getVTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.vTime;
        }
    }

    @Override
    public List getBaselineSets(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getBaselineSets(null, monitor);
    }

    public List getBaselineSets(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            SCMClientUtil.checkMonitor(monitor);
            this.validate();
            List list = this.workspaceManager.findBaselineSets(IBaselineSetSearchCriteria.FACTORY.newInstance().setOwnerWorkspaceOptional(this.workspaceHandle), Integer.MAX_VALUE, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            return list;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    protected void refreshItems(Collection<IItemHandle> items, IProgressMonitor monitor) {
        try {
            if (items instanceof List) {
                SCMClientUtil.refreshItemsAsNecessary((List)items, this.teamRepository().itemManager(), monitor);
            } else {
                SCMClientUtil.refreshItemsAsNecessary(new ArrayList<IItemHandle>(items), this.teamRepository().itemManager(), monitor);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {}
    }

    public boolean hasChangeSets(List changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemUtil.isSame((Collection)changeSets, (Collection)this.changeSetsInHistory(changeSets, syncInfo, monitor));
    }

    @Override
    public List changeSetsInHistory(List changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.changeSetsInHistory(changeSets, null, monitor);
    }

    public List changeSetsInHistory(List changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            IChangeSetHandle[] csHandles = changeSets.toArray(new IChangeSetHandle[changeSets.size()]);
            IChangeSetHandle[] result = service.changeSetsInWorkspace(handle, csHandles, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(80);
            SCMClientUtil.checkMonitor(monitor);
            List<IChangeSetHandle> list = Arrays.asList(result);
            return list;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IUpdateReport addComponent(IComponentHandle component, IBaselineConnection baseline, boolean produceDetailedUpdates, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.addComponent(component, baseline, produceDetailedUpdates, null, monitor);
    }

    public IUpdateReport addComponent(IComponentHandle component, IBaselineConnection baseline, boolean produceDetailedReport, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (baseline == null) {
            throw new IllegalArgumentException("baseline cannot be null");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " addComponent() begins");
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            progress.worked(4);
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            IComponentOpDescriptor addComponent = IComponentOpDescriptor.FACTORY.addComponent(component, (IContextHandle)baseline.getBaseline(), produceDetailedReport);
            WorkspaceUpdateReportResult result = service.updateComponents(this.workspaceHandle, null, IComponentOpDescriptor.FACTORY.array(addComponent), false, deltaParameter, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            IUpdateReport updateReport = result.getReport();
            progress.worked(90);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(3));
                this.sendEvent(updateReport, (IProgressMonitor)progress.newChild(2));
            }
            finally {
                this.release();
            }
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " addComponent() ends");
            IUpdateReport iUpdateReport = updateReport;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IUpdateReport replaceComponent(IComponentHandle component, IConnection seedConnection, boolean produceDetailedUpdates, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.replaceComponents(Collections.singletonList(component), Collections.singletonList(seedConnection), Collections.singletonList(produceDetailedUpdates), false, this.getReplaceSynchronizationInfo(Collections.singletonList(component)), monitor);
    }

    @Override
    public IUpdateReport replaceComponent(IComponentHandle component, IConnection seedConnection, boolean produceDetailedUpdates, boolean force, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.replaceComponents(Collections.singletonList(component), Collections.singletonList(seedConnection), Collections.singletonList(produceDetailedUpdates), force, this.getReplaceSynchronizationInfo(Collections.singletonList(component)), monitor);
    }

    @Override
    public IUpdateReport replaceComponents(List components, List seedConnections, List<Boolean> produceDetailedUpdates, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.replaceComponents(components, seedConnections, produceDetailedUpdates, false, this.getReplaceSynchronizationInfo(components), monitor);
    }

    @Override
    public IUpdateReport replaceComponents(List components, List seedConnections, List<Boolean> produceDetailedUpdates, boolean force, IProgressMonitor monitor) throws TeamRepositoryException {
        ISynchronizationInfo syncInfo = this.getReplaceSynchronizationInfo(components);
        return this.replaceComponents(components, seedConnections, produceDetailedUpdates, force, syncInfo, monitor);
    }

    private ISynchronizationInfo getReplaceSynchronizationInfo(List components) {
        ISynchronizationInfo syncInfo = ISynchronizationInfo.FACTORY.newInstance();
        if (this.isStream()) {
            for (IComponentHandle componentHandle : components) {
                try {
                    ICurrentComponentInfo componentInfo = this.getComponentInfo(componentHandle);
                    syncInfo.addChangeHistoryTime((IWorkspaceHandle)this.workspace, componentHandle, componentInfo.changeHistoryTime());
                    syncInfo.addConfigurationTime((IWorkspaceHandle)this.workspace, componentHandle, componentInfo.configurationTime());
                }
                catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {}
            }
        } else {
            syncInfo = null;
        }
        return syncInfo;
    }

    public IUpdateReport replaceComponents(List<IComponentHandle> components, List seedConnections, List<Boolean> produceDetailedUpdates, boolean force, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (components == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (seedConnections == null) {
            throw new IllegalArgumentException("seedConnections cannot be null");
        }
        if (components.size() != seedConnections.size()) {
            throw new IllegalArgumentException("component/connection ratio must be one-to-one");
        }
        if (components.size() != produceDetailedUpdates.size()) {
            throw new IllegalArgumentException("component/produceDetailedReports ratio must be one-to-one");
        }
        HashSet<UUID> componentIds = new HashSet<UUID>();
        ContextLock lock = new ContextLock();
        SubMonitor loopProgress = progress.newChild(1);
        loopProgress.setWorkRemaining(components.size());
        for (IComponentHandle component : components) {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            lock.addExclusive((IContextHandle)this.workspaceHandle, component);
            if (!componentIds.add(component.getItemId())) {
                throw new IllegalArgumentException("duplicate components not allowed: " + component.getItemId());
            }
            this.checkKnownComponent(component, (IProgressMonitor)loopProgress.newChild(1));
        }
        loopProgress.done();
        HashMap<UUID, ITeamRepository> teamRepositories = new HashMap<UUID, ITeamRepository>();
        loopProgress = progress.newChild(1);
        loopProgress.setWorkRemaining(components.size());
        IComponentOpDescriptor[] operations = new IComponentOpDescriptor[components.size()];
        int index = 0;
        while (index < components.size()) {
            IConnection seedConnection = (IConnection)seedConnections.get(index);
            if (seedConnection == null) {
                throw new IllegalArgumentException();
            }
            ITeamRepository seedRepository = seedConnection.teamRepository();
            teamRepositories.put(seedRepository.getId(), seedRepository);
            IComponentHandle component = components.get(index);
            IContextHandle seed = this.narrowSeedConnection(component, seedConnection, (IProgressMonitor)loopProgress.newChild(1));
            operations[index] = IComponentOpDescriptor.FACTORY.replaceComponent(component, seed, produceDetailedUpdates.get(index).booleanValue());
            ++index;
        }
        if (teamRepositories.size() > 1) {
            throw new IllegalArgumentException("Only 1 team repository can serve as a seed");
        }
        lock.acquire((IProgressMonitor)progress.newChild(3));
        try {
            WorkspaceUpdateReportResult result;
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " replaceComponents() begins");
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                RemoteRepoDescriptor newDescriptor = this.getRepositoryDescriptor(teamRepositories, (IProgressMonitor)progress.newChild(5));
                if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                    throw authEx;
                }
                remoteDescriptor = newDescriptor;
                try {
                    result = service.updateComponents((IWorkspaceHandle)this.getResolvedWorkspace(), remoteDescriptor, operations, force, deltaParameter, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (remoteDescriptor == null) {
                        throw e;
                    }
                    this.resetRepositoryDescriptor(teamRepositories);
                    authEx = e;
                    progress.setWorkRemaining(95);
                    continue;
                }
                break;
            }
            IUpdateReport report = result.getReport();
            progress.worked(80);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, true, (IProgressMonitor)progress.newChild(5));
                this.sendEvent(report, (IProgressMonitor)progress.newChild(5));
            }
            finally {
                this.release();
            }
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " replaceComponents() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    private IContextHandle narrowSeedConnection(IComponentHandle component, IConnection seedConnection, IProgressMonitor subMonitor) throws TeamRepositoryException {
        if (seedConnection instanceof IFlowNodeConnection) {
            FlowNodeConnection connection = (FlowNodeConnection)seedConnection;
            connection.checkKnownComponent(component, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)subMonitor).newChild(1));
            return connection.getWorkspaceHandle();
        }
        if (seedConnection instanceof IBaselineConnection) {
            IBaselineConnection baselineConnection = (IBaselineConnection)seedConnection;
            if (!baselineConnection.getComponent().sameItemId((IItemHandle)component)) {
                throw new IllegalArgumentException("baseline is associated with component " + baselineConnection.getComponent() + " rather than provided component " + component.getItemId());
            }
            return baselineConnection.getBaseline();
        }
        throw new IllegalArgumentException("Unknown connection type: " + seedConnection.getClass().getName());
    }

    @Override
    public IUpdateReport addComponent(IComponentHandle component, boolean produceDetailedUpdates, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.addComponent(component, produceDetailedUpdates, null, monitor);
    }

    public IUpdateReport addComponent(IComponentHandle component, boolean produceDetailedUpdates, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " addComponent() begins");
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.updateComponents(this.workspaceHandle, null, new IComponentOpDescriptor[]{IComponentOpDescriptor.FACTORY.addComponent(component, produceDetailedUpdates)}, false, deltaParameter, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(90);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                this.sendEvent(report, (IProgressMonitor)progress.newChild(4));
            }
            finally {
                this.release();
            }
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " addComponent() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IUpdateReport addComponent(IComponentHandle component, IFlowNodeConnection source, boolean produceDetailedUpdates, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.addComponent(component, source, produceDetailedUpdates, null, monitor);
    }

    public IUpdateReport addComponent(IComponentHandle component, IFlowNodeConnection source, boolean produceDetailedUpdates, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " addComponent() begins");
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            IComponentOpDescriptor addComp = IComponentOpDescriptor.FACTORY.addComponent(component, (IContextHandle)((FlowNodeConnection)source).getWorkspaceHandle(), produceDetailedUpdates);
            WorkspaceUpdateReportResult result = service.updateComponents(this.workspaceHandle, null, IComponentOpDescriptor.FACTORY.array(addComp), false, deltaParameter, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(90);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                this.sendEvent(report, (IProgressMonitor)progress.newChild(4));
            }
            finally {
                this.release();
            }
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " addComponent() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IUpdateReport dropComponent(IComponentHandle component, boolean produceDetailedUpdates, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.dropComponent(component, produceDetailedUpdates, null, monitor);
    }

    public IUpdateReport dropComponent(IComponentHandle component, boolean requireDetailedUpdates, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle, component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " dropComponent() begins");
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.updateComponents(this.getWorkspaceHandle(), null, new IComponentOpDescriptor[]{IComponentOpDescriptor.FACTORY.dropComponent(component, requireDetailedUpdates)}, true, deltaParameter, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(90);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                this.sendEvent(report, (IProgressMonitor)progress.newChild(4));
            }
            finally {
                this.release();
            }
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " dropComponent() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IComponentHandle> getComponents() throws TeamRepositoryException {
        this.validate();
        Object object = this.lock;
        synchronized (object) {
            ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>(this.cachedComponents.size());
            for (ClientCurrentComponentInfo i : this.cachedComponents.values()) {
                result.add(i.getComponent());
            }
            return Collections.unmodifiableList(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IComponentHandle> getUnreadableComponents() throws TeamRepositoryException {
        this.validate();
        Object object = this.lock;
        synchronized (object) {
            return this.inaccessibleComponents.values();
        }
    }

    @Override
    public IConfiguration configuration(IComponentHandle component) throws ItemNotFoundException, ComponentNotInWorkspaceException {
        this.validate();
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        this.checkKnownComponent(component, null);
        return new ConnectionBasedClientConfigurationProxy(this, component);
    }

    @Override
    public IChangeHistorySyncReport compareTo(IFlowNodeConnection remoteFlowNode, int flags, List excludedComponents, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.compareTo(remoteFlowNode, flags, excludedComponents, null, monitor);
    }

    public IChangeHistorySyncReport compareTo(IFlowNodeConnection remoteFlowNode, int flags, List excludedComponents, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (remoteFlowNode == null) {
                throw new IllegalArgumentException();
            }
            if (excludedComponents == null) {
                throw new IllegalArgumentException();
            }
            if (!WorkspaceComparisonFlags.isValid((int)flags)) {
                throw new IllegalArgumentException();
            }
            ComponentHandle[] componentHandles = excludedComponents.toArray(new ComponentHandle[excludedComponents.size()]);
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            ((FlowNodeConnection)remoteFlowNode).validate();
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                RemoteRepoDescriptor newDescriptor = this.extractRemoteDescriptor(remoteFlowNode, sm.newChild(5));
                if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                    throw authEx;
                }
                remoteDescriptor = newDescriptor;
                try {
                    IChangeHistorySyncReport result;
                    IChangeHistorySyncReport iChangeHistorySyncReport = result = service.compareWorkspaces(handle, ((FlowNodeConnection)remoteFlowNode).getWorkspaceHandle(), remoteDescriptor, flags, (IComponentHandle[])componentHandles, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)sm));
                    return iChangeHistorySyncReport;
                }
                catch (InvalidAuthenticationTokenException e) {
                    try {
                        if (remoteDescriptor == null) {
                            throw e;
                        }
                        this.resetRemoteDescriptor(remoteFlowNode);
                        authEx = e;
                        sm.setWorkRemaining(100);
                        continue;
                    }
                    catch (ItemNotFoundException e2) {
                        throw this.expandItemNotFoundDetails(e2);
                    }
                }
                break;
            }
        }
        finally {
            sm.done();
        }
    }

    protected RemoteRepoDescriptor extractRemoteDescriptor(IFlowNodeConnection remoteFlowNode, SubMonitor monitor) throws TeamRepositoryException {
        monitor.setWorkRemaining(100);
        RemoteRepoDescriptor remoteDescriptor = null;
        if (!remoteFlowNode.teamRepository().getId().equals((Object)this.teamRepository().getId())) {
            remoteDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor(remoteFlowNode.teamRepository(), (IProgressMonitor)monitor.newChild(100));
        }
        monitor.done();
        return remoteDescriptor;
    }

    protected void resetRemoteDescriptor(IFlowNodeConnection remoteFlowNode) {
        if (!remoteFlowNode.teamRepository().getId().equals((Object)this.teamRepository().getId())) {
            RemoteRepoDescriptorUtils.resetRemoteDescriptor(remoteFlowNode.teamRepository());
        }
    }

    @Override
    public void addBaselineSet(IBaselineSetHandle baselineSet, IProgressMonitor monitor) throws TeamRepositoryException {
        this.addBaselineSet(baselineSet, null, monitor);
    }

    @Override
    public IBaselineSetHandle cloneRemoteBaselineSet(IBaselineSetHandle toClone, ITeamRepository fromRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)SCMClientUtil.getMonitor(monitor, 100));
        try {
            IBaselineSet result;
            if (toClone == null) {
                throw new IllegalArgumentException();
            }
            if (fromRepository == null) {
                throw new IllegalArgumentException();
            }
            if (fromRepository.getId().equals((Object)this.teamRepository().getId())) {
                throw new IllegalArgumentException();
            }
            this.validate();
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                RemoteRepoDescriptor newDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor(fromRepository, (IProgressMonitor)sm.newChild(5));
                if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                    throw authEx;
                }
                remoteDescriptor = newDescriptor;
                IWorkspaceHandle ws = this.getWorkspaceHandle();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                try {
                    result = service.cloneBaselineSetFromRemoteRepository(toClone, ws, remoteDescriptor, (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)sm));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (remoteDescriptor == null) {
                        throw e;
                    }
                    RemoteRepoDescriptorUtils.resetRemoteDescriptor(fromRepository);
                    authEx = e;
                    sm.setWorkRemaining(100);
                    continue;
                }
                break;
            }
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(result));
            this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "baseline sets", null, result);
            IBaselineSet iBaselineSet = result;
            return iBaselineSet;
        }
        finally {
            sm.done();
        }
    }

    public void addBaselineSet(IBaselineSetHandle baselineSet, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            try {
                if (baselineSet == null) {
                    throw new IllegalArgumentException();
                }
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                IBaselineSet result = service.addBaselineSet(this.getWorkspaceHandle(), baselineSet, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
                this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(result));
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "baseline sets", null, baselineSet);
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected ItemNotFoundException expandItemNotFoundDetails(ItemNotFoundException e) {
        if (e.getData() instanceof IItemHandle && ((IItemHandle)e.getData()).sameItemId((IItemHandle)this.getWorkspaceHandle())) {
            ItemNotFoundException newException = new ItemNotFoundException(NLS.bind((String)Messages.WorkspaceConnection_19, (Object)this.getResolvedWorkspace().getName(), (Object[])new Object[0]), (IItemHandle)e.getData());
            if (e.getStackTrace() != null) {
                newException.setStackTrace(e.getStackTrace());
            }
            e = newException;
        }
        return e;
    }

    @Override
    public void removeBaselineSet(IBaselineSetHandle baselineSet, IProgressMonitor monitor) throws TeamRepositoryException {
        this.removeBaselineSet(baselineSet, null, monitor);
        this.teamRepository().itemManager().applyItemDeletes(Collections.singletonList(baselineSet));
    }

    public void removeBaselineSet(IBaselineSetHandle baselineSet, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            try {
                if (baselineSet == null) {
                    throw new IllegalArgumentException();
                }
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                service.removeBaselineSet(this.getWorkspaceHandle(), baselineSet, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyRemove", "baseline sets", baselineSet, null);
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeHistory changeHistory(IComponentHandle component) throws ItemNotFoundException, ComponentNotInWorkspaceException {
        this.validate();
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        this.checkKnownComponent(component, null);
        return new ClientChangeHistoryProxy(this, (ComponentHandle)component, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChangeHistoryHandle getHistoryHandle(ComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        Object object = this.lock;
        synchronized (object) {
            ClientCurrentComponentInfo info;
            block5: {
                info = this.cachedComponents.get(component.getItemId());
                if (info != null) break block5;
                return null;
            }
            return info.getChangeHistory();
        }
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IFlowNodeConnection)) {
            return false;
        }
        IFlowNodeConnection o = (IFlowNodeConnection)obj;
        return this.teamRepository() == o.teamRepository() && this.getWorkspaceHandle().sameItemId((IItemHandle)((FlowNodeConnection)o).getWorkspaceHandle());
    }

    public final int hashCode() {
        return this.getWorkspaceHandle().getItemId().hashCode();
    }

    @Override
    public IChangeHistorySyncReport compareToBaseline(IBaselineHandle baseline, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.compareToBaseline(baseline, null, monitor);
    }

    public IChangeHistorySyncReport compareToBaseline(IBaselineHandle baseline, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (baseline == null) {
                throw new IllegalArgumentException();
            }
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            IChangeHistorySyncReport r = service.compareWorkspaceToBaseline(handle, baseline, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(90);
            SCMClientUtil.checkMonitor(monitor);
            IChangeHistorySyncReport iChangeHistorySyncReport = r;
            return iChangeHistorySyncReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    protected void queue(Object o) {
        Event e = (Event)o;
        if (e instanceof IPropertyChangeEvent) {
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " Queuing event " + e.getEventType() + " property that changed =" + (String)((IPropertyChangeEvent)e).getProperty());
        } else {
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " Queuing event " + e.getEventType());
        }
        this.queueEvent(o);
    }

    protected static void log(String msg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)msg);
        }
    }

    protected void sendEvent(String type, List changeSetHandles) {
        this.queue(new ChangeHistoryEvent(this, type, Collections.EMPTY_LIST, changeSetHandles, null, null));
    }

    protected void sendEvent(String type, List baselines, List changeSetHandles) {
        this.queue(new ChangeHistoryEvent(this, type, baselines, changeSetHandles, null, null));
    }

    protected void sendEvent(String type, List changeSetHandles, IComponentHandle comp) {
        this.queue(new ChangeHistoryEvent(this, type, Collections.EMPTY_LIST, changeSetHandles, comp, null));
    }

    protected void sendEvent(IUpdateReport report, IProgressMonitor monitor) throws TeamRepositoryException {
        this.refreshComponentHierarchyCache(report, monitor);
        this.queue(new ConfigurationUpdateEvent(this, report));
    }

    protected void sendPropertyChangeEvent(String eventType, String property, Object oldValue, Object newValue) {
        this.queue(new PropertyChangeEvent((IEventSource)this, eventType, (Object)this, (Object)property, oldValue, newValue));
    }

    protected void sendPortingUpdateEvent(Set<UUID> componentsWithCurrentPortChanges, Set<UUID> componentsWithPendingPortsChanges) {
        this.queue(new PatchUpdateEvent(this, componentsWithCurrentPortChanges, componentsWithPendingPortsChanges));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getBases() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cachedComponents.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            TreeMap<IComponentHandle, IBaselineHandle> result = new TreeMap<IComponentHandle, IBaselineHandle>(ItemUtil.itemIdComparator);
            for (ClientCurrentComponentInfo info : this.cachedComponents.values()) {
                if (info.basis() == null) continue;
                result.put(info.getComponent(), info.basis());
            }
            return result;
        }
    }

    @Override
    public IHistoricBaselineIterator getBaselinesInHistory(IComponentHandle component, int max, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getBaselinesInHistory(component, max, null, monitor);
    }

    public IHistoricBaselineIterator getBaselinesInHistory(IComponentHandle component, int max, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (max < 1) {
                throw new IllegalArgumentException();
            }
            this.checkKnownComponent(component, monitor);
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            BaselinesInHistoryResult result = service.getBaselinesInHistory(ServiceHistoryProvider.FACTORY.create(handle, component), max, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(90);
            SCMClientUtil.checkMonitor(monitor);
            BaselinesInHistoryIterator baselinesInHistoryIterator = new BaselinesInHistoryIterator(result, this.workspaceManager);
            return baselinesInHistoryIterator;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IHistoricBaselineIterator getMergedBaselineHistory(IComponentHandle component, int max, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getMergedBaselineHistory(component, max, null, monitor);
    }

    public IHistoricBaselineIterator getMergedBaselineHistory(IComponentHandle component, int max, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (max < 1) {
                throw new IllegalArgumentException();
            }
            this.checkKnownComponent(component, monitor);
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            MergedBaselineResult result = service.getMergedBaselineHistory(handle, component, null, max, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(90);
            SCMClientUtil.checkMonitor(monitor);
            MergedBaselineHistoryIterator mergedBaselineHistoryIterator = new MergedBaselineHistoryIterator(handle, component, result, this.workspaceManager);
            return mergedBaselineHistoryIterator;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkKnownComponent(IComponentHandle componentHandle, IProgressMonitor monitor) throws ComponentNotInWorkspaceException {
        Object object = this.lock;
        synchronized (object) {
            if (this.cachedComponents.containsKey(componentHandle.getItemId())) {
                return;
            }
            if (this.inaccessibleComponents.containsKey(componentHandle.getItemId())) {
                return;
            }
        }
        String message = NLS.bind((String)Messages.FlowNodeConnection_3, (Object)componentHandle.getItemId(), (Object[])new Object[0]);
        if (monitor != null) {
            try {
                IComponent component = (IComponent)this.teamRepository().itemManager().fetchPartialItem((IItemHandle)componentHandle, 2, Collections.singletonList(IComponent.NAME_PROPERTY), monitor);
                message = NLS.bind((String)Messages.FlowNodeConnection_4, (Object)component.getName(), (Object[])new Object[0]);
            }
            catch (Exception exception) {}
        }
        throw new ComponentNotInWorkspaceException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICurrentComponentInfo getComponentInfo(IComponentHandle component) throws ComponentNotInWorkspaceException {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        Object object = this.lock;
        synchronized (object) {
            ClientCurrentComponentInfo info = this.cachedComponents.get(component.getItemId());
            if (info != null) {
                return info;
            }
        }
        throw new ComponentNotInWorkspaceException(NLS.bind((String)Messages.FlowNodeConnection_5, (Object)component.getItemId(), (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends ICurrentComponentInfo> getComponentsInfo() {
        Object object = this.lock;
        synchronized (object) {
            return this.cachedComponents.values();
        }
    }

    @Override
    public List getPastComponentInfos(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getPastComponentInfos(null, monitor);
    }

    public List getPastComponentInfos(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            PastComponent[] result = service.getPastComponents(handle, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            ArrayList<ClientPastComponentInfo> infos = new ArrayList<ClientPastComponentInfo>(result.length);
            int i = 0;
            while (i < result.length) {
                infos.add(new ClientPastComponentInfo(result[i].getComponent(), result[i].getNumBasesInHistory()));
                ++i;
            }
            ArrayList<ClientPastComponentInfo> arrayList = infos;
            return arrayList;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List getComponentAuditTrail(IComponentHandle component, long start, long max, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getComponentAuditTrail(component, start, max, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getComponentAuditTrail(IComponentHandle component, long start, long max, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            ArrayList<ClientComponentInfo> infos;
            if (component == null) {
                throw new IllegalArgumentException("component cannot be null");
            }
            if (start < 0L) {
                throw new IllegalArgumentException("start must be >= 0");
            }
            if (max < 1L) {
                throw new IllegalArgumentException("max must be >= 1");
            }
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            ClientCurrentComponentInfo currentEntry = null;
            Object object = this.lock;
            synchronized (object) {
                ClientCurrentComponentInfo info = this.cachedComponents.get(component.getItemId());
                if (info != null && start + max >= info.numBasisInHistory()) {
                    max = info.numBasisInHistory() - start - 1L;
                    if (start < info.numBasisInHistory()) {
                        currentEntry = info;
                    }
                }
            }
            if (max > 0L) {
                HistoricBasis[] result = service.getComponentHistory(handle, component, start, max, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
                infos = new ArrayList(result.length + (currentEntry == null ? 0 : 1));
                int i = 0;
                while (i < result.length) {
                    infos.add(new ClientComponentInfo(result[i].getDeliveredBy(), result[i].getDeliveryDate(), result[i].getBasis()));
                    ++i;
                }
            } else {
                infos = new ArrayList<ClientComponentInfo>(currentEntry == null ? 0 : 1);
            }
            if (currentEntry != null && (long)infos.size() <= max) {
                infos.add(currentEntry);
            }
            ArrayList<ClientComponentInfo> arrayList = infos;
            return arrayList;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFlowTable getFlowTable() {
        Object object = this.lock;
        synchronized (object) {
            return this.flowTable;
        }
    }

    @Override
    public void setFlowTable(IFlowTable flowTable, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setFlowTable(flowTable, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlowTable(IFlowTable flowTable, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (flowTable == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                FlowEntry[] acceptFlows = flowTable.acceptSources().toArray(new FlowEntry[flowTable.acceptSources().size()]);
                FlowEntry[] deliverFlows = flowTable.deliverTargets().toArray(new FlowEntry[flowTable.deliverTargets().size()]);
                CurrentFlows currentFlows = ((FlowTable)flowTable).getCurrentFlows();
                ArrayList<IComponentHandle> componentList = new ArrayList<IComponentHandle>();
                ArrayList<CurrentFlows> componentCurrentFlowsList = new ArrayList<CurrentFlows>();
                Set componentIds = ConfigUtil.getItemIds(this.getComponents());
                Iterator<Map.Entry<UUID, CurrentFlows>> it = ((FlowTable)flowTable).getCurrentComponentFlows().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<UUID, CurrentFlows> mapEntry = it.next();
                    if (componentIds.contains(mapEntry.getKey())) {
                        componentList.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(mapEntry.getKey(), null));
                        componentCurrentFlowsList.add(mapEntry.getValue());
                        continue;
                    }
                    it.remove();
                }
                IComponentHandle[] components = componentList.toArray(new IComponentHandle[componentList.size()]);
                CurrentFlows[] componentCurrentFlows = componentCurrentFlowsList.toArray(new CurrentFlows[componentCurrentFlowsList.size()]);
                IWorkspaceHandle handle = this.getWorkspaceHandle();
                Workspace result = (Workspace)service.setWorkspaceFlows(handle, (IFlowEntry[])acceptFlows, (IFlowEntry[])deliverFlows, currentFlows, components, componentCurrentFlows, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                this.acquire();
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.refreshWorkspace(result);
                    }
                }
                finally {
                    this.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IFlowNodeConnection.IComponentOpFactory componentOpFactory() {
        return this.componentOpFactory;
    }

    @Override
    public IUpdateReport applyComponentOperations(List componentOps, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.applyComponentOperations(componentOps, false, null, monitor);
    }

    @Override
    public IUpdateReport applyComponentOperations(List ops, boolean forceReplace, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.applyComponentOperations(ops, forceReplace, null, monitor);
    }

    @Override
    public IUpdateReport applyComponentOperationsWithoutBackupBaselines(List ops, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.applyComponentOperations(ops, false, false, null, monitor);
    }

    @Override
    public IUpdateReport applyComponentOperations(List componentOps, boolean forceReplace, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.applyComponentOperations(componentOps, true, forceReplace, syncInfo, monitor);
    }

    private IUpdateReport applyComponentOperations(List componentOps, boolean withBackups, boolean forceReplace, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (componentOps == null) {
            throw new IllegalArgumentException();
        }
        if (!this.validComponentOps(componentOps)) {
            throw new IllegalArgumentException("Only 1 operation per component allowed");
        }
        ArrayList<IComponentOpDescriptor> descriptors = new ArrayList<IComponentOpDescriptor>(componentOps.size());
        ContextLock lock = new ContextLock();
        HashMap<UUID, ITeamRepository> teamRepositories = new HashMap<UUID, ITeamRepository>();
        ArrayList<IComponentHandle> replaceComponents = new ArrayList<IComponentHandle>();
        for (IFlowNodeConnection.IComponentOp op : componentOps) {
            this.processComponentOps(op, descriptors, teamRepositories, replaceComponents, lock);
        }
        if (teamRepositories.size() > 1) {
            throw new IllegalArgumentException("Only 1 team repository can serve as a seed");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            WorkspaceUpdateReportResult result;
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " applyComponentOperations() begins");
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            if (syncInfo == null && replaceComponents.size() > 0) {
                syncInfo = this.getReplaceSynchronizationInfo(replaceComponents);
            }
            while (true) {
                RemoteRepoDescriptor newDescriptor = this.getRepositoryDescriptor(teamRepositories, (IProgressMonitor)progress.newChild(5));
                if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                    throw authEx;
                }
                remoteDescriptor = newDescriptor;
                try {
                    result = service.updateComponents2(handle, remoteDescriptor, descriptors.toArray(new IComponentOpDescriptor[descriptors.size()]), withBackups, forceReplace, deltaParameter, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (remoteDescriptor == null) {
                        throw e;
                    }
                    this.resetRepositoryDescriptor(teamRepositories);
                    authEx = e;
                    progress.setWorkRemaining(99);
                    continue;
                }
                break;
            }
            IUpdateReport report = result.getReport();
            progress.worked(90);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, true, (IProgressMonitor)progress.newChild(2));
                this.sendEvent(report, (IProgressMonitor)progress.newChild(2));
            }
            finally {
                this.release();
            }
            FlowNodeConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " applyComponentOperations() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    private RemoteRepoDescriptor getRepositoryDescriptor(Map<UUID, ITeamRepository> teamRepositories, IProgressMonitor monitor) throws TeamRepositoryException {
        Iterator<Map.Entry<UUID, ITeamRepository>> iterator = teamRepositories.entrySet().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        RemoteRepoDescriptor remoteDescriptor = null;
        ITeamRepository tr = iterator.next().getValue();
        if (!tr.getId().equals((Object)this.teamRepository().getId())) {
            remoteDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor(tr, monitor);
        }
        return remoteDescriptor;
    }

    private void resetRepositoryDescriptor(Map<UUID, ITeamRepository> teamRepositories) {
        Iterator<Map.Entry<UUID, ITeamRepository>> iterator = teamRepositories.entrySet().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        ITeamRepository tr = iterator.next().getValue();
        if (!tr.getId().equals((Object)this.teamRepository().getId())) {
            RemoteRepoDescriptorUtils.resetRemoteDescriptor(tr);
        }
    }

    private boolean validComponentOps(List componentOps) {
        for (IFlowNodeConnection.IComponentOp op : componentOps) {
            IComponentHandle handle = op.getComponent();
            for (IFlowNodeConnection.IComponentOp next : componentOps) {
                if (op == next || !handle.sameItemId((IItemHandle)next.getComponent())) continue;
                return false;
            }
        }
        return true;
    }

    private void processComponentOps(IFlowNodeConnection.IComponentOp op, List<IComponentOpDescriptor> descriptors, Map<UUID, ITeamRepository> teamRepositories, List<IComponentHandle> replaces, ContextLock lock) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        if (op instanceof IFlowNodeConnection.IComponentAdditionOp) {
            lock.addExclusive((IContextHandle)this.workspaceHandle);
            IFlowNodeConnection.IComponentAdditionOp addOp = (IFlowNodeConnection.IComponentAdditionOp)op;
            IConnection seedConnection = addOp.getSeedConnection();
            if (seedConnection != null) {
                ITeamRepository seedRepository = seedConnection.teamRepository();
                teamRepositories.put(seedRepository.getId(), seedRepository);
            } else {
                ITeamRepository repo = this.teamRepository();
                teamRepositories.put(repo.getId(), repo);
            }
            IContextHandle seed = this.processComponentSeed(seedConnection);
            if (seed == null) {
                descriptors.add(IComponentOpDescriptor.FACTORY.addComponent(addOp.getComponent(), addOp.requiresDetails()));
            } else {
                descriptors.add(IComponentOpDescriptor.FACTORY.addComponent(addOp.getComponent(), seed, addOp.requiresDetails()));
            }
        } else if (op instanceof IFlowNodeConnection.IComponentDeletionOp) {
            lock.addExclusive((IContextHandle)this.workspaceHandle);
            IFlowNodeConnection.IComponentDeletionOp removeOp = (IFlowNodeConnection.IComponentDeletionOp)op;
            descriptors.add(IComponentOpDescriptor.FACTORY.dropComponent(removeOp.getComponent(), removeOp.requiresDetails()));
        } else if (op instanceof IFlowNodeConnection.IComponentReplacementOp) {
            IFlowNodeConnection.IComponentReplacementOp replaceOp = (IFlowNodeConnection.IComponentReplacementOp)op;
            replaces.add(replaceOp.getComponent());
            IConnection seedConnection = replaceOp.getSeedConnection();
            ITeamRepository seedRepository = seedConnection.teamRepository();
            teamRepositories.put(seedRepository.getId(), seedRepository);
            IContextHandle seed = this.processComponentSeed(seedConnection);
            descriptors.add(IComponentOpDescriptor.FACTORY.replaceComponent(replaceOp.getComponent(), seed, replaceOp.requiresDetails()));
            lock.addExclusive((IContextHandle)this.workspaceHandle, replaceOp.getComponent());
        }
    }

    private IContextHandle processComponentSeed(IConnection seed) {
        if (seed == null) {
            return null;
        }
        IBaselineHandle handle = null;
        if (seed instanceof IBaselineConnection) {
            handle = ((IBaselineConnection)seed).getBaseline();
        } else if (seed instanceof IFlowNodeConnection) {
            handle = ((FlowNodeConnection)seed).getWorkspaceHandle();
        }
        return handle;
    }

    private IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    @Override
    public List getComponentsContainingVersionable(IVersionableHandle versionableHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getComponentsContainingVersionable(versionableHandle, null, monitor);
    }

    public List getComponentsContainingVersionable(IVersionableHandle versionableHandle, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (versionableHandle == null) {
                throw new IllegalArgumentException();
            }
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            IComponentHandle[] result = service.getComponentsContainingVersionable(handle, versionableHandle, FlowNodeConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(80);
            SCMClientUtil.checkMonitor(monitor);
            List<IComponentHandle> list = Arrays.asList(result);
            return list;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IUpdateReport compareConfigurations(IFlowNodeConnection otherConnection, List<? extends IComponentHandle> componentsToConsider, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (otherConnection == null) {
                throw new IllegalArgumentException();
            }
            IComponentHandle[] components = null;
            if (componentsToConsider != null) {
                components = new IComponentHandle[componentsToConsider.size()];
                int j = 0;
                for (IComponentHandle iComponentHandle : componentsToConsider) {
                    if (iComponentHandle == null) {
                        throw new IllegalArgumentException();
                    }
                    components[j++] = iComponentHandle;
                }
            }
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle iWorkspaceHandle = this.workspaceHandle;
            IWorkspaceHandle other = (IWorkspaceHandle)otherConnection.getResolvedWorkspace().getItemHandle();
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            IUpdateReport ur = service.compareWorkspaceConfigurations(iWorkspaceHandle, other, components, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(80);
            SCMClientUtil.checkMonitor(monitor);
            IUpdateReport iUpdateReport = ur;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Collection<IChangeSetFlowReport> findChangeSetsInFlows(Collection<IChangeSetHandle> changeSets, int flowFlags, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (changeSets == null || changeSets.isEmpty()) {
                throw new IllegalArgumentException();
            }
            for (IChangeSetHandle cs : changeSets) {
                if (cs != null) continue;
                throw new IllegalArgumentException();
            }
            if (!FlowFlags.isValid((int)flowFlags)) {
                throw new IllegalArgumentException();
            }
            this.validate();
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            IScmQueryService service = this.workspaceManager.getScmQueryService();
            IChangeSetFlowReport[] reports = service.findWhereChangeSetsHaveFlowed(this.workspaceHandle, flowFlags, changeSets.toArray(new IChangeSetHandle[changeSets.size()]), null, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(99);
            List<IChangeSetFlowReport> list = Arrays.asList(reports);
            return list;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ILockSearchResult getLocksInFlows(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            IScmQueryService service = this.workspaceManager.getScmQueryService();
            ILockSearchResult reports = service.findLocksInFlowTargets(this.workspaceHandle, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(99);
            ILockSearchResult iLockSearchResult = reports;
            return iLockSearchResult;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    private static class ComponentAdditionOp
    extends ComponentOp
    implements IFlowNodeConnection.IComponentAdditionOp {
        final IConnection seed;

        ComponentAdditionOp(IComponentHandle handle, IConnection seed, boolean requiresDetailedReport) {
            super(handle, requiresDetailedReport);
            this.seed = seed;
        }

        @Override
        public IConnection getSeedConnection() {
            return this.seed;
        }
    }

    private static class ComponentDeletionOp
    extends ComponentOp
    implements IFlowNodeConnection.IComponentDeletionOp {
        ComponentDeletionOp(IComponentHandle handle, boolean requiresDetailedReport) {
            super(handle, requiresDetailedReport);
        }
    }

    private static abstract class ComponentOp
    implements IFlowNodeConnection.IComponentOp {
        final IComponentHandle component;
        final boolean details;

        public ComponentOp(IComponentHandle handle, boolean details) {
            this.component = handle;
            this.details = details;
        }

        @Override
        public IComponentHandle getComponent() {
            return this.component;
        }

        @Override
        public boolean requiresDetails() {
            return this.details;
        }
    }

    static class ComponentOpFactory
    implements IFlowNodeConnection.IComponentOpFactory {
        ComponentOpFactory() {
        }

        @Override
        public IFlowNodeConnection.IComponentAdditionOp addComponent(IComponentHandle comp, IConnection seed, boolean produceDetailedUpdated) {
            if (comp == null) {
                throw new IllegalArgumentException();
            }
            if (seed == null) {
                throw new IllegalArgumentException();
            }
            return new ComponentAdditionOp(comp, seed, produceDetailedUpdated);
        }

        @Override
        public IFlowNodeConnection.IComponentAdditionOp addComponent(IComponentHandle comp, boolean produceDetailedUpdates) {
            if (comp == null) {
                throw new IllegalArgumentException();
            }
            return new ComponentAdditionOp(comp, null, produceDetailedUpdates);
        }

        @Override
        public IFlowNodeConnection.IComponentDeletionOp removeComponent(IComponentHandle comp, boolean produceDetailedUpdates) {
            if (comp == null) {
                throw new IllegalArgumentException();
            }
            return new ComponentDeletionOp(comp, produceDetailedUpdates);
        }

        @Override
        public IFlowNodeConnection.IComponentReplacementOp replaceComponent(IComponentHandle comp, IConnection seed, boolean produceDetailedUpdates) {
            if (comp == null) {
                throw new IllegalArgumentException();
            }
            if (seed == null) {
                throw new IllegalArgumentException();
            }
            return new ComponentReplacementOp(comp, seed, produceDetailedUpdates);
        }
    }

    private static class ComponentReplacementOp
    extends ComponentOp
    implements IFlowNodeConnection.IComponentReplacementOp {
        final IConnection seed;

        ComponentReplacementOp(IComponentHandle handle, IConnection seed, boolean requiresDetailedReport) {
            super(handle, requiresDetailedReport);
            this.seed = seed;
        }

        @Override
        public IConnection getSeedConnection() {
            return this.seed;
        }
    }
}

