/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.factory.PluginProviderFactory;
import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.interop.LinkedObjectUtils;
import com.ibm.rational.wvcm.interop.UcmImporterMessages;
import com.ibm.rational.wvcm.interop.UcmImporterMetadataMap;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.VersionSet;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class UcmImporter {
    public static final String DCTERMS_NS = "http://purl.org/dc/terms/";
    public static final String OSLC_CM_NS = "http://open-services.net/ns/cm#";
    public static final String RTC_CM_NS = "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/";
    public static final PropertyNameList.PropertyName<String> PN_CM_STATUS = new PropertyNameList.PropertyName("http://open-services.net/ns/cm#", "status");
    public static final PropertyNameList.PropertyName<List<String>> PN_CM_DEPENDS_ON_TASKS = new PropertyNameList.PropertyName("http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/", "dependsOn");
    public static final PropertyNameList.PropertyName<List<String>> PN_TAGS = new PropertyNameList.PropertyName("http://purl.org/dc/terms/", "subject");
    public static final PropertyNameList.PropertyName<String> PN_DURATION = new PropertyNameList.PropertyName("http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/", "duration");
    public static final String UCM_IMPORTER_NS = "com.ibm.team.ucm_importer";
    public static final PropertyNameList.PropertyName<String> PN_TRACKS_UCM_METADATUM = new PropertyNameList.PropertyName("com.ibm.team.ucm_importer", "tracksUcmMetadata");
    public static final PropertyNameList.PropertyName<List<String>> PN_REQUIRES_UCM_METADATA = new PropertyNameList.PropertyName("com.ibm.team.ucm_importer", "requiresUcm");
    public static final PropertyNameList.PropertyName<List<String>> PN_REQUIRES_JAZZ = new PropertyNameList.PropertyName("com.ibm.team.ucm_importer", "requiresJazz");
    public static final PropertyNameList.PropertyName<String> PN_IMPORTER_ENTRY = new PropertyNameList.PropertyName("com.ibm.team.ucm_importer", "importerEntry");
    public static final PropertyRequestItem.PropertyRequest PR_IMPORTER_ENTRY = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_IMPORTER_ENTRY});
    public static final PropertyRequestItem.PropertyRequest PR_RESOURCE_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.DISPLAY_NAME, Resource.RESOURCE_IDENTIFIER});
    public static final PropertyRequestItem.PropertyRequest PR_IMPORTED = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_RESOURCE_INFO, InteropCore.PN_CLONE});
    public static final PropertyRequestItem.PropertyRequest PR_TASK_STATE_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{InteropUtilities.PN_TASK_ID, PN_CM_STATUS, PN_DURATION});
    public static final PropertyRequestItem.PropertyRequest PR_UCM_METADATA_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_RESOURCE_INFO, PR_TASK_STATE_INFO, PN_REQUIRES_UCM_METADATA, PN_TRACKS_UCM_METADATUM, PN_IMPORTER_ENTRY, PN_CM_DEPENDS_ON_TASKS, InteropCore.PN_CLONE});
    private static final PropertyRequestItem.PropertyRequest PR_RESOURCE_TO_IMPORT_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_RESOURCE_INFO, Resource.COMMENT, Stream.TARGET, Component.ROOT_VERSION.nest(new PropertyRequestItem[]{PR_RESOURCE_INFO}), Activity.ACTIVITY_VERSION_LIST});
    private static final PropertyRequestItem.PropertyRequest PR_RF_PATH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Configuration.ROOT_FOLDER.nest(new PropertyRequestItem[]{Resource.PATHNAME_LOCATION})});
    public static final String IA_HAS_IMPORTED_OBJECT_INFO = "com.ibm.team.ucm_importer.HAS_OBJECT_LINKAGE_INFO";
    public static final String IA_TASKS_REQUIRE_TRANSITION_ACTIONS = "com.ibm.team.ucm_importer.TASKS_REQUIRE_TRANSITION_ACTIONS";
    private WorkspaceProvider _sourceProvider;
    private WorkspaceProvider _destinationProvider;
    private int _stateId;
    private InteropCore.InteropStreamState _state;
    private InteropCore.SyncStats _stats;
    private boolean additionalAssertionsEnabled = false;
    public static PropertyRequestItem.PropertyRequest PR_CONFIG_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{PR_RESOURCE_INFO, Version.VERSION_HISTORY.nest(new PropertyRequestItem[]{PR_RESOURCE_INFO, VersionHistory.ROOT_VERSION.nest(new PropertyRequestItem[]{PR_RESOURCE_INFO})})})});
    public static PropertyRequestItem.PropertyRequest PR_BCF_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_RESOURCE_INFO, ControllableResource.VERSION_HISTORY, PR_CONFIG_INFO});
    public static PropertyRequestItem.PropertyRequest PR_WORKSPACE_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.BASELINE_CONTROLLED_FOLDER_LIST.nest(new PropertyRequestItem[]{PR_BCF_INFO})});
    public static PropertyRequestItem.PropertyRequest PR_SRC_STREAM_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_RESOURCE_INFO, Stream.WORKSPACE.nest(new PropertyRequestItem[]{PR_WORKSPACE_INFO})});
    public static final PropertyNameList.PropertyName<String> PN_UCM_IMPORTER = new PropertyNameList.PropertyName("com.ibm.team.importer", "UCM_IMPORTER");
    public static final PropertyNameList.PropertyName<String> PN_UCM_IMPORTER_LOCKED = new PropertyNameList.PropertyName("com.ibm.team.interop", "UCM_IMPORTER_LOCKED");
    public static final PropertyNameList.PropertyName<Component> PN_UCM_ORIGIN = new PropertyNameList.PropertyName("com.ibm.team.importer", "UCM_ORIGIN");
    public static final PropertyNameList.PropertyName<String> PN_UCM_IMPORTER_CLONE = PN_TRACKS_UCM_METADATUM;
    public static final String IA_UCM_IMPORTER_WI_LOC_STR = "com.ibm.team.connector.scm.UCM_IMPORTER_WI_LOC_STR";
    private static final String JSON_VER = "version";
    private static final String JSON_STATE = "state";
    private static final String JSON_STATE_ID = "stateId";
    private static final String JSON_PROVIDERS = "providers";
    private static final String JSON_SOURCE_PROVIDER = "sourceProvider";
    private static final String JSON_DEST_PROVIDER = "destinationProvider";
    private static final String JSON_PROVIDER_PATH = "providerPath";
    private static final String JSON_PROVIDER_INITARGS = "providerInitArgs";
    public static final int KNOWN_HIGHEST_FORMAT_VERSION = 1;
    private static final PropertyRequestItem.PropertyRequest PR_ORIGIN_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_UCM_ORIGIN.nest(new PropertyRequestItem[]{Resource.DISPLAY_NAME})});
    private static final PropertyRequestItem.PropertyRequest PR_TASK_ID = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{InteropUtilities.PN_TASK_ID});
    public static final String IA_ADDITIONAL_ASSERTIONS_ENABLED = "com.ibm.team.interop.ADDITIONAL_ASSERTIONS_ENABLED";
    static final int SANITY_MAX = 500;
    private static final VersionSet.CompareFlag[] CF_NEW_ACT = new VersionSet.CompareFlag[]{VersionSet.CompareFlag.NEW_ONLY, VersionSet.CompareFlag.ACTIVITIES};
    public static final PropertyRequestItem.PropertyRequest PR_BASELINE_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Version.VERSION_HISTORY, Resource.DISPLAY_NAME, Baseline.SUCCESSOR_LIST, Baseline.SUB_BASELINE_LIST});
    public static final PropertyRequestItem.PropertyRequest PR_CHANGED_VERSIONS_ACT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_RESOURCE_INFO, Version.ACTIVITY.nest(new PropertyRequestItem[]{PR_RESOURCE_INFO, Resource.CREATION_DATE}), Resource.CREATION_DATE, Version.VERSION_HISTORY});
    public static final PropertyRequestItem.PropertyRequest PR_ACTIVITY_INFO_VERS_LIST_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_RESOURCE_INFO, Resource.CREATION_DATE, Activity.ACTIVITY_VERSION_LIST});
    public static final Long IS_BLOCKED_VALUE = 28800000L;
    public static final Long IS_UNBLOCKED_VALUE = -1L;
    public static final PropertyRequestItem.PropertyRequest PR_CI_DN_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{Baseline.DISPLAY_NAME, InteropCore.PN_CLONE})});
    public static final PropertyRequestItem.PropertyRequest PR_TGT_COMPONENT_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Component.ROOT_VERSION, PR_RESOURCE_INFO});

    UcmImporter(WorkspaceProvider sourceProvider, WorkspaceProvider destinationProvider, int stateId, InteropCore.InteropStreamState state) {
        this._sourceProvider = sourceProvider;
        this._destinationProvider = destinationProvider;
        this._stateId = stateId;
        this._state = state;
        this._stats = new InteropCore.SyncStats();
    }

    public WorkspaceProvider sourceProvider() {
        return this._sourceProvider;
    }

    public WorkspaceProvider destinationProvider() {
        return this._destinationProvider;
    }

    public static UcmImporter newUcmImporter(WorkspaceProvider destinationProvider, Stream sourceStream, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        sourceStream = (Stream)sourceStream.doReadProperties(f.nest(PR_ORIGIN_DN, 10));
        Component pvob = (Component)sourceStream.getProperty(PN_UCM_ORIGIN);
        return UcmImporter.newUcmImporter(sourceStream, (Resource)pvob, destinationProvider, f.nest(99));
    }

    public static UcmImporter newUcmImporter(Stream sourceStream, Resource sourceScopeResource, WorkspaceProvider destinationProvider, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        WorkspaceProvider sourceProvider = sourceStream.workspaceProvider();
        InteropCore.setHasCloneInfo(sourceProvider.initArgs(), false);
        InteropCore.setHasCloneInfo(destinationProvider.initArgs(), true);
        Task destResourceQuery = (Task)destinationProvider.buildProxy(Task.class, destinationProvider.rootLocation());
        String scopeString = sourceScopeResource.getResourceIdentifier();
        destResourceQuery.setProperty(PN_UCM_IMPORTER_CLONE, (Object)scopeString);
        Task destTask = (Task)destResourceQuery.doFind(f.nest(PR_TASK_ID, 30));
        if (destTask != null) {
            throw new WvcmException(NLS.bind((String)UcmImporterMessages.UcmImporter_ERROR_OVERWRITE_IMPORTER, (Object)destTask.getProperty(InteropUtilities.PN_TASK_ID)), (Resource)destTask, WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        destTask = destinationProvider.task(destinationProvider.rootLocation());
        destTask.setDisplayName(NLS.bind((String)UcmImporterMessages.UcmImporter_NAME_TASK_INITIAL, (Object)sourceScopeResource.getDisplayName()));
        destTask = destTask.doCreateGeneratedResource(f.nest(50));
        UcmImporter.setSourceStreamInitArg(sourceProvider.initArgs(), sourceStream);
        Workspace sourceWorkspace = UcmImporter.getSourceWorkspace(sourceStream, f.nest(60));
        sourceWorkspace.doUpdate(InteropUtilities.makeList(sourceStream), f.nest(61));
        destTask.setProperty(PN_UCM_IMPORTER_CLONE, (Object)scopeString);
        destTask.setProperty(PN_UCM_IMPORTER, (Object)UcmImporter.unparseUcmImporter(sourceProvider, destinationProvider, 0, InteropCore.InteropStreamState.OK));
        destTask.doWriteProperties(f.nest(70));
        destTask = (Task)destTask.doReadProperties(f.nest(PR_TASK_ID, 80));
        String taskId = InteropUtilities.tryGetProperty((Resource)destTask, InteropUtilities.PN_TASK_ID);
        if (taskId != null) {
            f.notifyActive(NLS.bind((String)UcmImporterMessages.UcmImporter_MSG_TASK_CREATION, (Object)destTask.getProperty(InteropUtilities.PN_TASK_ID)));
        }
        return UcmImporter.getUcmImporter(destTask, f.nest(100));
    }

    Stream getSourceStream(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        String thatStreamPath = this.getSourceStreamPath();
        Stream proxy = this._sourceProvider.stream(this._sourceProvider.location(thatStreamPath));
        Stream result = (Stream)proxy.doReadProperties(f);
        return result;
    }

    public String getSourceStreamPath() {
        String path = (String)this._sourceProvider.initArgs().get("com.ibm.team.interop.OTHER_STREAM_LOCATION");
        if (path == null) {
            throw new IllegalStateException("UcmImporter should be initialized with the source stream, but its path is null");
        }
        return path;
    }

    public static void setSourceStreamInitArg(Map<String, String> initArgs, Stream source) throws WvcmException {
        initArgs.put("com.ibm.team.interop.OTHER_STREAM_LOCATION", source.location().string());
    }

    static void setSourceWorkspaceInitArg(Map<String, String> initArgs, Workspace ws) throws WvcmException {
        initArgs.put("com.ibm.rational.wvcm.WORKSPACE_LOCATION", ws.location().string());
    }

    public Workspace getSourceWorkspace(Feedback feedback) throws WvcmException {
        return UcmImporter.getSourceWorkspace(this.getSourceStream(feedback), feedback);
    }

    private static Workspace getSourceWorkspace(Stream srcStream, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        WorkspaceProvider srcP = srcStream.workspaceProvider();
        String thatWorkspacePath = (String)srcP.initArgs().get("com.ibm.rational.wvcm.WORKSPACE_LOCATION");
        if (thatWorkspacePath == null) {
            Workspace result = InteropUtilities.createWorkspace("UcmImporter", false, srcStream, f);
            UcmImporter.setSourceWorkspaceInitArg(srcP.initArgs(), result);
            return result;
        }
        Workspace proxy = srcP.workspace(srcP.location(thatWorkspacePath));
        Workspace result = (Workspace)proxy.doReadProperties(f);
        return result;
    }

    protected boolean additionalAssertionsEnabled() {
        boolean result = this.additionalAssertionsEnabled;
        if (this._destinationProvider.initArgs().containsKey(IA_ADDITIONAL_ASSERTIONS_ENABLED)) {
            result = Boolean.valueOf((String)this._destinationProvider.initArgs().get(IA_ADDITIONAL_ASSERTIONS_ENABLED));
        }
        return result;
    }

    public static UcmImporter getUcmImporter(Task importerTask, Feedback feedback) throws WvcmException {
        String ucmImporterMetadata = InteropUtilities.doReadProperty((Resource)importerTask, PN_UCM_IMPORTER, feedback);
        UcmImporter importer = null;
        JSONObject root = null;
        try {
            root = JSONObject.parse((Reader)new StringReader(ucmImporterMetadata));
            int ver = Integer.parseInt(root.get((Object)JSON_VER).toString());
            if (1 < ver) {
                throw new RuntimeException(NLS.bind((String)UcmImporterMessages.UcmImporter_ERROR_METADATA_VERSION_MISMATCH, (Object)1));
            }
            InteropCore.InteropStreamState state = InteropCore.InteropStreamState.valueOf(root.get((Object)JSON_STATE).toString());
            int stateId = Integer.parseInt(root.get((Object)JSON_STATE_ID).toString());
            JSONObject providers = (JSONObject)root.get((Object)JSON_PROVIDERS);
            JSONObject destProvider = (JSONObject)providers.get((Object)JSON_DEST_PROVIDER);
            JSONObject sourceProvider = (JSONObject)providers.get((Object)JSON_SOURCE_PROVIDER);
            String thisProviderPath = (String)destProvider.get((Object)JSON_PROVIDER_PATH);
            String thatProviderPath = (String)sourceProvider.get((Object)JSON_PROVIDER_PATH);
            HashMap<String, String> thisProviderInitArgs = new HashMap<String, String>((Map)destProvider.get((Object)JSON_PROVIDER_INITARGS));
            thisProviderInitArgs.put(IA_UCM_IMPORTER_WI_LOC_STR, importerTask.location().string());
            HashMap thatProviderInitArgs = new HashMap((Map)sourceProvider.get((Object)JSON_PROVIDER_INITARGS));
            WorkspaceProvider thisP = (WorkspaceProvider)PluginProviderFactory.pluginCreateProvider((String)thisProviderPath, null, thisProviderInitArgs);
            WorkspaceProvider thatP = (WorkspaceProvider)PluginProviderFactory.pluginCreateProvider((String)thatProviderPath, null, thatProviderInitArgs);
            importer = new UcmImporter(thatP, thisP, stateId, state);
        }
        catch (Exception ioe) {
            throw new WvcmException(UcmImporterMessages.UcmImporter_ERROR_READING_METADATA, WvcmException.ReasonCode.FORBIDDEN, (Throwable)ioe);
        }
        return importer;
    }

    public static String unparseUcmImporter(WorkspaceProvider sourceProvider, WorkspaceProvider destinationProvider, int stateId, InteropCore.InteropStreamState state) throws WvcmException {
        JSONObject thisInitArgs = new JSONObject();
        thisInitArgs.putAll(destinationProvider.initArgs());
        thisInitArgs.remove((Object)IA_UCM_IMPORTER_WI_LOC_STR);
        JSONObject thisProvider = new JSONObject();
        thisProvider.put((Object)JSON_PROVIDER_PATH, (Object)destinationProvider.getClass().getCanonicalName());
        thisProvider.put((Object)JSON_PROVIDER_INITARGS, (Object)thisInitArgs);
        JSONObject thatInitArgs = new JSONObject();
        thatInitArgs.putAll(sourceProvider.initArgs());
        JSONObject thatProvider = new JSONObject();
        thatProvider.put((Object)JSON_PROVIDER_PATH, (Object)sourceProvider.getClass().getCanonicalName());
        thatProvider.put((Object)JSON_PROVIDER_INITARGS, (Object)thatInitArgs);
        JSONObject providers = new JSONObject();
        providers.put((Object)JSON_DEST_PROVIDER, (Object)thisProvider);
        providers.put((Object)JSON_SOURCE_PROVIDER, (Object)thatProvider);
        JSONObject root = new JSONObject();
        root.put((Object)JSON_VER, (Object)String.valueOf(1));
        root.put((Object)JSON_STATE, (Object)state.toString());
        root.put((Object)JSON_STATE_ID, (Object)String.valueOf(stateId));
        root.put((Object)JSON_PROVIDERS, (Object)providers);
        return root.toString();
    }

    public String unparseUcmImporter() throws WvcmException {
        return UcmImporter.unparseUcmImporter(this._sourceProvider, this._destinationProvider, this._stateId, this._state);
    }

    public void updateUCMImporterMetadata(Feedback feedback) throws WvcmException {
        ++this._stateId;
        String ucmImporterMetadata = this.unparseUcmImporter();
        Task task = this.destinationImporterTask();
        task.setProperty(PN_UCM_IMPORTER, (Object)ucmImporterMetadata);
        task.doWriteProperties(feedback);
    }

    public Task destinationImporterTask() throws WvcmException {
        String workItemLoc = (String)this.destinationProvider().initArgs().get(IA_UCM_IMPORTER_WI_LOC_STR);
        return this.destinationProvider().task(this.destinationProvider().location(workItemLoc));
    }

    public void updateDestInitArgs(Map<String, String> newInitArgs, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveImporterTask(f.nest(25));
        try {
            this._destinationProvider.initArgs().putAll(newInitArgs);
            this.updateUCMImporterMetadata(f.nest(50));
        }
        finally {
            this.unreserveImporterTask(f.nest(100));
        }
    }

    public void updateSourceInitArgs(Map<String, String> newInitArgs, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveImporterTask(f.nest(25));
        try {
            String currentStreamInitArg = this.getSourceStreamPath();
            currentStreamInitArg.equals(newInitArgs.get("com.ibm.team.interop.OTHER_STREAM_LOCATION"));
            this._sourceProvider.initArgs().putAll(newInitArgs);
            this.updateUCMImporterMetadata(f.nest(50));
        }
        finally {
            this.unreserveImporterTask(f.nest(100));
        }
    }

    void unreserveImporterTask(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Task task = this.destinationImporterTask();
        try {
            task.removeProperty(PN_UCM_IMPORTER_LOCKED);
            task.doWriteProperties(f.nest(100));
        }
        catch (Exception exception) {
            f.notifyWarning(UcmImporterMessages.UcmImporter_ERROR_COULD_NOT_UNRESERVE);
        }
    }

    void reserveImporterTask(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Task task = this.destinationImporterTask();
        UcmImporter currentImporter = this.refresh(f.nest(50));
        if (this._stateId != currentImporter._stateId) {
            throw new WvcmException(UcmImporterMessages.UcmImporter_ERROR_OVERWRITE_METADATA, WvcmException.ReasonCode.PROPERTY_OVERWRITE_FORBIDDEN);
        }
        task.initProperty(PN_UCM_IMPORTER_LOCKED, (Object)InteropUtilities.TRUE_STRING);
        try {
            task.doWriteProperties(f.nest(100));
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.CANNOT_OVERWRITE)) {
                throw new WvcmException(f.format(UcmImporterMessages.UcmImporter_ERROR_LOCKED_METADATA, new Object[]{task}), WvcmException.ReasonCode.CONFLICT, (Throwable)e);
            }
            throw e;
        }
    }

    public UcmImporter refresh(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        UcmImporter result = UcmImporter.getUcmImporter(this.destinationImporterTask(), f.nest(50));
        if (result._stateId == this._stateId) {
            return this;
        }
        f.notifyPercentComplete(100);
        return result;
    }

    public InteropCore.SyncStats getImportStats() {
        return this._stats;
    }

    public InteropCore.InteropStreamState get_state() {
        return this._state;
    }

    private void set_state(InteropCore.InteropStreamState state) {
        this._state = state;
    }

    private void internalSetImportState(InteropCore.InteropStreamState state, Feedback f) throws WvcmException {
        this.set_state(state);
        this.updateUCMImporterMetadata(f);
    }

    public void setImportPending(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveImporterTask(f.nest(25));
        try {
            this.internalSetImportState(InteropCore.InteropStreamState.OPERATION_PENDING, f.nest(50));
        }
        finally {
            this.unreserveImporterTask(f.nest(100));
        }
    }

    public void setImportFailed(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveImporterTask(f.nest(40));
        try {
            this.internalSetImportState(InteropCore.InteropStreamState.OPERATION_ERROR, f.nest(60));
        }
        finally {
            this.unreserveImporterTask(f.nest(100));
        }
    }

    private void setInteropStreamState(Throwable e) throws WvcmException {
        if (!(e instanceof WvcmException)) {
            this.set_state(InteropCore.InteropStreamState.OPERATION_ERROR);
            throw new WvcmException("Runtime Error", null, WvcmException.ReasonCode.FORBIDDEN, e);
        }
        WvcmException we = (WvcmException)e;
        switch (we.getReasonCode()) {
            case ABORTED: {
                this.set_state(InteropCore.InteropStreamState.OPERATION_CANCELED);
                break;
            }
            default: {
                this.set_state(InteropCore.InteropStreamState.OPERATION_ERROR);
                throw we;
            }
        }
    }

    public void doOperation(Feedback feedback) throws WvcmException {
        block13: {
            Feedback f = DetailedFeedback.fb((Feedback)feedback);
            Feedback nowork = f.nest();
            this._destinationProvider.clearCache(null);
            this._sourceProvider.clearCache(null);
            this.reserveImporterTask(nowork);
            try {
                try {
                    this.set_state(InteropCore.InteropStreamState.OPERATION_ACTIVE);
                    Stream sourceStream = this.getSourceStream(f.nest(1));
                    Workspace sourceWorkspace = this.getSourceWorkspace(f.nest(2));
                    sourceWorkspace = sourceWorkspace.doUpdate(InteropUtilities.makeList(sourceStream), f.nest(3));
                    UcmImporterMetadataMap map = UcmImporter.makeMap(sourceStream, sourceWorkspace, f.nest(10));
                    f.notifyCompleted("<map>\n");
                    f.notifyCompleted(map.toJSON().toString(true));
                    f.notifyCompleted("</map>");
                    List<Task> createdTasks = this.createTasks(map, f.nest(12));
                    int createdTasksCount = createdTasks.size();
                    f.notifyCompleted(f.format(UcmImporterMessages.UcmImporter_MSG_TASK_CREATED, new Object[]{String.valueOf(createdTasksCount)}));
                    List<Object> unblockedTasks = Collections.emptyList();
                    int i = 1;
                    ResourceList<Task> executableTasks = this.executableTasks(f.nest(PR_UCM_METADATA_INFO, 15));
                    do {
                        int progress = InteropUtilities.LP(90, i, 500, 5, 90);
                        List<Task> executedTasks = this.executeTasks(sourceWorkspace, (List<Task>)executableTasks, f.nest(progress + 1));
                        int executedTasksCount = executedTasks.size();
                        f.notifyCompleted(f.format(UcmImporterMessages.UcmImporter_MSG_TASK_EXECUTED, new Object[]{String.valueOf(executedTasksCount)}));
                        executableTasks = this.executableTasks(f.nest(PR_UCM_METADATA_INFO, progress + 2));
                        if (!executableTasks.isEmpty()) continue;
                        unblockedTasks = this.unblockTasksWithDepsMet(f.nest(PR_UCM_METADATA_INFO, progress + 3));
                        int unblockedTasksCount = unblockedTasks.size();
                        f.notifyCompleted(f.format(UcmImporterMessages.UcmImporter_MSG_TASK_UNBLOCKED, new Object[]{String.valueOf(unblockedTasksCount)}));
                        if (unblockedTasksCount == 0) break;
                        executableTasks.addAll(unblockedTasks);
                    } while (++i <= 500);
                    if (i > 500) {
                        executableTasks = this.executableTasks(f.nest(91));
                        ResourceList<Task> blockedTasks = this.blockedTasks(f.nest(92));
                        f.notifyWarning(f.format(UcmImporterMessages.UcmImporter_WARN_SANITY_MAX_REACHED, new Object[]{String.valueOf(i), executableTasks.size(), blockedTasks.size()}));
                    }
                    this.set_state(InteropCore.InteropStreamState.OK);
                }
                catch (Throwable e) {
                    this.setInteropStreamState(e);
                    try {
                        this.updateUCMImporterMetadata(nowork);
                    }
                    catch (Exception exception) {
                        f.notifyWarning(UcmImporterMessages.UcmImporter_ERROR_IMPORTER_METADATA_UPDATE_FAILED);
                    }
                    this.unreserveImporterTask(nowork);
                    f.notifyPercentComplete(100);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.updateUCMImporterMetadata(nowork);
                }
                catch (Exception exception) {
                    f.notifyWarning(UcmImporterMessages.UcmImporter_ERROR_IMPORTER_METADATA_UPDATE_FAILED);
                }
                this.unreserveImporterTask(nowork);
                f.notifyPercentComplete(100);
                throw throwable;
            }
            try {
                this.updateUCMImporterMetadata(nowork);
            }
            catch (Exception exception) {
                f.notifyWarning(UcmImporterMessages.UcmImporter_ERROR_IMPORTER_METADATA_UPDATE_FAILED);
            }
            this.unreserveImporterTask(nowork);
            f.notifyPercentComplete(100);
        }
    }

    public static UcmImporterMetadataMap makeMap(Stream stream, Workspace ws, Feedback feedback) throws WvcmException {
        Assert.isNotNull((Object)ws, (String)"workspace argument must not be null");
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        UcmImporterMetadataMap result = new UcmImporterMetadataMap();
        stream = (Stream)stream.doReadProperties((Feedback)PR_RESOURCE_TO_IMPORT_INFO);
        HashMap<String, UcmImporterMetadataMap.ComponentEntry> componentEntries = new HashMap<String, UcmImporterMetadataMap.ComponentEntry>();
        ArrayList<UcmImporterMetadataMap.ActivityEntry> activityEntries = new ArrayList<UcmImporterMetadataMap.ActivityEntry>();
        String streamName = stream.getDisplayName();
        String streamResId = stream.getResourceIdentifier();
        ws = (Workspace)ws.doReadProperties((Feedback)PR_WORKSPACE_INFO);
        ResourceList bcfs = ws.getBaselineControlledFolderList();
        ArrayList<UcmImporterMetadataMap.ConfigurationEntry> configEntries = new ArrayList<UcmImporterMetadataMap.ConfigurationEntry>(bcfs.size());
        for (ControllableFolder bcf : bcfs) {
            UcmImporterMetadataMap.ConfigurationEntry entry = UcmImporter.computeConfigurationEntry(ws, stream, bcf, componentEntries, activityEntries, f);
            configEntries.add(entry);
        }
        UcmImporterMetadataMap.StreamEntry s = new UcmImporterMetadataMap.StreamEntry(streamResId, streamName, configEntries);
        result.addStream(s, componentEntries.values());
        result.addActivities(activityEntries);
        return result;
    }

    public static UcmImporterMetadataMap.ConfigurationEntry computeConfigurationEntry(Workspace ws, Stream sourceStream, ControllableFolder bcf, Map<String, UcmImporterMetadataMap.ComponentEntry> componentEntries, List<UcmImporterMetadataMap.ActivityEntry> activityEntries, Feedback f) throws WvcmException {
        Configuration config = bcf.getConfiguration();
        Component comp = (Component)config.getVersionHistory();
        String compName = comp.getDisplayName();
        String compResId = comp.getResourceIdentifier();
        UcmImporterMetadataMap.ComponentEntry componentEntry = new UcmImporterMetadataMap.ComponentEntry(compResId, compName);
        componentEntries.put(compResId, componentEntry);
        Baseline initialBaseline = (Baseline)comp.getRootVersion();
        String baselineName = initialBaseline.getDisplayName();
        UcmImporterMetadataMap.BaselineEntry baselineEntry = new UcmImporterMetadataMap.BaselineEntry(initialBaseline.getResourceIdentifier(), baselineName, sourceStream.getResourceIdentifier(), compResId);
        List<UcmImporterMetadataMap.TimelineEntry> timelineEntries = UcmImporter.computeTimelineEntries(sourceStream, comp, componentEntry, initialBaseline, activityEntries, f.nest(10));
        VersionHistory bcfVH = bcf.getVersionHistory();
        String configEntryName = UcmImporter.computeConfigEntryName(baselineName, compName, sourceStream.getDisplayName(), f.nest(20));
        UcmImporterMetadataMap.ConfigurationEntry result = new UcmImporterMetadataMap.ConfigurationEntry(configEntryName, componentEntry, baselineEntry, bcfVH.getResourceIdentifier(), timelineEntries);
        return result;
    }

    protected static List<UcmImporterMetadataMap.TimelineEntry> computeTimelineEntries(Stream sourceStream, Component sourceComponent, UcmImporterMetadataMap.ComponentEntry componentEntry, Baseline initialBaseline, List<UcmImporterMetadataMap.ActivityEntry> activityEntries, Feedback f) throws WvcmException {
        ArrayList<UcmImporterMetadataMap.TimelineEntry> results = new ArrayList<UcmImporterMetadataMap.TimelineEntry>();
        String sourceStreamResId = sourceStream.getResourceIdentifier();
        String sourceComponentResId = sourceComponent.getResourceIdentifier();
        List<Baseline> baselines = InteropUtilities.doFindAllBaselinesInStreamInComponent(sourceStream, sourceComponent, f.nest(PR_BASELINE_INFO, 10));
        baselines = InteropUtilities.orderVersions(baselines);
        int baselineCount = baselines.size();
        Baseline older = initialBaseline;
        int i = 0;
        for (Baseline newer : baselines) {
            List<UcmImporterMetadataMap.TimelineEntry> someResults = UcmImporter.report2TimelineEntries(sourceStreamResId, older, (VersionSet)newer, sourceComponentResId, activityEntries, f.nest(InteropUtilities.LP(20, ++i, baselineCount + 1, 20, 80)));
            results.addAll(someResults);
            f.notifyActive(f.format("added {0} activity tasks", new Object[]{someResults.size()}));
            if (!newer.equals(initialBaseline)) {
                String name = newer.getDisplayName();
                UcmImporterMetadataMap.BaselineEntry e = new UcmImporterMetadataMap.BaselineEntry(newer.getResourceIdentifier(), name, sourceStreamResId, sourceComponentResId);
                results.add(e);
                f.notifyActive(f.format("added task for baseline: {0}", new Object[]{name}));
            }
            older = newer;
        }
        List<UcmImporterMetadataMap.TimelineEntry> someResults = UcmImporter.report2TimelineEntries(sourceStreamResId, older, (VersionSet)sourceStream, sourceComponentResId, activityEntries, f.nest(90));
        results.addAll(someResults);
        f.notifyActive(f.format("added {0} activity tasks", new Object[]{someResults.size()}));
        return results;
    }

    private static List<UcmImporterMetadataMap.TimelineEntry> report2TimelineEntries(String sourceStreamResId, Baseline older, VersionSet newer, String sourceComponentResId, List<UcmImporterMetadataMap.ActivityEntry> activityEntries, Feedback f) throws WvcmException {
        ArrayList<UcmImporterMetadataMap.TimelineEntry> results = new ArrayList<UcmImporterMetadataMap.TimelineEntry>();
        ResourceList.ResponseIterator report = older.doCompareReport(newer, CF_NEW_ACT, f.nest(PR_ACTIVITY_INFO_VERS_LIST_INFO, 10));
        List<Activity> srcActivities = UcmImporter.computeActivityListSortedByCreationDate((ResourceList.ResponseIterator<VersionSet.CompareReport>)report);
        int i = 0;
        for (Activity a : srcActivities) {
            String resId = a.getResourceIdentifier();
            UcmImporterMetadataMap.ActivityEntry activityEntry = new UcmImporterMetadataMap.ActivityEntry(resId, a.getDisplayName());
            activityEntries.add(activityEntry);
            String changeSetName = f.format(UcmImporterMessages.UcmImporter_INFO_CHANGESET_NAME_PATTERN, new Object[]{i++, activityEntry.name, resId});
            ResourceList versionList = a.getActivityVersionList();
            List<String> versionResIds = UcmImporter.resourceIds((ResourceList<? extends Resource>)versionList);
            UcmImporterMetadataMap.ChangeSetEntry e = new UcmImporterMetadataMap.ChangeSetEntry(changeSetName, activityEntry, sourceStreamResId, sourceComponentResId, versionResIds);
            results.add(e);
        }
        return results;
    }

    private static List<Activity> computeActivityListSortedByCreationDate(ResourceList.ResponseIterator<VersionSet.CompareReport> report) throws WvcmException {
        ArrayList<Activity> results = new ArrayList<Activity>();
        while (report.hasNext()) {
            VersionSet.CompareReport entry = (VersionSet.CompareReport)report.next();
            if (entry instanceof VersionSet.AddedActivity) {
                results.add(((VersionSet.AddedActivity)entry).getActivity());
                continue;
            }
            if (!(entry instanceof VersionSet.PartiallyAddedActivity)) continue;
            results.add(((VersionSet.PartiallyAddedActivity)entry).getActivity());
        }
        return UcmImporter.sortByCreationDate(results);
    }

    private static <T extends Resource> List<T> sortByCreationDate(List<T> resources) throws WvcmException {
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        Resource aResource = (Resource)resources.get(0);
        Object cDate = aResource.lookupProperty(Resource.CREATION_DATE);
        if (cDate instanceof WvcmException) {
            return resources;
        }
        ArrayList<T> results = new ArrayList<T>(resources);
        Collections.sort(results, new ResourceCreationDateComparator());
        return results;
    }

    public static String computeConfigEntryName(String baselineName, String compName, String streamName, Feedback f) {
        return f.format(UcmImporterMessages.UcmImporter_CONFIG_ENTRY_NAME, new Object[]{baselineName, compName, streamName});
    }

    public static void tryRemoveWorkspace(Workspace w, Feedback feedback) {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        if (w != null) {
            try {
                w.doUnbindAll(null);
            }
            catch (WvcmException e) {
                if (!e.getReasonCode().equals((Object)WvcmException.ReasonCode.NOT_FOUND)) {
                    f.notifyWarning(f.format(UcmImporterMessages.UcmImporter_WARN_REMOVING_TEMP_WS_FAILED, new Object[]{e.getMessage()}));
                }
            }
            catch (Exception e) {
                f.notifyWarning(f.format(UcmImporterMessages.UcmImporter_WARN_REMOVING_TEMP_WS_FAILED, new Object[]{e.getMessage()}));
            }
        }
    }

    protected List<Task> createTasksForTests(boolean printMap, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Stream sourceStream = this.getSourceStream(f.nest(10));
        Workspace sourceWorkspace = this.getSourceWorkspace(f.nest(20));
        sourceWorkspace = sourceWorkspace.doUpdate(InteropUtilities.makeList(sourceStream), f.nest(30));
        UcmImporterMetadataMap map = UcmImporter.makeMap(sourceStream, sourceWorkspace, f.nest(40));
        if (printMap && feedback != null) {
            f.notifyActive("creating tasks from map:");
            f.notifyActive(map.toJSON().toString(true));
        }
        return this.createTasks(map, f);
    }

    public List<Task> createTasks(UcmImporterMetadataMap map, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        PropertyRequestItem.PropertyRequest propertyRequestForResult = f.getPropertyRequestForResult();
        ResourceList<Task> currentTasks = this.getAllTasks();
        HashMap<String, Task> currentTasksByResId = new HashMap<String, Task>(currentTasks.size());
        for (Task task : currentTasks) {
            String sourceResId = InteropUtilities.getProperty((Resource)task, PN_TRACKS_UCM_METADATUM);
            currentTasksByResId.put(sourceResId, task);
        }
        List<Task> results = this.createEntryTasks(currentTasksByResId, map.componentsByResId.values(), f.nest(propertyRequestForResult, 10));
        List<Task> activityTasks = this.createEntryTasks(currentTasksByResId, map.activities, f.nest(propertyRequestForResult, 20));
        results.addAll(activityTasks);
        List<Task> streamsRelatedTasks = this.createStreamRelatedTasks(currentTasksByResId, map.streams, f.nest(propertyRequestForResult, 90));
        results.addAll(streamsRelatedTasks);
        return results;
    }

    private List<Task> createEntryTasks(Map<String, Task> currentTasksByResId, Collection<? extends UcmImporterMetadataMap.Entry> entries, Feedback f) throws WvcmException {
        int count = entries.size();
        ArrayList<Task> results = new ArrayList<Task>();
        int c = 0;
        for (UcmImporterMetadataMap.Entry entry : entries) {
            if (currentTasksByResId.containsKey(entry.resId)) continue;
            Task task = this.createTask(entry, null, null, f.nest(f.getPropertyRequestForResult(), InteropUtilities.LP(10, ++c, count, 10, 90)));
            results.add(task);
        }
        return results;
    }

    private List<Task> createStreamRelatedTasks(Map<String, Task> currentTasksByResId, List<UcmImporterMetadataMap.StreamEntry> streams, Feedback f) throws WvcmException {
        int streamCount = streams.size();
        ArrayList<Task> results = new ArrayList<Task>(streamCount);
        int i = 0;
        for (UcmImporterMetadataMap.StreamEntry streamEntry : streams) {
            int lp = InteropUtilities.LP(10, ++i, streamCount, 10, 90);
            if (!currentTasksByResId.containsKey(streamEntry.resId)) {
                Task streamTask = this.createTask(streamEntry, null, null, f.nest(f.getPropertyRequestForResult(), lp));
                results.add(streamTask);
            }
            for (UcmImporterMetadataMap.ConfigurationEntry configurationEntry : streamEntry.configurations) {
                List<Task> configTasks = this.createConfigurationTasks(currentTasksByResId, streamEntry, configurationEntry, f.nest(f.getPropertyRequestForResult(), lp + 1));
                results.addAll(configTasks);
            }
        }
        return results;
    }

    private List<Task> createConfigurationTasks(Map<String, Task> currentTasksByResId, UcmImporterMetadataMap.Entry streamEntry, UcmImporterMetadataMap.ConfigurationEntry configurationEntry, Feedback f) throws WvcmException {
        Task initialConfigTask;
        ArrayList<Task> results = new ArrayList<Task>();
        boolean configTaskAlreadyExists = currentTasksByResId.containsKey(configurationEntry.resId);
        Task task = initialConfigTask = configTaskAlreadyExists ? currentTasksByResId.get(configurationEntry.resId) : this.createTask(configurationEntry, Arrays.asList(streamEntry, configurationEntry.componentEntry), null, f.nest(f.getPropertyRequestForResult(), 10));
        if (!configTaskAlreadyExists) {
            results.add(initialConfigTask);
        }
        int timelineSize = configurationEntry.timelineEntries.size();
        Task previousTask = initialConfigTask;
        int i = 0;
        for (UcmImporterMetadataMap.TimelineEntry entry : configurationEntry.timelineEntries) {
            Task t;
            boolean taskAlreadyExists;
            Task existingTask;
            ResourceList<Task> dependsOnTaskList = InteropUtilities.makeList(previousTask);
            boolean isChangeSetEntry = entry instanceof UcmImporterMetadataMap.ChangeSetEntry;
            UcmImporterMetadataMap.ChangeSetEntry changeSetEntry = isChangeSetEntry ? (UcmImporterMetadataMap.ChangeSetEntry)entry : null;
            List<Object> requiredEntries = Collections.emptyList();
            if (changeSetEntry != null) {
                requiredEntries = Collections.singletonList(changeSetEntry.activityEntry);
            }
            Task task2 = existingTask = (taskAlreadyExists = currentTasksByResId.containsKey(entry.resId)) ? currentTasksByResId.get(entry.resId) : null;
            if (existingTask != null) {
                boolean listsMatch;
                boolean requirementsMatch = this.listsMatch(requiredEntries, InteropUtilities.tryGetProperty((Resource)existingTask, PN_REQUIRES_UCM_METADATA));
                boolean bl = listsMatch = requirementsMatch && this.listsMatch(dependsOnTaskList, InteropUtilities.tryGetProperty((Resource)existingTask, PN_CM_DEPENDS_ON_TASKS));
                if (!listsMatch) {
                    if (isChangeSetEntry) {
                        existingTask = (Task)existingTask.doReadProperties((Feedback)PR_IMPORTER_ENTRY);
                        JSONObject existingEntryJson = this.getEntryJson(existingTask);
                        String existingEntryComponentResId = (String)existingEntryJson.get((Object)UcmImporterMetadataMap.FieldTags.COMPONENT.printedAs());
                        List srcVerResIds = (List)existingEntryJson.get((Object)UcmImporterMetadataMap.FieldTags.VERSIONS.printedAs());
                        taskAlreadyExists = changeSetEntry.componentResId == existingEntryComponentResId && changeSetEntry.versionResIds.size() == srcVerResIds.size();
                    } else {
                        taskAlreadyExists = false;
                    }
                }
            }
            if (taskAlreadyExists) {
                t = existingTask;
            } else {
                t = this.createTask(entry, requiredEntries, dependsOnTaskList, f.nest(f.getPropertyRequestForResult(), InteropUtilities.LP(10, ++i, timelineSize, 10, 90)));
                results.add(t);
            }
            previousTask = t;
        }
        return results;
    }

    private boolean listsMatch(List<? extends UcmImporterMetadataMap.Entry> expectedEntries, List<String> actualResIds) {
        int count = expectedEntries.size();
        if (actualResIds == null || count != actualResIds.size()) {
            return false;
        }
        int i = 0;
        List<String> expectedResIds = UcmImporter.resourceIdsFromEntryList(expectedEntries);
        for (String expected : expectedResIds) {
            if (!expected.equals(actualResIds.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean listsMatch(ResourceList<Task> expectedTasks, List<String> actualResIds) throws WvcmException {
        int count = expectedTasks.size();
        if (count != actualResIds.size()) {
            return false;
        }
        int i = 0;
        List<String> expectedResIds = UcmImporter.resourceIds(expectedTasks);
        for (String expected : expectedResIds) {
            if (!expected.equals(actualResIds.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean tasksRequireTransitionAction(WorkspaceProvider p) {
        return InteropUtilities.TRUE_STRING.equals(p.initArgs().get(IA_TASKS_REQUIRE_TRANSITION_ACTIONS));
    }

    protected Task createTaskProxyForResource(UcmImporterMetadataMap.Entry e, Feedback f) throws WvcmException {
        Task thisTask = this._destinationProvider.task(this._destinationProvider.rootLocation());
        String resIdString = e.resId;
        if (e.resId == null) {
            resIdString = "{no resource Id}";
        } else {
            thisTask.setProperty(PN_TRACKS_UCM_METADATUM, (Object)e.resId);
        }
        thisTask.setDisplayName(f.format(UcmImporterMessages.UcmImporter_TASK_SUMMARY, new Object[]{e.myKind.displayName(), e.name, resIdString}));
        JSONObject entryJSON = e.toJSON();
        thisTask.setComment(entryJSON.toString(true));
        thisTask.setProperty(PN_IMPORTER_ENTRY, (Object)entryJSON.toString(false));
        if (!this.tasksRequireTransitionAction(this._destinationProvider)) {
            TaskState.INITIAL.setPropertyInProxy((Resource)thisTask, PN_CM_STATUS);
        }
        this.setStreamFilterInTaskProxy(thisTask);
        return thisTask;
    }

    public void setStreamFilterInTaskProxy(Task thisTask) {
        thisTask.setProperty(PN_TAGS, Collections.singletonList(this.getSourceStreamPath()));
    }

    public static List<String> resourceIds(ResourceList<? extends Resource> resources) throws WvcmException {
        ArrayList<String> results = new ArrayList<String>(resources.size());
        for (Resource resource : resources) {
            results.add(resource.getResourceIdentifier());
        }
        return results;
    }

    private Task createTask(UcmImporterMetadataMap.Entry entry, List<? extends UcmImporterMetadataMap.Entry> entryDependencies, ResourceList<Task> taskDependencies, Feedback f) throws WvcmException {
        boolean hasTaskDependencies;
        boolean hasEntryDependencies;
        Task result = this.createTaskProxyForResource(entry, f.nest());
        boolean bl = hasEntryDependencies = entryDependencies != null && !entryDependencies.isEmpty();
        if (hasEntryDependencies) {
            List<String> resourceIds = UcmImporter.resourceIdsFromEntryList(entryDependencies);
            result.setProperty(PN_REQUIRES_UCM_METADATA, resourceIds);
        }
        boolean bl2 = hasTaskDependencies = taskDependencies != null && !taskDependencies.isEmpty();
        if (hasTaskDependencies) {
            result.setProperty(PN_CM_DEPENDS_ON_TASKS, UcmImporter.resourceIds(taskDependencies));
        }
        this.setBlockedProperty(result, hasEntryDependencies || hasTaskDependencies);
        result = result.doCreateGeneratedResource(f);
        return result;
    }

    public static List<String> resourceIdsFromEntryList(List<? extends UcmImporterMetadataMap.Entry> entries) {
        ArrayList<String> results = new ArrayList<String>(entries.size());
        for (UcmImporterMetadataMap.Entry entry : entries) {
            results.add(entry.resId);
        }
        return results;
    }

    private void setBlockedProperty(Task result, boolean isBlocked) {
        Long value = isBlocked ? IS_BLOCKED_VALUE : IS_UNBLOCKED_VALUE;
        result.setProperty(PN_DURATION, (Object)String.valueOf(value));
    }

    protected Task transitionTask(Task task, TaskState toState) throws WvcmException {
        Task result = InteropUtilities.createNewProxy(task);
        toState.setPropertyInProxy((Resource)result, PN_CM_STATUS);
        result = (Task)result.doWriteProperties((Feedback)PR_UCM_METADATA_INFO);
        return result;
    }

    private ResourceList<Task> tasksInState(TaskState desiredState, boolean isBlocked, Feedback f) throws WvcmException {
        ResourceList results = this._destinationProvider.resourceList((Resource[])new Task[0]);
        Task query = this._destinationProvider.task(this._destinationProvider.rootLocation());
        this.setStreamFilterInTaskProxy(query);
        if (desiredState != null) {
            desiredState.setPropertyInProxy((Resource)query, PN_CM_STATUS);
            this.setBlockedProperty(query, isBlocked);
        }
        ResourceList.ResponseIterator resultSet = query.doFindAll(f);
        while (resultSet.hasNext()) {
            results.add((Object)((Task)resultSet.next()));
        }
        return results;
    }

    public ResourceList<Task> getAllTasks() throws WvcmException {
        return this.tasksInState(null, false, (Feedback)PR_UCM_METADATA_INFO);
    }

    public ResourceList<Task> blockedTasks(Feedback feedback) throws WvcmException {
        return this.tasksInState(TaskState.INITIAL, true, DetailedFeedback.fb((Feedback)feedback));
    }

    public ResourceList<Task> executableTasks(Feedback feedback) throws WvcmException {
        return this.tasksInState(TaskState.INITIAL, false, DetailedFeedback.fb((Feedback)feedback));
    }

    public ResourceList<Task> completedTasks(Feedback feedback) throws WvcmException {
        return this.tasksInState(TaskState.DONE, false, DetailedFeedback.fb((Feedback)feedback));
    }

    public List<Task> unblockTasksWithDepsMet(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        ResourceList<Task> blocked = this.blockedTasks(f.nest(PR_UCM_METADATA_INFO, 10));
        if (blocked.isEmpty()) {
            return Collections.emptyList();
        }
        ImportedResourcesAndTheirTasks imports = this.getImportedResources(f.nest(20));
        ArrayList<Task> unblockable = new ArrayList<Task>();
        for (Task task : blocked) {
            List<String> blockingTaskResIds;
            List<String> requiredResIds = InteropUtilities.tryGetProperty((Resource)task, PN_REQUIRES_UCM_METADATA);
            if (requiredResIds != null && !requiredResIds.isEmpty() && !imports.ImportedMetadataResIds.containsAll(requiredResIds) || (blockingTaskResIds = InteropUtilities.tryGetProperty((Resource)task, PN_CM_DEPENDS_ON_TASKS)) != null && !blockingTaskResIds.isEmpty() && !imports.CompletedTasksResIds.containsAll(blockingTaskResIds)) continue;
            this.setBlockedProperty(task, false);
            unblockable.add(task);
        }
        ResourceList<?> updateMe = InteropUtilities.makeResourceList((Provider)this._destinationProvider, unblockable);
        int count = unblockable.size();
        ArrayList<Task> results = new ArrayList<Task>(count);
        ResourceList.ResponseIterator iterator = updateMe.doWriteProperties((Feedback)f.getPropertyRequestForResult());
        while (iterator.hasNext()) {
            Task update = (Task)iterator.next();
            results.add(update);
        }
        f.notifyActive(f.format(UcmImporterMessages.UcmImporter_INFO_UNBLOCKED_TASKS, new Object[]{String.valueOf(count)}));
        return results;
    }

    private ImportedResourcesAndTheirTasks getImportedResources(Feedback f) throws WvcmException {
        ResourceList<Task> completedTasks = this.completedTasks(f.nest(PR_UCM_METADATA_INFO));
        ArrayList<String> importedMetadataResIds = new ArrayList<String>(completedTasks.size());
        for (Task task : completedTasks) {
            String importedResId = InteropUtilities.tryGetProperty((Resource)task, PN_TRACKS_UCM_METADATUM);
            if (importedResId == null) continue;
            importedMetadataResIds.add(importedResId);
        }
        ImportedResourcesAndTheirTasks results = new ImportedResourcesAndTheirTasks(importedMetadataResIds, UcmImporter.resourceIds(completedTasks));
        return results;
    }

    public List<Task> executeReadyTasks(Workspace srcWs, Feedback f) throws WvcmException {
        ResourceList<Task> readyTasks = this.executableTasks(f.nest(PR_UCM_METADATA_INFO, 10));
        return this.executeTasks(srcWs, (List<Task>)readyTasks, f);
    }

    public List<Task> executeTasks(Workspace srcWs, List<Task> readyTasks, Feedback f) throws WvcmException {
        int count = readyTasks.size();
        f.notifyActive(f.format(UcmImporterMessages.UcmImporter_INFO_ACTIVE_EXECUTING_TASKS_WITH_COUNT, new Object[]{count}));
        ArrayList<Task> results = new ArrayList<Task>(count);
        int i = 0;
        for (Task task : readyTasks) {
            task = this.executeTask(task, srcWs, f.nest(f.getPropertyRequestForResult(), InteropUtilities.LP(20, i++, count, 20, 80)));
            results.add(task);
        }
        return results;
    }

    /*
     * Exception decompiling
     */
    protected Task executeTask(Task task, Workspace srcWs, Feedback f) throws WvcmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected JSONObject getEntryJson(Task task) throws WvcmException {
        String entryString = InteropUtilities.tryGetProperty((Resource)task, PN_IMPORTER_ENTRY);
        if (entryString == null) {
            throw new IllegalStateException("task has no entry data: " + task.getResourceIdentifier());
        }
        JSONObject entryJson = null;
        try {
            entryJson = JSONObject.parse((Reader)new StringReader(entryString));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not parse entry string:\n" + entryString);
        }
        return entryJson;
    }

    private void validatecCreatedResource(Resource source, String sourceResId, Resource createdResource, Feedback f) throws WvcmException {
        List<Resource> stuff;
        Resource proxy = createdResource.doReadProperties((Feedback)PR_IMPORTED);
        String imported = InteropUtilities.tryGetProperty(proxy, InteropCore.PN_CLONE);
        if (imported == null || !sourceResId.equals(imported)) {
            throw new IllegalStateException("imported not set on created resource");
        }
        if (!(source instanceof Activity)) {
            Resource debugging_target = UcmImporter.lookupTypedResourceImportedFor(source, this._destinationProvider, f.nest(35));
            if (debugging_target == null) {
                throw new IllegalStateException("imported object not found by imported link");
            }
            debugging_target = debugging_target.doReadProperties((Feedback)PR_IMPORTED);
            imported = InteropUtilities.tryGetProperty(proxy, InteropCore.PN_CLONE);
            if (imported == null || !sourceResId.equals(imported)) {
                throw new IllegalStateException("imported not set on created resource");
            }
        }
        if ((stuff = UcmImporter.lookupResourcesImportedFor(this._sourceProvider, Collections.singletonList(source), this._destinationProvider, f.nest(40))) == null || stuff.isEmpty()) {
            throw new IllegalStateException("imported object not found by lookupResourcesImportedFor");
        }
        Resource item = stuff.get(0).doReadProperties((Feedback)PR_IMPORTED);
        String valueForSource = InteropUtilities.tryGetProperty(item, InteropCore.PN_CLONE);
        if (item == null || !sourceResId.equals(valueForSource)) {
            throw new IllegalStateException("imported object not found in response from lookupResourcesImportedFor");
        }
    }

    private Baseline importBaseline(Baseline source, JSONObject entryJson, Feedback f) throws WvcmException {
        Baseline baseline;
        block4: {
            String sourceStreamResId = (String)entryJson.get((Object)UcmImporterMetadataMap.FieldTags.STREAM.printedAs());
            String componentResId = (String)entryJson.get((Object)UcmImporterMetadataMap.FieldTags.COMPONENT.printedAs());
            ResourceList<Resource> tgtResourcesList = UcmImporter.lookupDependencies(this._sourceProvider, Arrays.asList(sourceStreamResId, componentResId), this._destinationProvider, f.nest(1));
            ArrayList<Resource> tgtResources = new ArrayList<Resource>(tgtResourcesList.size());
            ResourceList.ResponseIterator depsIter = tgtResourcesList.doReadProperties(f.nest(PR_IMPORTED));
            while (depsIter.hasNext()) {
                tgtResources.add((Resource)depsIter.next());
            }
            Stream targetStream = this.findOneStreamResource(tgtResources, f.nest(2));
            Component tgtComponent = this.findOneComponentResource(tgtResources, f.nest(3));
            String wsName = UcmImporter.uniquify("targetWorkspace");
            Workspace tgtWs = null;
            try {
                tgtWs = InteropUtilities.createWorkspace(wsName, true, targetStream, f.nest(30));
                tgtWs = tgtWs.doUpdate(InteropUtilities.makeList(targetStream), f.nest(40));
                Configuration config = InteropUtilities.doFindConfigurationInWorkspace(tgtWs, tgtComponent, f.nest(50));
                config = (Configuration)config.doCheckout(null, f.nest(60));
                config.setDisplayName(source.getDisplayName());
                config = (Configuration)config.doCheckin(null, f.nest(PR_CI_DN_CLONE, 70));
                Baseline result = (Baseline)config.getCheckedIn();
                f.notifyCompleted(f.format("imported {0}", new Object[]{result.getDisplayName()}));
                baseline = result;
                if (tgtWs == null) break block4;
            }
            catch (Throwable throwable) {
                if (tgtWs != null) {
                    UcmImporter.tryRemoveWorkspace(tgtWs, f);
                }
                throw throwable;
            }
            UcmImporter.tryRemoveWorkspace(tgtWs, f);
        }
        return baseline;
    }

    private Resource importChangeSet(Activity source, List<Resource> dependencies, Task target, JSONObject entryJson, Workspace srcWs, Feedback f) throws WvcmException {
        Activity activity;
        String sourceStreamResId = (String)entryJson.get((Object)UcmImporterMetadataMap.FieldTags.STREAM.printedAs());
        String componentResId = (String)entryJson.get((Object)UcmImporterMetadataMap.FieldTags.COMPONENT.printedAs());
        ResourceList<Resource> tgtResourcesList = UcmImporter.lookupDependencies(this._sourceProvider, Arrays.asList(sourceStreamResId, componentResId), this._destinationProvider, f.nest(1));
        ArrayList<Resource> tgtResources = new ArrayList<Resource>(tgtResourcesList.size());
        ResourceList.ResponseIterator depsIter = tgtResourcesList.doReadProperties(f.nest(PR_IMPORTED));
        while (depsIter.hasNext()) {
            tgtResources.add((Resource)depsIter.next());
        }
        Stream targetStream = this.findOneStreamResource(tgtResources, f.nest(2));
        Component tgtComponent = this.findOneComponentResource(tgtResources, f.nest(3));
        String wsName = UcmImporter.uniquify("targetWorkspace");
        Workspace tgtWs = null;
        try {
            tgtWs = InteropUtilities.createWorkspace(wsName, false, targetStream, f.nest(30));
            tgtWs = tgtWs.doMerge(InteropUtilities.makeList(targetStream), null, f.nest(40));
            List srcVerResIds = (List)entryJson.get((Object)UcmImporterMetadataMap.FieldTags.VERSIONS.printedAs());
            int count = srcVerResIds.size();
            if (target != null) {
                target = (Task)target.doReadProperties((Feedback)PR_RESOURCE_INFO);
                f.notifyActive(f.format(UcmImporterMessages.UcmImporter_INFO_IMPORTING_VERSIONS_INTO_CHANGE_SET_FOR_TASK, new Object[]{count, target.getDisplayName()}));
            }
            ResourceList<Version> sourceVersionProxies = this.computeVersionProxies(this._sourceProvider, srcVerResIds);
            ResourceList.ResponseIterator respIter = sourceVersionProxies.doReadProperties(f.nest(InteropCore.PR_CHILDMAP_VH, 20));
            HashMap<VersionHistory, Version> srcVh2srcVer = new HashMap<VersionHistory, Version>(count);
            ResourceList srcVhs = this._sourceProvider.resourceList((Resource[])new VersionHistory[0]);
            while (respIter.hasNext()) {
                Version srcVer = (Version)respIter.next();
                VersionHistory srcVh = srcVer.getVersionHistory();
                srcVhs.add((Object)srcVh);
                Version previousValue = srcVh2srcVer.put(srcVh, srcVer);
                if (previousValue == null) continue;
                String message = "NYI: support for importing a change set with multiple versions of a single version history";
                try {
                    ControllableResource srcCr = InteropUtilities.doFindCRInWorkspace(srcWs, srcVh, (Feedback)InteropCore.PR_PATH);
                    String path = srcCr.getPathnameLocation().string();
                    message = f.format("{0}: a controllable resource of the version history has the path: {1}", new Object[]{message, path});
                }
                catch (Exception exception) {}
                throw new WvcmException(message, WvcmException.ReasonCode.FORBIDDEN);
            }
            Configuration tgtConfig = InteropUtilities.doFindConfigurationInWorkspace(tgtWs, tgtComponent, f.nest(PR_RF_PATH, 45));
            ControllableFolder rootFolder = tgtConfig.getRootFolder();
            String tgtComponentRootFolderPath = rootFolder.getPathnameLocation().string();
            this.sendoverChanges(tgtWs, tgtComponentRootFolderPath, srcWs, Collections.unmodifiableMap(srcVh2srcVer), f.nest(50));
            tgtWs = (Workspace)tgtWs.doReadProperties(f.nest(InteropCore.PR_CA_TASKS_COMMENT, 55));
            ResourceList tgtActList = tgtWs.getCurrentActivityList();
            Activity result = null;
            if (tgtActList != null && !tgtActList.isEmpty()) {
                Activity tgtAct = (Activity)tgtActList.get(0);
                tgtAct.setIsComplete(true);
                tgtAct.doWriteProperties(f.nest(60));
                result = tgtAct;
                ResourceList tgtTasks = this._destinationProvider.resourceList((Resource[])new Task[]{target});
                InteropUtilities.trySetActivityTaskList(tgtAct, (ResourceList<Task>)tgtTasks, tgtWs, f.nest(65));
                tgtActList.clear();
                tgtWs.setCurrentActivityList(tgtActList);
                tgtWs = (Workspace)tgtWs.doWriteProperties(f.nest(70));
            }
            targetStream = targetStream.doUpdate(InteropUtilities.makeList(tgtWs), f.nest(90));
            activity = result;
        }
        catch (Throwable throwable) {
            UcmImporter.tryRemoveWorkspace(tgtWs, f);
            throw throwable;
        }
        UcmImporter.tryRemoveWorkspace(tgtWs, f);
        return activity;
    }

    public static String uniquify(String base) {
        return String.valueOf(base) + '_' + UUID.randomUUID().toString();
    }

    private void sendoverChanges(Workspace tgtWs, String tgtComponentRootFolderPath, Workspace srcWs, Map<VersionHistory, Version> srcVh2srcVer, Feedback f) throws WvcmException {
        InteropStream interopStream = InteropUtilities.createInteropStream((Provider)this._sourceProvider, (Provider)this._destinationProvider);
        ResourceList srcChangedVersions = srcWs.workspaceProvider().resourceList((Resource[])new Version[0]);
        srcChangedVersions.addAll(srcVh2srcVer.values());
        interopStream.sendoverChanges(tgtWs, Collections.singleton(tgtComponentRootFolderPath), (ResourceList<Version>)srcChangedVersions, srcWs, false, srcVh2srcVer, f);
    }

    private ResourceList<Version> computeVersionProxies(WorkspaceProvider p, List<String> verResIds) throws WvcmException {
        ResourceList results = p.resourceList((Resource[])new Version[0]);
        for (String verResId : verResIds) {
            results.add((Object)p.version(p.location(verResId)));
        }
        return results;
    }

    private Resource createActivityTask(Activity source, Feedback f) throws WvcmException {
        Task result = this._destinationProvider.task(this._destinationProvider.rootLocation());
        String sourceDisplayName = (String)InteropUtilities.doReadProperty((Resource)source, Resource.DISPLAY_NAME, f.nest(5));
        String activityResId = source.getResourceIdentifier();
        String taskDisplayName = f.format(UcmImporterMessages.UcmImporter_TASK_NAME_PATTERN, new Object[]{sourceDisplayName, activityResId});
        result.setDisplayName(taskDisplayName);
        result.initProperty(InteropCore.PN_CLONE, (Object)activityResId);
        result = result.doCreateGeneratedResource(f.nest(f.getPropertyRequestForResult(), 50));
        f.notifyActive(f.format(UcmImporterMessages.UcmImporter_INFO_COMPLETED_CREATE_TASK_WITH_NAME, new Object[]{taskDisplayName}));
        return result;
    }

    public static ResourceList<Resource> lookupDependencies(WorkspaceProvider sourceProvider, List<String> depResIds, WorkspaceProvider destinationProvider, Feedback feedback) throws WvcmException {
        if (depResIds == null || depResIds.isEmpty()) {
            return destinationProvider.resourceList(new Resource[0]);
        }
        LinkedObjectUtils u = new LinkedObjectUtils(InteropCore.PN_CLONE, IA_HAS_IMPORTED_OBJECT_INFO);
        ResourceList<Resource> results = u.lookupResourcesLinkedToTheseIds(sourceProvider, depResIds, destinationProvider, feedback);
        return results;
    }

    public static List<Resource> lookupResourcesImportedFor(WorkspaceProvider sourceProvider, List<? extends Resource> sources, WorkspaceProvider destinationProvider, Feedback feedback) throws WvcmException {
        LinkedObjectUtils u = new LinkedObjectUtils(InteropCore.PN_CLONE, IA_HAS_IMPORTED_OBJECT_INFO);
        return u.lookupLinkedObjects(sourceProvider, sources, destinationProvider);
    }

    public static <T extends Resource> T lookupTypedResourceImportedFor(T source, WorkspaceProvider tgtP, Feedback feedback) throws WvcmException {
        Resource emptyProxy = UcmImporter.lookupLinkedResource(source, InteropCore.PN_CLONE, tgtP);
        Resource result = emptyProxy == null ? null : emptyProxy.doReadProperties(feedback);
        return (T)result;
    }

    protected static Resource lookupLinkedResource(Resource source, PropertyNameList.PropertyName<String> linkPropertyName, WorkspaceProvider tgtP) throws WvcmException {
        LinkedObjectUtils u = new LinkedObjectUtils(linkPropertyName, IA_HAS_IMPORTED_OBJECT_INFO);
        Resource result = u.lookupLinkedObject(source, tgtP);
        return result;
    }

    protected Component importComponentObject(Component source, Feedback f) throws WvcmException {
        String compName = source.getDisplayName();
        Workspace ws = this._destinationProvider.workspace(this._destinationProvider.rootLocation().child("Ucm Importer component creation temp. workspace"));
        try {
            ws = ws.doCreateGeneratedResource(f.nest(20));
            ControllableFolder bcf = this._destinationProvider.controllableFolder(ws.location().child(compName));
            bcf = bcf.doBaselineControl(f.nest(InteropCore.PR_CONFIG_VH, 30));
            Configuration config = bcf.getConfiguration();
            Component result = (Component)config.getVersionHistory();
            result.setProperty(InteropCore.PN_CLONE, (Object)source.getResourceIdentifier());
            result = (Component)result.doWriteProperties(f);
            f.notifyCompleted(f.format(UcmImporterMessages.UcmImporter_IMPORTED_COMPONENT, new Object[]{compName}));
            Component component = result;
            return component;
        }
        finally {
            UcmImporter.tryRemoveWorkspace(ws, f);
        }
    }

    protected Stream importStreamObject(Stream source, Feedback f) throws WvcmException {
        Stream importedStream = UcmImporter.lookupTypedResourceImportedFor(source, this._destinationProvider, f.nest(10));
        if (importedStream != null) {
            return importedStream;
        }
        String streamName = source.getDisplayName();
        Stream result = this._destinationProvider.stream(this._destinationProvider.rootLocation().child(streamName));
        result.setProperty(InteropCore.PN_CLONE, (Object)source.getResourceIdentifier());
        String comment = f.format(UcmImporterMessages.UcmImporter_IMPORTED_FROM_BY_OBJ_NAME_AND_UUID, new Object[]{streamName, source.getResourceIdentifier()});
        result.setProperty(Resource.COMMENT, (Object)comment);
        result = (Stream)result.doCreateGeneratedResource(f.nest(f.getPropertyRequestForResult(), 30));
        f.notifyCompleted(f.format(UcmImporterMessages.UcmImporter_IMPORTED_STREAM, new Object[]{streamName}));
        return result;
    }

    protected Baseline addComponentToStream(VersionHistory sourceBcfVh, List<Resource> dependencies, VersionHistory targetBcfVh, Feedback f) throws WvcmException {
        Baseline baseline;
        Component targetComponent = this.findOneComponentResource(dependencies, f.nest(PR_TGT_COMPONENT_INFO, 10));
        String bindingName = targetComponent.getDisplayName();
        Baseline initialBaseline = (Baseline)targetComponent.getRootVersion();
        Stream targetStream = this.findOneStreamResource(dependencies, f.nest(PR_RESOURCE_INFO, 20));
        String wsName = "targetWorkspace " + UUID.randomUUID().toString();
        Workspace w = null;
        try {
            w = InteropUtilities.createWorkspace(wsName, false, targetStream, f.nest(30));
            w = w.doMerge(InteropUtilities.makeList(targetStream), null, f.nest(40));
            Configuration config = InteropUtilities.doFindConfigurationInWorkspace(w, targetComponent, f.nest(35));
            if (config == null) {
                WorkspaceProvider targetP = targetComponent.workspaceProvider();
                ControllableFolder targetBcf = targetP.controllableFolder(w.location().child(bindingName));
                targetBcf = targetBcf.doCreateBaselineControlledFolder(initialBaseline, f.nest(50));
                w.doCheckinAll(null, null, f.nest(60));
                targetBcf = (ControllableFolder)targetBcf.doReadProperties(f.nest(InteropCore.PR_VH_CLONE, 65));
                targetBcfVh = targetBcf.getVersionHistory();
                InteropCore.linkClones((Resource)sourceBcfVh, (Resource)targetBcfVh, f.nest(70));
                targetStream = targetStream.doUpdate(InteropUtilities.makeList(w), f.nest(PR_RESOURCE_INFO, 80));
                String targetBaselineName = (String)InteropUtilities.getOrReadProperty((Resource)initialBaseline, Resource.DISPLAY_NAME, f.nest(85));
                f.notifyCompleted(f.format(UcmImporterMessages.UcmImporter_MSG_IMPORTED_BASELINE, new Object[]{targetBaselineName, targetComponent.getDisplayName(), targetStream.getDisplayName()}));
            }
            baseline = initialBaseline;
        }
        catch (Throwable throwable) {
            UcmImporter.tryRemoveWorkspace(w, f);
            throw throwable;
        }
        UcmImporter.tryRemoveWorkspace(w, f);
        return baseline;
    }

    private Stream findOneStreamResource(List<Resource> resources, Feedback f) throws WvcmException {
        Stream result = null;
        for (Resource res : resources) {
            if (!(res instanceof Stream)) continue;
            if (result != null) {
                throw new IllegalStateException("found more than one stream in a list of resources that should have only one");
            }
            result = (Stream)res;
        }
        if (result == null) {
            throw new IllegalStateException("expected to find one stream in a list of resources that should have one, but there were no streams");
        }
        result = (Stream)result.doReadProperties(f);
        return result;
    }

    private Component findOneComponentResource(List<Resource> resources, Feedback f) throws WvcmException {
        Component result = null;
        for (Resource res : resources) {
            if (!(res instanceof Component)) continue;
            if (result != null) {
                throw new IllegalStateException("found more than one comoponent in a list of resources that should have only one");
            }
            result = (Component)res;
        }
        if (result == null) {
            throw new IllegalStateException("expected to find one component in a list of resources that should have one, but there were no components");
        }
        result = (Component)result.doReadProperties(f);
        return result;
    }

    public static class ImportedResourcesAndTheirTasks {
        Collection<String> ImportedMetadataResIds;
        Collection<String> CompletedTasksResIds;

        public ImportedResourcesAndTheirTasks(Collection<String> importedMetadataResIds, Collection<String> completedTasksResIds) {
            this.ImportedMetadataResIds = importedMetadataResIds;
            this.CompletedTasksResIds = completedTasksResIds;
        }
    }

    public static class ResourceCreationDateComparator
    implements Comparator<Resource> {
        private static final int lt = -1;
        private static final int eq = 0;
        private static final int gt = 1;

        @Override
        public final int compare(Resource o1, Resource o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            try {
                Date o1CreationDate = o1.getCreationDate();
                int comparison = o1CreationDate.compareTo(o2.getCreationDate());
                String o1ResId = o1.getResourceIdentifier();
                String o2ResId = o2.getResourceIdentifier();
                if (comparison == 0 && !o1ResId.equals(o2ResId)) {
                    throw new IllegalArgumentException(String.format("creation dates for different resources must be different but here is a pair that has the same date: o1(%s), o2(%s) have creation date: %s", o1ResId, o2ResId, new SimpleDateFormat("HH.mm.ss.SSS").format(o1CreationDate)));
                }
                return comparison;
            }
            catch (WvcmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum TaskState {
        INITIAL("New"),
        IN_PROGRESS("In Progress"),
        DONE("Done");

        static final EnumSet<TaskState> TaskStateEnumSet;
        static final Map<String, TaskState> taskStates;
        private final String displayName;

        static {
            TaskStateEnumSet = EnumSet.allOf(TaskState.class);
            taskStates = new HashMap<String, TaskState>(TaskStateEnumSet.size());
            for (TaskState state : TaskStateEnumSet) {
                taskStates.put(state.displayName(), state);
            }
        }

        private TaskState(String name) {
            this.displayName = name;
        }

        public String displayName() {
            return this.displayName;
        }

        public void setPropertyInProxy(Resource r, PropertyNameList.PropertyName<String> pN) {
            r.setProperty(pN, (Object)this.displayName());
        }

        public static TaskState lookup(String name) {
            return taskStates.get(name);
        }
    }
}

