/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet_def;

import com.urbancode.air.property.interceptors.InterceptorRegistryLookup;
import com.urbancode.air.property.persistence.AbstractPropertyFactory;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactory;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroup;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.Persistent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropSheetDefFactoryImpl
extends AbstractPropertyFactory<PropSheetDef>
implements PropSheetDefFactory {
    @Override
    public PropSheetDef createPropSheetDef(PropSheetGroup group, String name) {
        PropSheetDef result = new PropSheetDef(name);
        if (group != null) {
            result.setPropSheetGroup(group);
            group.addPropSheetDef(result);
        }
        this.getDBSession().save((Object)result);
        return result;
    }

    @Override
    public PropSheetDef createVersionedPropSheetDef(String path, PropSheetGroup group, String name) {
        if (group != null && group.isVersioned()) {
            path = group.getPersistenceData().getPath() + "/propSheetDefs/{id}";
        }
        PropSheetDef result = new PropSheetDef(name);
        path = path.replace("{id}", result.getId().toString());
        result.getPersistenceData().setPath(path);
        if (group != null) {
            result.setPropSheetGroup(group);
            group.addPropSheetDef(result);
        }
        this.getVCSession().saveOrUpdate((Persistent)result);
        return result;
    }

    @Override
    public PropSheetDef getPropSheetDefForId(UUID id) {
        PropSheetDef result = null;
        try {
            result = (PropSheetDef)((Object)this.getEntityForId(PropSheetDef.class, id, "PropSheetDef"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (result != null) {
            this.interceptRead(result);
        }
        return result;
    }

    @Override
    public Map<UUID, PropSheetDef> getPropSheetDefsForIds(List<UUID> ids) {
        return this.getEntitiesForIds(PropSheetDef.class, ids, "PropSheetDef");
    }

    @Override
    public PropSheetDef getPropSheetDefForHandle(Handle handle) {
        return (PropSheetDef)((Object)this.restore(handle));
    }

    @Override
    public PropSheetDef getPropSheetDefForHandleNoSecurity(Handle handle) {
        return this.getPropSheetDefForHandle(handle);
    }

    @Override
    public Map<Handle, PropSheetDef> restoreWithHandlesIntoMap(Collection<Handle> handles) {
        return this.restoreWithHandlesIntoMap(handles, true);
    }

    @Override
    public List<PropSheetDef> getPropSheetDefsForPaths(List<String> paths, boolean skipVersionCount) {
        return this.restoreLatestWithPaths(paths, skipVersionCount);
    }

    @Override
    public void copyPropDefsFromAndToPropSheetDef(PropSheetDef copyFrom, PropSheetDef copyTo) {
        if (copyTo.equals((Object)copyFrom) || copyFrom == null || copyTo == null) {
            return;
        }
        List<PropDef> propDefList = copyFrom.getPropDefList();
        for (PropDef copyFromPropDef : propDefList) {
            PropDef existingPropDef = copyTo.getPropDef(copyFromPropDef.getName());
            if (existingPropDef != null) {
                copyTo.removePropDef(existingPropDef);
            }
            PropDef newPropDef = new PropDef(copyTo, copyFromPropDef);
            copyTo.addPropDef(newPropDef);
        }
    }

    @Override
    public void deletePropSheetDef(PropSheetDef propSheetDef) {
        if (propSheetDef.isVersioned()) {
            propSheetDef.getPersistenceData().setDeleted(true);
        } else {
            this.getDBSession().delete((Object)propSheetDef);
        }
    }

    private void interceptRead(PropSheetDef propSheetDef) {
        InterceptorRegistryLookup.getInterceptorRegistry().interceptRead(propSheetDef);
    }
}

