/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.srvc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.WvcmException;

public class SrvcUtils {
    public static <T> T doReadProperty(Resource resource, PropertyNameList.PropertyName<T> propName, Feedback feedback) throws WvcmException {
        PropertyRequestItem.PropertyRequest pr = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{propName});
        PropertyRequestItem.PropertyRequest f = feedback == null ? pr : feedback.nest(pr);
        resource = resource.doReadProperties((Feedback)f);
        return (T)resource.getProperty(propName);
    }

    public static int LP(int percentDone, int index, int size, int begin, int end) {
        return begin + ((end - begin) * index + (end - begin) * percentDone / 100) / size;
    }

    public static List<Folder> doFindAllSubRoots(Folder start, int threshold, Feedback feedback) throws WvcmException {
        if (feedback == null) {
            throw new IllegalArgumentException("feedback must not be null");
        }
        HashSet<Folder> results = new HashSet<Folder>();
        SrvcUtils.findRootsHelper(start, threshold, results, feedback);
        return new ArrayList<Folder>(results);
    }

    public static int findRootsHelper(Folder root, int threshold, Set<Folder> results, Feedback feedback) throws WvcmException {
        int mySize = 0;
        int fileCount = 0;
        ResourceList members = (ResourceList)SrvcUtils.doReadProperty((Resource)root, Folder.CHILD_LIST, feedback.nest(10));
        int memberCount = members.size();
        TreeMap<Integer, ArrayList<Folder>> memberMap = new TreeMap<Integer, ArrayList<Folder>>();
        int i = 0;
        for (Resource resource : members) {
            if (resource instanceof Folder) {
                Folder folder = (Folder)resource;
                int memberSize = SrvcUtils.findRootsHelper(folder, threshold, results, feedback.nest(SrvcUtils.LP(98, i, memberCount, 15, 90)));
                ArrayList<Folder> chain = (ArrayList<Folder>)memberMap.get(memberSize);
                if (chain == null) {
                    chain = new ArrayList<Folder>();
                    memberMap.put(memberSize, chain);
                }
                chain.add(folder);
                mySize += memberSize;
                continue;
            }
            ++fileCount;
        }
        mySize += fileCount;
        while (mySize >= threshold && !memberMap.isEmpty()) {
            Integer memberSize = (Integer)memberMap.lastKey();
            List folders = (List)memberMap.get(memberSize);
            while (mySize >= threshold && !folders.isEmpty()) {
                results.add((Folder)folders.remove(0));
                mySize -= memberSize.intValue();
            }
        }
        if (mySize >= threshold) {
            results.add(root);
        }
        return mySize;
    }
}

